/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.mainframeperformance;

import com.ez.common.ui.guielements.DatePicker;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypeSelectionPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourceTypeSelectionPage.class);
    public static final String START_DATE = "start date";
    public static final String END_DATE = "end date";
    private static final int DIALOG_MIN_HEIGHT = 450;
    private static final int DIALOG_MIN_WIDTH = 600;
    private boolean good;
    private DatePicker startDate;
    private DatePicker endDate;
    private Button jobTypeBtn;
    private Button prgsTypeBtn;
    private Button cicsTypeBtn;

    protected ResourceTypeSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(ResourceTypeSelectionPage.class, "resTypePage.title"));
        this.setDescription(Messages.getString(ResourceTypeSelectionPage.class, "resTypePage.description"));
    }

    protected void createContent(Composite composite) {
        new Label(composite, 0);
        Group resGroup = new Group(composite, 0);
        resGroup.setText(Messages.getString(ResourceTypeSelectionPage.class, "res.group.text"));
        resGroup.setLayout((Layout)new GridLayout());
        GridData data = new GridData(256);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        resGroup.setLayoutData((Object)data);
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceTypeSelectionPage.this.setPageComplete(ResourceTypeSelectionPage.this.isPageComplete());
            }
        };
        this.jobTypeBtn = new Button((Composite)resGroup, 32);
        this.jobTypeBtn.setText(Messages.getString(ResourceTypeSelectionPage.class, "jobs.btn.label"));
        this.jobTypeBtn.setSelection(true);
        this.jobTypeBtn.addSelectionListener((SelectionListener)selListener);
        this.prgsTypeBtn = new Button((Composite)resGroup, 32);
        this.prgsTypeBtn.setText(Messages.getString(ResourceTypeSelectionPage.class, "prgs.btn.label"));
        this.prgsTypeBtn.setSelection(true);
        this.prgsTypeBtn.addSelectionListener((SelectionListener)selListener);
        this.cicsTypeBtn = new Button((Composite)resGroup, 32);
        this.cicsTypeBtn.setText(Messages.getString(ResourceTypeSelectionPage.class, "cics.btn.label"));
        this.cicsTypeBtn.setSelection(true);
        this.cicsTypeBtn.addSelectionListener((SelectionListener)selListener);
        new Label(composite, 0);
        Group dateGroup = new Group(composite, 0);
        dateGroup.setText(Messages.getString(ResourceTypeSelectionPage.class, "date.group.text"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        dateGroup.setLayout((Layout)gl);
        dateGroup.setLayoutData((Object)new GridData(256));
        Label lbl = new Label((Composite)dateGroup, 0);
        lbl.setText(Messages.getString(ResourceTypeSelectionPage.class, "from.label"));
        this.startDate = new DatePicker((Composite)dateGroup, 2052);
        this.startDate.addModifyListener((ModifyListener)new CalendarFocusAdapter(this.startDate));
        Label lblTo = new Label((Composite)dateGroup, 0);
        lblTo.setText(Messages.getString(ResourceTypeSelectionPage.class, "to.label"));
        this.endDate = new DatePicker((Composite)dateGroup, 2052);
        this.endDate.addModifyListener((ModifyListener)new CalendarFocusAdapter(this.endDate));
        this.getShell().layout();
    }

    public boolean isPageComplete() {
        boolean ret = false;
        if (this.wizard.getValue(START_DATE) != null && this.wizard.getValue(END_DATE) != null) {
            if (this.good) {
                this.setMessage(null);
                ret = true;
            }
        } else {
            ret = true;
            this.setMessage(null);
        }
        if ((this.jobTypeBtn.getSelection() || this.prgsTypeBtn.getSelection() || this.cicsTypeBtn.getSelection()) && ret) {
            ret = true;
            this.wizard.set("job_resource", (Object)this.jobTypeBtn.getSelection());
            this.wizard.set("prg_resource", (Object)this.prgsTypeBtn.getSelection());
            this.wizard.set("cics_resource", (Object)this.cicsTypeBtn.getSelection());
        } else {
            ret = false;
        }
        return ret;
    }

    private boolean verifyDates() {
        boolean ret = false;
        Date start = this.startDate.getDate();
        Date end = this.endDate.getDate();
        if (start != null && end != null) {
            Calendar startC = Calendar.getInstance();
            startC.setTime(start);
            Calendar endC = Calendar.getInstance();
            endC.setTime(end);
            L.debug("start: {}", (Object)startC.getTimeInMillis());
            L.debug("end: {}", (Object)endC.getTimeInMillis());
            if (startC.before(endC)) {
                ret = true;
            }
        }
        return ret;
    }

    class CalendarFocusAdapter
    implements ModifyListener {
        DatePicker dt;

        public CalendarFocusAdapter(DatePicker date) {
            this.dt = date;
        }

        public void modifyText(ModifyEvent e) {
            boolean refresh = false;
            String txt = ((Text)e.getSource()).getText();
            L.debug("new date: {}", (Object)txt);
            if (this.dt == ResourceTypeSelectionPage.this.startDate) {
                Date d = ResourceTypeSelectionPage.this.startDate.getDate();
                if (d != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    if (ResourceTypeSelectionPage.this.wizard.getValue(ResourceTypeSelectionPage.END_DATE) != null) {
                        ResourceTypeSelectionPage.this.good = ResourceTypeSelectionPage.this.verifyDates();
                        if (!ResourceTypeSelectionPage.this.good) {
                            ResourceTypeSelectionPage.this.setMessage(Messages.getString(ResourceTypeSelectionPage.class, "wrongDates.error.message"), 3);
                        }
                        ResourceTypeSelectionPage.this.wizard.set(ResourceTypeSelectionPage.START_DATE, (Object)c.getTime());
                    } else {
                        ResourceTypeSelectionPage.this.wizard.set(ResourceTypeSelectionPage.START_DATE, (Object)c.getTime());
                    }
                } else {
                    ResourceTypeSelectionPage.this.wizard.set(ResourceTypeSelectionPage.START_DATE, null);
                }
                refresh = true;
            } else if (this.dt == ResourceTypeSelectionPage.this.endDate) {
                Date d = ResourceTypeSelectionPage.this.endDate.getDate();
                if (d != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    if (ResourceTypeSelectionPage.this.wizard.getValue(ResourceTypeSelectionPage.START_DATE) != null) {
                        ResourceTypeSelectionPage.this.good = ResourceTypeSelectionPage.this.verifyDates();
                        if (!ResourceTypeSelectionPage.this.good) {
                            ResourceTypeSelectionPage.this.setMessage(Messages.getString(ResourceTypeSelectionPage.class, "wrongDates.error.message"), 3);
                        }
                        ResourceTypeSelectionPage.this.wizard.set(ResourceTypeSelectionPage.END_DATE, (Object)c.getTime());
                    } else {
                        ResourceTypeSelectionPage.this.wizard.set(ResourceTypeSelectionPage.END_DATE, (Object)c.getTime());
                    }
                } else {
                    ResourceTypeSelectionPage.this.wizard.set(ResourceTypeSelectionPage.END_DATE, null);
                }
                refresh = true;
            }
            if (refresh) {
                ResourceTypeSelectionPage.this.setPageComplete(ResourceTypeSelectionPage.this.isPageComplete());
            }
        }
    }
}

