/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.mainframeperformance;

import com.ez.internal.utils.Pair;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.mainframeperformance.DBResults;
import com.ez.report.application.ezreport.reports.mainframeperformance.Obj4Report;
import com.ez.report.application.ezreport.reports.mainframeperformance.SC2DatasourceLayout2;
import com.ez.report.application.ezreport.reports.mainframeperformance.SummaryGroupDS;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.ReportRow;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC2DataSource;
import com.ez.report.generation.common.datasource.SC7DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.Triplet;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDataSource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportDataSource.class);
    private List<ElementGroupInfo> list = new ArrayList<ElementGroupInfo>();
    private Obj4Report currentValue;
    DBResults dbResults;
    ElementGroupInfo summElem = new ElementGroupInfo("");

    public boolean nextItem() throws JRException {
        Obj4Report obj4Report = this.currentValue = this.list.size() > 0 ? (Obj4Report)this.list.remove(0) : null;
        return this.currentValue != null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = super.getFieldValue(field);
        if (field.getName().equals("testReportDataSource") && this.currentValue != null) {
            value = this.currentValue.getDataSource();
        } else if (field.getName().equals("prg_name") && this.currentValue != null) {
            value = this.currentValue.getObjName();
        } else if (field.getName().equals("group_name") && this.currentValue != null) {
            value = this.currentValue.getGroup();
        } else if (field.getName().equals("summaryDataSource")) {
            value = this.summElem;
        }
        return value;
    }

    public void setData(DBResults resultList, SubMonitor monitor) {
        this.dbResults = resultList;
        if (this.dbResults != null) {
            if (this.dbResults.isEmpty()) {
                Obj4Report elem = new Obj4Report("", null);
                this.list.add(elem);
                this.summElem = null;
            } else {
                String[] titles;
                if (this.dbResults.jobsResults != null) {
                    L.debug("preparing jobs");
                    monitor.subTask(Messages.getString(ReportDataSource.class, "preparingJobs.subtaskName"));
                    titles = new String[]{Messages.getString(ReportDataSource.class, "jobGroup.table.column1.title"), Messages.getString(ReportDataSource.class, "jobGroup.table.column2.title"), Messages.getString(ReportDataSource.class, "jobGroup.table.column3.title"), Messages.getString(ReportDataSource.class, "jobGroup.table.column4.title"), Messages.getString(ReportDataSource.class, "jobGroup.table.column5.title"), Messages.getString(ReportDataSource.class, "jobGroup.table.column6.title"), Messages.getString(ReportDataSource.class, "jobGroup.table.column7.title")};
                    this.buildJobsSubrepData(titles, this.dbResults.jobsResults, Messages.getString(ReportDataSource.class, "jobs.groupName"), monitor);
                }
                if (this.dbResults.programsResults != null && !monitor.isCanceled()) {
                    L.debug("preparing programs");
                    monitor.subTask(Messages.getString(ReportDataSource.class, "preparingPrograms.subtaskName"));
                    titles = new String[]{Messages.getString(ReportDataSource.class, "programGroup.table.column1.title"), Messages.getString(ReportDataSource.class, "programGroup.table.column2.title"), Messages.getString(ReportDataSource.class, "programGroup.table.column3.title"), Messages.getString(ReportDataSource.class, "programGroup.table.column4.title"), Messages.getString(ReportDataSource.class, "programGroup.table.column5.title"), Messages.getString(ReportDataSource.class, "programGroup.table.column6.title"), Messages.getString(ReportDataSource.class, "programGroup.table.column7.title")};
                    this.buildJobsSubrepData(titles, this.dbResults.programsResults, Messages.getString(ReportDataSource.class, "programs.groupName"), monitor);
                }
                if (this.dbResults.cicsResults != null && !monitor.isCanceled()) {
                    L.debug("preparing cics");
                    monitor.subTask(Messages.getString(ReportDataSource.class, "preparingCics.subtaskName"));
                    this.buildCicsSubrepData(monitor);
                }
            }
        }
    }

    private void buildCicsSubrepData(SubMonitor monitor) {
        String cics = null;
        Obj4Report el = null;
        int occ = 0;
        int distincts = 0;
        ArrayList<Pair<String, Integer>> vals = new ArrayList<Pair<String, Integer>>();
        ArrayList<Triplet<String, Integer, String>> maxVals = new ArrayList<Triplet<String, Integer, String>>();
        int i = 0;
        while (i < this.dbResults.cicsResults.length && !monitor.isCanceled()) {
            String[] data = this.dbResults.cicsResults[i];
            if (!data[0].equalsIgnoreCase(cics)) {
                if (el != null) {
                    this.buildCicsElemSummary(el, vals, occ, maxVals);
                }
                ++distincts;
                cics = data[0];
                occ = 0;
                vals.clear();
                el = new Obj4Report(cics, Messages.getString(ReportDataSource.class, "cics.groupName"));
                SC1DataSource titleDS = new SC1DataSource();
                titleDS.setLayout(2);
                ArrayList<ObjectForSubreport> titleLst = new ArrayList<ObjectForSubreport>();
                ObjectForSubreport obj = new ObjectForSubreport();
                obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.programName.label"));
                obj.setExpVal(data[1]);
                titleLst.add(obj);
                obj = new ObjectForSubreport();
                obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.priority.label"));
                obj.setExpVal(data[2]);
                titleLst.add(obj);
                titleDS.setList(titleLst);
                el.setTitleVals(titleDS.getReportName(), (SubreportDataSource)titleDS);
                this.list.add(el);
            }
            SC2DatasourceLayout2 ds = new SC2DatasourceLayout2();
            String startDate = Messages.getString(ReportDataSource.class, "cicsGroup.startDate.label", new String[]{data[5]});
            if (i > 0) {
                String prevStartDate = this.dbResults.cicsResults[i - 1][5];
                if (data[5].equalsIgnoreCase(prevStartDate)) {
                    startDate = "";
                } else {
                    ++occ;
                }
            } else {
                ++occ;
            }
            ds.setTitle1(startDate);
            ds.setTitle2(Messages.getString(ReportDataSource.class, "cicsGroup.endDate.label", new String[]{data[6]}));
            ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
            ds.setList(lst);
            el.addDataSource((SubreportDataSource)ds);
            this.buildCicsObj(data, lst, vals);
            ++i;
        }
        if (el != null && !monitor.isCanceled()) {
            this.buildCicsElemSummary(el, vals, occ, maxVals);
        }
        if (distincts > 0 && !monitor.isCanceled()) {
            this.addSummaryElement(Messages.getString(ReportDataSource.class, "report.summary.cicsGroup"), distincts, maxVals);
        }
    }

    private void buildCicsElemSummary(Obj4Report el, List<Pair<String, Integer>> vals, int occ, List<Triplet<String, Integer, String>> maxVals) {
        if (occ > 1) {
            Triplet max;
            SummaryGroupDS summDS = new SummaryGroupDS();
            ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.summary.occurences.label"));
            obj.setExpVal(String.valueOf(occ));
            lst.add(obj);
            Triplet triplet = max = maxVals.size() > 0 ? maxVals.get(0) : null;
            if (max == null) {
                max = new Triplet();
                max.setFirst((Object)Messages.getString(ReportDataSource.class, "report.summary.cicsGroup.occurences.label"));
                max.setSecond((Object)occ);
                maxVals.add((Triplet<String, Integer, String>)max);
            } else {
                max.setSecond((Object)((Integer)max.getSecond() + occ));
            }
            int i = 1;
            for (Pair<String, Integer> p : vals) {
                obj = new ObjectForSubreport();
                obj.setExp((String)p.getFirst());
                obj.setExpVal(((Integer)p.getSecond()).toString());
                lst.add(obj);
                Triplet triplet2 = max = maxVals.size() > i ? maxVals.get(i) : null;
                if (max == null) {
                    max = new Triplet();
                    max.setFirst((Object)Messages.getString(ReportDataSource.class, "report.summary.cicsGroup.max.labels", new String[]{(String)p.getFirst()}));
                    max.setSecond((Object)((Integer)p.getSecond()));
                    max.setThird((Object)el.getGroupElem());
                    maxVals.add((Triplet<String, Integer, String>)max);
                } else if ((Integer)p.getSecond() > (Integer)max.getSecond()) {
                    max.setSecond((Object)((Integer)p.getSecond()));
                    max.setThird((Object)el.getGroupElem());
                } else if (p.getSecond() == max.getSecond()) {
                    max.setThird((Object)Messages.getString(ReportDataSource.class, "report.summary.anyGroup.max.oneResourceName", new String[]{(String)max.getThird()}));
                }
                ++i;
            }
            summDS.setList(lst);
            el.setSummaryVals(summDS.getReportName(), (SubreportDataSource)summDS);
        }
        vals.clear();
    }

    private void buildCicsObj(String[] data, List<ObjectForSubreport> lst, List<Pair<String, Integer>> vals) {
        Pair p;
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.terminalID.label"));
        obj.setExpVal(data[3]);
        lst.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.userID.label"));
        obj.setExpVal(data[4]);
        lst.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.program.label"));
        obj.setExpVal(data[7]);
        lst.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.luName.label"));
        obj.setExpVal(data[8]);
        lst.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.userCPU.label"));
        obj.setExpVal(data[9]);
        lst.add(obj);
        Pair pair = p = vals.size() > 0 ? vals.get(0) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.userCPU.label"), (Object)Integer.valueOf(data[9]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[9])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.suspendCPU.label"));
        obj.setExpVal(data[10]);
        lst.add(obj);
        Pair pair2 = p = vals.size() > 1 ? vals.get(1) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.suspendCPU.label"), (Object)Integer.valueOf(data[10]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[10])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.elapseTime.label"));
        obj.setExpVal(data[11]);
        lst.add(obj);
        Pair pair3 = p = vals.size() > 2 ? vals.get(2) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.elapseTime.label"), (Object)Integer.valueOf(data[11]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[11])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.fileGetCount.label"));
        obj.setExpVal(data[12]);
        lst.add(obj);
        Pair pair4 = p = vals.size() > 3 ? vals.get(3) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.fileGetCount.label"), (Object)Integer.valueOf(data[12]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[12])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.filePutCount.label"));
        obj.setExpVal(data[13]);
        lst.add(obj);
        Pair pair5 = p = vals.size() > 4 ? vals.get(4) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.filePutCount.label"), (Object)Integer.valueOf(data[13]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[13])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.fileBrowseCount.label"));
        obj.setExpVal(data[14]);
        lst.add(obj);
        Pair pair6 = p = vals.size() > 5 ? vals.get(5) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.fileBrowseCount.label"), (Object)Integer.valueOf(data[14]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[14])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.fileAddCount.label"));
        obj.setExpVal(data[15]);
        lst.add(obj);
        Pair pair7 = p = vals.size() > 6 ? vals.get(6) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.fileAddCount.label"), (Object)Integer.valueOf(data[15]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[15])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.fileDeleteCount.label"));
        obj.setExpVal(data[16]);
        lst.add(obj);
        Pair pair8 = p = vals.size() > 7 ? vals.get(7) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.fileDeleteCount.label"), (Object)Integer.valueOf(data[16]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[16])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.fileTotalIOCount.label"));
        obj.setExpVal(data[17]);
        lst.add(obj);
        Pair pair9 = p = vals.size() > 8 ? vals.get(8) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.fileTotalIOCount.label"), (Object)Integer.valueOf(data[17]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[17])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.programLinkCount.label"));
        obj.setExpVal(data[18]);
        lst.add(obj);
        Pair pair10 = p = vals.size() > 9 ? vals.get(9) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.programLinkCount.label"), (Object)Integer.valueOf(data[18]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[18])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.programXctlCount.label"));
        obj.setExpVal(data[19]);
        lst.add(obj);
        Pair pair11 = p = vals.size() > 10 ? vals.get(10) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.programXctlCount.label"), (Object)Integer.valueOf(data[19]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[19])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.programLoadCount.label"));
        obj.setExpVal(data[20]);
        lst.add(obj);
        Pair pair12 = p = vals.size() > 11 ? vals.get(11) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.programLoadCount.label"), (Object)Integer.valueOf(data[20]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[20])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.imsCallCount.label"));
        obj.setExpVal(data[21]);
        lst.add(obj);
        Pair pair13 = p = vals.size() > 12 ? vals.get(12) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.imsCallCount.label"), (Object)Integer.valueOf(data[21]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[21])));
        }
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(ReportDataSource.class, "cicsGroup.db2CallCount.label"));
        obj.setExpVal(data[22]);
        lst.add(obj);
        Pair pair14 = p = vals.size() > 13 ? vals.get(13) : null;
        if (p == null) {
            p = new Pair((Object)Messages.getString(ReportDataSource.class, "cicsGroup.summary.db2Callcount.label"), (Object)Integer.valueOf(data[22]));
            vals.add((Pair<String, Integer>)p);
        } else {
            p.setSecond((Object)((Integer)p.getSecond() + Integer.valueOf(data[22])));
        }
    }

    private void buildJobsSubrepData(String[] titles, String[][] results, String groupName, SubMonitor monitor) {
        int distincts = 0;
        int totalOcc = 0;
        String jobName = null;
        Obj4Report elem = null;
        ArrayList<ReportRow> objList = null;
        int CPUTime = 0;
        int IOCount = 0;
        int IOTime = 0;
        ArrayList<Triplet<String, Integer, String>> maxVals = new ArrayList<Triplet<String, Integer, String>>();
        int i = 0;
        while (i < results.length && !monitor.isCanceled()) {
            String[] data = results[i];
            if (!data[0].equalsIgnoreCase(jobName)) {
                if (elem != null) {
                    totalOcc += objList.size();
                    this.buildGroupSummary(elem, (List<ReportRow>)objList, CPUTime, IOCount, IOTime, maxVals);
                }
                jobName = data[0];
                elem = new Obj4Report(jobName, groupName);
                objList = new ArrayList<ReportRow>();
                SC7DataSource elemDS = new SC7DataSource("", objList, titles);
                elemDS.setLayoutStyle(2);
                elem.addDataSource((SubreportDataSource)elemDS);
                this.list.add(elem);
                ++distincts;
                CPUTime = 0;
                IOCount = 0;
                IOTime = 0;
            }
            ReportRow obj = new ReportRow(data[1], data[2]);
            obj.setThirdField(data[3]);
            IOCount += Integer.valueOf(data[3]).intValue();
            obj.setFourthField(data[4]);
            CPUTime += Integer.valueOf(data[4]).intValue();
            obj.setFifthField(data[5]);
            obj.setSixthField(data[6]);
            String ioTime = data[7].equals("-1") ? null : data[7];
            obj.setSeventhField(ioTime);
            if (ioTime != null) {
                IOTime += Integer.valueOf(ioTime).intValue();
            }
            objList.add(obj);
            ++i;
        }
        if (elem != null && !monitor.isCanceled()) {
            totalOcc += objList.size();
            this.buildGroupSummary(elem, (List<ReportRow>)objList, CPUTime, IOCount, IOTime, maxVals);
        }
        if (distincts > 0 && !monitor.isCanceled()) {
            Triplet max = new Triplet();
            max.setFirst((Object)Messages.getString(ReportDataSource.class, "report.summary.programOrJob.section.occurences.label"));
            max.setSecond((Object)totalOcc);
            maxVals.add(0, (Triplet<String, Integer, String>)max);
            this.addSummaryElement(groupName, distincts, maxVals);
        }
    }

    private void addSummaryElement(String groupName, int distincts, List<Triplet<String, Integer, String>> maxVals) {
        ArrayList<ObjectForSubreport> summLst = new ArrayList<ObjectForSubreport>();
        SC2DataSource ds = new SC2DataSource(groupName, summLst);
        this.summElem.addDataSource((SubreportDataSource)ds);
        Triplet max = new Triplet();
        max.setFirst((Object)Messages.getString(ReportDataSource.class, "report.summary.anySection.distincts.label"));
        max.setSecond((Object)distincts);
        maxVals.add(0, (Triplet<String, Integer, String>)max);
        for (Triplet<String, Integer, String> maxs : maxVals) {
            if (maxs == null) continue;
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp((String)maxs.getFirst());
            obj.setExpVal(String.valueOf(maxs.getSecond()));
            summLst.add(obj);
            if (maxs.getThird() != null) {
                obj = new ObjectForSubreport();
                obj.setExp((String)maxs.getThird());
                obj.setExpVal("");
                summLst.add(obj);
                continue;
            }
            obj = new ObjectForSubreport();
            obj.setExp("");
            obj.setExpVal("");
            summLst.add(obj);
        }
    }

    private void buildGroupSummary(Obj4Report elem, List<ReportRow> objList, int CPUTime, int IOCount, int IOTime, List<Triplet<String, Integer, String>> maxVals) {
        Triplet max;
        int occ = objList.size();
        if (occ > 1) {
            SummaryGroupDS summDS = new SummaryGroupDS();
            ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(ReportDataSource.class, "jobOrProgramGroup.occurences.label"));
            obj.setExpVal(String.valueOf(occ));
            lst.add(obj);
            if (CPUTime > 0) {
                obj = new ObjectForSubreport();
                obj.setExp(Messages.getString(ReportDataSource.class, "jobOrProgramGroup.cpuTime.label"));
                obj.setExpVal(String.valueOf(CPUTime));
                lst.add(obj);
            }
            if (IOCount > 0) {
                obj = new ObjectForSubreport();
                obj.setExp(Messages.getString(ReportDataSource.class, "jobOrProgramGroup.ioCount.label"));
                obj.setExpVal(String.valueOf(IOCount));
                lst.add(obj);
            }
            if (IOTime > 0) {
                obj = new ObjectForSubreport();
                obj.setExp(Messages.getString(ReportDataSource.class, "jobOrProgramGroup.ioTime.label"));
                obj.setExpVal(String.valueOf(IOTime));
                lst.add(obj);
            }
            summDS.setList(lst);
            elem.setSummaryVals(summDS.getReportName(), (SubreportDataSource)summDS);
        }
        if (CPUTime > 0) {
            Triplet triplet = max = maxVals.size() > 0 ? maxVals.get(0) : null;
            if (max == null) {
                max = new Triplet();
                max.setFirst((Object)Messages.getString(ReportDataSource.class, "jobOrProgramGroup.summary.maxCPUTime.label"));
                max.setSecond((Object)CPUTime);
                max.setThird((Object)elem.getGroupElem());
                if (maxVals.size() > 0) {
                    maxVals.remove(0);
                }
                maxVals.add(0, (Triplet<String, Integer, String>)max);
            } else if (CPUTime >= (Integer)max.getSecond()) {
                if (CPUTime == (Integer)max.getSecond()) {
                    max.setThird((Object)Messages.getString(ReportDataSource.class, "report.summary.anyGroup.max.oneResourceName", new String[]{(String)max.getThird()}));
                } else {
                    max.setThird((Object)elem.getGroupElem());
                }
                max.setSecond((Object)CPUTime);
            }
        }
        if (IOCount > 0) {
            Triplet triplet = max = maxVals.size() > 1 ? maxVals.get(1) : null;
            if (max == null) {
                max = new Triplet();
                max.setFirst((Object)Messages.getString(ReportDataSource.class, "jobOrProgramGroup.summary.maxIOCount.label"));
                max.setSecond((Object)IOCount);
                max.setThird((Object)elem.getGroupElem());
                if (maxVals.isEmpty()) {
                    maxVals.add(null);
                } else if (maxVals.size() == 2) {
                    maxVals.remove(1);
                }
                maxVals.add(1, (Triplet<String, Integer, String>)max);
            } else if (IOCount >= (Integer)max.getSecond()) {
                if (IOCount == (Integer)max.getSecond()) {
                    max.setThird((Object)Messages.getString(ReportDataSource.class, "report.summary.anyGroup.max.oneResourceName", new String[]{(String)max.getThird()}));
                } else {
                    max.setThird((Object)elem.getGroupElem());
                }
                max.setSecond((Object)IOCount);
            }
        }
        if (IOTime > 0) {
            Triplet triplet = max = maxVals.size() > 2 ? maxVals.get(2) : null;
            if (max == null) {
                max = new Triplet();
                max.setFirst((Object)Messages.getString(ReportDataSource.class, "jobOrProgramGroup.summary.maxIOTime.label"));
                max.setSecond((Object)IOTime);
                max.setThird((Object)elem.getGroupElem());
                if (maxVals.size() == 0) {
                    maxVals.add(null);
                    maxVals.add(null);
                } else if (maxVals.size() == 1) {
                    maxVals.add(null);
                } else if (maxVals.size() == 3) {
                    maxVals.remove(2);
                }
                maxVals.add(2, (Triplet<String, Integer, String>)max);
            } else if (IOTime >= (Integer)max.getSecond()) {
                if (IOTime == (Integer)max.getSecond()) {
                    max.setThird((Object)Messages.getString(ReportDataSource.class, "report.summary.anyGroup.max.oneResourceName", new String[]{(String)max.getThird()}));
                } else {
                    max.setThird((Object)elem.getGroupElem());
                }
                max.setSecond((Object)IOTime);
            }
        }
    }
}

