/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.mainframeperformance;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.mainframeperformance.DBResults;
import com.ez.report.application.ezreport.reports.mainframeperformance.ReportDataSource;
import com.ez.report.application.ezreport.reports.mainframeperformance.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    int step = 0;
    Set<BaseResourceInput4GUI> cics;
    Set<BaseResourceInput4GUI> jobs;
    Set<BaseResourceInput4GUI> progs;
    private static final String dateSql = "select convert ( varchar(30), min(t.mi), 21 ) as first, convert ( varchar(30), max(t.ma), 21) as last from ( \tselect min(MFJCLStepInfo.StartDate) as mi, max(MFJCLStepInfo.StartDate) as ma from MFJCLStepInfo \tunion \tselect min(MFCICSTransactionPerformance.StartTime) as mi, max(MFCICSTransactionPerformance.StartTime) as ma  from MFCICSTransactionPerformance) as t";
    private static final String dateDb2 = "SELECT  VARCHAR_FORMAT(MIN(mi),'YYYY-MM-DD HH:MI:SS.FF3') as first, VARCHAR_FORMAT(MAX(ma),'YYYY-MM-DD HH:MI:SS.FF3') as last FROM ( SELECT MIN(StartDate) AS mi , MAX(StartDate) AS ma FROM MFJCLStepInfo UNION SELECT MIN(StartTime) AS mi , MAX(StartTime) AS ma FROM MFCICSTransactionPerformance )t";
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss.S";

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.parameters = new HashMap();
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        final DBResults resultList = new DBResults();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                    ReportBuilder.this.data(conn, monitor, resultList);
                }
            }, LockType.Shared, (IProgressMonitor)monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        ReportDataSource dataSource = new ReportDataSource();
        dataSource.setData(resultList, monitor.newChild(100));
        String appendixStr = this.prepareAppendixResrsList(null);
        this.parameters.put("inputResources", appendixStr);
        return dataSource;
    }

    private void data(EZSourceConnection conn, IProgressMonitor pmonitor, DBResults dbResults) {
        Timestamp endDate;
        Timestamp startDate;
        SubMonitor monitor;
        block18: {
            this.clearForJasperReport();
            monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.subTask(Messages.getString(ReportBuilder.class, "collectingData.subtask"));
            this.step = 1;
            this.jobs = (Set)this.getSelected();
            this.step = 2;
            this.progs = (Set)this.getSelected();
            this.step = 3;
            this.cics = (Set)this.getSelected();
            startDate = ((ReportModel)this.getReportModel()).getStartDate();
            endDate = ((ReportModel)this.getReportModel()).getEndDate();
            this.parameters.put("showAppendix", Boolean.TRUE);
            this.buildAppendixDateSection(startDate, endDate);
            if (startDate == null || endDate == null) {
                L.debug("reading start/end date from database");
                try {
                    ServerType dbEngine = conn.getProjectInfo().getDbEngine();
                    String[][] data = null;
                    switch (dbEngine) {
                        case SqlServer: {
                            data = conn.executeSQL(dateSql);
                            break;
                        }
                        case Db2: 
                        case Db2Z: {
                            data = conn.executeSQL(dateDb2);
                        }
                    }
                    if (data.length <= 0) break block18;
                    SimpleDateFormat df = new SimpleDateFormat(dateFormat);
                    Timestamp d1 = null;
                    Timestamp d2 = null;
                    try {
                        d1 = new Timestamp(df.parse(data[0][0]).getTime());
                        d2 = new Timestamp(df.parse(data[0][1]).getTime());
                    }
                    catch (ParseException e) {
                        L.error("exception at parsing default dates from database", (Throwable)e);
                    }
                    startDate = startDate == null ? d1 : startDate;
                    endDate = endDate == null ? d2 : endDate;
                }
                catch (EZSourceConnectionException e) {
                    L.error("exception at getting default dates from database", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(ReportBuilder.class, "storedProcedureError.logMessage"), e);
                }
            }
        }
        if (!monitor.isCanceled()) {
            String[][] results;
            SingleQueryResult queryResult;
            if (this.jobs != null && !this.jobs.isEmpty()) {
                L.debug("executing query for jobs");
                this.step = 1;
                queryResult = new SingleQueryResult();
                this.queryForData(new Object[]{startDate, endDate}, EZSourceDataType.String, this.getSelected(), queryResult, conn);
                results = queryResult.data;
                dbResults.jobsResults = results;
            } else {
                L.info("no jobs selected!");
            }
            if (!monitor.isCanceled()) {
                if (this.progs != null && !this.progs.isEmpty()) {
                    L.debug("executing query for programs");
                    this.step = 2;
                    queryResult = new SingleQueryResult();
                    this.queryForData(new Object[]{startDate, endDate}, EZSourceDataType.String, this.getSelected(), queryResult, conn);
                    results = queryResult.data;
                    dbResults.programsResults = results;
                } else {
                    L.info("no programs selected!");
                }
                if (!monitor.isCanceled()) {
                    if (this.cics != null && !this.cics.isEmpty()) {
                        L.debug("executing query for cics");
                        this.step = 3;
                        queryResult = new SingleQueryResult();
                        this.queryForData(new Object[]{startDate, endDate}, EZSourceDataType.String, this.getSelected(), queryResult, conn);
                        results = queryResult.data;
                        dbResults.cicsResults = results;
                    } else {
                        L.info("no CICSTrans selected!");
                    }
                }
            }
        }
        monitor.setWorkRemaining(0);
    }

    private void buildAppendixDateSection(Timestamp startDate, Timestamp endDate) {
        this.parameters.put("resourcesSummary.2", Messages.getString(ReportBuilder.class, "report.appendix.period.label"));
        StringBuffer res = new StringBuffer();
        res.append(Messages.getString(ReportBuilder.class, "report.appendix.period.startDate.label"));
        res.append(startDate != null ? startDate.toString() : Messages.getString(ReportBuilder.class, "report.appendix.period.noStartDate.message"));
        res.append(Messages.getString(ReportBuilder.class, "report.appendix.period.endDate.label"));
        res.append(endDate != null ? endDate.toString() : Messages.getString(ReportBuilder.class, "report.appendix.period.noEndDate.message"));
        this.parameters.put("inputResources.2", res.toString());
    }

    protected Collection getSelected() {
        Set all = null;
        Set<Object> sel = null;
        all = (Set)this.report.getProperty("inputs");
        if (this.step == 0) {
            sel = new HashSet(all);
        } else {
            Integer type = null;
            switch (this.step) {
                case 1: {
                    if (this.jobs == null) {
                        type = 22;
                        break;
                    }
                    sel = this.jobs;
                    break;
                }
                case 2: {
                    if (this.progs == null) {
                        type = 21;
                        break;
                    }
                    sel = this.progs;
                    break;
                }
                case 3: {
                    if (this.cics == null) {
                        type = 23;
                        break;
                    }
                    sel = this.cics;
                    break;
                }
            }
            if (type != null) {
                sel = new HashSet();
                for (BaseResourceInput4GUI inpt : all) {
                    if (!inpt.getTypeCode().equals(type)) continue;
                    sel.add(inpt);
                }
                switch (type) {
                    case 21: {
                        this.progs = sel;
                        break;
                    }
                    case 22: {
                        this.jobs = sel;
                        break;
                    }
                    case 23: {
                        this.cics = sel;
                        break;
                    }
                }
                L.debug("type: {} -- selected: {}", (Object)type, sel);
            }
        }
        return sel;
    }

    private void clearForJasperReport() {
    }

    protected String getProcedure() {
        return this.getSelectiveProcedure();
    }

    protected String getSelectiveProcedure() {
        String proc = null;
        switch (this.step) {
            case 1: {
                proc = "EZReports_MainframeRuntimePerf_Jobs";
                break;
            }
            case 2: {
                proc = "EZReports_MainframeRuntimePerf_Programs";
                break;
            }
            case 3: {
                proc = "EZReports_MainframeRuntimePerf_Cics";
                break;
            }
        }
        return proc;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParameters.process.name"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.parameters.put("separateColumn", false);
        monitor.worked(100);
        return this.parameters;
    }

    private void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "resources.summary.lbl");
        params.put("resourcesSummary", externalized);
        params.put("title.appFieldValues", this.applicationsName);
        params.put("summaryLabel", Messages.getString(ReportBuilder.class, "report.group.summary.title"));
    }

    protected String getReportTemplatePath() {
        return "reports/mainframePerformance.jasper";
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Date d = (Date)this.inputs.get("start date");
            new SimpleDateFormat(dateFormat);
            if (d != null) {
                ((ReportModel)this.report).setStartDate(new Timestamp(d.getTime()));
            }
            if ((d = (Date)this.inputs.get("end date")) != null) {
                d.setHours(23);
                d.setMinutes(59);
                d.setSeconds(59);
                ((ReportModel)this.report).setEndDate(new Timestamp(d.getTime()));
            }
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected String prepareAppendixResrsList(Set prgList) {
        StringBuffer sb = new StringBuffer();
        if (this.jobs != null && !this.jobs.isEmpty()) {
            sb.append(Messages.getString(ReportBuilder.class, "report.appendix.jobs.startLabel"));
            for (BaseResourceInput4GUI obj : this.jobs) {
                sb.append(obj.getObject().getName());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(Messages.getString(ReportBuilder.class, "report.appendix.jobs.endLabel"));
        }
        if (this.progs != null && !this.progs.isEmpty()) {
            sb.append(Messages.getString(ReportBuilder.class, "report.appendix.programs.startLabel"));
            sb.append(this.progs.toString());
            sb.append(Messages.getString(ReportBuilder.class, "report.appendix.programs.endLabel"));
        }
        if (this.cics != null && !this.cics.isEmpty()) {
            sb.append(Messages.getString(ReportBuilder.class, "report.appendix.cics.startLabel"));
            sb.append(this.cics.toString());
            sb.append(Messages.getString(ReportBuilder.class, "report.appendix.cics.endLabel"));
        }
        return sb.toString();
    }

    public void cleanMemory() {
        if (this.cics != null) {
            this.cics.clear();
            this.cics = null;
        }
        if (this.jobs != null) {
            this.jobs.clear();
            this.jobs = null;
        }
        if (this.progs != null) {
            this.progs.clear();
            this.progs = null;
        }
        super.cleanMemory();
    }
}

