/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact2;

import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.ImpactBuilder;
import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.CallsInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FieldExpansionBuilder;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FieldExpansionSearch;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Holder;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.LinkagePrinter;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PathPrinter;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Program;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ReportModel;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VarDetails;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VarLinkInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Variable;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VariableElement;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VariablePrinter;
import com.ez.report.application.ezreport.reports.impact2.ImpactReportDataSource;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.all.LegendDataSource;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactReportBuilder.class);
    private static final String NOT_AVAILABLE = Messages.getString(FieldExpansionSearch.class, "notAvailable");
    static final String FORWARD_DIRECTION = "forward";
    private static final String procTitle = Messages.getString(ImpactReportBuilder.class, "proc.colum.header");
    private static final String actualParamTitle = Messages.getString(ImpactReportBuilder.class, "actparam.colum.header");
    private static final String formParamTitle = Messages.getString(ImpactReportBuilder.class, "formparam.colum.header");
    private List<String[]> finalVarsInfo = null;
    private List<String[]> programInfo = null;
    private Map<String, List<List<String[]>>> pathsInfo = null;
    private List<String[]> progCallsInfo = null;
    private Map<String, List<Pair<String, String>>> varsInProgramsInfo = null;
    private Map<String, Map<String[], Set<String>>> resourceResults = null;
    private List<Program> programList = new ArrayList<Program>();
    private Set<Program> sourcesList = new HashSet<Program>();
    private Map<String, Object> extraInputs;
    private CSVWriter csvWriter;

    public ImpactReportBuilder(String reportName, Map<String, Object> reportInfo, Map<String, Object> extraInputs) {
        this.finalVarsInfo = (List)reportInfo.get("finalVariables");
        this.programInfo = (List)reportInfo.get("programs");
        this.pathsInfo = (Map)reportInfo.get("pathsInfo");
        this.progCallsInfo = (List)reportInfo.get("progCallsInfo");
        this.varsInProgramsInfo = (Map)reportInfo.get("varsInProgramsInfo");
        this.resourceResults = (Map)reportInfo.get("resourceResults");
        this.extraInputs = extraInputs;
    }

    protected String getReportTemplatePath() {
        return "reports/fieldExpansion.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor monitor) {
        this.parameters.put("report.title", Messages.getString(ImpactReportBuilder.class, "report.title"));
        this.titleParameters(this.parameters);
        this.parameters.put("separateColumn", false);
        return this.parameters;
    }

    protected void titleParameters(Map<String, Object> params) {
        String dirStr;
        ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
        String coverPageRow1 = null;
        String csvInputsDetail = null;
        String resType = (String)this.inputs.get("res_type");
        String program = null;
        Object include = null;
        List inpts = null;
        List inptsSegm = (List)this.extraInputs.get("input_list");
        boolean isVariable = "variable".equalsIgnoreCase(resType);
        if (isVariable) {
            csvInputsDetail = Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVars");
            inpts = (List)this.inputs.get("variableName");
        } else {
            boolean isDataset = "dataset".equalsIgnoreCase(resType);
            if (isDataset) {
                inpts = (List)this.inputs.get("datasetNames");
                csvInputsDetail = Messages.getString(ImpactReportBuilder.class, "dataset.lbl");
            } else {
                boolean isSqlField = "sqlField".equalsIgnoreCase(resType);
                if (isSqlField) {
                    inpts = (List)this.inputs.get("sqlField");
                    csvInputsDetail = Messages.getString(ImpactReportBuilder.class, "sql.fields.lbl");
                }
            }
        }
        int maxVarOnCover = Math.min(2, inpts.size());
        int varNo = 0;
        for (String inptName : inpts) {
            if (isVariable) {
                EZEntityID id = (EZEntityID)inptsSegm.get(varNo);
                inptName = ((EZSourceVariableIDSg)id.getSegment(EZSourceVariableIDSg.class)).getResourceName();
                program = ((EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class)).getProgramName();
                include = null;
            }
            String appendixStr = this.getAppendixStr(resType, inptName, program, include);
            csvInputsDetail = String.valueOf(csvInputsDetail) + this.getCoverPageRow1Part(resType, inptName, program, include);
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp(appendixStr);
            obj.setExpVal("");
            lst.add(obj);
            if (varNo + 1 < inpts.size()) {
                csvInputsDetail = String.valueOf(csvInputsDetail) + ", ";
            }
            ++varNo;
        }
        if (varNo <= maxVarOnCover) {
            coverPageRow1 = ReportsUtils.stripNonValidXMLCharacters((String)csvInputsDetail, (boolean)true);
        } else {
            int firstIdx = csvInputsDetail.indexOf(", ");
            int secondIdx = csvInputsDetail.indexOf(", ", firstIdx + 1);
            coverPageRow1 = csvInputsDetail.substring(0, secondIdx);
            coverPageRow1 = String.valueOf(coverPageRow1) + Messages.getString(ImpactBuilder.class, "coverPage.row1.multiple.inputs", new String[]{String.valueOf(inpts.size() - maxVarOnCover)});
            coverPageRow1 = ReportsUtils.stripNonValidXMLCharacters((String)coverPageRow1, (boolean)true);
        }
        params.put("title.varName", coverPageRow1);
        params.put("all.inputs.name", csvInputsDetail);
        params.put("inputResources", lst);
        String coverPageRow2 = "";
        Object depth = this.getReportModel().getProperty("max cycles");
        boolean noDepth = depth == null || (Integer)depth == 0;
        Object isFwVal = this.getReportModel().getProperty(FORWARD_DIRECTION);
        String string = dirStr = isFwVal != null ? this.getDirectionStr((Boolean)isFwVal) : null;
        if (dirStr != null) {
            coverPageRow2 = noDepth ? Messages.getString(ImpactBuilder.class, "coverPage.row2.directionNoDepth", new String[]{dirStr}) : Messages.getString(ImpactBuilder.class, "coverPage.row2.directionAndDepth", new String[]{dirStr, String.valueOf(depth)});
        } else if (!noDepth) {
            coverPageRow2 = Messages.getString(ImpactBuilder.class, "coverPage.row2.depthNoDirection", new String[]{String.valueOf(depth)});
        }
        if (coverPageRow2 != null) {
            params.put("title.resourceName", coverPageRow2);
        }
    }

    private String getCoverPageRow1Part(String inputType, String inputName, String program, String include) {
        String coverPageRow1 = "";
        if ("variable".equalsIgnoreCase(inputType)) {
            coverPageRow1 = program != null ? Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphWithResrs", new String[]{inputName, "program", program}) : (include != null ? Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphWithResrs", new String[]{inputName, "include", include}) : Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphNoResrs", new String[]{inputName}));
        } else if ("dataset".equalsIgnoreCase(inputType) || "sqlField".equalsIgnoreCase(inputType)) {
            coverPageRow1 = Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphNoResrs", new String[]{inputName});
        }
        return coverPageRow1;
    }

    private String getAppendixStr(String inputType, String inputName, String program, String include) {
        String appendixStr = "";
        if ("variable".equalsIgnoreCase(inputType)) {
            appendixStr = program != null ? Messages.getString(ImpactReportBuilder.class, "appendixStrStartVarInProgram", new String[]{inputName, program}) : (include != null ? Messages.getString(ImpactReportBuilder.class, "appendixStrStartVarInInclude", new String[]{inputName, include}) : Messages.getString(ImpactReportBuilder.class, "appendixStrStartVar", new String[]{inputName}));
        } else if ("dataset".equalsIgnoreCase(inputType)) {
            appendixStr = Messages.getString(ImpactReportBuilder.class, "dataset.appendix", new String[]{inputName});
        } else if ("sqlField".equalsIgnoreCase(inputType)) {
            appendixStr = Messages.getString(ImpactReportBuilder.class, "sql.appendix", new String[]{inputName});
        }
        appendixStr = ReportsUtils.stripNonValidXMLCharacters((String)appendixStr, (boolean)true);
        return appendixStr;
    }

    private String getDirectionStr(Boolean isForward) {
        return isForward != false ? Messages.getString(ImpactReportBuilder.class, "forward.direction") : Messages.getString(ImpactReportBuilder.class, "backward.direction");
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) throws Exception {
        this.splitPathsInfo();
        this.csvFile = this.createTempCSVFile();
        this.csvWriter = this.initTempCSVFile();
        if (this.csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
            CSVImpactUtils.writeCSVHeader(this.csvWriter, this.parameters, this.project);
            CSVImpactUtils.writeCsvHeader(this.csvWriter, true);
        }
        Holder hd = new Holder();
        VariableElement summaryE = new VariableElement("");
        hd.setSummaryEl(summaryE);
        ArrayList<ObjectForSubreport3Link> summaryEntries = new ArrayList<ObjectForSubreport3Link>();
        VariableElement detailEl = new VariableElement("");
        hd.setDetailsEl(detailEl);
        DetailsDataSource summaryDS = new DetailsDataSource(7);
        summaryDS.setList(summaryEntries);
        summaryE.addDataSource((SubreportDataSource)summaryDS);
        summaryE.setSummaryAdded(true);
        summaryDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "summarytotals.column1.title"));
        summaryDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "summarytotals.column2.title"));
        String titleAnchor = "Variable summary";
        ObjectForSubreport3Link objSumm = new ObjectForSubreport3Link();
        objSumm.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.variable.column1.text"));
        ArrayList<Variable> finalVariables = new ArrayList<Variable>();
        for (String[] info : this.finalVarsInfo) {
            Variable v = new Variable();
            v.varName = info[0];
            v.parentRecord = info[1];
            v.id = info[2];
            v.defSource = info[3];
            v.language = info[4];
            v.startRow = Integer.valueOf(info[5]);
            v.progName = info[6];
            v.defSourceIsInclude = info[7] != null && Boolean.valueOf(info[7]) == false;
            finalVariables.add(v);
            Program inp = new Program();
            inp.name = v.defSource;
            inp.path = v.defSource;
            inp.type = v.language;
            inp.isInclude = v.defSourceIsInclude;
            inp.startRow = String.valueOf(v.startRow);
            this.sourcesList.add(inp);
        }
        int varNo = finalVariables.size();
        if (varNo > 0) {
            objSumm.setLeftLink(titleAnchor);
            objSumm.setLeftAnchor(Boolean.valueOf(true));
        } else {
            L.debug("no variables in summary");
        }
        summaryEntries.add(objSumm);
        DetailsDataSource detailsDS = null;
        ArrayList<ObjectForSubreport3Link> detailsEntries = null;
        HashSet<String> finalVarIds = new HashSet<String>();
        ObjectForSubreport3Link obj = null;
        if (varNo > 0) {
            detailsEntries = new ArrayList<ObjectForSubreport3Link>();
            Collections.sort(finalVariables);
            L.trace("after sorting variables");
            for (Variable var : finalVariables) {
                obj = new ObjectForSubreport3Link();
                obj.setMiddleLink(var.id);
                obj.setMiddleAnchor(Boolean.valueOf(true));
                obj.setLeftValue(com.ez.mainframe.data.utils.Utils.filterNullValue((String)var.parentRecord) == null ? "" : var.parentRecord);
                obj.setMiddleValue(var.varName);
                obj.setRightValue(Messages.getString(FieldExpansionSearch.class, "source.column.entry", new Object[]{var.defSource, var.startRow}));
                obj.setRightLink(String.valueOf(var.defSource) + "," + var.language + "," + var.startRow);
                detailsEntries.add(obj);
                finalVarIds.add(var.id);
            }
            objSumm.setMiddleValue(Integer.toString(finalVarIds.size()));
            if (detailsEntries.isEmpty()) {
                objSumm.setLeftAnchor(Boolean.valueOf(false));
                objSumm.setLeftLink(null);
            } else {
                detailsDS = new DetailsDataSource(3);
                detailsDS.setList(detailsEntries);
                detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "variable.summary.page.title"));
                detailsDS.setTitleAnchor(titleAnchor);
                detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "variable.summary.page.TOCentry"));
                summaryE.addDataSource((SubreportDataSource)detailsDS);
                detailsDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "variable.summary.column1.title"));
                detailsDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "variable.summary.column2.title"));
                detailsDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "variable.summary.column3.title"));
            }
        }
        HashMap<String, CallsInfo> programCalls = new HashMap<String, CallsInfo>();
        if (this.programInfo.size() > 0) {
            for (String[] info : this.programInfo) {
                Program p = new Program();
                p.name = info[0];
                p.id = info[1];
                p.path = info[2];
                p.type = info[3];
                p.startRow = info[4];
                this.programList.add(p);
            }
            for (String[] info : this.progCallsInfo) {
                this.addProgramCall(programCalls, info[0], info[1], info[2], info[3], info[4], info[5], info[6], info[7], info[8], info[9], info[10]);
            }
            titleAnchor = "programs summary";
            obj = new ObjectForSubreport3Link();
            obj.setLeftValue(Messages.getString(ImpactReportBuilder.class, "summary.proc.column1.text"));
            obj.setLeftLink(titleAnchor);
            obj.setLeftAnchor(Boolean.valueOf(true));
            obj.setMiddleValue(Integer.toString(this.programList.size()));
            summaryEntries.add(obj);
            ArrayList<ObjectForSubreport3Link> progSummDetEntries = new ArrayList<ObjectForSubreport3Link>();
            detailsDS = new DetailsDataSource(4);
            detailsDS.setList(progSummDetEntries);
            detailsDS.setTitle(Messages.getString(ImpactReportBuilder.class, "summary.proc.page.title"));
            detailsDS.setTitleAnchor(titleAnchor);
            detailsDS.setTocEntry(Messages.getString(ImpactReportBuilder.class, "summary.proc.page.TOCentry"));
            summaryE.addDataSource((SubreportDataSource)detailsDS);
            detailsDS.setCol1Title(Messages.getString(ImpactReportBuilder.class, "proc.summary.column1.text"));
            detailsDS.setCol2Title(Messages.getString(ImpactReportBuilder.class, "proc.summary.column2.text"));
            Collections.sort(this.programList);
            L.trace("after sorting programs");
            for (Program p : this.programList) {
                if (p.path == null) {
                    p.path = NOT_AVAILABLE;
                }
                obj = new ObjectForSubreport3Link();
                obj.setLeftValue(p.name);
                HashMap<String, Set<VarLinkInfo>> varsInProgram = new HashMap<String, Set<VarLinkInfo>>();
                TreeSet<VarLinkInfo> vars = new TreeSet<VarLinkInfo>();
                if (this.varsInProgramsInfo.containsKey(p.id)) {
                    for (Pair<String, String> pair : this.varsInProgramsInfo.get(p.id)) {
                        VarLinkInfo vli = new VarLinkInfo();
                        vli.vid = (String)pair.getFirst();
                        vli.vname = (String)pair.getSecond();
                        vars.add(vli);
                    }
                }
                varsInProgram.put(p.id, vars);
                boolean hasDetails = this.addProgramDetails(detailEl, p, finalVarIds, programCalls, varsInProgram);
                if (hasDetails) {
                    obj.setLeftLink("program_" + p.id);
                    obj.setLeftAnchor(Boolean.valueOf(true));
                }
                obj.setMiddleValue(p.path);
                if (!p.path.equals(NOT_AVAILABLE)) {
                    obj.setMiddleLink(String.valueOf(p.path) + ", " + p.type);
                }
                progSummDetEntries.add(obj);
            }
        }
        this.putResourceDetails(summaryE, summaryEntries, detailEl, programCalls);
        this.putSourceDetails(summaryE, summaryEntries, this.sourcesList);
        this.putDetails(detailEl, finalVariables);
        this.buildAppendixOptionsPart(this.parameters);
        ImpactReportDataSource dataSource = new ImpactReportDataSource(hd);
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        return dataSource;
    }

    private void splitPathsInfo() {
        Collection<List<List<String[]>>> realPaths = Collections.unmodifiableCollection(this.pathsInfo.values());
        HashMap toAdd = new HashMap();
        for (List<List<String[]>> paths : realPaths) {
            if (paths.isEmpty()) continue;
            for (List<String[]> path : paths) {
                if (path.isEmpty()) continue;
                ArrayList<String[]> fakeList = new ArrayList<String[]>();
                String[] firstsg = path.get(0);
                fakeList.add(firstsg);
                if (firstsg[9] != null && !toAdd.containsKey(firstsg[9])) {
                    toAdd.put(firstsg[9], fakeList);
                }
                int i = 1;
                while (i < path.size() - 1) {
                    ArrayList<String[]> list = new ArrayList<String[]>(fakeList);
                    String[] sgI = path.get(i);
                    list.add(sgI);
                    if (sgI[9] != null && !toAdd.containsKey(sgI[9])) {
                        toAdd.put(sgI[9], list);
                    }
                    fakeList = new ArrayList(list);
                    ++i;
                }
            }
        }
        for (String id : toAdd.keySet()) {
            if (this.pathsInfo.containsKey(id)) {
                L.debug("path will be skip it.");
                continue;
            }
            ArrayList<List> list = new ArrayList<List>();
            list.add((List)toAdd.get(id));
            this.pathsInfo.put(id, list);
        }
    }

    private String addToFinalVar(String[] pathInfo) {
        String vid = null;
        Object progName = null;
        String varName = pathInfo[4];
        String language = pathInfo[7];
        String startRow = pathInfo[5];
        String defSource = pathInfo[6];
        String[] stringArray = new String[7];
        stringArray[0] = varName;
        stringArray[2] = vid;
        stringArray[3] = defSource;
        stringArray[4] = language;
        stringArray[5] = startRow;
        stringArray[6] = progName;
        this.finalVarsInfo.add(stringArray);
        return vid;
    }

    private void putResourceDetails(VariableElement summaryE, List<ObjectForSubreport3Link> summaryEntries, VariableElement detailEl, Map<String, CallsInfo> programCalls) {
        if (this.resourceResults != null) {
            for (String resType : this.resourceResults.keySet()) {
                Map<String[], Set<String>> result = this.resourceResults.get(resType);
                ArrayList<String[]> rez = new ArrayList<String[]>(result.keySet());
                String resTypeName = this.getResourceTypeName(resType);
                String titleAnchor = String.valueOf(resTypeName) + " summary";
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.resource.column1.text", new String[]{resTypeName}));
                obj.setLeftLink(titleAnchor);
                obj.setLeftAnchor(Boolean.valueOf(true));
                obj.setMiddleValue(Integer.toString(rez.size()));
                summaryEntries.add(obj);
                ArrayList<ObjectForSubreport3Link> detailsEntries = new ArrayList<ObjectForSubreport3Link>();
                DetailsDataSource detailsDS = new DetailsDataSource(4);
                detailsDS.setList(detailsEntries);
                detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "summary.resource.page.title", new String[]{resTypeName}));
                detailsDS.setTitleAnchor(titleAnchor);
                detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "summary.resource.page.TOCentry", new String[]{resTypeName}));
                summaryE.addDataSource((SubreportDataSource)detailsDS);
                detailsDS.setCol1Title(resTypeName);
                String col2Title = Messages.getString(FieldExpansionSearch.class, "resources.summary.column2.text");
                boolean isDataset = false;
                if (resType.equalsIgnoreCase("EXT_TYPE_DATASET")) {
                    detailsDS.setCol3Title(col2Title);
                    isDataset = true;
                } else {
                    detailsDS.setCol2Title(col2Title);
                }
                Collections.sort(rez, new ResourcesComparator(resType));
                for (String[] cols : rez) {
                    obj = new ObjectForSubreport3Link();
                    if (resType.equals("56")) {
                        cols[1] = AdabasUtils.getListableName((String)cols[1], (String)cols[4]);
                    }
                    String resName = ReportsUtils.stripNonValidXMLCharacters((String)cols[1], (boolean)true);
                    obj.setLeftValue(resName);
                    boolean hasDetails = this.addResourceDetails(detailEl, resType, cols, programCalls, result.get(cols));
                    if (hasDetails) {
                        obj.setLeftLink(String.valueOf(resTypeName) + ReportsUtils.stripNonValidXMLCharacters((String)cols[0], (boolean)true));
                        obj.leftTooltip = Messages.getString(FieldExpansionSearch.class, "resource.summary.details.tooltip", new String[]{ReportsUtils.prepareTooltip((String)cols[1])});
                        obj.setLeftAnchor(Boolean.valueOf(true));
                    }
                    if (isDataset) {
                        obj.setRightValue(NOT_AVAILABLE);
                    } else if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[3]) != null && !cols[3].trim().equals("") || com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[2]) != null && !cols[2].trim().equals("")) {
                        String line = cols[3];
                        String source = Messages.getString(FieldExpansionSearch.class, "source.column.entry", new Object[]{cols[2], line});
                        obj.setMiddleValue(source);
                        String language = null;
                        if ((resType.equals("1") || resType.equals("187")) && cols.length > 4) {
                            language = cols[4];
                        }
                        if (language == null && cols[2] != null) {
                            language = this.findProgramLanguageByPath(cols[2]);
                        }
                        String link = String.valueOf(cols[2]) + "," + (language == null ? this.getResourceTypeName(resType) : language) + "," + line;
                        obj.setMiddleLink(link);
                    } else {
                        obj.setMiddleValue(NOT_AVAILABLE);
                    }
                    detailsEntries.add(obj);
                }
            }
        }
    }

    private void putSourceDetails(VariableElement summaryE, List<ObjectForSubreport3Link> summaryEntries, Set<Program> sourcesList) {
        if (sourcesList != null && sourcesList.size() > 0) {
            String titleAnchor = "sources summary";
            ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
            obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.sources.column1.text"));
            obj.setLeftLink(titleAnchor);
            obj.setLeftAnchor(Boolean.valueOf(true));
            obj.setMiddleValue(Integer.toString(sourcesList.size()));
            summaryEntries.add(obj);
            ArrayList<ObjectForSubreport3Link> detailsEntries = new ArrayList<ObjectForSubreport3Link>();
            DetailsDataSource detailsDS = new DetailsDataSource(4);
            detailsDS.setList(detailsEntries);
            detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "summary.sources.section.title"));
            detailsDS.setTitleAnchor(titleAnchor);
            detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "summary.sources.page.TOCentry"));
            summaryE.addDataSource((SubreportDataSource)detailsDS);
            detailsDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "sources.summary.column1.text"));
            detailsDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "sources.summary.column2.text"));
            ArrayList<Program> lstSourcesList = new ArrayList<Program>(sourcesList);
            Collections.sort(lstSourcesList);
            L.trace("after sorting sources");
            for (Program s : lstSourcesList) {
                obj = new ObjectForSubreport3Link();
                obj.setLeftValue(ReportsUtils.stripNonValidXMLCharacters((String)s.name, (boolean)true));
                obj.setLeftLink(String.valueOf(s.path) + ", " + s.type);
                String type = s.type;
                obj.setRightValue(String.valueOf(type) + (s.isInclude ? " " + Utils.RESOURCE_TYPE_INCLUDE : ""));
                detailsEntries.add(obj);
            }
            lstSourcesList.clear();
        }
    }

    private void putResDetails(VariableElement el, Map<String, List<String[]>> resourceResults) {
        if (resourceResults == null || resourceResults.isEmpty()) {
            return;
        }
        for (String resType : resourceResults.keySet()) {
            List<String[]> rez = resourceResults.get(resType);
            if (rez == null || rez.size() <= 0) continue;
            Iterator<String[]> iterator = rez.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    private void addProgramCall(Map<String, CallsInfo> programCalls, String fromId, String fromName, String toId, String toName, String dir, String fromVId, String fromVName, String toVId, String toVName, String sOffset, String eOffset) {
        dir = "1".equals(dir) ? "->" : "<-";
        CallsInfo fromInfo = programCalls.get(fromId);
        if (fromInfo == null) {
            fromInfo = new CallsInfo();
            fromInfo.id = fromId;
            fromInfo.name = fromName;
            fromInfo.inCalls = new ArrayList<PInfo>();
            fromInfo.outCalls = new ArrayList<PInfo>();
            programCalls.put(fromId, fromInfo);
        }
        PInfo outExists = null;
        for (PInfo pinfo : fromInfo.outCalls) {
            if (!pinfo.fromId.equals(fromId) || !pinfo.toId.equals(toId)) continue;
            outExists = pinfo;
            break;
        }
        if (outExists == null) {
            PInfo pinfo;
            pinfo = new PInfo();
            pinfo.fromId = fromId;
            pinfo.fromName = fromName;
            pinfo.toId = toId;
            pinfo.toName = toName;
            pinfo.callDir = dir;
            if (fromVName != null) {
                VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
                pinfo.vInfo.add(vinfo);
            }
            fromInfo.outCalls.add(pinfo);
        } else if (fromVName != null) {
            VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
            if (outExists.vInfo.contains(vinfo) && vinfo.linkageVId != null) {
                outExists.vInfo.remove(vinfo);
                outExists.vInfo.add(vinfo);
            } else {
                outExists.vInfo.add(vinfo);
            }
        }
        CallsInfo toInfo = programCalls.get(toId);
        if (toInfo == null) {
            toInfo = new CallsInfo();
            toInfo.id = toId;
            toInfo.name = toName;
            toInfo.inCalls = new ArrayList<PInfo>();
            toInfo.outCalls = new ArrayList<PInfo>();
            programCalls.put(toId, toInfo);
        }
        PInfo inExists = null;
        for (PInfo pinfo : toInfo.inCalls) {
            if (!pinfo.fromId.equals(fromId) || !pinfo.toId.equals(toId)) continue;
            inExists = pinfo;
            break;
        }
        if (inExists == null) {
            PInfo pinfo;
            pinfo = new PInfo();
            pinfo.fromId = fromId;
            pinfo.fromName = fromName;
            pinfo.toId = toId;
            pinfo.toName = toName;
            pinfo.callDir = dir;
            if (fromVName != null) {
                VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
                pinfo.vInfo.add(vinfo);
            }
            toInfo.inCalls.add(pinfo);
        } else if (fromVName != null) {
            VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
            if (inExists.vInfo.contains(vinfo) && vinfo.linkageVId != null) {
                inExists.vInfo.remove(vinfo);
                inExists.vInfo.add(vinfo);
            } else {
                inExists.vInfo.add(vinfo);
            }
        }
    }

    private String findProgramLanguageByPath(String prgPath) {
        String language = null;
        for (Program p : this.programList) {
            if (language != null) continue;
            if (p.path == null) {
                p.path = NOT_AVAILABLE;
            }
            if (!p.path.equalsIgnoreCase(prgPath)) continue;
            language = p.type;
            L.trace("path found, use the language of program: {}", (Object)p.name);
            break;
        }
        if (language == null && this.sourcesList != null) {
            Iterator<Program> it = this.sourcesList.iterator();
            while (it.hasNext() && language == null) {
                Program p = it.next();
                if (!prgPath.equalsIgnoreCase(p.path) || !p.isInclude) continue;
                language = p.type;
                L.trace("path found, use the language of include: {}", (Object)p.name);
            }
        }
        return language;
    }

    private boolean addProgramDetails(VariableElement el, Program p, Set<String> finalVarIds, Map<String, CallsInfo> programCalls, Map<String, Set<VarLinkInfo>> varsInPrograms) {
        boolean hasDetails = false;
        DetailsDataSource elemDS = new DetailsDataSource(6);
        String tocEntry = Messages.getString(ImpactReportBuilder.class, "details.proc.tocEntry", new String[]{p.name});
        String textToPrint = Messages.getString(ImpactReportBuilder.class, "details.proc.entry", new String[]{p.name});
        String detailsTitle = FieldExpansionSearch.getTitle4DetailsSection(textToPrint);
        elemDS.setList(new ArrayList());
        elemDS.setTitle(detailsTitle);
        elemDS.setTitleAnchor("program_" + p.id);
        elemDS.setTocEntry(tocEntry);
        boolean hasVarPaths = false;
        ArrayList<VarDetails> details = new ArrayList<VarDetails>();
        List<List<String[]>> paths = this.pathsInfo.get(p.id);
        if (paths != null && paths.size() > 0) {
            for (String[] pInfo : paths.get(0)) {
                VarDetails vd = new VarDetails();
                vd.from = pInfo[0];
                vd.to = pInfo[4];
                vd.toLanguage = pInfo[7];
                vd.toLine = pInfo[5];
                vd.toLink = pInfo[6];
                vd.impactType = pInfo[8];
                vd.programName = pInfo[1];
                details.add(vd);
            }
            elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
            elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
            elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
            String[] stringArray = new String[4];
            stringArray[1] = p.name;
            stringArray[2] = Utils.RESOURCE_TYPE_PROGRAM;
            stringArray[3] = p.type;
            String[] csvDetails = stringArray;
            hasVarPaths = !details.isEmpty() && this.addVarDetails(el, details, elemDS, null, null, null, false, true, csvDetails);
        } else {
            elemDS.setCol1Title(null);
            elemDS.setCol2Title(null);
            elemDS.setCol3Title(null);
            ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
            obj.setLeftValue("");
            elemDS.getList().add(obj);
        }
        PathPrinter pp = new PathPrinter();
        pp.setCSVWriter(this.csvWriter);
        boolean hasPaths = pp.printProgramPaths(1, p.id, p.name, programCalls, elemDS);
        VariablePrinter vp = new VariablePrinter(false);
        vp.setCSVWriter(this.csvWriter);
        boolean hasvariables = vp.printVariableList(p.id, p.name, varsInPrograms, null, elemDS);
        LinkagePrinter lp = new LinkagePrinter(true, procTitle, actualParamTitle, formParamTitle);
        lp.setCSVWriter(this.csvWriter);
        boolean hasCalls = lp.printLinkage(p.id, p.name, programCalls, finalVarIds, elemDS);
        boolean bl = hasDetails = hasPaths || hasvariables || hasCalls || hasVarPaths;
        if (!hasDetails) {
            L.info("prg without details: {}", (Object)p.name);
        } else {
            el.addDataSource((SubreportDataSource)elemDS);
        }
        return hasDetails;
    }

    private boolean addResourceDetails(VariableElement el, String resType, String[] cols, Map<String, CallsInfo> programCalls, Set<String> usageInPrograms) {
        List<List<String[]>> paths = this.pathsInfo.get(cols[0]);
        if (paths == null || paths.size() == 0) {
            return false;
        }
        String resName = ReportsUtils.stripNonValidXMLCharacters((String)cols[1], (boolean)true);
        String type = this.getResourceTypeName(resType);
        String resType4Details = Messages.getString(FieldExpansionSearch.class, "resourceType.detailsName." + resType);
        String tocEntry = Messages.getString(FieldExpansionSearch.class, "details.resource.tocEntry", new String[]{type, resName});
        String nameToPrint = Messages.getString(FieldExpansionSearch.class, "details.resource.tocEntry", new String[]{resType4Details, resName});
        boolean isFirst = true;
        for (List<String[]> det : paths) {
            DetailsDataSource elemDS = new DetailsDataSource(6);
            ArrayList<ObjectForSubreport3Link> objList = new ArrayList<ObjectForSubreport3Link>();
            elemDS.setList(objList);
            if (isFirst) {
                elemDS.setTitle(FieldExpansionSearch.getTitle4DetailsSection(nameToPrint));
                elemDS.setTitleAnchor(String.valueOf(type) + cols[0]);
                elemDS.setTitleTooltip(ReportsUtils.prepareTooltip((String)(String.valueOf(type) + " " + cols[1])));
                elemDS.setTocEntry(tocEntry);
                isFirst = false;
            }
            elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
            elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
            elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
            el.addDataSource((SubreportDataSource)elemDS);
            String startProgram = null;
            for (String[] vInfo : det) {
                String from = vInfo[0];
                String to = vInfo[4];
                String toLanguage = vInfo[7];
                String toLine = vInfo[5];
                String toLink = vInfo[6];
                String impactType = vInfo[8];
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(ReportsUtils.stripNonValidXMLCharacters((String)from, (boolean)true));
                obj.setMiddleValue(ReportsUtils.stripNonValidXMLCharacters((String)to, (boolean)true));
                obj.setRightValue(impactType);
                if (toLink != null) {
                    String language = toLanguage;
                    obj.setRightLink(String.valueOf(toLink) + "," + language + "," + toLine);
                }
                objList.add(obj);
                if (startProgram == null) {
                    startProgram = vInfo[1];
                }
                if (this.csvWriter == null) continue;
                this.csvWriter.write(new String[]{CSVImpactUtils.CSV_IMPACT_VAR_DETAIL, startProgram == null ? "" : startProgram, cols[1], type, from, to, impactType});
            }
            if (usageInPrograms == null || usageInPrograms.isEmpty()) continue;
            PathPrinter pp = new PathPrinter();
            pp.setCSVWriter(this.csvWriter);
            pp.printResource(1, programCalls, elemDS, cols[1], resType4Details, usageInPrograms);
        }
        return true;
    }

    private boolean addVarDetails(VariableElement el, List<VarDetails> details, DetailsDataSource elemDS, String textInDetails, String tocEntry, String titleAnchor, boolean addLinks, boolean hasSubtitle, String[] csvDetails) {
        String detailsTitle;
        boolean hasDetails = false;
        String string = detailsTitle = elemDS != null ? elemDS.getTitle() : FieldExpansionSearch.getTitle4DetailsSection(textInDetails);
        if (details.size() == 0) {
            L.debug("could not found relations for {}", (Object)tocEntry);
            if (elemDS == null) {
                elemDS = new DetailsDataSource(6);
                ArrayList objList = new ArrayList();
                elemDS.setList(objList);
                elemDS.setTitle(detailsTitle);
                elemDS.setTitleAnchor(titleAnchor);
                elemDS.setTocEntry(tocEntry);
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "noDataAvailable.text"));
                elemDS.getList().add(obj);
            }
        } else {
            ArrayList<ObjectForSubreport3Link> objList;
            if (elemDS == null) {
                elemDS = new DetailsDataSource(6);
                objList = new ArrayList<ObjectForSubreport3Link>();
                elemDS.setList(objList);
                elemDS.setTitle(detailsTitle);
                elemDS.setTitleAnchor(titleAnchor);
                elemDS.setTocEntry(tocEntry);
                elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
                elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
                elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
            }
            objList = (ArrayList<ObjectForSubreport3Link>)elemDS.getList();
            boolean isFirst = true;
            String prgName = null;
            for (VarDetails vd : details) {
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(ReportsUtils.stripNonValidXMLCharacters((String)vd.from, (boolean)true));
                if (addLinks && vd.fromLink != null) {
                    obj.setLeftLink(String.valueOf(vd.fromLink) + "," + vd.fromLanguage + "," + vd.fromLine);
                }
                obj.setMiddleValue(ReportsUtils.stripNonValidXMLCharacters((String)vd.to, (boolean)true));
                if (addLinks && vd.toLink != null) {
                    obj.setMiddleLink(String.valueOf(vd.toLink) + "," + vd.toLanguage + "," + vd.toLine);
                }
                obj.setRightValue(ReportsUtils.stripNonValidXMLCharacters((String)vd.impactType, (boolean)true));
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)vd.toLink) != null) {
                    String language = vd.toLanguage;
                    if (language == null || language.isEmpty()) {
                        language = "TODO";
                    }
                    obj.setRightLink(String.valueOf(vd.toLink) + "," + language + "," + vd.toLine);
                }
                objList.add(obj);
                if (csvDetails != null) {
                    if (isFirst) {
                        prgName = vd.programName;
                    }
                    this.csvWriter.write(new String[]{CSVImpactUtils.CSV_IMPACT_VAR_DETAIL, prgName, csvDetails[1], String.valueOf(csvDetails[2]) + (csvDetails[3] == null ? "" : " (" + csvDetails[3] + ")"), vd.from, vd.to, vd.impactType});
                }
                if (!isFirst || !hasSubtitle) continue;
                if (vd.programName == null) {
                    L.debug("startProgram is not set");
                }
                String subTitle = Messages.getString(FieldExpansionSearch.class, "details.startProgram.section.title", new String[]{vd.programName});
                elemDS.setSubTitle(subTitle);
                isFirst = false;
            }
            hasDetails = true;
        }
        return hasDetails;
    }

    private String getResourceTypeName(String resType) {
        return Messages.getString(FieldExpansionSearch.class, "resourceType." + resType);
    }

    private void putDetails(VariableElement el, List<Variable> finalVariables) {
        for (Variable var : finalVariables) {
            if (!this.pathsInfo.containsKey(var.id)) continue;
            int i = 0;
            String varNameToPrint = null;
            for (List<String[]> det : this.pathsInfo.get(var.id)) {
                DetailsDataSource elemDS = new DetailsDataSource(6);
                ArrayList<ObjectForSubreport3Link> objList = new ArrayList<ObjectForSubreport3Link>();
                elemDS.setList(objList);
                el.addDataSource((SubreportDataSource)elemDS);
                String subTitle2 = Messages.getString(FieldExpansionSearch.class, "details.contextProgram.section.title", new String[]{var.progName});
                elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
                elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
                elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
                elemDS.setSubTitle2(subTitle2);
                if (i == 0) {
                    varNameToPrint = String.valueOf(com.ez.mainframe.data.utils.Utils.filterNullValue((String)var.parentRecord) == null ? "" : String.valueOf(var.parentRecord) + ".") + var.varName;
                    String varType = Messages.getString(FieldExpansionSearch.class, "variable.details.type");
                    String detailsTitle = Messages.getString(FieldExpansionSearch.class, "details.section.title", new String[]{varType, varNameToPrint});
                    String subTitle = Messages.getString(FieldExpansionSearch.class, "details.path.section.title", new String[]{var.defSource, String.valueOf(var.startRow)});
                    elemDS.setSubTitle(subTitle);
                    elemDS.setSubtitleLink(String.valueOf(var.defSource) + "," + var.language + "," + var.startRow);
                    elemDS.setTitle(detailsTitle);
                    elemDS.setTitleAnchor(var.id);
                    elemDS.setTocEntry(varNameToPrint);
                    ++i;
                }
                for (String[] vInfo : det) {
                    String from = vInfo[0];
                    String to = vInfo[4];
                    String toLanguage = vInfo[7];
                    String toLine = vInfo[5];
                    String toLink = vInfo[6];
                    String impactType = vInfo[8];
                    ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                    obj.setLeftValue(ReportsUtils.stripNonValidXMLCharacters((String)from, (boolean)true));
                    obj.setMiddleValue(ReportsUtils.stripNonValidXMLCharacters((String)to, (boolean)true));
                    obj.setRightValue(impactType);
                    if (toLink != null) {
                        String language = toLanguage;
                        obj.setRightLink(String.valueOf(toLink) + "," + language + "," + toLine);
                    }
                    objList.add(obj);
                    if (this.csvWriter == null) continue;
                    this.csvWriter.write(new String[]{CSVImpactUtils.CSV_IMPACT_VAR_DETAIL, var.progName, varNameToPrint, Messages.getString(FieldExpansionSearch.class, "csv.variable.details"), from, to, impactType});
                }
            }
        }
        if (this.pathsInfo != null) {
            this.pathsInfo.clear();
        }
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Boolean forPrograms = (Boolean)this.inputs.get("selectionOnPrograms");
            if (forPrograms != null) {
                if (Boolean.TRUE.equals(forPrograms)) {
                    this.report.addProperty("resource_type", (Object)Utils.RESOURCE_TYPE_PROGRAM);
                } else {
                    this.report.addProperty("resource_type", (Object)Utils.RESOURCE_TYPE_INCLUDE);
                }
            }
            this.report.addProperty("selectionOnDBField", this.inputs.get("selectionOnDBField"));
            Integer depth = (Integer)this.inputs.get("max cycles");
            this.report.addProperty("max cycles", (Object)depth);
            this.report.addProperty(FORWARD_DIRECTION, this.inputs.get(FORWARD_DIRECTION));
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public JasperPrint getReportDocument() {
        JasperPrint print;
        JasperPrint jasperPrint = print = this.report != null ? this.report.print : null;
        if (print != null) {
            this.report.print.setProperty("pdf_hyperlink_export", "true");
        }
        return print;
    }

    protected void buildAppendixOptionsPart(Map<String, Object> params) {
        Boolean partialData;
        Integer propVal = (Integer)this.report.getProperty("max cycles");
        String maxCyclesText = propVal == null || propVal == 0 ? Messages.getString(FieldExpansionBuilder.class, "depth.appendix.unlimtedvalue") : propVal.toString();
        String optionsText = Messages.getString(FieldExpansionBuilder.class, "depth.appendix.text", new String[]{maxCyclesText});
        Boolean isFwVal = (Boolean)this.report.getProperty(FORWARD_DIRECTION);
        if (isFwVal != null) {
            String direction = this.getDirectionStr(isFwVal);
            optionsText = String.valueOf(optionsText) + Messages.getString(FieldExpansionBuilder.class, "direction.appendix.text", new String[]{direction});
        }
        if ((partialData = (Boolean)this.extraInputs.get("partialData")) != null && partialData.booleanValue()) {
            optionsText = String.valueOf(optionsText) + Messages.getString(ImpactReportBuilder.class, "canceled.appendix.text");
        }
        params.put("noColor", Boolean.TRUE);
        ElementGroupInfo appDS = new ElementGroupInfo("");
        DSFactory factory = new DSFactory();
        SC1DataSource dataSource = (SC1DataSource)factory.createDS(3);
        dataSource.setExtraTitle(Messages.getString(FieldExpansionBuilder.class, "appendix.title"));
        dataSource.setLayout(6);
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        dataSource.setList(list);
        appDS.addDataSource((SubreportDataSource)dataSource);
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(FieldExpansionBuilder.class, "options.appendix.label"));
        obj.setExpVal(optionsText);
        list.add(obj);
        list.add(FieldExpansionBuilder.createEmptySpace(factory));
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(FieldExpansionBuilder.class, "appendix.inputs.subtitle"));
        SC1DataSource inptsDS = new SC1DataSource();
        inptsDS.setLayout(4);
        obj.setSubreportDS((BaseSubreportDataSource)inptsDS);
        obj.setSubreportName("reports/subCols1-layout4.jasper");
        list.add(obj);
        params.remove("resourcesSummary");
        List inptsLst = (List)params.remove("inputResources");
        inptsDS.setList(inptsLst);
        list.add(FieldExpansionBuilder.createEmptySpace(factory));
        HashMap excludedRes = (HashMap)this.extraInputs.remove("excludedResources");
        if (excludedRes != null && !excludedRes.isEmpty()) {
            this.buildAppendixExcludedPart(list, excludedRes);
        }
        list.add(FieldExpansionBuilder.createEmptySpace(factory));
        ArrayList<String[]> scores = new ArrayList<String[]>();
        String[] stringArray = new String[3];
        stringArray[0] = "";
        String[] edgesTitle = stringArray;
        String txt = Messages.getString(ImpactReportBuilder.class, "appendix.flow.legend.programCall");
        String[] stringArray2 = new String[3];
        stringArray2[1] = "blue";
        stringArray2[2] = txt;
        String[] edges1 = stringArray2;
        txt = Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.dataflow");
        String[] stringArray3 = new String[5];
        stringArray3[1] = "green2";
        stringArray3[2] = txt;
        stringArray3[4] = "true";
        String[] edges2 = stringArray3;
        txt = Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.resourceusage");
        String[] stringArray4 = new String[7];
        stringArray4[1] = "black";
        stringArray4[2] = txt;
        stringArray4[6] = "true";
        String[] edges3 = stringArray4;
        scores.add(edgesTitle);
        scores.add(edges1);
        scores.add(edges2);
        scores.add(edges3);
        appDS.addDataSource((SubreportDataSource)new LegendDataSource(Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.title"), scores));
        params.put("thinLines", Boolean.TRUE);
        params.put("appendixDS", appDS);
    }

    private void buildAppendixExcludedPart(List<ObjectForSubreport> list, HashMap<String, List<Map<String, String>>> excludedRes) {
        for (String resType : excludedRes.keySet()) {
            List<Map<String, String>> excludedObj = excludedRes.get(resType);
            if (excludedObj == null || excludedObj.isEmpty()) continue;
            ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
            String subreportTitle = null;
            ObjectForSubreport obj = new ObjectForSubreport();
            SC1DataSource inptsDS = new SC1DataSource();
            inptsDS.setLayout(4);
            inptsDS.setList(lst);
            obj.setSubreportDS((BaseSubreportDataSource)inptsDS);
            obj.setSubreportName("reports/subCols1-layout4.jasper");
            list.add(obj);
            for (Map<String, String> data : excludedObj) {
                String txt = null;
                if ("variable".equals(resType)) {
                    String resTypeStr;
                    String varName = data.get("variable");
                    String program = data.get("program");
                    String include = data.get("include");
                    boolean fromProgram = program != null && !program.isEmpty();
                    boolean fromInclude = include != null && !include.isEmpty();
                    subreportTitle = Messages.getString(ImpactReportBuilder.class, "appendix.excludedVariables.label");
                    String string = fromProgram ? Messages.getString(ImpactReportBuilder.class, "appendix.excludedVariables.resourcetype.program") : (resTypeStr = fromInclude ? Messages.getString(ImpactReportBuilder.class, "appendix.excludedVariables.resourcetype.include") : null);
                    txt = resTypeStr == null ? varName : Messages.getString(ImpactReportBuilder.class, "appendix.excludedVariables.varEntry", new String[]{varName, resTypeStr, fromProgram ? program : include});
                } else if ("sqltable".equals(resType)) {
                    subreportTitle = Messages.getString(ImpactReportBuilder.class, "appendix.excludedSQLTables.label");
                    txt = data.get("sqltable");
                } else if ("sqlfield".equals(resType)) {
                    String fieldName;
                    subreportTitle = Messages.getString(ImpactReportBuilder.class, "appendix.excludedSQLFields.label");
                    String tblName = data.get("sqltable");
                    txt = fieldName = data.get("sqlfield");
                    if (tblName != null && !tblName.isEmpty()) {
                        txt = String.valueOf(txt) + Messages.getString(ImpactReportBuilder.class, "sql.tbl.lbl", new String[]{tblName});
                    }
                } else if ("dataset".equals(resType)) {
                    subreportTitle = Messages.getString(ImpactReportBuilder.class, "appendix.excludedDatasets.label");
                    txt = data.get("dataset");
                } else if ("bmsproxy".equals(resType)) {
                    subreportTitle = Messages.getString(ImpactReportBuilder.class, "appendix.excludedBMSMap.label");
                    String name = data.get("bmsproxy");
                    String mapName = data.get("mapset");
                    txt = name;
                    if (name != null && !name.isEmpty()) {
                        txt = String.valueOf(txt) + Messages.getString(ImpactReportBuilder.class, "mapset.lbl", new String[]{mapName});
                    }
                } else if ("dalfile".equals(resType)) {
                    subreportTitle = Messages.getString(ImpactReportBuilder.class, "appendix.excludedDALFile.label");
                    txt = data.get("dalfile");
                }
                if (txt == null) continue;
                obj.setExp(subreportTitle);
                ObjectForSubreport varObj = new ObjectForSubreport();
                varObj.setExp(txt);
                varObj.setExpVal("");
                lst.add(varObj);
            }
        }
    }

    public void setInputs(Map<String, Object> inputs) {
        super.setInputs(inputs);
        this.inputs.putAll(this.extraInputs);
    }

    public void cleanMemory() {
        if (this.pathsInfo != null) {
            this.pathsInfo.clear();
            this.pathsInfo = null;
        }
        if (this.progCallsInfo != null) {
            this.progCallsInfo.clear();
            this.progCallsInfo = null;
        }
        if (this.programInfo != null) {
            this.programInfo.clear();
            this.programInfo = null;
        }
        if (this.programList != null) {
            this.programList.clear();
            this.programList = null;
        }
        if (this.resourceResults != null) {
            this.resourceResults.clear();
            this.resourceResults = null;
        }
        if (this.sourcesList != null) {
            this.sourcesList.clear();
            this.sourcesList = null;
        }
        if (this.varsInProgramsInfo != null) {
            this.varsInProgramsInfo.clear();
            this.varsInProgramsInfo = null;
        }
        if (this.extraInputs != null) {
            this.extraInputs.clear();
            this.extraInputs = null;
        }
        if (this.finalVarsInfo != null) {
            this.finalVarsInfo.clear();
            this.finalVarsInfo = null;
        }
        super.cleanMemory();
    }

    private class ResourcesComparator
    implements Comparator<String[]> {
        String resType = null;

        public ResourcesComparator(String resType) {
            this.resType = resType;
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            int ret = -1;
            if (o1 == null && o2 == null) {
                ret = 0;
            } else if (o1 != null) {
                if (o2 != null) {
                    if (o1.length > 2 && o2.length > 2) {
                        if (o1[1] != null) {
                            if (o2[1] != null) {
                                String n1 = o1[1];
                                String n2 = o2[1];
                                if (this.resType.equals("56")) {
                                    n1 = AdabasUtils.getListableName((String)o1[1], (String)o1[4]);
                                    n2 = AdabasUtils.getListableName((String)o2[1], (String)o2[4]);
                                }
                                ret = n1.compareToIgnoreCase(n2);
                            } else {
                                ret = 1;
                            }
                        } else if (o2[1] != null) {
                            ret = -1;
                        }
                    } else {
                        ret = 0;
                    }
                } else {
                    ret = 1;
                }
            } else {
                ret = -1;
            }
            return ret;
        }
    }
}

