/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.tst;

import com.ez.report.application.ezreport.reports.impact.tst.Entry;
import com.ez.report.application.ezreport.reports.impact.tst.EntryComparator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerArrayTuple;

public class Test {
    static int id = 0;

    public static void main(String[] args) {
        PersistentEntryList lst = Test.createList();
        int idx = 300000;
        System.out.println("entry with id=" + idx + ": " + lst.getByInternalId(idx));
        String dbID = "20000";
        Test.printEntriesWithId(lst, dbID);
        idx = 99994;
        Entry ent = lst.getByInternalId(idx);
        System.out.println("before update: " + ent);
        Test.printEntriesWithId(lst, ent.getDbId());
        Entry ent2 = new Entry(ent.getInternalID(), ent.getDbId());
        ent2.setName("nume modificat");
        lst.update(ent2);
        ent = lst.getByInternalId(idx);
        System.out.println("after update: " + ent);
        Test.printEntriesWithId(lst, dbID);
        lst.close();
    }

    private static void printEntriesWithId(PersistentEntryList lst, String dbID) {
        System.out.println("entries with dbID=" + dbID);
        Iterable<Entry> it = lst.getById(dbID);
        for (Entry entry : it) {
            System.out.println(entry);
        }
        System.out.println("-----------------");
    }

    private static PersistentEntryList createList() {
        PersistentEntryList lst = new PersistentEntryList();
        int dbID = 1;
        int i = 0;
        while (i < 500000) {
            String id = String.valueOf(dbID);
            Entry e = new Entry(i, id);
            e.setName("nume");
            lst.add(e);
            if (i % 5 == 0) {
                ++dbID;
            }
            if (i % 10000 == 0) {
                System.out.println("i=" + i);
            }
            ++i;
        }
        return lst;
    }

    static int getNewID() {
        return id++;
    }

    static class CustomSerializer
    implements Serializer<Entry>,
    Serializable {
        CustomSerializer() {
        }

        public void serialize(DataOutput2 out, Entry value) throws IOException {
            out.writeUTF(String.valueOf(value.getInternalID()));
            out.writeUTF(value.getDbId());
            out.writeUTF(value.getName());
        }

        public Entry deserialize(DataInput2 in, int available) throws IOException {
            Entry e = new Entry(Integer.valueOf(in.readUTF()), in.readUTF());
            e.setName(in.readUTF());
            return e;
        }

        public int fixedSize() {
            return -1;
        }
    }

    static class PersistentEntryList
    implements Iterable<Entry> {
        private Map<Integer, Entry> byInternalIds;
        NavigableSet<Object[]> byId;
        Iterator<Entry> it = null;
        DB db = null;

        PersistentEntryList() {
            DBMaker.Maker mak = DBMaker.fileDB((String)"C://a/temp.db");
            this.db = mak.make();
            this.byInternalIds = this.db.hashMap("byInternalIds").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)new CustomSerializer()).counterEnable().create();
            this.byId = (NavigableSet)this.db.treeSet("byId").serializer((GroupSerializer)new SerializerArrayTuple(new Serializer[]{this.db.getDefaultSerializer(), new CustomSerializer()}, new Comparator[]{String.CASE_INSENSITIVE_ORDER, new EntryComparator()})).create();
        }

        public void add(Entry e) {
            Map<Integer, Entry> byInternalIds = this.getbyInternalIds();
            if (!byInternalIds.containsKey(e.getInternalID())) {
                this.byId.add(new Object[]{e.getDbId(), e});
                this.getById(e.getDbId());
                byInternalIds.put(e.getInternalID(), e);
            }
        }

        public boolean isEmpty() {
            Map<Integer, Entry> byInternalIds = this.getbyInternalIds();
            return byInternalIds.isEmpty();
        }

        public void clear() {
        }

        public int size() {
            Map<Integer, Entry> byInternalIds = this.getbyInternalIds();
            return byInternalIds.size();
        }

        public Iterable<Entry> getById(String id) {
            Iterable<Entry> iterable = null;
            Object[] objectArray = new Object[2];
            objectArray[0] = id;
            SortedSet<Object[]> mapSubset = this.byId.subSet(new Object[]{id}, objectArray);
            if (!mapSubset.isEmpty()) {
                ArrayList vals = new ArrayList();
                mapSubset.forEach(s -> {
                    boolean bl = vals.add((Entry)s[1]);
                });
                iterable = () -> vals.iterator();
            } else {
                iterable = Collections.emptyList();
            }
            return iterable;
        }

        public Entry getByInternalId(int id) {
            Map<Integer, Entry> byInternalIds = this.getbyInternalIds();
            return byInternalIds.get(id);
        }

        @Override
        public Iterator<Entry> iterator() {
            Map<Integer, Entry> byInternalIds = this.getbyInternalIds();
            if (this.it == null) {
                this.it = byInternalIds.values().iterator();
            }
            return this.it;
        }

        private Map<Integer, Entry> getbyInternalIds() {
            return this.byInternalIds;
        }

        public void update(Entry entry) {
            Map<Integer, Entry> byInternalIds = this.getbyInternalIds();
            Entry removed = byInternalIds.remove(entry.getInternalID());
            System.out.println("*** removed from byInternalIds=" + removed);
            String cfr_ignored_0 = "bb" + entry.getInternalID() + "-nume";
            Iterable<Entry> it = this.getById(entry.getDbId());
            if (it != null) {
                for (Entry ent : it) {
                    if (!ent.equals(entry)) continue;
                    System.out.println("*** found it: " + entry);
                }
            }
            boolean rem = this.byId.remove(new Object[]{entry.getDbId(), entry});
            System.out.println("*** removed from byId=" + rem);
            this.add(entry);
        }

        public void close() {
            this.db.close();
        }
    }
}

