/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldrenaming;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.ImpactBuilder;
import com.ez.report.application.ezreport.reports.impact.fieldrenaming.FieldRenamingDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldrenaming.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends ImpactBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_STATEMENT_DETAILS = "EZReports_FieldRenaming_Stmt_Details";
    private static final String EZREP_STATEMENT_DBFIELD_DETAILS = "EZReports_FieldRenaming_NoSql_Stmt_Details";
    private static final String EZREP_PROGRAM_DETAILS = "EZReports_FieldRenaming_Program_Details";
    private static final String EZREP_PROGRAM_DBFIELD_DETAILS = "EZReports_FieldRenaming_Program_NoSQL_Details";
    private static final String EZREP_SOURCE_DETAILS = "EZReports_FieldRenaming_SourceFile_Details";
    private static final String EZREP_SOURCE_DBFIELD_DETAILS = "EZReports_FieldRenaming_SourceFile_NoSQL_Details";
    static final String PROGRAMS_DETAILS_ANCHOR = "programs_details";
    static final String STATEMENTS_DETAILS_ANCHOR = "statements_details";
    static final String SOURCE_FILES_DETAILS_ANCHOR = "source_files_details";
    private static final String EZREP_STATEMENTS_SUMMARY_SQL = "EZReports_FieldRenaming_Stmt_Summary_Sql";
    private static final String EZREP_STATEMENTS_DBFIELD_SUMMARY_SQL = "EZReports_FieldRenaming_Stmt_NoSQL_Summary_Sql";
    private static final String EZREP_PROGRAM_SUMMARY_SQL = "EZReports_FieldRenaming_Programs_Summary_Sql";
    private static final String EZREP_PROGRAM_DBFIELD_SUMMARY_SQL = "EZReports_FieldRenaming_Programs_NoSQL_Summary_Sql";
    private static final String EZREP_SOURCE_SUMMARY_SQL = "EZReports_FieldRenaming_Sources_Summary_Sql";
    private static final String EZREP_SOURCE_DBFIELD_SUMMARY_SQL = "EZReports_FieldRenaming_Sources_NoSQL_Summary_Sql";
    private int queryStep = 0;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        FieldRenamingDataSource dataSource = null;
        StoredProcedureResults spr = this.data((IProgressMonitor)monitor);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
            CSVImpactUtils.writeCSVHeader(csvWriter, this.parameters, this.project);
        }
        try {
            if (spr != null) {
                dataSource = new FieldRenamingDataSource(csvWriter);
                dataSource.setData(spr);
            } else {
                this.parameters.put("report.details", null);
            }
        }
        finally {
            if (csvWriter != null) {
                csvWriter.close();
            }
        }
        monitor.done();
        return dataSource;
    }

    private final void closeTest(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.canceled = true;
            throw new CanceledException("canceled or closed by OS");
        }
    }

    private StoredProcedureResults data(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        this.closeTest(pmonitor);
        SingleQueryResult queryResult = null;
        StoredProcedureResults spr = new StoredProcedureResults();
        int selectedPrgNo = 0;
        Collection selected = this.getSelected();
        if (selected != null) {
            selectedPrgNo = selected.size();
        }
        this.titleParameters(this.parameters);
        this.buildAppendix();
        if (selectedPrgNo == 0) {
            L.warn("no results for Field Usage Report");
        } else {
            L.debug("Field Usage results:");
            this.closeTest(pmonitor);
            this.queryStep = 0;
            queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer);
            String[][] stmtDetailsResults = queryResult.data;
            if (stmtDetailsResults != null) {
                spr.setResultsPrgsVSInclude(stmtDetailsResults);
            }
            this.closeTest(pmonitor);
            this.queryStep = 1;
            queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer);
            String[][] progsDetailsResults = queryResult.data;
            if (progsDetailsResults != null) {
                spr.setResultsPrgVSSQLTables(progsDetailsResults);
            }
            this.closeTest(pmonitor);
            this.queryStep = 2;
            queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer);
            String[][] srcDetailsResults = queryResult.data;
            if (srcDetailsResults != null) {
                spr.setResultsPrgsVSCLFile(srcDetailsResults);
            }
            this.closeTest(pmonitor);
            if (stmtDetailsResults == null && progsDetailsResults == null && srcDetailsResults == null) {
                spr = null;
            }
        }
        return spr;
    }

    private void buildAppendix() {
        ElementGroupInfo appDS = new ElementGroupInfo("");
        DSFactory factory = new DSFactory();
        SC1DataSource dataSource = (SC1DataSource)factory.createDS(3);
        dataSource.setTitleDescription(Messages.getString(ReportBuilder.class, "appendix.inputs.title"));
        dataSource.setLayout(6);
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        dataSource.setList(list);
        appDS.addDataSource((SubreportDataSource)dataSource);
        ObjectForSubreport obj = new ObjectForSubreport();
        SC1DataSource inptsDS = new SC1DataSource();
        inptsDS.setLayout(4);
        obj.setSubreportDS((BaseSubreportDataSource)inptsDS);
        obj.setSubreportName("reports/subCols1-layout4.jasper");
        list.add(obj);
        this.parameters.remove("resourcesSummary");
        List inptsLst = (List)this.parameters.remove("inputResources");
        inptsDS.setList(inptsLst);
        this.parameters.put("appendixDS", appDS);
    }

    private void clearForJasperReport() {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, false);
            Boolean forPrograms = (Boolean)this.inputs.get("selectionOnPrograms");
            if (forPrograms != null) {
                if (Boolean.TRUE.equals(forPrograms)) {
                    this.report.addProperty("resource_type", (Object)Utils.RESOURCE_TYPE_PROGRAM);
                } else {
                    this.report.addProperty("resource_type", (Object)Utils.RESOURCE_TYPE_INCLUDE);
                }
            }
            this.report.addProperty("selectionOnDBField", this.inputs.get("selectionOnDBField"));
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected boolean getSelectionFlag() {
        return false;
    }

    protected boolean getSelectionFlagFromInputs() {
        return false;
    }

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.putSummaryParams(monitor);
        monitor.worked(100);
        return this.parameters;
    }

    private void putSummaryParams(SubMonitor monitor) {
        boolean summaryEmpty = true;
        long count = this.queryForSummary(0, monitor);
        String msg = null;
        if (count >= 0L) {
            msg = Messages.getString(ReportBuilder.class, "nrOfStatements.summary.label");
            this.parameters.put("report.sum1.lbl", msg);
            this.parameters.put("report.sum1", String.valueOf(count));
            if (count != 0L) {
                this.parameters.put("sum1.anchor", STATEMENTS_DETAILS_ANCHOR);
            }
            summaryEmpty = false;
        }
        if ((count = this.queryForSummary(1, monitor)) >= 0L) {
            msg = Messages.getString(ReportBuilder.class, "nrOfPrograms.summary.label");
            this.parameters.put("report.sum2.lbl", msg);
            this.parameters.put("report.sum2", String.valueOf(count));
            if (count != 0L) {
                this.parameters.put("sum2.anchor", PROGRAMS_DETAILS_ANCHOR);
            }
            summaryEmpty = false;
        }
        if ((count = this.queryForSummary(2, monitor)) >= 0L) {
            msg = Messages.getString(ReportBuilder.class, "nrOfSourceFiles.summary.label");
            this.parameters.put("report.sum3.lbl", msg);
            this.parameters.put("report.sum3", String.valueOf(count));
            if (count != 0L) {
                this.parameters.put("sum3.anchor", SOURCE_FILES_DETAILS_ANCHOR);
            }
            summaryEmpty = false;
        }
        if (!summaryEmpty) {
            msg = Messages.getString(ReportBuilder.class, "summary.column1.label");
            this.parameters.put("report.sumary.col1.lbl", msg);
            msg = Messages.getString(ReportBuilder.class, "summary.column2.label");
            this.parameters.put("report.sumary.col2.lbl", msg);
            msg = Messages.getString(ReportBuilder.class, "summary.column3.label");
            this.parameters.put("report.sumary.col3.lbl", msg);
        }
    }

    private long queryForSummary(final int type, SubMonitor monitor) {
        final SingleQueryResult queryResult = new SingleQueryResult();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection bridge, IProgressMonitor pmonitor) {
                    Collection selected = ReportBuilder.this.getSelected();
                    if (selected != null) {
                        String[] procParam = new String[]{};
                        if (ReportBuilder.this.pInfo == null) {
                            ReportBuilder.this.pInfo = bridge.getProjectInfo();
                        }
                        int dbEngineInt = ReportBuilder.this.pInfo.getDbEngine().getValue();
                        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[selected.size()]);
                        Collections.fill(types, EZSourceDataType.Integer);
                        String selectiveProc = "";
                        switch (type) {
                            case 0: {
                                if (dbEngineInt == ServerType.SqlServer.getValue() || dbEngineInt == ServerType.Db2Z.getValue() || dbEngineInt == ServerType.Db2.getValue()) {
                                    selectiveProc = ReportBuilder.this.isStartedOnDBField() ? ReportBuilder.EZREP_STATEMENTS_DBFIELD_SUMMARY_SQL : ReportBuilder.EZREP_STATEMENTS_SUMMARY_SQL;
                                    break;
                                }
                                L.warn("Unhandled db engine type: " + ReportBuilder.this.pInfo.getDbEngine() + "!");
                                break;
                            }
                            case 1: {
                                if (dbEngineInt == ServerType.SqlServer.getValue() || dbEngineInt == ServerType.Db2Z.getValue() || dbEngineInt == ServerType.Db2.getValue()) {
                                    selectiveProc = ReportBuilder.this.isStartedOnDBField() ? ReportBuilder.EZREP_PROGRAM_DBFIELD_SUMMARY_SQL : ReportBuilder.EZREP_PROGRAM_SUMMARY_SQL;
                                    break;
                                }
                                L.warn("Unhandled db engine type: " + ReportBuilder.this.pInfo.getDbEngine() + "!");
                                break;
                            }
                            case 2: {
                                if (dbEngineInt == ServerType.SqlServer.getValue() || dbEngineInt == ServerType.Db2Z.getValue() || dbEngineInt == ServerType.Db2.getValue()) {
                                    selectiveProc = ReportBuilder.this.isStartedOnDBField() ? ReportBuilder.EZREP_SOURCE_DBFIELD_SUMMARY_SQL : ReportBuilder.EZREP_SOURCE_SUMMARY_SQL;
                                    break;
                                }
                                L.warn("Unhandled db engine type: " + ReportBuilder.this.pInfo.getDbEngine() + "!");
                            }
                        }
                        Assert.isNotNull((Object)selectiveProc);
                        queryResult.data = bridge.execNonTransactionalStoredProc(selectiveProc, procParam, types, new ArrayList(selected));
                        queryResult.resourcesCount = selected.size();
                    }
                }
            }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        long ret = 0L;
        if (queryResult.data != null) {
            try {
                ret = Long.valueOf(queryResult.data[0][0]);
            }
            catch (Exception exception) {
                L.error("wrong type for summary data");
            }
        }
        return ret;
    }

    private void putExternalizedParameters(Map<String, Object> params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
    }

    protected String getReportTemplatePath() {
        return "reports/fieldRenaming.jasper";
    }

    protected String getProcedure() {
        switch (this.queryStep) {
            case 0: {
                return this.isStartedOnDBField() ? EZREP_STATEMENT_DBFIELD_DETAILS : EZREP_STATEMENT_DETAILS;
            }
            case 1: {
                return this.isStartedOnDBField() ? EZREP_PROGRAM_DBFIELD_DETAILS : EZREP_PROGRAM_DETAILS;
            }
            case 2: {
                return this.isStartedOnDBField() ? EZREP_SOURCE_DBFIELD_DETAILS : EZREP_SOURCE_DETAILS;
            }
        }
        return null;
    }

    protected String getSelectiveTempTableName() {
        return null;
    }

    protected String getSelectiveProcedure() {
        return this.getProcedure();
    }

    protected void moveTableOfContents(JasperPrint jasperPrint) {
        super.moveTableOfContents(jasperPrint);
        List pages = jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            List elements = null;
            Iterator it = null;
            JRPrintElement element2 = null;
            int i = 1;
            boolean isFound = false;
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("stmtVarPage");
            keys.add("prgVarPage");
            keys.add("srcVarPage");
            int moved = 0;
            while (i < pages.size() && !isFound) {
                page = (JRPrintPage)pages.get(i);
                elements = page.getElements();
                if (elements != null && elements.size() > 0) {
                    for (JRPrintElement element2 : elements) {
                        String key;
                        if (!(element2 instanceof JRPrintText) || !keys.contains(key = ((JRPrintText)element2).getKey())) continue;
                        isFound = true;
                        String value = ((JRPrintText)element2).getFullText();
                        try {
                            int initPage = Integer.valueOf(value);
                            if (moved == 0) {
                                moved = i + 1 - (initPage - 1);
                            }
                            int newValue = initPage + moved;
                            ((JRPrintText)element2).setText(String.valueOf(newValue));
                        }
                        catch (NumberFormatException e) {
                            if ("-".equals(value)) {
                                L.debug("report has no pages");
                                continue;
                            }
                            L.warn("wrong page number", (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

