/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldrenaming;

import com.ez.mainframe.gui.wizard.MultiSelectionPage;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.ui.ApplicationsProvider;
import com.ez.mainframe.reports.gui.wizard.ProgramOrIncludePage;
import com.ez.mainframe.reports.gui.wizard.VariablePatternFilter;
import com.ez.report.application.ezreport.reports.impact.DBFieldProvider;
import com.ez.report.application.ezreport.reports.impact.DBTableProvider;
import com.ez.report.application.ezreport.reports.impact.ImpactReportWizard;
import com.ez.report.application.ezreport.reports.impact.ProgramsUsingIncludeCollector;
import com.ez.report.application.ezreport.reports.impact.SelectDBFieldPage;
import com.ez.report.application.ezreport.reports.impact.SelectVariablePage;
import com.ez.report.application.ezreport.reports.impact.SkipNoVariableEntities;
import com.ez.report.application.ezreport.reports.impact.VariableDetailProvider;
import com.ez.report.application.ezreport.reports.impact.VariableSelectionVerifier;
import com.ez.report.application.ezreport.reports.impact.fieldrenaming.ProgramsProvider;
import com.ez.report.application.ezreport.reports.impact.fieldrenaming.VariableOrTableFieldPage;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;

public class FieldRenamingWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, Object> params;
    private boolean projectIsUCMDB;
    private static final String VARIABLE_IN_PROGRAM_OR_TABLE_FIELD_PAGE_NAME = "VariableInProgramOrTableField";

    public FieldRenamingWizard(boolean ucmdbProject, String wizardName, Map<String, Object> params) {
        this.projectIsUCMDB = ucmdbProject;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(wizardName);
        this.params = params;
        this.init();
    }

    public void init() {
        if (this.params == null) {
            if (this.projectIsUCMDB) {
                SelectSingleFromListPage appssp = new SelectSingleFromListPage("application name page");
                ApplicationsProvider appProv = new ApplicationsProvider(this);
                appssp.setSelectionKey("selected applications");
                appssp.setItemProvider((SelectSingleFromListPage.ListDetailProvider)appProv);
                this.addPage((IWizardPage)appssp);
            }
            this.addPage((IWizardPage)new VariableOrTableFieldPage(VARIABLE_IN_PROGRAM_OR_TABLE_FIELD_PAGE_NAME));
            SelectSingleFromListPage dbTablesPage = new SelectSingleFromListPage("selectDBTable");
            DBTableProvider tblProv = new DBTableProvider();
            dbTablesPage.setSelectionKey("selectedDBTableID");
            dbTablesPage.setItemProvider((SelectSingleFromListPage.ListDetailProvider)tblProv);
            this.addPage((IWizardPage)dbTablesPage);
            SelectDBFieldPage dbFieldsPage = new SelectDBFieldPage("selectDBField");
            DBFieldProvider fieldProv = new DBFieldProvider(this);
            dbFieldsPage.setSelectionKey("selectedFieldID");
            dbFieldsPage.setItemProvider(fieldProv);
            this.addPage((IWizardPage)dbFieldsPage);
            this.addPage((IWizardPage)new ProgramOrIncludePage("program or include"));
            SelectSingleFromListPage ssp = new SelectSingleFromListPage("select single from list");
            ProgramsProvider poiip = new ProgramsProvider(this);
            poiip.setFilter(new SkipNoVariableEntities());
            ssp.setSelectionKey("selected id");
            ssp.setItemProvider((SelectSingleFromListPage.ListDetailProvider)poiip);
            this.addPage((IWizardPage)ssp);
            MultiSelectionPage sp = new MultiSelectionPage("select from programs using includes", false);
            sp.setTitle(Messages.getString(FieldRenamingWizard.class, "single.prg.selection"));
            sp.setDescription(Messages.getString(FieldRenamingWizard.class, "single.prg.selection.descr"));
            sp.setSelectedPropName("selectPrgUsingIncl");
            ProgramsUsingIncludeCollector pc = new ProgramsUsingIncludeCollector(this, "selected id", true);
            sp.setResourcesCollector((ResourcesCollector)pc);
            this.addPage((IWizardPage)sp);
        } else if (!this.isStartedOnDBField()) {
            List prgInp = (List)this.params.get("selected resources");
            ArrayList<SelectSingleFromListPage.ArrayListItem> items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
            boolean isInclude = false;
            for (ProgramInputNoGUI pi : prgInp) {
                SelectSingleFromListPage.ArrayListItem item = new SelectSingleFromListPage.ArrayListItem();
                items.add(item);
                Integer typeCode = pi.getTypeCode();
                if (typeCode != -100) {
                    String[] prgSel = new String[]{pi.getName(), String.valueOf(pi.getProgramID()), "", String.valueOf(typeCode)};
                    this.set("selectionOnPrograms", Boolean.TRUE);
                    this.params.put("selectionOnPrograms", Boolean.TRUE);
                    item.setStringArray(prgSel);
                    continue;
                }
                isInclude = true;
                String[] inclSel = new String[]{pi.getName(), String.valueOf(pi.getProgramID())};
                this.set("selectionOnPrograms", Boolean.FALSE);
                this.params.put("selectionOnPrograms", Boolean.FALSE);
                item.setStringArray(inclSel);
                this.params.remove("selected resources");
            }
            this.set("selected id", items);
            this.params.put("selected id", items);
            if (isInclude) {
                MultiSelectionPage sp = new MultiSelectionPage("select from programs using includes", false);
                sp.setTitle(Messages.getString(ImpactReportWizard.class, "prg.selection"));
                sp.setDescription(Messages.getString(ImpactReportWizard.class, "prg.selection.descr"));
                sp.setSelectedPropName("selectPrgUsingIncl");
                ProgramsUsingIncludeCollector pc = new ProgramsUsingIncludeCollector(this, "selected id", true);
                sp.setResourcesCollector((ResourcesCollector)pc);
                this.addPage((IWizardPage)sp);
            }
        }
        if (this.params == null || !this.params.containsKey("selected variable(s)")) {
            if (this.isStartedOnDBField()) {
                Object fieldID = this.params.get("selectedFieldID");
                if (fieldID == null) {
                    SelectDBFieldPage dbFieldsPage = new SelectDBFieldPage("selectDBField");
                    DBFieldProvider fieldProv = new DBFieldProvider(this);
                    dbFieldsPage.setSelectionKey("selectedFieldID");
                    dbFieldsPage.setItemProvider(fieldProv);
                    this.addPage((IWizardPage)dbFieldsPage);
                }
                this.set("selectionOnDBField", Boolean.TRUE);
                this.set("selectedFieldID", fieldID);
                this.set("selectedDBTableID", this.params.get("selectedDBTableID"));
            }
            SelectVariablePage vsp = new SelectVariablePage("variable select page name");
            VariableDetailProvider vdp = new VariableDetailProvider(this, "variable select page name", true);
            vsp.setItemProvider(vdp);
            VariableSelectionVerifier vsf = new VariableSelectionVerifier(true);
            vsp.setSelectionVerifier(vsf);
            vsp.setPatternFilter(new VariablePatternFilter());
            vsp.setSelectionKey("selected variable(s)");
            this.addPage((IWizardPage)vsp);
        }
    }

    private boolean isStartedOnDBField() {
        Object p;
        boolean ret = false;
        Object object = p = this.params != null ? this.params.get("selectionOnDBField") : null;
        if (p != null && (ret = ((Boolean)p).booleanValue())) {
            ret = this.params.get("selectedFieldID") != null || this.params.get("selectedDBTableID") != null;
        }
        return ret;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (VARIABLE_IN_PROGRAM_OR_TABLE_FIELD_PAGE_NAME.equals(page.getName())) {
            Object startOnField = this.getValue("selectionOnDBField");
            if (startOnField != null && ((Boolean)startOnField).booleanValue()) {
                return this.getPage("selectDBTable");
            }
            return this.getPage("program or include");
        }
        if ("program or include".equals(page.getName())) {
            return this.getPage("select single from list");
        }
        if ("selectDBTable".equals(page.getName())) {
            return this.getPage("selectDBField");
        }
        if ("selectDBField".equals(page.getName())) {
            return this.getPage("variable select page name");
        }
        if ("select single from list".equals(page.getName())) {
            Boolean forPrograms = (Boolean)this.getValue("selectionOnPrograms");
            if (forPrograms != null) {
                if (Boolean.TRUE.equals(forPrograms)) {
                    return this.getPage("variable select page name");
                }
                return this.getPage("select from programs using includes");
            }
        } else if ("select from programs using includes".equals(page.getName())) {
            return this.getPage("variable select page name");
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().getName().equals("selectDBField")) {
            return this.getContainer().getCurrentPage().isPageComplete();
        }
        return super.canFinish();
    }
}

