/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldrenaming;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.DSFieldFactory;
import com.ez.report.application.ezreport.reports.impact.fieldrenaming.DetailsDataSource;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRenamingDataSource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FieldRenamingDataSource.class);
    private List<DetailsDataSource> list = new ArrayList<DetailsDataSource>();
    private DetailsDataSource currentValue = null;
    private StoredProcedureResults data;
    private CSVWriter csvWriter;

    public FieldRenamingDataSource(CSVWriter csvWriter) {
        this.csvWriter = csvWriter;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("subreportDataSource")) {
            value = this.currentValue.getDataSource();
        }
        if (field.getName().equals("subReportName")) {
            value = this.currentValue.getReportName();
        }
        if (field.getName().equals("varName")) {
            value = this.currentValue.getVarName();
        }
        return value;
    }

    public boolean nextItem() throws JRException {
        DetailsDataSource detailsDataSource = this.currentValue = this.list != null && this.list.size() > 0 ? this.list.remove(0) : null;
        return this.currentValue != null;
    }

    public void setData(StoredProcedureResults data) {
        this.data = data;
        DSFieldFactory factory = new DSFieldFactory();
        String[][] stmtDetails = this.data.resultsPrgsVSInclude;
        if (stmtDetails == null) {
            L.warn("no results for statements details in field usage report");
        } else {
            this.fill(stmtDetails, factory, 0, Messages.getString(FieldRenamingDataSource.class, "stmt.details.page.title"), "variable name", new String[]{Messages.getString(FieldRenamingDataSource.class, "stmt.details.column1.title"), Messages.getString(FieldRenamingDataSource.class, "stmt.details.column2.title"), Messages.getString(FieldRenamingDataSource.class, "stmt.details.column3.title")});
        }
        String[][] prgDetails = this.data.resultsPrgsVSSQLTables;
        if (prgDetails == null) {
            L.warn("no results for programs details in field usage report");
        } else {
            this.fill(prgDetails, factory, 1, Messages.getString(FieldRenamingDataSource.class, "progs.details.page.title"), "variable name", new String[]{Messages.getString(FieldRenamingDataSource.class, "progs.details.column1.title"), Messages.getString(FieldRenamingDataSource.class, "progs.details.column2.title")});
        }
        String[][] srcDetails = this.data.resultsPrgsVSCLFile;
        if (srcDetails == null) {
            L.warn("no results for source files details in field usage report");
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = Messages.getString(FieldRenamingDataSource.class, "sources.details.column1.title");
            stringArray[2] = Messages.getString(FieldRenamingDataSource.class, "sources.details.column2.title");
            this.fill(srcDetails, factory, 2, Messages.getString(FieldRenamingDataSource.class, "sources.details.page.title"), "variable name", stringArray);
        }
    }

    private void fill(String[][] results, DSFieldFactory factory, int elemDSKind, String elemTitle, String groupPrefix, String[] colsTitles) {
        ArrayList<ObjectForSubreport> objList = null;
        ObjectForSubreport obj = null;
        HashMap<Integer, DetailsDataSource> reportObjs = new HashMap<Integer, DetailsDataSource>();
        int i = 0;
        while (i < results.length) {
            String varID = results[i][0];
            if (Utils.filterNullValue((String)varID) != null) {
                DetailsDataSource elemDS = (DetailsDataSource)((Object)reportObjs.get(elemDSKind));
                if (elemDS == null) {
                    objList = new ArrayList<ObjectForSubreport>();
                    elemDS = new DetailsDataSource(elemDSKind);
                    elemDS.setList(objList);
                    elemDS.setTitle(elemTitle);
                    elemDS.setTocEntry(elemTitle);
                    elemDS.setCol1Title(colsTitles[0]);
                    elemDS.setCol2Title(colsTitles[1]);
                    if (colsTitles.length > 2) {
                        elemDS.setCol3Title(colsTitles[2]);
                    }
                    ArrayList<String> validColumnTitlesList = new ArrayList<String>();
                    String[] stringArray = colsTitles;
                    int n = colsTitles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String columnTitle = stringArray[n2];
                        if (columnTitle != null && !columnTitle.isEmpty()) {
                            validColumnTitlesList.add(columnTitle);
                        }
                        ++n2;
                    }
                    if (this.csvWriter != null && !validColumnTitlesList.isEmpty()) {
                        this.csvWriter.write(validColumnTitlesList.toArray(new String[0]));
                    }
                    reportObjs.put(elemDSKind, elemDS);
                } else {
                    objList = elemDS.getList();
                }
                obj = factory.createObj(elemDSKind, results[i], groupPrefix, this.csvWriter);
                objList.add(obj);
            }
            ++i;
        }
        this.csvWriter.writeLine("");
        if (!reportObjs.isEmpty()) {
            Collection lists = reportObjs.values();
            this.list.addAll(lists);
        }
    }
}

