/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VarLinkInfo;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablePrinter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VariablePrinter.class);
    private CSVWriter csv;
    private boolean isProgram = true;

    public VariablePrinter() {
    }

    public VariablePrinter(boolean isProgram) {
        this.isProgram = isProgram;
    }

    public boolean printVariableList(String pid, String pname, Map<String, Set<VarLinkInfo>> variableInPrograms, Set<String> inputVarIds, DetailsDataSource elemDS) {
        boolean hasDetails = false;
        L.trace("--------------");
        L.trace("variables for program: id = {}; name= {}", (Object)pid, (Object)pname);
        Set<VarLinkInfo> varInfo = variableInPrograms.get(pid);
        L.trace("var info: {}", varInfo);
        if (varInfo != null && !varInfo.isEmpty()) {
            ElementGroupInfo info = elemDS.getDatasourceDetails();
            if (info == null) {
                info = new ElementGroupInfo("");
                elemDS.setPrgDetails(info);
            }
            DetailsDataSource ds = new DetailsDataSource(8);
            ds.setTitle(this.isProgram ? Messages.getString(VariablePrinter.class, "details.datasource.title", new String[]{pname}) : Messages.getString(VariablePrinter.class, "details.datasource.proc.title", new String[]{pname}));
            ArrayList<ObjectForSubreport3Link> lst = new ArrayList<ObjectForSubreport3Link>();
            ds.setList(lst);
            info.addDataSource((SubreportDataSource)ds);
            int k = 0;
            ObjectForSubreport3Link obj = null;
            for (VarLinkInfo vi : varInfo) {
                L.trace("{}", (Object)vi);
                if (inputVarIds == null || !inputVarIds.contains(vi.vid)) {
                    hasDetails = true;
                    switch (k % 3) {
                        case 0: {
                            obj = new ObjectForSubreport3Link();
                            lst.add(obj);
                            obj.setLeftValue(vi.vname);
                            obj.setLeftLink(vi.vid);
                            obj.setLeftAnchor(Boolean.valueOf(true));
                            break;
                        }
                        case 1: {
                            obj.setMiddleValue(vi.vname);
                            obj.setMiddleLink(vi.vid);
                            obj.setMiddleAnchor(Boolean.valueOf(true));
                            break;
                        }
                        case 2: {
                            obj.setRightValue(vi.vname);
                            obj.setRightLink(vi.vid);
                            obj.setRightAnchor(Boolean.valueOf(true));
                        }
                    }
                    if (this.csv != null) {
                        this.csv.write(new String[]{CSVImpactUtils.CSV_VAR_LIST, pname, vi.vname});
                    }
                    ++k;
                    continue;
                }
                L.info("ignore variable {} (id={}) as being input", (Object)vi.vname, (Object)vi.vid);
            }
        }
        L.trace("------");
        return hasDetails;
    }

    public void setCSVWriter(CSVWriter csv) {
        this.csv = csv;
    }
}

