/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DataStepProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(QueryHandler.class);
    private Runnable closeRunnable;

    public QueryHandler(Runnable closeRunnable) {
        this.closeRunnable = closeRunnable;
    }

    public void runSP(DataStepProcessor dsp, String spName, Collection<String> param, EZSourceConnection bridge) {
        this.runSP(dsp, spName, param, true, bridge);
    }

    public void runSP(DataStepProcessor dsp, String spName, Collection<String> param, boolean useTempTable, EZSourceConnection conn) {
        this.runSP(dsp, spName, param, useTempTable, "numeric_param_temp", new int[1], conn);
    }

    public void runSP(DataStepProcessor dsp, String spName, Collection<String> param, boolean useTempTable, String tempTable, int[] paramType, EZSourceConnection conn) {
        String[] paramsList = null;
        this.runSP(dsp, spName, param, useTempTable, tempTable, paramType, paramsList, conn);
    }

    public void runSP(DataStepProcessor dsp, String spName, Collection<String> param, boolean useTempTable, String tempTable, int[] paramType, String[] paramsList, EZSourceConnection bridge) {
        NonBlockingOperationHandle handler = null;
        int nrRows = 256;
        try {
            List<EZSourceDataType> types = null;
            if (param != null) {
                if (useTempTable) {
                    types = Arrays.asList(new EZSourceDataType[param.size()]);
                    if (tempTable.equalsIgnoreCase("numeric_param_temp")) {
                        Collections.fill(types, EZSourceDataType.Integer);
                    } else {
                        Collections.fill(types, EZSourceDataType.String);
                    }
                    if (paramsList == null) {
                        paramsList = new String[]{};
                    }
                } else {
                    paramsList = param.toArray(new String[0]);
                }
            }
            this.closeTest();
            L.info("runquery2:p:" + (param == null ? "null" : Integer.valueOf(param.size())) + "; spName=" + spName);
            handler = types != null ? bridge.beginNonTransactionalStoredProc(spName, paramsList, types, new ArrayList<String>(param), nrRows) : bridge.beginNonTransactionalStoredProc(spName, paramsList, nrRows);
            this.handlePartialResults(dsp, handler);
            L.info("runquery2:");
        }
        finally {
            if (bridge != null && handler != null) {
                handler.close();
            }
        }
    }

    public void runSP(DataStepProcessor dsp, String spName, Collection<String> param, Collection<String> tempTableParam, EZSourceConnection conn) {
        NonBlockingOperationHandle handler = null;
        try {
            String[] paramsList = null;
            List<EZSourceDataType> types = null;
            if (tempTableParam != null && !tempTableParam.isEmpty()) {
                types = Arrays.asList(new EZSourceDataType[tempTableParam.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
            }
            paramsList = param != null && !param.isEmpty() ? param.toArray(new String[0]) : new String[]{};
            this.closeTest();
            L.info("runquery3:p:" + (param == null ? "null" : Integer.valueOf(param.size())));
            handler = types != null ? conn.beginNonTransactionalStoredProc(spName, paramsList, types, new ArrayList<String>(tempTableParam), 256) : conn.beginNonTransactionalStoredProc(spName, paramsList, 256);
            this.handlePartialResults(dsp, handler);
            L.info("runquery3");
        }
        finally {
            if (conn != null && handler != null) {
                handler.close();
            }
        }
    }

    public void handlePartialResults(DataStepProcessor dsp, NonBlockingOperationHandle handler) {
        int amount = 0;
        List rows = null;
        while (!handler.finished()) {
            long t1 = System.currentTimeMillis();
            L.trace("get more data ... ");
            rows = handler.getAvailableData();
            long t2 = System.currentTimeMillis();
            L.trace("time1={}", (Object)(t2 - t1));
            if (rows == null) break;
            amount += rows.size();
            try {
                dsp.dataStep(rows);
            }
            catch (Exception e) {
                L.error("while processing data ", (Throwable)e);
            }
            long t3 = System.currentTimeMillis();
            L.trace("time2={}", (Object)(t3 - t2));
            L.debug("got " + rows.size() + ", total so far " + amount);
            this.closeTest();
            L.trace("time3={}", (Object)(System.currentTimeMillis() - t3));
        }
        L.debug("done processing {} rows", (Object)amount);
    }

    private void closeTest() {
        this.closeRunnable.run();
    }
}

