/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Entry;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.EntryListInterface;
import com.ez.report.application.utils.mapDB.PersistentCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerArrayTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentEntryList
extends PersistentCollection
implements EntryListInterface<Entry> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PersistentEntryList.class);
    private Map<Integer, Entry> byInternalIds;
    private NavigableSet<Object[]> byId;
    private DB.AtomicLongMaker sizeCounter;

    PersistentEntryList(int cacheSize) {
        super(PersistentEntryList.class, cacheSize);
        this.createByInternalIdMap();
        this.createByIdSet();
    }

    private void createByInternalIdMap() {
        this.byInternalIds = this.db.hashMap("byInternalIds").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)new Entry.CustomSerializer()).counterEnable().create();
        this.sizeCounter = this.db.atomicLong("mapSize");
    }

    PersistentEntryList() {
        this(-1);
    }

    private void createByIdSet() {
        this.byId = (NavigableSet)this.db.treeSet("byId").serializer((GroupSerializer)new SerializerArrayTuple(new Serializer[]{this.db.getDefaultSerializer(), new Entry.CustomSerializer()}, new Comparator[]{String.CASE_INSENSITIVE_ORDER, new EntryComparator()})).create();
    }

    @Override
    public void add(Entry e) {
        if (!this.byInternalIds.containsKey(e.internalID)) {
            this.byId.add(this.makeObj4Map(e));
            this.byInternalIds.put(e.internalID, e);
        }
    }

    @Override
    public void addAll(EntryListInterface<Entry> q) {
        for (Entry e : q) {
            this.add(e);
        }
    }

    private Object[] makeObj4Map(Entry e) {
        return new Object[]{e.dbId, e};
    }

    @Override
    public boolean isEmpty() {
        return this.byInternalIds != null && this.byInternalIds.isEmpty();
    }

    @Override
    public int size() {
        int size1 = ((Atomic.Long)this.sizeCounter.createOrOpen()).intValue();
        L.trace("size1={}", (Object)size1);
        return size1;
    }

    @Override
    public Iterable<Entry> getById(String id) {
        Iterable<Entry> iterable = null;
        Object[] objectArray = new Object[2];
        objectArray[0] = id;
        SortedSet<Object[]> mapSubset = this.byId.subSet(new Object[]{id}, objectArray);
        if (!mapSubset.isEmpty()) {
            ArrayList vals = new ArrayList();
            mapSubset.forEach(s -> {
                boolean bl = vals.add((Entry)s[1]);
            });
            iterable = () -> vals.iterator();
        } else {
            iterable = Collections.emptyList();
        }
        return iterable;
    }

    @Override
    public Entry getByInternalId(int id) {
        return this.byInternalIds.get(id);
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.byInternalIds.values().iterator();
    }

    @Override
    public void update(Entry entry) {
        Iterable<Entry> it;
        Entry removed = this.byInternalIds.remove(entry.internalID);
        L.trace("**** {} removed from byInternalIds={}", (Object)entry.internalID, (Object)removed);
        if (L.isTraceEnabled() && (it = this.getById(entry.dbId)) != null) {
            for (Entry ent : it) {
                if (!ent.equals(entry)) continue;
                L.trace("**** found it: {}", (Object)entry);
            }
        }
        boolean rem = this.byId.remove(this.makeObj4Map(entry));
        L.trace("**** removed from byId={}", (Object)rem);
        this.add(entry);
    }

    @Override
    public void dispose() {
        if (this.db != null && !this.db.isClosed()) {
            this.close();
        }
        this.deleteFile();
    }

    @Override
    public void clear() {
        if (this.db != null && !this.db.isClosed()) {
            this.byInternalIds.clear();
            this.recreateById();
            this.db.commit();
        }
    }

    private void recreateById() {
        if (this.db.exists("byId")) {
            this.byId.clear();
        } else {
            this.createByIdSet();
        }
    }

    public void commit() {
        try {
            this.db.commit();
        }
        catch (Throwable t) {
            L.warn("error at commit; ignored. file: {}", (Object)this.file, (Object)t);
        }
    }

    @Override
    public List<Entry> getList() {
        return new ArrayList<Entry>(this.byInternalIds.values());
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    class EntryComparator
    implements Comparator<Entry> {
        EntryComparator() {
        }

        @Override
        public int compare(Entry left, Entry right) {
            return left.compareTo(right);
        }
    }
}

