/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.CallsInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ChainElem;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ProgDetailsObj;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ProgramDetailsDS;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.scriptlets.HeadingsScriptlet;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPrinter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PathPrinter.class);
    public static final String DATA_TO_RIGHT = "--->";
    public static final String DATA_TO_LEFT = "<---";
    public static final String PGM_CALL_FORWARD = "->";
    public static final String PGM_CALL_BACKWARD = "<-";
    private CSVWriter csv;

    public boolean printProgramPaths(Integer direction, String pid, String pName, Map<String, CallsInfo> programCalls, DetailsDataSource el) {
        return this.printProgramPaths(direction, pid, pName, programCalls, el, null, null);
    }

    private boolean printProgramPaths(Integer direction, String pid, String programName, Map<String, CallsInfo> programCalls, DetailsDataSource el, String resName, String resType) {
        return this.printProgramPaths(direction, pid, programName, programCalls, el, resName, resType, null);
    }

    public boolean printProgramPaths(Integer direction, String pid, String programName, Map<String, CallsInfo> programCalls, DetailsDataSource el, String resName, String resType, HeaderHolder headerHolder) {
        List<ProgDetailsObj> lst;
        boolean hasPaths = false;
        boolean isResource = resName != null;
        CallsInfo callInfo = programCalls.get(pid);
        List<ProgDetailsObj> list = lst = headerHolder == null ? null : headerHolder.header;
        if (callInfo != null) {
            String groupName;
            String pName = callInfo.name;
            if (L.isTraceEnabled()) {
                L.trace("===================");
                L.trace("program paths for");
                L.trace("program id: {}", (Object)pid);
                L.trace("program name: {}", (Object)pName);
                if (resName != null) {
                    L.trace("resource name: {}", (Object)resName);
                    L.trace("resource type: {}", (Object)resType);
                }
                L.trace("-------------------");
            }
            ArrayList<List<ChainElem>> chains = new ArrayList<List<ChainElem>>();
            L.trace("{}", (Object)callInfo);
            if (!isResource || direction == 1) {
                L.trace("<<<<<<<< data flows to the left <<<<<<");
                this.printPaths(1, callInfo.inCalls, programCalls, chains);
                L.trace("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                if (!chains.isEmpty()) {
                    if (lst == null) {
                        lst = this.buildDSHeader(pName, el, resName, resType);
                        if (headerHolder != null) {
                            headerHolder.header = lst;
                        }
                    }
                    groupName = null;
                    groupName = resName == null ? Messages.getString(PathPrinter.class, "dataflows.into.short", new String[]{pName}) : Messages.getString(PathPrinter.class, "dataflows.into.detailed", new String[]{resType, resName});
                    this.buildReportData(pName, chains, lst, groupName, resName, resType);
                    hasPaths = true;
                }
            }
            chains.clear();
            if (!isResource || direction == 2) {
                L.trace(">>>>>>>> data flows to the right >>>>>>");
                this.printPaths(2, callInfo.outCalls, programCalls, chains);
                L.trace(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                L.trace("-------------------");
                if (!chains.isEmpty()) {
                    if (lst == null) {
                        lst = this.buildDSHeader(pName, el, resName, resType);
                        if (headerHolder != null) {
                            headerHolder.header = lst;
                        }
                    }
                    groupName = null;
                    groupName = !isResource ? Messages.getString(PathPrinter.class, "dataflows.outof.short", new String[]{pName}) : Messages.getString(PathPrinter.class, "dataflows.outof.detailed", new String[]{resType, resName});
                    this.buildReportData(pName, chains, lst, groupName, resName, resType);
                    hasPaths = true;
                }
            }
        } else {
            L.trace("no info for {}:{}:{}", new Object[]{pid, isResource, resType});
        }
        return hasPaths;
    }

    private List<ProgDetailsObj> buildDSHeader(String pName, DetailsDataSource ds, String resName, String resType) {
        ElementGroupInfo info = new ElementGroupInfo("");
        ArrayList<ProgDetailsObj> lst = new ArrayList<ProgDetailsObj>();
        ProgramDetailsDS det = new ProgramDetailsDS("", lst, -1);
        String title = null;
        title = resName == null ? Messages.getString(PathPrinter.class, "dataflows.throughProgram.title", new String[]{pName}) : Messages.getString(PathPrinter.class, "dataflows.throughResource.title", new String[]{resType, resName});
        title = ReportsUtils.stripNonValidXMLCharacters((String)title, (boolean)true);
        det.setTitle(title);
        info.addDataSource((SubreportDataSource)det);
        ds.setPrgDetails(info);
        return lst;
    }

    private void buildReportData(String pName, List<List<ChainElem>> chains, List<ProgDetailsObj> lst, String groupName, String resName, String resType) {
        groupName = ReportsUtils.stripNonValidXMLCharacters((String)groupName, (boolean)true);
        for (List<ChainElem> chain : chains) {
            this.printChainToCSV(pName, chain, resName, resType);
            ProgDetailsObj obj = new ProgDetailsObj(groupName);
            if (resName == null) {
                obj.setLeftValue(pName);
                lst.add(obj);
            } else {
                ChainElem elem = chain.get(0);
                obj.setLeftValue(ReportsUtils.stripNonValidXMLCharacters((String)resName, (boolean)true));
                obj.setMiddleValue(pName);
                obj.setMiddleLink(HeadingsScriptlet.getAnchor(null, (String)("program_" + elem.leftId)));
                obj.middleTooltip = Messages.getString(PathPrinter.class, "program.tooltip", new String[]{elem.left});
                obj.resourceLink = Boolean.TRUE;
                if (DATA_TO_LEFT.equals(elem.dataDir)) {
                    obj.flow1BkwDirection = Boolean.TRUE;
                } else {
                    obj.flow1FwDirection = Boolean.TRUE;
                }
                lst.add(obj);
            }
            for (ChainElem elem : chain) {
                if (obj.getMiddleValue() == null) {
                    if (PGM_CALL_FORWARD.equals(elem.callDir)) {
                        obj.call1FwDirection = Boolean.TRUE;
                    } else {
                        obj.call1BkwDirection = Boolean.TRUE;
                    }
                    if (DATA_TO_LEFT.equals(elem.dataDir)) {
                        obj.flow1BkwDirection = Boolean.TRUE;
                    } else {
                        obj.flow1FwDirection = Boolean.TRUE;
                    }
                    obj.setMiddleValue(elem.right);
                    obj.setMiddleLink(HeadingsScriptlet.getAnchor(null, (String)("program_" + elem.rightId)));
                    obj.middleTooltip = Messages.getString(PathPrinter.class, "program.tooltip", new String[]{elem.right});
                    continue;
                }
                if (PGM_CALL_FORWARD.equals(elem.callDir)) {
                    obj.call2FwDirection = Boolean.TRUE;
                } else {
                    obj.call2BkwDirection = Boolean.TRUE;
                }
                if (DATA_TO_LEFT.equals(elem.dataDir)) {
                    obj.flow2BkwDirection = Boolean.TRUE;
                } else {
                    obj.flow2FwDirection = Boolean.TRUE;
                }
                obj.setRightValue(elem.right);
                obj.setRightLink(HeadingsScriptlet.getAnchor(null, (String)("program_" + elem.rightId)));
                obj.rightTooltip = Messages.getString(PathPrinter.class, "program.tooltip", new String[]{elem.right});
                obj = new ProgDetailsObj(groupName);
                lst.add(obj);
            }
            obj.isLast = Boolean.TRUE;
        }
    }

    private void printChainToCSV(String name, List<ChainElem> chain, String resName, String resType) {
        if (this.csv != null && chain.size() > 0) {
            ArrayList<String> cols = new ArrayList<String>();
            ChainElem first = chain.get(0);
            if (resName == null) {
                cols.add(CSVImpactUtils.CSV_PROGRAM_PATHS);
                cols.add(name);
            } else {
                cols.add(CSVImpactUtils.CSV_RESOURCE_PATHS);
                cols.add(resName);
                cols.add(resType);
            }
            cols.add(first.dataDir);
            cols.add(first.left);
            for (ChainElem elem : chain) {
                cols.add(elem.callDir);
                cols.add(elem.right);
            }
            this.csv.write(cols.toArray(new String[0]));
        }
    }

    private void printPaths(int dir, List<PInfo> startList, Map<String, CallsInfo> programCalls, List<List<ChainElem>> chains) {
        ArrayList<PInfo> wklist = new ArrayList<PInfo>(startList);
        ArrayList<PInfo> path = new ArrayList<PInfo>();
        while (!wklist.isEmpty()) {
            CallsInfo next;
            PInfo pInfo = (PInfo)wklist.remove(0);
            while (!path.isEmpty()) {
                PInfo last = (PInfo)path.get(path.size() - 1);
                if (dir == 1) {
                    if (last.fromId.equals(pInfo.toId)) break;
                    path.remove(path.size() - 1);
                    continue;
                }
                if (last.toId.equals(pInfo.fromId)) break;
                path.remove(path.size() - 1);
            }
            if (this.isCycle(dir, path, pInfo)) {
                this.printPath(dir, path, pInfo, chains);
                continue;
            }
            path.add(pInfo);
            if (this.isWrongDirectionChange(dir, path)) {
                path.remove(pInfo);
                continue;
            }
            if (dir == 1) {
                next = programCalls.get(pInfo.fromId);
                if (next == null || next.inCalls.isEmpty()) {
                    this.printPath(dir, path, null, chains);
                    path.remove(path.size() - 1);
                }
                wklist.addAll(0, next.inCalls);
                continue;
            }
            next = programCalls.get(pInfo.toId);
            if (next == null || next.outCalls.isEmpty()) {
                this.printPath(dir, path, null, chains);
                path.remove(path.size() - 1);
            }
            wklist.addAll(0, next.outCalls);
        }
    }

    private void printPath(int dir, List<PInfo> path, PInfo cycle, List<List<ChainElem>> chains) {
        if (cycle != null && path.size() > 0) {
            PInfo last = path.get(path.size() - 1);
            if (last.fromId.equals(cycle.toId) && last.toId.equals(cycle.fromId)) {
                cycle = null;
            }
        }
        ArrayList<PInfo> withCycle = new ArrayList<PInfo>(path);
        if (cycle != null) {
            withCycle.add(cycle);
        }
        if (this.isWrongDirectionChange(dir, withCycle)) {
            return;
        }
        if (path.size() > 0) {
            StringBuilder sb = new StringBuilder();
            ArrayList<ChainElem> chain = new ArrayList<ChainElem>();
            chains.add(chain);
            for (PInfo pi : path) {
                ChainElem ch;
                if (dir == 1) {
                    ch = new ChainElem();
                    ch.left = pi.toName;
                    ch.leftId = pi.toId;
                    ch.dataDir = DATA_TO_LEFT;
                    ch.callDir = this.invDir(pi.callDir);
                    ch.right = pi.fromName;
                    ch.rightId = pi.fromId;
                    chain.add(ch);
                    if (!L.isTraceEnabled()) continue;
                    sb.append(String.valueOf(pi.toName) + DATA_TO_LEFT + "(" + this.invDir(pi.callDir) + ")" + pi.fromName + " ");
                    continue;
                }
                ch = new ChainElem();
                ch.left = pi.fromName;
                ch.leftId = pi.fromId;
                ch.dataDir = DATA_TO_RIGHT;
                ch.callDir = pi.callDir;
                ch.right = pi.toName;
                ch.rightId = pi.toId;
                chain.add(ch);
                if (!L.isTraceEnabled()) continue;
                sb.append(String.valueOf(pi.fromName) + DATA_TO_RIGHT + "(" + pi.callDir + ")" + pi.toName + " ");
            }
            if (cycle != null) {
                ChainElem ch;
                if (dir == 1) {
                    ch = new ChainElem();
                    ch.left = cycle.toName;
                    ch.leftId = cycle.toId;
                    ch.dataDir = DATA_TO_LEFT;
                    ch.callDir = this.invDir(cycle.callDir);
                    ch.right = Messages.getString(PathPrinter.class, "cycle.mark", new String[]{cycle.fromName});
                    ch.rightId = cycle.fromId;
                    chain.add(ch);
                    if (L.isTraceEnabled()) {
                        sb.append(String.valueOf(cycle.toName) + DATA_TO_LEFT + "(" + this.invDir(cycle.callDir) + ")" + cycle.fromName + " (cycle)");
                    }
                } else {
                    ch = new ChainElem();
                    ch.left = cycle.fromName;
                    ch.leftId = cycle.fromId;
                    ch.dataDir = DATA_TO_RIGHT;
                    ch.callDir = cycle.callDir;
                    ch.right = Messages.getString(PathPrinter.class, "cycle.mark", new String[]{cycle.toName});
                    ch.rightId = cycle.toId;
                    chain.add(ch);
                    if (L.isTraceEnabled()) {
                        sb.append(String.valueOf(cycle.fromName) + DATA_TO_RIGHT + "(" + cycle.callDir + ")" + cycle.toName + " (cycle)");
                    }
                }
            }
            if (L.isTraceEnabled()) {
                L.trace(sb.toString());
            }
        }
    }

    private String invDir(String dir) {
        if (dir.equals(PGM_CALL_FORWARD)) {
            return PGM_CALL_BACKWARD;
        }
        if (dir.equals(PGM_CALL_BACKWARD)) {
            return PGM_CALL_FORWARD;
        }
        return dir;
    }

    private boolean isCycle(int dir, List<PInfo> path, PInfo entry) {
        boolean cycle = false;
        HashSet<String> visited = new HashSet<String>();
        for (PInfo e : path) {
            if (dir == 1) {
                visited.add(e.toId);
                if (!visited.contains(entry.fromId)) continue;
                cycle = true;
                break;
            }
            visited.add(e.fromId);
            if (!visited.contains(entry.toId)) continue;
            cycle = true;
            break;
        }
        return cycle;
    }

    private boolean isWrongDirectionChange(int dir, List<PInfo> path) {
        boolean wrongDir = false;
        String startDir = null;
        String cDir = null;
        String prevDir = null;
        int changed = 0;
        for (PInfo e : path) {
            if (startDir == null) {
                startDir = dir == 1 ? this.invDir(e.callDir) : e.callDir;
                prevDir = startDir;
                cDir = startDir;
            } else {
                cDir = dir == 1 ? this.invDir(e.callDir) : e.callDir;
                if (startDir.equals(PGM_CALL_FORWARD) && cDir.equals(PGM_CALL_BACKWARD)) {
                    wrongDir = true;
                    break;
                }
                if (startDir.equals(PGM_CALL_BACKWARD)) {
                    if (!prevDir.equals(cDir)) {
                        ++changed;
                    }
                    if (changed > 1) {
                        wrongDir = true;
                        break;
                    }
                }
            }
            prevDir = cDir;
        }
        return wrongDir;
    }

    public void setCSVWriter(CSVWriter csv) {
        this.csv = csv;
    }

    public boolean printResource(Integer direction, Map<String, CallsInfo> programCalls, DetailsDataSource elemDS, String resName, String resType, Set<String> usageInPrograms) {
        boolean has = false;
        HeaderHolder hh = new HeaderHolder();
        for (String pid : usageInPrograms) {
            boolean r = this.printProgramPaths(direction, pid, null, programCalls, elemDS, resName, resType, hh);
            boolean bl = has = has || r;
        }
        return has;
    }

    private class HeaderHolder {
        List<ProgDetailsObj> header;

        private HeaderHolder() {
        }
    }
}

