/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.CallsInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.LinkageInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VInfo;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkagePrinter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LinkagePrinter.class);
    private CSVWriter csv;
    private static final String prg_value = Messages.getString(LinkagePrinter.class, "program.colum.header");
    private static final String param_value = Messages.getString(LinkagePrinter.class, "parameter.colum.header");
    private static final String formalParam_value = Messages.getString(LinkagePrinter.class, "linkageVariable.colum.header");
    private String col1;
    private String col2;
    private String col3;
    private boolean isProgram = true;

    public LinkagePrinter() {
    }

    public LinkagePrinter(boolean isProgram, String col1, String col2, String col3) {
        this();
        this.isProgram = isProgram;
        this.col1 = col1;
        this.col2 = col2;
        this.col3 = col3;
    }

    public boolean printLinkage(String pid, String pName, Map<String, CallsInfo> programCalls, Set<String> finalVarIds, DetailsDataSource elemDS) {
        CallsInfo callInfo;
        boolean hasDetails = false;
        if (L.isTraceEnabled()) {
            L.trace("===================");
            L.trace("linkage for");
            L.trace("program id: {}", (Object)pid);
            L.trace("program name: {}", (Object)pName);
            L.trace("-------------------");
        }
        if ((callInfo = programCalls.get(pid)) != null) {
            List<ObjectForSubreport3Link> lst;
            String groupName;
            TreeSet<LinkageInfo> invoked = new TreeSet<LinkageInfo>();
            TreeSet<LinkageInfo> calling = new TreeSet<LinkageInfo>();
            this.prepareInfo(callInfo, invoked, calling);
            if (calling != null && !calling.isEmpty()) {
                groupName = this.isProgram ? Messages.getString(LinkagePrinter.class, "programCalls.groupName", new String[]{pName}) : Messages.getString(LinkagePrinter.class, "procCalls.groupName", new String[]{pName});
                lst = this.buildDSHeader(groupName, elemDS, true);
                this.buildReportData(calling, finalVarIds, lst, true);
                if (L.isTraceEnabled()) {
                    L.trace(String.valueOf(pName) + " calls: ");
                    for (LinkageInfo li : calling) {
                        this.printLinkage(li);
                    }
                    L.trace("----------");
                }
                boolean bl = hasDetails = !calling.isEmpty();
            }
            if (invoked != null && !invoked.isEmpty()) {
                groupName = this.isProgram ? Messages.getString(LinkagePrinter.class, "programInvoked.groupName", new String[]{pName}) : Messages.getString(LinkagePrinter.class, "procInvoked.groupName", new String[]{pName});
                lst = this.buildDSHeader(groupName, elemDS, false);
                this.buildReportData(invoked, finalVarIds, lst, false);
                if (L.isTraceEnabled()) {
                    L.trace(String.valueOf(pName) + " invoked by : ");
                    for (LinkageInfo li : invoked) {
                        this.printLinkage(li);
                        L.trace(String.valueOf(li.toName) + "(" + li.toId + ") ");
                    }
                    L.trace("----------");
                }
                hasDetails = !invoked.isEmpty();
            }
        } else {
            L.trace("no info");
        }
        return hasDetails;
    }

    private void printLinkage(LinkageInfo li) {
        L.trace(String.valueOf(li.toName) + "(" + li.toId + ") ");
        for (VInfo vi : li.vInfo) {
            L.trace("\t   param: " + vi.paramVName + "(" + vi.paramVId + ") ");
            L.trace("\t linkage: " + (vi.linkageVId == null ? "-" : String.valueOf(vi.linkageVName) + "(" + vi.linkageVId + ") "));
        }
    }

    private void buildReportData(Set<LinkageInfo> infos, Set<String> finalVarIds, List<ObjectForSubreport3Link> lst, boolean isFw) {
        for (LinkageInfo li : infos) {
            boolean first = true;
            for (VInfo vi : li.vInfo) {
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                if (first) {
                    obj.setLeftValue(li.toName);
                    obj.setLeftLink("program_" + li.toId);
                    obj.setLeftAnchor(Boolean.valueOf(true));
                    first = false;
                }
                String middleText = this.printedText(vi, true);
                obj.setMiddleValue(middleText);
                if (finalVarIds.contains(vi.paramVId)) {
                    obj.setMiddleLink(vi.paramVId);
                    obj.setMiddleAnchor(Boolean.valueOf(true));
                }
                String rightText = this.printedText(vi, false);
                obj.setRightValue(rightText);
                if (finalVarIds.contains(vi.linkageVId)) {
                    obj.setRightLink(vi.linkageVId);
                    obj.setRightAnchor(Boolean.valueOf(true));
                }
                if (this.csv != null) {
                    this.csv.write(new String[]{CSVImpactUtils.CSV_LINKAGE, li.fromName, isFw ? "->" : "<-", li.toName, middleText, rightText});
                }
                lst.add(obj);
            }
        }
    }

    private String printedText(VInfo vi, boolean isParam) {
        String txt;
        String notAvailableStr = Messages.getString(LinkagePrinter.class, "notAvailable");
        String string = isParam ? (vi.paramVName == null ? String.valueOf(notAvailableStr) + vi.paramVId : vi.paramVName) : (txt = vi.linkageVId != null ? vi.linkageVName : notAvailableStr);
        if (vi.sOffset != null) {
            txt = String.valueOf(txt) + " (" + vi.sOffset + ", " + vi.eOffset + ")";
        }
        return txt;
    }

    private List<ObjectForSubreport3Link> buildDSHeader(String title, DetailsDataSource ds, boolean isFw) {
        ElementGroupInfo info = ds.getDatasourceDetails();
        if (info == null) {
            info = new ElementGroupInfo("");
            ds.setPrgDetails(info);
        }
        DetailsDataSource det = new DetailsDataSource(8);
        det.setTitle(title);
        ArrayList<ObjectForSubreport3Link> lst = new ArrayList<ObjectForSubreport3Link>();
        det.setList(lst);
        det.setCol1Title(this.col1);
        det.setCol2Title(this.col2);
        det.setCol3Title(this.col3);
        info.addDataSource((SubreportDataSource)det);
        return lst;
    }

    private void prepareInfo(CallsInfo callInfo, Set<LinkageInfo> invoked, Set<LinkageInfo> calling) {
        LinkageInfo li;
        for (PInfo pi : callInfo.inCalls) {
            li = new LinkageInfo();
            li.fromId = pi.toId;
            li.fromName = pi.toName;
            li.toId = pi.fromId;
            li.toName = pi.fromName;
            li.vInfo = pi.vInfo;
            if (pi.callDir.equals("<-")) {
                calling.add(li);
                continue;
            }
            invoked.add(li);
        }
        for (PInfo pi : callInfo.outCalls) {
            li = new LinkageInfo();
            li.fromId = pi.fromId;
            li.fromName = pi.fromName;
            li.toId = pi.toId;
            li.toName = pi.toName;
            li.vInfo = pi.vInfo;
            if (pi.callDir.equals("<-")) {
                invoked.add(li);
                continue;
            }
            calling.add(li);
        }
    }

    public void setCSVWriter(CSVWriter csv) {
        this.csv = csv;
    }
}

