/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Sextet;
import com.ez.mainframe.gui.datasetflow.IValidator;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.INetworkProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LimitJobAndNetwork
implements IValidator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LimitJobAndNetwork.class);
    private INetworkProvider networkProvider;
    private boolean allowNoNetworkTransition;

    public LimitJobAndNetwork(INetworkProvider networkProvider) {
        this.networkProvider = networkProvider;
        String prop = System.getProperty("allowNoNetworkTransition", "false");
        this.allowNoNetworkTransition = Boolean.parseBoolean(prop);
        L.info("Impact Analysis, dataset flow: allowNoNetworkTransition:{}", (Object)this.allowNoNetworkTransition);
    }

    public boolean isAcceptable(Sextet<Integer, String, Direction, Integer, String[], String> t, String[] cols) {
        boolean ret = true;
        boolean sameJob = false;
        String[] extra = (String[])t.getFifth();
        Direction d = (Direction)t.getThird();
        if (extra != null) {
            String fromJobId = extra[0];
            String toJobId = cols[13];
            if (fromJobId.equals(toJobId)) {
                sameJob = true;
            }
            if (sameJob) {
                String startStepLine = extra[2];
                String toStepLine = cols[25];
                if (!toStepLine.equals("-1")) {
                    int ss = Integer.parseInt(startStepLine);
                    int ts = Integer.parseInt(toStepLine);
                    if (d == Direction.FORWARD && ts <= ss) {
                        ret = false;
                    }
                    if (d == Direction.BACKWARD && ts >= ss) {
                        ret = false;
                    }
                }
            } else if (this.networkProvider != null && this.networkProvider.isDataAvailable()) {
                Pair<String, String> startNetworkInfo = this.networkProvider.getNetworkForJob(extra[3]);
                Pair<String, String> endNetworkInfo = this.networkProvider.getNetworkForJob(cols[12]);
                if (startNetworkInfo.getFirst() != null) {
                    if (!((String)startNetworkInfo.getFirst()).equals(endNetworkInfo.getFirst())) {
                        ret = false;
                    }
                } else {
                    ret = endNetworkInfo.getFirst() != null ? false : this.allowNoNetworkTransition;
                }
                if (ret && startNetworkInfo.getSecond() != null && endNetworkInfo.getSecond() != null) {
                    int stJob = Integer.parseInt((String)startNetworkInfo.getSecond());
                    int endJob = Integer.parseInt((String)endNetworkInfo.getSecond());
                    if (d == Direction.FORWARD && stJob > endJob) {
                        ret = false;
                    }
                    if (d == Direction.BACKWARD && stJob < endJob) {
                        ret = false;
                    }
                }
            } else {
                ret = this.allowNoNetworkTransition;
            }
        }
        return ret;
    }
}

