/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.datasetflow.DatasetFlow;
import com.ez.mainframe.gui.datasetflow.IValidator;
import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.AAutoNetworkProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DataStepProcessor;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Entry;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.EntryList;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FieldExpansionUtils;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.IDProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.IExtraDependencyProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.INetworkProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.LimitJobAndNetwork;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.QueryHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileToDatasetDependencyProvider
implements IExtraDependencyProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private IValidator validator = null;
    private INetworkProvider networkProvider = null;
    private Set<String> aautoJobsSummary = new HashSet<String>();
    private Set<String> aautoNetworksSummary = new HashSet<String>();

    public FileToDatasetDependencyProvider(EZSourceConnection conn) {
        this.networkProvider = new AAutoNetworkProvider(conn);
        this.validator = new LimitJobAndNetwork(this.networkProvider);
    }

    @Override
    public String getType() {
        return "EXT_TYPE_DATASET";
    }

    @Override
    public Pair<EntryList, List<String[]>> search(EntryList fileEntryList, Map<String, Map<String, Set<String>>> resourceUsage, List<VSAMInput> excludedDS, int direction, Integer limit, IDProvider idProvider, EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(FileToDatasetDependencyProvider.class, "collectingDatasets.taskName"));
        EntryList datasetEntries = new EntryList();
        ArrayList<String[]> datasetInfo = new ArrayList<String[]>();
        DatasetFlow datasetFlow = null;
        List<VSAMInput> datasets = this.findDatasetsForFiles(conn, fileEntryList, resourceUsage, datasetEntries, datasetInfo, idProvider, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            return null;
        }
        if (datasets != null) {
            Direction d = null;
            switch (direction) {
                case 0: {
                    d = Direction.BOTH;
                    break;
                }
                case 1: {
                    d = Direction.FORWARD;
                    break;
                }
                case 2: {
                    d = Direction.BACKWARD;
                    break;
                }
                default: {
                    d = Direction.FORWARD;
                }
            }
            datasetFlow = new DatasetFlow(d);
            datasetFlow.setValidator(this.validator);
            ArrayList<VSAMInput> tmp = new ArrayList<VSAMInput>(datasets);
            if (excludedDS != null) {
                tmp.removeAll(excludedDS);
            }
            datasetFlow.setInputs(tmp);
            if (limit != null) {
                datasetFlow.setLimit(limit.intValue());
            }
            datasetFlow.setExcludes(excludedDS);
            datasetFlow.find(conn, (IProgressMonitor)monitor.newChild(10));
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (datasetFlow != null) {
            Map flowResults = datasetFlow.getResults();
            this.processFlowResults(datasets, flowResults, datasetEntries, datasetInfo, idProvider, (IProgressMonitor)monitor.newChild(10));
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return new Pair((Object)datasetEntries, datasetInfo);
    }

    private List<VSAMInput> findDatasetsForFiles(EZSourceConnection conn, EntryList fileEntryList, Map<String, Map<String, Set<String>>> resourceUsage, EntryList datasetEntries, List<String[]> datasetInfo, IDProvider idProvider, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        ArrayList<String> param = new ArrayList<String>();
        String spName = "EZViewer_ImpactFileToDatasetProcedure";
        ArrayList<VSAMInput> datasets = new ArrayList<VSAMInput>();
        HashMap<String, Integer> fileInternalIds = new HashMap<String, Integer>();
        for (Entry fileEntry : fileEntryList.getList()) {
            String fileID = fileEntry.dbId;
            fileInternalIds.put(fileID, fileEntry.internalID);
            param.add(fileID);
        }
        final Object[] ret = new Object[1];
        QueryHandler qh = new QueryHandler(new CloseTest());
        qh.runSP(new DataStepProcessor(){

            @Override
            public void dataStep(List<String[]> data) {
                ret[0] = data;
            }
        }, spName, param, conn);
        List data = (List)ret[0];
        this.handleFileData(datasetEntries, datasetInfo, idProvider, monitor, datasets, fileInternalIds, resourceUsage, data);
        return datasets;
    }

    private void processFlowResults(List<VSAMInput> inputs, Map<String, Iterable<InfoData>> flowResults, EntryList datasetEntries, List<String[]> datasetInfo, IDProvider idProvider, IProgressMonitor pmonitor) {
        SubMonitor.convert((IProgressMonitor)pmonitor);
        ArrayList<String> toExpand = new ArrayList<String>();
        for (VSAMInput vi : inputs) {
            toExpand.add(vi.getListableName());
        }
        while (!toExpand.isEmpty()) {
            String dsn = (String)toExpand.remove(0);
            Iterable<InfoData> info = flowResults.get(dsn);
            if (info == null) continue;
            for (InfoData id : info) {
                Iterable already = datasetEntries.getById(id.id2);
                if (already != null && !already.isEmpty()) continue;
                Iterable backlist = datasetEntries.getById(id.id1);
                if (backlist != null && !backlist.isEmpty()) {
                    Entry dsEntry = Entry.instantiate(idProvider, id.id2);
                    int backid = ((Entry)backlist.get((int)0)).internalID;
                    String utility = id.procName != null && !id.procName.isEmpty() ? String.valueOf(id.procName) + "/" + id.pgmName : id.pgmName;
                    String network = this.networkProvider.isDataAvailable() ? (String)this.networkProvider.getNetworkForJob(id.jobName).getFirst() : null;
                    String nameToPrint = String.valueOf(id.name2) + "(" + id.jobName + "/" + id.stepName + (network != null && !network.isEmpty() ? "/" + network : "") + ")";
                    dsEntry.setBackID(backid);
                    dsEntry.isResource = true;
                    dsEntry.setImpactType(Messages.getString(FileToDatasetDependencyProvider.class, "dataset.impactType", new String[]{utility}));
                    dsEntry.programPath = id.cardInfo[11];
                    dsEntry.language = "JCL";
                    int line = id.cardInfo[12] == null ? 0 : Integer.parseInt(id.cardInfo[12]);
                    line = line >= 0 ? line : 0;
                    dsEntry.startRow = "" + line;
                    datasetEntries.add(dsEntry);
                    this.addOrdered(datasetInfo, nameToPrint, "" + dsEntry.internalID, id.id2);
                    this.aautoJobsSummary.add(id.jobName);
                    if (network != null && !network.isEmpty()) {
                        this.aautoNetworksSummary.add(network);
                    }
                    Entry.register(idProvider, dsEntry);
                }
                toExpand.add(id.name2);
            }
        }
    }

    @Override
    public Map<String, Set<String>> getSummary() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (!this.aautoJobsSummary.isEmpty()) {
            map.put(Messages.getString(FileToDatasetDependencyProvider.class, "impactedJobs.summaryName"), this.aautoJobsSummary);
        }
        if (!this.aautoNetworksSummary.isEmpty()) {
            map.put(Messages.getString(FileToDatasetDependencyProvider.class, "impactedAAutoNetworks.summaryName"), this.aautoNetworksSummary);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    private void addOrdered(List<String[]> datasetInfo, String name, String internalId, String datasetId) {
        int i = 0;
        boolean add = true;
        for (String[] s : datasetInfo) {
            int cmp = name.compareToIgnoreCase(s[1]);
            if (cmp > 0) {
                ++i;
                continue;
            }
            if (cmp != 0) break;
            add = false;
            break;
        }
        if (add) {
            String[] stringArray = new String[5];
            stringArray[0] = internalId;
            stringArray[1] = name;
            stringArray[4] = datasetId;
            datasetInfo.add(i, stringArray);
        }
    }

    private void handleFileData(EntryList datasetEntries, List<String[]> datasetInfo, IDProvider idProvider, SubMonitor monitor, List<VSAMInput> datasets, Map<String, Integer> fileInternalIds, Map<String, Map<String, Set<String>>> resourceUsage, List<String[]> data) {
        if (data != null) {
            for (String[] row : data) {
                String network;
                String jobName = row[0];
                String stepName = row[2];
                String ddCard = row[4];
                String datasetName = row[5];
                String datasetId = row[6];
                String fileID = row[9];
                String path = row[14];
                String line = row[15];
                String dsMemberName = row[13];
                VSAMInput vsi = new VSAMInput(datasetName, Integer.valueOf(Integer.parseInt(datasetId)), null, dsMemberName);
                vsi.setExtra(new String[]{row[1], row[3], row[10], jobName});
                datasets.add(vsi);
                Entry dsEntry = Entry.instantiate(idProvider, datasetId);
                dsEntry.setBackID(fileInternalIds.get(fileID));
                dsEntry.setImpactType(Messages.getString(FileToDatasetDependencyProvider.class, "ddcard.impactType", new String[]{ddCard}));
                dsEntry.isResource = true;
                dsEntry.programPath = path;
                dsEntry.language = "JCL";
                dsEntry.startRow = line;
                Entry e = idProvider.getEntryWithInternalID(dsEntry.getBackID());
                while (e != null && e.getBackID() != -1) {
                    if (e.progID != null) {
                        dsEntry.progID = e.progID;
                        dsEntry.setProgramName(e.getProgramName());
                        FieldExpansionUtils.registerResourceUsage(resourceUsage, this.getType(), datasetId, e.progID);
                        break;
                    }
                    e = idProvider.getEntryWithInternalID(e.getBackID());
                }
                Entry.register(idProvider, dsEntry);
                datasetEntries.add(dsEntry);
                this.aautoJobsSummary.add(jobName);
                String string = network = this.networkProvider.isDataAvailable() ? (String)this.networkProvider.getNetworkForJob(jobName).getFirst() : null;
                if (network != null) {
                    this.aautoNetworksSummary.add(network);
                }
                String datasetWithMemberName = vsi.getListableName();
                String name = String.valueOf(datasetWithMemberName) + "(" + jobName + "/" + stepName + (network != null && !network.isEmpty() ? "/" + network : "") + ")";
                this.addOrdered(datasetInfo, name, "" + dsEntry.internalID, datasetId);
                if (monitor.isCanceled()) break;
            }
        }
    }

    class CloseTest
    implements Runnable {
        CloseTest() {
        }

        @Override
        public void run() {
        }
    }
}

