/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Entry;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.EntryListInterface;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PersistentEntryList;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Program;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldExpansionUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FieldExpansionUtils.class);

    static boolean isIDIn(String id, EntryListInterface list, Runnable closeTest) {
        boolean vb;
        Iterable<Entry> duplicates = list.getById(id);
        boolean bl = vb = duplicates != null && duplicates.iterator() != null;
        if (vb) {
            vb = duplicates.iterator().hasNext();
            if (duplicates instanceof PersistentEntryList && L.isTraceEnabled()) {
                L.trace("print duplicates with id={}", (Object)id);
                for (Entry type : duplicates) {
                    if (closeTest != null) {
                        closeTest.run();
                    }
                    L.trace("{}", (Object)type);
                }
            }
        }
        return vb;
    }

    static boolean isIDWithOrdinalIn(String id, String ordinalPos, EntryListInterface<Entry> list, Runnable closeTest) {
        boolean rez = false;
        Iterable<Entry> duplicates = list.getById(id);
        if (duplicates != null) {
            for (Entry entry : duplicates) {
                if (closeTest != null) {
                    closeTest.run();
                }
                if (entry.ordinalPos == null || !entry.ordinalPos.equals(ordinalPos)) continue;
                rez = true;
                break;
            }
        }
        return rez;
    }

    static Entry getIDWithOrdinalIn(String id, String ordinalPos, EntryListInterface<Entry> list, Runnable closeTest) {
        Entry rez = null;
        Iterable<Entry> duplicates = list.getById(id);
        if (duplicates != null) {
            for (Entry entry : duplicates) {
                if (closeTest != null) {
                    closeTest.run();
                }
                if (entry.ordinalPos == null || !entry.ordinalPos.equals(ordinalPos)) continue;
                rez = entry;
                break;
            }
        }
        return rez;
    }

    static boolean isIDOffsetIn(String dependentVar, String offsetStart, String offsetEnd, EntryListInterface list, Runnable closeTest) {
        boolean rez = false;
        Iterable<Entry> duplicates = list.getById(dependentVar);
        if (duplicates != null) {
            for (Entry entry : duplicates) {
                if (closeTest != null) {
                    closeTest.run();
                }
                if (entry.getStringOffsetStart() != null && offsetStart != null) {
                    int ts = Integer.valueOf(offsetStart);
                    int te = Integer.valueOf(offsetEnd);
                    if (entry.getIntOS() > ts || entry.getIntOE() < te) continue;
                    rez = true;
                    break;
                }
                if (entry.getStringOffsetStart() != null || offsetStart != null) continue;
                rez = true;
                break;
            }
        }
        return rez;
    }

    static boolean isProgramIDIn(String programID, List<Program> list, Runnable closeTest) {
        boolean rez = false;
        int i = 0;
        for (Program prg : list) {
            if (i % 1000 == 0 && closeTest != null) {
                closeTest.run();
            }
            if (prg.id.equals(programID)) {
                rez = true;
                break;
            }
            ++i;
        }
        return rez;
    }

    public static List<Entry> getEntriesWithID(String id, EntryListInterface<Entry> list) {
        ArrayList<Entry> found = new ArrayList<Entry>();
        Iterable<Entry> duplicates = list.getById(id);
        Iterator<Entry> it = duplicates.iterator();
        while (it.hasNext()) {
            found.add(it.next());
        }
        return found;
    }

    public static void registerResourceUsage(Map<String, Map<String, Set<String>>> resourceUsage, String resourceTypeId, String resID, String programId) {
        Set<String> usedByPrograms;
        Map<String, Set<String>> usageByType = resourceUsage.get(resourceTypeId);
        if (usageByType == null) {
            usageByType = new HashMap<String, Set<String>>();
            resourceUsage.put(resourceTypeId, usageByType);
        }
        if ((usedByPrograms = usageByType.get(resID)) == null) {
            usedByPrograms = new HashSet<String>();
            usageByType.put(resID, usedByPrograms);
        }
        usedByPrograms.add(programId);
    }
}

