/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.ObjectForSubreport3Link;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.CallsInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DataStepProcessor;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.DetailsDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Entry;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.EntryList;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.EntryListInterface;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FieldExpansionUtils;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FileToDatasetDependencyProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Holder;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.IDProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.IExtraDependencyProvider;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.LinkagePrinter;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PathPrinter;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.PersistentEntryList;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Program;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.QueryHandler;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VarDetails;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VarLinkInfo;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Variable;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VariableElement;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.VariablePrinter;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldExpansionSearch {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FieldExpansionSearch.class);
    private static String EZREPORTS_FIELD_EXPANSION_QUERY9 = "EZReports_FieldExpansion_Query9";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY6_UCMDB = "EZReports_FieldExpansion_Query6_UCMDB";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY6 = "EZReports_FieldExpansion_Query6";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY5 = "EZReports_FieldExpansion_Query5";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY4 = "EZReports_FieldExpansion_Query4";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY2 = "EZReports_FieldExpansion_Query2";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY4_FORWARD = "EZReports_FieldExpansion_Query4_forward";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY2_FORWARD = "EZReports_FieldExpansion_Query2_forward";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY4_BACKWARD = "EZReports_FieldExpansion_Query4_backward";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY2_BACKWARD = "EZReports_FieldExpansion_Query2_backward";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY3 = "EZReports_FieldExpansion_Query3";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY6_1 = "EZReports_FieldExpansion_Query6_1";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY6_1_UCMDB = "EZReports_FieldExpansion_Query6_1_UCMDB";
    private static String EZREPORTS_FIELD_EXPANSION_UpdateEntries_1 = "EZReports_FieldExpansion_UpdateEntries_1";
    private static String EZREPORTS_FIELD_EXPANSION_UpdateEntries_2 = "EZReports_FieldExpansion_UpdateEntries_2";
    private static String EZREPORTS_FIELD_EXPANSION_Step0_IncludeHandling = "EZReports_FieldExpansion_Step0_IncludeHandling";
    private static String EZVIEWER_FIELD_EXPANSION_InitFromVariables_Sql_Impact = "EZViewer_FieldExpansion_InitFromVariables_Sql_Impact";
    private static String EZREPORTS_FIELD_EXPANSION_FillProgramDetails = "EZReports_FieldExpansion_FillProgramDetails";
    private static String EZREPORTS_FIELD_EXPANSION_FillIncludeDetails = "EZReports_FieldExpansion_FillIncludeDetails";
    private static String EZReports_FieldExpansion_ExcludedVarIDs = "EZReports_FieldExpansion_ExcludedVarIDs";
    private static String EZReports_FieldExpansion_FillVarDBFieldDetails = "EZReports_FieldExpansion_FillVarDBFieldDetails";
    private static String EZReports_FieldExpansion_FillVarDBFieldDetails_fw = "EZReports_FieldExpansion_FillVarDBFieldDetails_fw";
    private static String EZReports_FieldExpansion_FillVarDBFieldDetails_bkw = "EZReports_FieldExpansion_FillVarDBFieldDetails_bkw";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY4_SQL_FORWARD = "EZReports_FieldExpansion_Query4_sql_forward";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY4_SQL_BACKWARD = "EZReports_FieldExpansion_Query4_sql_backward";
    private static String EZREPORTS_FIELD_EXPANSION_QUERY4_SQL = "EZReports_FieldExpansion_Query4_sql";
    private static final String SQL_FIELD_MAPPING_LABEL = Messages.getString(FieldExpansionSearch.class, "generic.sqlFieldMapping.label");
    private AbstractReport report;
    private boolean multiplePaths = true;
    private boolean useMemoryLists = false;
    private EntryListInterface<Entry> q1 = this.useMemoryLists ? new EntryList() : new PersistentEntryList(2048);
    private EntryListInterface<Entry> q2 = this.useMemoryLists ? new EntryList() : new PersistentEntryList(2048);
    private EntryList q3 = new EntryList();
    private EntryListInterface<Entry> q2extra = this.useMemoryLists ? new EntryList() : new PersistentEntryList(1024);
    private EntryListInterface<Entry> l1 = this.useMemoryLists ? new EntryList() : new PersistentEntryList(3072);
    private EntryListInterface<Entry> l2 = this.useMemoryLists ? new EntryList() : new PersistentEntryList(2048);
    private EntryListInterface<Entry> l3 = this.useMemoryLists ? new EntryList() : new PersistentEntryList(2048);
    private EntryListInterface<Entry> ltemp = this.useMemoryLists ? new EntryList() : new PersistentEntryList(4096);
    private EntryListInterface<Entry> entries = this.useMemoryLists ? new EntryList() : new PersistentEntryList(4096);
    private IDProvider idProvider = new IDProvider(this.entries);
    private List<Program> programList = new ArrayList<Program>();
    private List<Object[]> programParameterList = new ArrayList<Object[]>();
    private Map<String, Set<VarLinkInfo>> varsInPrograms = new HashMap<String, Set<VarLinkInfo>>();
    private boolean firstCycle = true;
    private String monitorPrefix = "";
    private CloseRunnable closeRunnable = new CloseRunnable();
    Map<String, CallsInfo> programCalls = new HashMap<String, CallsInfo>();
    Map<String, Map<String, Set<String>>> resourceUsage = new HashMap<String, Map<String, Set<String>>>();
    private static final String USE_SHARED_INCLUDE = "Use_shared_include";
    private QueryHandler queryHandler = new QueryHandler(this.closeRunnable);
    boolean continued = false;
    Stack<IProgressMonitor> monitorStack = new Stack();
    static final int VARIABLE = 0;
    static final int PROGRAM = 1;
    static final int OTHER = 2;
    private static final String NOT_AVAILABLE = Messages.getString(FieldExpansionSearch.class, "notAvailable");
    public static final String EXT_TYPE_DATASET = "EXT_TYPE_DATASET";
    private final String STATEMENT_TYPE = Messages.getString(FieldExpansionSearch.class, "impactType.stmtType");
    private final String CALLED_PROGRAM = Messages.getString(FieldExpansionSearch.class, "impactType.calledProgram");
    private final String SHARED_INCLUDE = Messages.getString(FieldExpansionSearch.class, "impactType.sharedInclude");
    private final String PROGRAM_ARGUMENT = Messages.getString(FieldExpansionSearch.class, "impactType.programArgument");
    private final String CALL_PARAMETER = Messages.getString(FieldExpansionSearch.class, "impactType.callParameter");
    private final String REDEFINED = Messages.getString(FieldExpansionSearch.class, "impactType.variableRedefined");
    private final String CALLING_PROGRAM = Messages.getString(FieldExpansionSearch.class, "impactType.callingProgram");
    private final String DEFINITION_PROGRAM = Messages.getString(FieldExpansionSearch.class, "impactType.definitionProgram");
    private int cycles = 0;
    private CSVWriter csv;
    private Map<String, IExtraDependencyProvider> extraDependencyProviders = new HashMap<String, IExtraDependencyProvider>();
    private Map<String, Set<String>> extraDependencySummary = new HashMap<String, Set<String>>();
    private Map<String, String> resourceQueries = new HashMap<String, String>(){
        {
            this.put("1", "EZReports_FieldExpansion_Query11");
            this.put("6", "EZReports_FieldExpansion_Query12");
            this.put("9", "EZReports_FieldExpansion_Query13");
            this.put("18", "");
            this.put("19", "");
            this.put("20", "");
            this.put("21", "");
            this.put("56", "EZReports_FieldExpansion_Query24");
            this.put("61", "EZReports_FieldExpansion_Query14");
            this.put("62", "EZReports_FieldExpansion_Query15");
            this.put("69", "EZReports_FieldExpansion_Query16");
            this.put("70", "EZReports_FieldExpansion_Query17");
            this.put("77", "EZReports_FieldExpansion_Query18");
            this.put("78", "EZReports_FieldExpansion_Query19");
            this.put("81", "");
            this.put("82", "EZReports_FieldExpansion_Query25");
            this.put("182", "EZReports_FieldExpansion_Query20");
            this.put("189", "EZReports_FieldExpansion_Query21");
            this.put("190", "EZReports_FieldExpansion_Query22");
            this.put("193", "EZReports_FieldExpansion_Query23");
            this.put("214", "EZReports_FieldExpansion_Query26");
            this.put("1000", "EZReports_FieldExpansion_Query27");
        }
    };
    private Map<String, EntryList> resourceMap = new HashMap<String, EntryList>();
    private Map<String, List<String[]>> resourceResults = new HashMap<String, List<String[]>>();
    private List<String> orderedTypes = new ArrayList<String>(){
        {
            this.add("1");
            this.add("6");
            this.add("9");
            this.add("18");
            this.add("19");
            this.add("20");
            this.add("21");
            this.add("56");
            this.add("61");
            this.add("69");
            this.add("70");
            this.add("77");
            this.add("78");
            this.add("81");
            this.add("82");
            this.add("182");
            this.add("189");
            this.add("190");
            this.add("1000");
            this.add("214");
        }
    };
    private Set<String> numericVarTypes = new HashSet<String>(){
        {
            this.add("1");
            this.add("2");
            this.add("3");
            this.add("4");
            this.add("5");
        }
    };
    private List<Variable> finalVariables = null;
    private Set<Program> sourcesList = null;
    private Map<String, Properties> excludedVars = null;
    private List<String> excludedIds = null;
    private List<VSAMInput> excludedDS = null;
    private boolean fieldExpansionReport;
    private Integer direction;
    private Set<String> inputVarIds = new HashSet<String>();
    private Map<String, String[]> variableMapp;
    private final String debugFile = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "ezreport_debug.txt";

    private final void registerMonitor(IProgressMonitor monitor) {
        this.monitorStack.push(monitor);
    }

    private final void unRegisterMonitor(IProgressMonitor monitor) {
        L.debug("{} from stack; received: {}", (Object)this.monitorStack.pop(), (Object)monitor);
    }

    private final void closeTest() {
        if (!this.continued && !this.monitorStack.isEmpty() && this.monitorStack.peek().isCanceled()) {
            this.closePersistentFiles(false);
            throw new CanceledException(Messages.getString(FieldExpansionSearch.class, "reportCanceled.exception"));
        }
    }

    public FieldExpansionSearch(AbstractReport report, boolean fieldExpansionReport) {
        this.report = report;
        this.fieldExpansionReport = fieldExpansionReport;
        if (fieldExpansionReport) {
            this.multiplePaths = false;
        }
    }

    public void doSearch(EZSourceConnection conn, IProgressMonitor monitor) {
        SubMonitor sub;
        block16: {
            boolean useImpactDataFlow = Boolean.parseBoolean(System.getProperty("impactDataflow", "true"));
            if (useImpactDataFlow) {
                this.extraDependencyProviders.put("9", new FileToDatasetDependencyProvider(conn));
            }
            L.trace("start {} for report: {} -- {}", new Object[]{this, this.report.identifier, this.report.getProperty("variable_name")});
            sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
            sub.beginTask(Messages.getString(FieldExpansionSearch.class, "generatingReport.monitor.description"), 1000);
            this.registerMonitor((IProgressMonitor)sub);
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "initializing.subTask.name"));
            this.direction = (Integer)this.report.getProperty("direction");
            this.excludedVars = (Map)this.report.getProperty("excluded variables");
            this.excludedDS = (List)this.report.getProperty("excluded datasets");
            this.getExcludedIds(conn);
            String varName = (String)this.report.getProperty("start_var_name");
            Integer propVal = (Integer)this.report.getProperty("max cycles");
            int maxCycles = propVal != null ? propVal : 0;
            L.debug("maxCycles={}", (Object)maxCycles);
            if (this.multiplePaths && this.direction != 1 && this.direction != 2) {
                L.error("direction must be 1 (forward) or 2 (backward) for multiple path");
                throw new RuntimeException("direction must be 1 (forward) or 2 (backward) for multiple path");
            }
            this.initialize();
            this.closeTest();
            if (varName != null) {
                this.initializeFromVariable(varName, conn);
            } else {
                this.initializeFromProgramOrInclude();
            }
            this.closeTest();
            sub.worked(100);
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "searchVariables.subTask.name"));
            try {
                try {
                    this.partOne((IProgressMonitor)sub.newChild(500), maxCycles, conn);
                }
                catch (CanceledException rc) {
                    L.info("report was canceled. partial results are available, ask user if report should be generated with partial results");
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FieldExpansionSearch.this.continued = MessageDialog.openQuestion(null, (String)Messages.getString(FieldExpansionSearch.class, "canceledDialog.title"), (String)Messages.getString(FieldExpansionSearch.class, "canceledDialog.message"));
                        }
                    });
                    if (!this.continued) {
                        L.info("report generation is canceled");
                        throw rc;
                    }
                    L.info("user chose to continue report with partial results. Cancel is not available anymore.");
                    try {
                        this.q1.clear();
                        this.q2.clear();
                        this.q3.clear();
                    }
                    catch (Throwable ex) {
                        L.warn("error at clear; ignore it and continue", ex);
                        this.q1 = null;
                        this.q2 = null;
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.q1.clear();
                    this.q2.clear();
                    this.q3.clear();
                }
                catch (Throwable ex) {
                    L.warn("error at clear; ignore it and continue", ex);
                    this.q1 = null;
                    this.q2 = null;
                }
                throw throwable;
            }
            try {
                this.q1.clear();
                this.q2.clear();
                this.q3.clear();
            }
            catch (Throwable ex) {
                L.warn("error at clear; ignore it and continue", ex);
                this.q1 = null;
                this.q2 = null;
            }
        }
        this.closeTest();
        this.printQueues("after partOne");
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "preparingSearchResults.subTask.name"));
        this.partTwo((IProgressMonitor)sub.newChild(400), conn);
        sub.subTask("");
        this.printQueues("after partTwo");
        this.variableMapp = this.getVarDbFieldDetails(conn);
        this.unRegisterMonitor((IProgressMonitor)sub);
    }

    private boolean isStartedOnDBField() {
        String fieldID;
        SelectSingleFromListPage.ArrayListItem it;
        boolean ret = false;
        Boolean vb = (Boolean)this.report.getProperty("selectionOnDBField");
        if (vb != null && vb.booleanValue() && (it = (SelectSingleFromListPage.ArrayListItem)this.report.getProperty("selectedFieldID")) != null && (fieldID = it.getStringArray()[1]) != null) {
            ret = true;
        }
        return ret;
    }

    private Map<String, String[]> getVarDbFieldDetails(EZSourceConnection conn) {
        String fieldID;
        SelectSingleFromListPage.ArrayListItem it;
        if (this.isStartedOnDBField() && (it = (SelectSingleFromListPage.ArrayListItem)this.report.getProperty("selectedFieldID")) != null && (fieldID = it.getStringArray()[1]) != null) {
            Collection varIds = (Collection)this.report.getProperty("inputs");
            final HashMap<String, String[]> mapping = new HashMap<String, String[]>();
            ArrayList<String> param = new ArrayList<String>();
            param.add(fieldID);
            String spName = EZReports_FieldExpansion_FillVarDBFieldDetails;
            int direction = this.fieldExpansionReport ? 0 : this.direction;
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    if (rez != null) {
                        for (String[] cols : rez) {
                            FieldExpansionSearch.this.closeTest();
                            String varID = cols[0];
                            if (mapping.containsKey(varID)) continue;
                            mapping.put(varID, cols);
                        }
                    }
                }
            }, spName, varIds, true, "numeric_param_temp", new int[]{1}, new String[]{fieldID, String.valueOf(direction)}, conn);
            return mapping;
        }
        return null;
    }

    private void printQueues(String stepName) {
        if (L.isTraceEnabled()) {
            L.trace("------------- {}", (Object)stepName);
            if (this.excludedVars != null) {
                L.trace("excludedVars(map).size(): {}", (Object)this.excludedVars.size());
                L.trace("excludedIds(list).size(): {}", (Object)this.excludedIds.size());
            }
            if (this.finalVariables != null) {
                L.trace("finalVariables(list).size: {}", (Object)this.finalVariables.size());
            } else {
                L.trace("finalVariables(list) is null");
            }
            L.trace("programList(list).size: {}", (Object)this.programList.size());
            L.trace("resourceResults(map).size: {}", (Object)this.resourceResults.size());
            if (this.sourcesList != null) {
                L.trace("sourcesList(set).size: {}", (Object)this.sourcesList.size());
            } else {
                L.trace("sourcesList(set) is null");
            }
            L.trace("    -----------------------");
        }
    }

    private void getExcludedIds(EZSourceConnection conn) {
        ArrayList<String> namedVariables = new ArrayList<String>();
        this.excludedIds = new ArrayList<String>();
        for (String key : this.excludedVars.keySet()) {
            this.closeTest();
            Properties prop = this.excludedVars.get(key);
            String varName = prop.getProperty("varName");
            String varID = prop.getProperty("varID");
            if (varID == null) {
                namedVariables.add(varName);
                continue;
            }
            if ("-100".equals(varID)) {
                int max = Integer.valueOf(prop.getProperty("varIDNumber"));
                int i = 0;
                while (i < max) {
                    this.excludedIds.add(prop.getProperty(String.valueOf(varName) + "." + i));
                    ++i;
                }
                continue;
            }
            this.excludedIds.add(varID);
        }
        this.getIdsForNamedVariables(namedVariables, conn);
    }

    private void getIdsForNamedVariables(List<String> names, EZSourceConnection conn) {
        if (names != null && names.size() > 0) {
            int databaseEngine = ServerType.SqlServer.getValue();
            String spName = databaseEngine == ServerType.SqlServer.getValue() ? EZReports_FieldExpansion_ExcludedVarIDs : null;
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    if (rez != null) {
                        int i = 0;
                        for (String[] cols : rez) {
                            if (i % 1000 == 0) {
                                FieldExpansionSearch.this.closeTest();
                            }
                            FieldExpansionSearch.this.excludedIds.add(cols[0]);
                            ++i;
                        }
                    }
                }
            }, spName, names, true, "string_param_temp", new int[]{1}, conn);
        }
    }

    private boolean isExcludedID(String id) {
        return this.excludedIds != null ? this.excludedIds.contains(id) : false;
    }

    private void initializeFromVariable(String varName, EZSourceConnection bridge) {
        final HashSet varIDs = new HashSet();
        final HashSet progs = new HashSet();
        String spName = EZVIEWER_FIELD_EXPANSION_InitFromVariables_Sql_Impact;
        ArrayList<String> param = new ArrayList<String>();
        param.add(varName.toUpperCase());
        this.queryHandler.runSP(new DataStepProcessor(){

            @Override
            public void dataStep(List<String[]> rez) {
                if (rez != null) {
                    for (String[] cols : rez) {
                        FieldExpansionSearch.this.closeTest();
                        if (FieldExpansionSearch.this.isExcludedID(cols[0])) continue;
                        if (!varIDs.contains(cols[0])) {
                            Entry inp = Entry.instantiate(FieldExpansionSearch.this.idProvider, cols[0]);
                            Entry.register(FieldExpansionSearch.this.idProvider, inp);
                            FieldExpansionSearch.this.q1.add(inp);
                            varIDs.add(cols[0]);
                        }
                        if (progs.contains(cols[1])) continue;
                        Program prg = new Program();
                        prg.setId(cols[1]);
                        prg.name = cols[2];
                        FieldExpansionSearch.this.programList.add(prg);
                        progs.add(cols[1]);
                    }
                }
            }
        }, spName, param, true, "string_param_temp", new int[]{1}, bridge);
        if (!varIDs.isEmpty()) {
            this.inputVarIds.addAll(varIDs);
        }
    }

    private void initializeFromProgramOrInclude() {
        block3: {
            block4: {
                Collection ids = (Collection)this.report.getProperty("inputs");
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    this.closeTest();
                    String id = (String)iterator.next();
                    if (id == null || this.isExcludedID(id)) continue;
                    Entry inp = Entry.instantiate(this.idProvider, id);
                    Entry.register(this.idProvider, inp);
                    this.q1.add(inp);
                    this.inputVarIds.add(id);
                }
                if (this.q1.isEmpty()) break block3;
                Map prgs = (Map)this.report.getProperty("program map");
                if (prgs == null || prgs.size() == 0) break block4;
                for (String key : prgs.keySet()) {
                    this.closeTest();
                    Program prg = new Program();
                    prg.setId(key);
                    prg.name = (String)prgs.get(key);
                    this.programList.add(prg);
                }
                break block3;
            }
            Map resMap = (Map)this.report.getProperty("resources_map");
            if (resMap == null || resMap.size() == 0) break block3;
            for (String key : resMap.keySet()) {
                Program prg = new Program();
                prg.setId(key);
                prg.name = (String)resMap.get(key);
                String resType = (String)this.report.getProperty("resource_type");
                prg.isInclude = Utils.RESOURCE_TYPE_INCLUDE.equalsIgnoreCase(resType);
                this.programList.add(prg);
            }
        }
    }

    private void initialize() {
        this.q1.clear();
        this.q2.clear();
        this.q2extra.clear();
        this.q3.clear();
        this.l1.clear();
        this.ltemp.clear();
        this.l2.clear();
        this.l3.clear();
        this.programList.clear();
        this.programParameterList.clear();
    }

    private void partOne(IProgressMonitor monitor, int maxCycles, EZSourceConnection conn) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.beginTask(null, -1);
        this.registerMonitor((IProgressMonitor)sub);
        L.debug("partOne");
        this.cycles = 0;
        while ((maxCycles > 0 && this.cycles < maxCycles || maxCycles == 0) && !this.finished()) {
            L.info("current cycle: {}", (Object)this.cycles);
            this.closeTest();
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "processVariablesProgress.subTask.name", new String[]{String.valueOf(this.l1.size())}));
            this.monitorPrefix = Messages.getString(FieldExpansionSearch.class, "monitorPrefix.label", new String[]{String.valueOf(this.cycles + 1), String.valueOf(this.l1.size())});
            this.writeListToDebug("=========== new cycle ===========", null);
            this.writeListToDebug("Q1", this.q1);
            this.writeListToDebug("Q2", this.q2);
            this.writeListToDebug("Q3", this.q3);
            this.directDA((IProgressMonitor)sub.newChild(100), conn);
            this.closeTest();
            this.nonDirectDA((IProgressMonitor)sub.newChild(100), conn);
            this.closeTest();
            this.newRedefineDA((IProgressMonitor)sub.newChild(100), conn);
            this.ltemp = this.recreatePersistentList(this.ltemp);
            this.firstCycle = false;
            ++this.cycles;
        }
        L.debug("l2 size={}", (Object)this.l2.size());
        L.debug("l3 size={}", (Object)this.l3.size());
        this.l2.clear();
        this.l3.clear();
        this.unRegisterMonitor((IProgressMonitor)sub);
    }

    private void writeListToDebug(String string, EntryListInterface q12) {
        block15: {
            if (!System.getProperty("DEBUG_EXPANSION_LISTS", "false").equals("true")) {
                return;
            }
            OutputStreamWriter fw = null;
            try {
                try {
                    fw = new FileWriter(this.debugFile, true);
                    if (q12 != null) {
                        fw.write("---- start id's for : " + string + " ----\n");
                        for (Entry e : q12.getList()) {
                            fw.write(String.valueOf(e.dbId) + ",\n");
                        }
                        fw.write("---- end id's for : " + string + " ----\n");
                        break block15;
                    }
                    fw.write(String.valueOf(string) + "\n");
                }
                catch (IOException e) {
                    L.error("Error:", (Throwable)e);
                    if (fw == null) break block15;
                    try {
                        fw.close();
                    }
                    catch (IOException e2) {
                        L.warn("error at closing debug file: {}", (Object)this.debugFile, (Object)e2);
                    }
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        L.warn("error at closing debug file: {}", (Object)this.debugFile, (Object)e);
                    }
                }
            }
        }
    }

    private void directDA(IProgressMonitor monitor, EZSourceConnection conn) {
        Map<Integer, List<String>> ids;
        L.debug("directDA()");
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.beginTask(null, -1);
        this.registerMonitor((IProgressMonitor)sub);
        this.ltemp = this.recreatePersistentList(this.ltemp);
        ArrayList<String> param = new ArrayList<String>();
        HashMap<String, List<Entry>> origEntries = new HashMap<String, List<Entry>>();
        for (Entry e : this.q1) {
            this.closeTest();
            if (!this.CALLING_PROGRAM.equals(e.getImpactType())) {
                param.add(e.dbId);
                this.l1.add(e);
                this.ltemp.add(e);
                ArrayList<Entry> duplicates = (ArrayList<Entry>)origEntries.get(e.dbId);
                if (duplicates == null) {
                    duplicates = new ArrayList<Entry>();
                    origEntries.put(e.dbId, duplicates);
                }
                duplicates.add(e);
                continue;
            }
            L.info("directDA; ignored program id={} as having impact={}", (Object)e.dbId, (Object)e.getImpactType());
        }
        this.q1 = this.recreatePersistentList(this.q1);
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingDirectDeps.step1.subTask.name", new String[]{this.monitorPrefix}));
        if (!this.firstCycle && this.fieldExpansionReport) {
            this.step0(this.q1, this.l1, param, origEntries, conn);
        }
        if ((ids = this.step1(param, conn)) != null) {
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingDirectDeps.processVariables.subTask.name", new String[]{this.monitorPrefix}));
            this.processVariables(this.q1, this.l1, ids, this.getQuery(2), conn);
            this.closeTest();
            if (this.fieldExpansionReport) {
                this.processVariables(this.q1, this.l1, ids, EZREPORTS_FIELD_EXPANSION_QUERY3, conn);
                this.closeTest();
            }
            this.processQ6_1(this.q1, this.l1, ids, conn);
            this.closeTest();
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingDirectDeps.processResources.subTask.name", new String[]{this.monitorPrefix}));
            this.processOthers(ids, conn);
            this.closeTest();
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingDirectDeps.processPrograms.subTask.name", new String[]{this.monitorPrefix}));
            this.processProgramsQ5(ids, conn);
            this.closeTest();
            this.processProgramsQ6(this.q1, this.l1, ids, conn);
            this.closeTest();
        }
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingDirectDeps.step3.subTask.name", new String[]{this.monitorPrefix}));
        this.ddaStep3(conn);
        this.closeTest();
        this.ltemp = this.recreatePersistentList(this.ltemp);
        this.unRegisterMonitor((IProgressMonitor)sub);
    }

    private String getQuery(int queryNumber) {
        String rez = null;
        if (this.fieldExpansionReport) {
            switch (queryNumber) {
                case 2: {
                    rez = EZREPORTS_FIELD_EXPANSION_QUERY2;
                    break;
                }
                case 4: {
                    rez = EZREPORTS_FIELD_EXPANSION_QUERY4;
                }
            }
        } else {
            switch (queryNumber) {
                case 2: {
                    switch (this.direction) {
                        case 0: {
                            rez = EZREPORTS_FIELD_EXPANSION_QUERY2;
                            break;
                        }
                        case 1: {
                            rez = EZREPORTS_FIELD_EXPANSION_QUERY2_FORWARD;
                            break;
                        }
                        case 2: {
                            rez = EZREPORTS_FIELD_EXPANSION_QUERY2_BACKWARD;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.direction) {
                        case 0: {
                            rez = EZREPORTS_FIELD_EXPANSION_QUERY4;
                            break;
                        }
                        case 1: {
                            rez = EZREPORTS_FIELD_EXPANSION_QUERY4_FORWARD;
                            break;
                        }
                        case 2: {
                            rez = EZREPORTS_FIELD_EXPANSION_QUERY4_BACKWARD;
                        }
                    }
                    break;
                }
            }
        }
        return rez;
    }

    private boolean onAForwardCallChain(Entry e) {
        boolean forward = false;
        while (e != null) {
            if (this.CALLED_PROGRAM.equals(e.getImpactType())) {
                forward = true;
                break;
            }
            e = this.getEntryWithInternalID(e.getBackID(), this.entries);
        }
        return forward;
    }

    private void markProcessedCall(Entry e, String p1, String argPos, String p2, String os, String oe) {
        this.programParameterList.add(new Object[]{p1, argPos, p2, e, os, oe});
    }

    private Entry getProcessedCall(String p1, String argPos, String p2, String os, String oe) {
        Entry processed = null;
        for (Object[] calls : this.programParameterList) {
            if (!calls[0].equals(p1) || !calls[1].equals(argPos) || !calls[2].equals(p2) || (calls[4] != null || os != null) && (calls[4] == null || !calls[4].equals(os)) || (calls[5] != null || oe != null) && (calls[5] == null || !calls[5].equals(oe))) continue;
            processed = (Entry)calls[3];
            break;
        }
        return processed;
    }

    private void processQ6_1(final EntryListInterface opList, final EntryListInterface backOpList, Map<Integer, List<String>> ids, EZSourceConnection conn) {
        L.debug("processProgramsQ6_1()");
        List<String> varIds = ids.get(0);
        if (varIds != null && varIds.size() > 0) {
            String appName = (String)this.report.getProperty("APPLICATION_NAME");
            ArrayList<String> appNames = null;
            String queryName = EZREPORTS_FIELD_EXPANSION_QUERY6_1;
            if (appName != null && !"".equals(appName)) {
                appNames = new ArrayList<String>();
                appNames.add(appName);
                queryName = EZREPORTS_FIELD_EXPANSION_QUERY6_1_UCMDB;
            }
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleQ6_1(opList, backOpList, rez);
                }
            }, queryName, appNames, varIds, conn);
        }
    }

    private void processVariables(final EntryListInterface opList, final EntryListInterface backOpList, Map<Integer, List<String>> ids, String spName, EZSourceConnection conn) {
        L.debug("processVariables()");
        List<String> varIds = ids.get(0);
        if (varIds != null && varIds.size() > 0) {
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleProcessVariables(opList, backOpList, rez);
                }
            }, spName, varIds, conn);
        }
    }

    private int getInternalIDFor(String string) {
        return this.getInternalIDFor(string, this.entries);
    }

    private int getInternalIDFor(String string, EntryListInterface list) {
        int rez = 0;
        boolean found = false;
        Iterable<Entry> duplicates = list.getById(string);
        if (duplicates != null) {
            if (duplicates instanceof List) {
                if (!((List)duplicates).isEmpty()) {
                    rez = ((Entry)((List)duplicates).get((int)0)).internalID;
                    found = true;
                }
            } else {
                Iterator<Entry> it = duplicates.iterator();
                if (it != null && it.hasNext()) {
                    Entry e = it.next();
                    rez = e.internalID;
                    found = true;
                }
            }
        }
        if (!found) {
            throw new RuntimeException("internal ID not found");
        }
        return rez;
    }

    private void processOthers(Map<Integer, List<String>> ids, EZSourceConnection conn) {
        L.debug("processOthers()");
        List<String> otherIds = ids.get(2);
        if (otherIds != null && otherIds.size() > 0) {
            final HashMap tmp = new HashMap();
            String firstQuery = this.getQuery4Extra();
            if (firstQuery != null && !firstQuery.isEmpty()) {
                this.queryHandler.runSP(new DataStepProcessor(){

                    @Override
                    public void dataStep(List<String[]> rez) {
                        if (rez != null) {
                            for (String[] cols : rez) {
                                HashSet<String> tblIDs;
                                FieldExpansionSearch.this.closeTest();
                                String varID = cols[0];
                                String occID = cols[1];
                                HashMap<String, HashSet<String>> occ = (HashMap<String, HashSet<String>>)tmp.get(occID);
                                if (occ == null) {
                                    occ = new HashMap<String, HashSet<String>>();
                                    tmp.put(occID, occ);
                                }
                                if ((tblIDs = (HashSet<String>)occ.get(varID)) == null) {
                                    tblIDs = new HashSet<String>();
                                    occ.put(varID, tblIDs);
                                }
                                tblIDs.add(cols[2]);
                            }
                        }
                    }
                }, firstQuery, otherIds, conn);
            }
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleResourceResults(tmp, rez);
                }
            }, this.getQuery(4), otherIds, conn);
        }
    }

    private String getQuery4Extra() {
        String rez = "";
        if (this.fieldExpansionReport) {
            rez = EZREPORTS_FIELD_EXPANSION_QUERY4_SQL;
        } else {
            switch (this.direction) {
                case 0: {
                    L.warn("omnidirectional cannot be used with Impact report!");
                    break;
                }
                case 1: {
                    rez = EZREPORTS_FIELD_EXPANSION_QUERY4_SQL_FORWARD;
                    break;
                }
                case 2: {
                    rez = EZREPORTS_FIELD_EXPANSION_QUERY4_SQL_BACKWARD;
                }
            }
        }
        return rez;
    }

    private void processProgramsQ5(Map<Integer, List<String>> ids, EZSourceConnection conn) {
        L.debug("processProgramsQ5()");
        List<String> prgIds = ids.get(1);
        if (prgIds != null && prgIds.size() > 0) {
            String appName = (String)this.report.getProperty("APPLICATION_NAME");
            ArrayList<String> appNames = null;
            String query5Name = EZREPORTS_FIELD_EXPANSION_QUERY5;
            if (appName != null && !"".equals(appName)) {
                appNames = new ArrayList<String>();
                appNames.add(appName);
                query5Name = "EZReports_FieldExpansion_Query5_UCMDB";
            }
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleQ5(rez);
                }
            }, query5Name, appNames, prgIds, conn);
        }
    }

    private void processProgramsQ6(final EntryListInterface opList, final EntryListInterface backOpList, Map<Integer, List<String>> ids, EZSourceConnection conn) {
        L.debug("processProgramsQ6()");
        List<String> prgIds = ids.get(1);
        if (prgIds != null && prgIds.size() > 0) {
            String appName = (String)this.report.getProperty("APPLICATION_NAME");
            ArrayList<String> appNames = null;
            String query6Name = EZREPORTS_FIELD_EXPANSION_QUERY6;
            if (appName != null && !"".equals(appName)) {
                appNames = new ArrayList<String>();
                appNames.add(appName);
                query6Name = EZREPORTS_FIELD_EXPANSION_QUERY6_UCMDB;
            }
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleQ6(opList, backOpList, rez);
                }
            }, query6Name, appNames, prgIds, conn);
        }
    }

    private void updateProgramWithCallStatement(int varBackID, String prgID) {
        for (Program p : this.programList) {
            this.closeTest();
            if (!p.id.equals(prgID) || p.backID != -1) continue;
            p.backID = varBackID;
        }
    }

    private void nonDirectDA(IProgressMonitor monitor, EZSourceConnection conn) {
        L.debug("nonDirectDA()");
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.beginTask(null, -1);
        this.ltemp = this.recreatePersistentList(this.ltemp);
        ArrayList<String> param = new ArrayList<String>();
        for (Entry e : this.q2) {
            if (!this.CALLING_PROGRAM.equals(e.getImpactType())) {
                this.closeTest();
                param.add(e.dbId);
                this.l2.add(e);
                this.ltemp.add(e);
                continue;
            }
            L.info("nonDirectDA; calling prog found in nnda, it will be ignored. id={}", (Object)e.dbId);
        }
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingNonDirectDeps.step1.subTask.name", new String[]{this.monitorPrefix}));
        this.q2 = this.recreatePersistentList(this.q2);
        Map<Integer, List<String>> ids = this.step1(param, conn);
        this.closeTest();
        if (ids != null) {
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingNonDirectDeps.processVariables.subTask.name", new String[]{this.monitorPrefix}));
            this.processVariables(this.q2, this.l2, ids, this.getQuery(2), conn);
            this.closeTest();
            this.processVariables(this.q3, this.l3, ids, this.getQuery(2), conn);
            this.closeTest();
            if (this.fieldExpansionReport) {
                this.processVariables(this.q2, this.l2, ids, EZREPORTS_FIELD_EXPANSION_QUERY3, conn);
                this.closeTest();
                this.processVariables(this.q3, this.l3, ids, EZREPORTS_FIELD_EXPANSION_QUERY3, conn);
                this.closeTest();
            }
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingNonDirectDeps.processResources.subTask.name", new String[]{this.monitorPrefix}));
            this.processOthers(ids, conn);
            this.closeTest();
            sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingNonDirectDeps.processPrograms.subTask.name", new String[]{this.monitorPrefix}));
            this.processProgramsQ5(ids, conn);
            this.closeTest();
            this.processProgramsQ6(this.q2, this.l2, ids, conn);
            this.closeTest();
            this.processProgramsQ6(this.q3, this.l3, ids, conn);
            this.closeTest();
            this.processQ6_1(this.q2, this.l2, ids, conn);
            this.closeTest();
            this.processQ6_1(this.q3, this.l3, ids, conn);
            this.closeTest();
        }
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "findingNonDirectDeps.step3.subTask.name", new String[]{this.monitorPrefix}));
        this.nddaStep3(conn);
        this.closeTest();
        this.ltemp = this.recreatePersistentList(this.ltemp);
    }

    private void nddaStep3(EZSourceConnection conn) {
        L.debug("nddaStep3()");
        ArrayList<String> param = new ArrayList<String>();
        final HashMap<String, ArrayList<Entry>> origEntries = new HashMap<String, ArrayList<Entry>>();
        for (Entry e : this.ltemp) {
            this.closeTest();
            if (this.CALLED_PROGRAM.equals(e.getImpactType()) || this.CALLING_PROGRAM.equals(e.getImpactType())) {
                L.warn("nddaStep3; progid={}, impact={}", (Object)e.dbId, (Object)e.getImpactType());
            }
            param.add(e.dbId);
            ArrayList<Entry> duplicates = (ArrayList<Entry>)origEntries.get(e.dbId);
            if (duplicates == null) {
                duplicates = new ArrayList<Entry>();
                origEntries.put(e.dbId, duplicates);
            }
            duplicates.add(e);
        }
        if (param.size() > 0) {
            String query = "EZReports_FieldExpansion_Query8";
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleNddaStep3(origEntries, rez);
                }
            }, query, param, conn);
        }
    }

    private Entry getEntryWithID(String id, EntryListInterface list) {
        return this.getEntryWithID(id, list, true);
    }

    private Entry getEntryWithID(String id, EntryListInterface list, boolean getFirstFound) {
        return this.getEntryWithID(id, list, getFirstFound, false);
    }

    private Entry getEntryWithID(String id, EntryListInterface list, boolean getFirstFound, boolean isVariable) {
        Entry rez = null;
        Iterable<Entry> duplicates = list.getById(id);
        if (duplicates != null) {
            if (duplicates instanceof List) {
                if (!((List)duplicates).isEmpty()) {
                    rez = (Entry)((List)duplicates).get(0);
                }
            } else {
                Iterator<Entry> it = duplicates.iterator();
                if (it != null) {
                    Entry r = null;
                    boolean cont = it.hasNext();
                    while (cont) {
                        rez = it.next();
                        if (isVariable && (this.CALLED_PROGRAM.equals(rez.getImpactType()) || this.CALLING_PROGRAM.equals(rez.getImpactType())) || rez.isResource) {
                            cont = true;
                        } else {
                            r = r == null ? rez : (r.internalID < rez.internalID ? r : rez);
                            cont = !getFirstFound;
                        }
                        cont = cont && it.hasNext();
                        L.trace("{} continue={}", (Object)rez, (Object)cont);
                    }
                    rez = r;
                }
            }
        }
        return rez;
    }

    private Entry getEntryWithInternalID(int id, EntryListInterface list) {
        return list.getByInternalId(id);
    }

    private void newRedefineDA(IProgressMonitor monitor, EZSourceConnection conn) {
        L.debug("new redefineDA()");
        ArrayList<String> param = new ArrayList<String>();
        this.ltemp = this.recreatePersistentList(this.ltemp);
        this.ltemp.addAll(this.q3);
        this.q3.clear();
        L.debug("will run for {} variables", (Object)this.ltemp.size());
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.ltemp.size());
        sub.beginTask(null, this.ltemp.size());
        this.registerMonitor((IProgressMonitor)sub);
        param.clear();
        final HashMap<String, ArrayList<Entry>> origEntries = new HashMap<String, ArrayList<Entry>>();
        for (Entry e : this.ltemp) {
            this.closeTest();
            if (this.CALLED_PROGRAM.equals(e.getImpactType()) || this.CALLING_PROGRAM.equals(e.getImpactType())) {
                L.info("newRedefineDA; ignored program id={} as having impact={}", (Object)e.dbId, (Object)e.getImpactType());
                continue;
            }
            this.l3.add(e);
            if (e.getStringOffsetEnd() != null && e.getStringOffsetStart() != null && e.getIntOE() >= 0 && e.getIntOS() >= 0) {
                e.getIntOS();
                e.getIntOE();
            }
            param.add(e.dbId);
            ArrayList<Entry> duplicates = (ArrayList<Entry>)origEntries.get(e.dbId);
            if (duplicates == null) {
                duplicates = new ArrayList<Entry>();
                origEntries.put(e.dbId, duplicates);
            }
            duplicates.add(e);
        }
        if (param.size() > 0) {
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleRedefineDA(origEntries, rez);
                }
            }, "EZReports_FieldExpansion_Query9_NEW", param, conn);
        }
        this.unRegisterMonitor((IProgressMonitor)sub);
    }

    private EntryListInterface<Entry> recreatePersistentList(EntryListInterface<Entry> list) {
        if (list instanceof PersistentEntryList) {
            PersistentEntryList lst = (PersistentEntryList)((Object)list);
            int cacheSize = lst.getCacheSize();
            lst.commit();
            lst.dispose();
            lst = null;
            return new PersistentEntryList(cacheSize);
        }
        list = new EntryList();
        return list;
    }

    private boolean finished() {
        return this.q1.isEmpty() && this.q2.isEmpty() && this.q3.isEmpty();
    }

    private void partTwo(IProgressMonitor monitor, EZSourceConnection conn) {
        L.debug("partTwo( )");
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.beginTask(null, -1);
        this.registerMonitor((IProgressMonitor)sub);
        this.updateEntries(conn);
        this.closeTest();
        HashSet<String> param = new HashSet<String>();
        for (Entry e : this.l1) {
            this.closeTest();
            param.add(e.dbId);
        }
        for (Entry e : this.q2extra) {
            this.closeTest();
            param.add(e.dbId);
        }
        this.finalVariables = this.buildVariableList(param, conn);
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "processResources.subTask.name"));
        L.debug("processing resources");
        for (final String resType : this.resourceQueries.keySet()) {
            this.closeTest();
            String resQuery = this.resourceQueries.get(resType);
            if (resQuery == null) {
                L.error("resource type {} not covered!", (Object)resType);
            } else if (resQuery.length() != 0) {
                param.clear();
                EntryList ent = this.resourceMap.get(resType);
                if (ent != null) {
                    for (Entry e : ent) {
                        this.closeTest();
                        param.add(e.dbId);
                    }
                    this.queryHandler.runSP(new DataStepProcessor(){

                        @Override
                        public void dataStep(List<String[]> data) {
                            if (resType.equals("56") || resType.equals("62") || resType.equals("193")) {
                                FieldExpansionSearch.this.handleAdabasResources(data);
                            } else {
                                FieldExpansionSearch.this.resourceResults.put(resType, data);
                            }
                        }
                    }, resQuery, param, conn);
                }
            }
            if (this.fieldExpansionReport) continue;
            this.linkExtraDependencies(resType, conn, (IProgressMonitor)sub.newChild(10));
        }
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "processPrograms.subTask.name"));
        L.debug("processing programs");
        this.fillProgramsDetails(conn);
        sub.subTask(Messages.getString(FieldExpansionSearch.class, "processFinalVariables.subTask.name"));
        L.debug("processing final variables");
        this.sourcesList = new HashSet<Program>();
        for (Variable var : this.finalVariables) {
            this.closeTest();
            Program inp = new Program();
            inp.name = var.defSource;
            inp.path = var.defSource;
            inp.type = var.language;
            inp.isInclude = var.defSourceIsInclude;
            inp.startRow = String.valueOf(var.startRow);
            this.sourcesList.add(inp);
        }
        L.debug("processing resourceResults");
        block24: for (final String resType : this.resourceResults.keySet()) {
            this.closeTest();
            List<String[]> rez = this.resourceResults.get(resType);
            if (rez == null) {
                L.debug("no results");
                continue;
            }
            switch (resType) {
                case "77": {
                    Program inp;
                    for (String[] cols : rez) {
                        this.closeTest();
                        inp = new Program();
                        inp.name = String.valueOf(cols[4]) + "." + cols[1];
                        inp.path = cols[2];
                        inp.type = "TYPE_IDMS_RECORD";
                        inp.isResource = true;
                        inp.startRow = cols[3];
                        this.sourcesList.add(inp);
                    }
                    continue block24;
                }
                case "78": {
                    Program inp;
                    for (String[] cols : rez) {
                        this.closeTest();
                        inp = new Program();
                        inp.name = String.valueOf(cols[4]) + "." + cols[1];
                        inp.path = cols[2];
                        inp.type = "TYPE_IDMS_SET";
                        inp.isResource = true;
                        inp.startRow = cols[3];
                        this.sourcesList.add(inp);
                    }
                    continue block24;
                }
                default: {
                    Program inp;
                    for (String[] cols : rez) {
                        this.closeTest();
                        if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[2]) == null) continue;
                        inp = new Program();
                        inp.name = cols[1];
                        inp.path = cols[2];
                        inp.startRow = cols[3];
                        inp.type = this.getResourceTypeName(resType);
                        inp.isResource = true;
                        this.sourcesList.add(inp);
                    }
                    continue block24;
                }
                case "1": 
                case "9": 
                case "56": 
                case "62": 
                case "82": 
                case "189": 
                case "190": 
                case "193": 
                case "214": 
                case "1000": 
            }
        }
        this.unRegisterMonitor((IProgressMonitor)sub);
    }

    private List<Variable> buildVariableList(Set<String> param, EZSourceConnection conn) {
        final ArrayList<Variable> rez = new ArrayList<Variable>();
        this.closeTest();
        L.debug("buildVariableList: Q10_1");
        this.queryHandler.runSP(new DataStepProcessor(){

            @Override
            public void dataStep(List<String[]> data) {
                FieldExpansionSearch.this.addUnique(rez, data, true);
            }
        }, "EZReports_FieldExpansion_Query10_1", param, conn);
        this.closeTest();
        L.debug("buildVariableList: Q10_2");
        this.queryHandler.runSP(new DataStepProcessor(){

            @Override
            public void dataStep(List<String[]> data) {
                FieldExpansionSearch.this.addUnique(rez, data, false);
            }
        }, "EZReports_FieldExpansion_Query10_2", param, conn);
        this.closeTest();
        L.debug("buildVariableList: sorting variables");
        Collections.sort(rez, new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                int cmp = o1.defSource.compareToIgnoreCase(o2.defSource);
                if (cmp == 0) {
                    cmp = o1.startRow < o2.startRow ? -1 : (o1.startRow == o2.startRow ? 0 : 1);
                }
                return cmp;
            }
        });
        this.closeTest();
        return rez;
    }

    private void addUnique(List<Variable> rez, List<String[]> qrez, boolean isInclude) {
        if (qrez != null) {
            Variable pVar = null;
            for (String[] cols : qrez) {
                this.closeTest();
                Variable cVar = new Variable();
                Entry e = this.getEntryWithID(cols[0], this.entries);
                cVar.defSourceIsInclude = isInclude;
                cVar.language = e.language;
                cVar.id = cols[0];
                cVar.parentRecord = cols[1];
                cVar.varName = cols[2];
                cVar.defSource = cols[3];
                cVar.startRow = Integer.valueOf(cols[4]);
                boolean okToAdd = true;
                if (pVar != null) {
                    if (pVar.parentRecord == null) {
                        L.debug("parent null for pVar={}; id={}", (Object)pVar.varName, (Object)pVar.id);
                    }
                    if (cVar.parentRecord == null) {
                        L.debug("parent null for cVar={}; id={}", (Object)cVar.varName, (Object)cVar.id);
                    }
                }
                if (pVar != null && pVar.varName.equalsIgnoreCase(cVar.varName) && (pVar.parentRecord == null && cVar.parentRecord == null || pVar.parentRecord != null && pVar.parentRecord.equalsIgnoreCase(cVar.parentRecord)) && pVar.defSource.equalsIgnoreCase(cVar.defSource) && pVar.startRow == cVar.startRow) {
                    boolean bl = okToAdd = this.fieldExpansionReport ? false : isInclude;
                }
                if (!okToAdd) continue;
                if (!cols[2].startsWith("FILLER #")) {
                    Set<VarLinkInfo> varInfo = this.varsInPrograms.get(cols[5]);
                    if (varInfo == null) {
                        varInfo = new TreeSet<VarLinkInfo>();
                        this.varsInPrograms.put(cols[5], varInfo);
                    }
                    VarLinkInfo vli = new VarLinkInfo();
                    vli.vid = cols[0];
                    vli.vname = cols[2];
                    varInfo.add(vli);
                }
                rez.add(cVar);
                pVar = cVar;
            }
        }
    }

    private Map<Integer, List<String>> step1(ArrayList<String> param, EZSourceConnection conn) {
        L.debug("step1");
        final HashMap<Integer, List<String>> results = new HashMap<Integer, List<String>>();
        if (!param.isEmpty()) {
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    if (rez != null) {
                        for (String[] cols : rez) {
                            FieldExpansionSearch.this.closeTest();
                            if (cols[1].equals("4")) {
                                ArrayList<String> varIds = (ArrayList<String>)results.get(0);
                                if (varIds == null) {
                                    varIds = new ArrayList<String>();
                                    results.put(0, varIds);
                                }
                                if (FieldExpansionSearch.this.isExcludedID(cols[0])) continue;
                                varIds.add(cols[0]);
                                continue;
                            }
                            if (cols[1].equals("5")) {
                                ArrayList<String> progIds = (ArrayList<String>)results.get(1);
                                if (progIds == null) {
                                    progIds = new ArrayList<String>();
                                    results.put(1, progIds);
                                }
                                progIds.add(cols[0]);
                                continue;
                            }
                            ArrayList<String> otherIds = (ArrayList<String>)results.get(2);
                            if (otherIds == null) {
                                otherIds = new ArrayList<String>();
                                results.put(2, otherIds);
                            }
                            otherIds.add(cols[0]);
                        }
                    }
                }
            }, "EZReports_FieldExpansion_Query1", param, conn);
        }
        return results.isEmpty() ? null : results;
    }

    private void step0(final EntryListInterface opList, final EntryListInterface backOpList, ArrayList<String> param, final Map<String, List<Entry>> origEntries, EZSourceConnection conn) {
        L.debug("step0()");
        if (param != null && param.size() > 0) {
            L.debug("step0: processing {} params", (Object)param.size());
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleStep0(opList, backOpList, origEntries, rez);
                }
            }, EZREPORTS_FIELD_EXPANSION_Step0_IncludeHandling, param, conn);
        }
    }

    private int[] getIntersection(String currentStart, String currentEnd, Entry parent) {
        int pos = -1;
        int poe = -1;
        int cos = -1;
        int coe = -1;
        if (parent != null) {
            cos = Integer.parseInt(currentStart);
            coe = Integer.parseInt(currentEnd);
            if (parent.getStringOffsetStart() != null) {
                pos = Integer.parseInt(parent.getStringOffsetStart());
            }
            if (parent.getStringOffsetEnd() != null) {
                poe = Integer.parseInt(parent.getStringOffsetEnd());
            }
            if (pos != -1 && poe != -1) {
                if (coe < pos || cos > poe) {
                    coe = -1;
                    cos = -1;
                } else {
                    if (cos < pos) {
                        cos = pos;
                    }
                    if (coe > poe) {
                        coe = poe;
                    }
                }
            }
        }
        return new int[]{cos, coe};
    }

    private void ddaStep3(EZSourceConnection conn) {
        ArrayList<String> param = new ArrayList<String>();
        final HashMap<String, ArrayList<Entry>> origEntries = new HashMap<String, ArrayList<Entry>>();
        for (Entry e : this.ltemp) {
            this.closeTest();
            if (!this.CALLING_PROGRAM.equals(e.getImpactType())) {
                param.add(e.dbId);
                ArrayList<Entry> duplicates = (ArrayList<Entry>)origEntries.get(e.dbId);
                if (duplicates == null) {
                    duplicates = new ArrayList<Entry>();
                    origEntries.put(e.dbId, duplicates);
                }
                duplicates.add(e);
                continue;
            }
            L.info("calling prog found in dda; id={}", (Object)e.dbId);
        }
        L.debug("ddaStep3() processing {} params", (Object)param.size());
        if (param.size() > 0) {
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    FieldExpansionSearch.this.handleDdaStep3(origEntries, rez);
                }
            }, "EZReports_FieldExpansion_Query7", param, conn);
        }
    }

    public Holder searchResults() {
        int varNo;
        L.info("cycles={}", (Object)this.cycles);
        CSVImpactUtils.writeCsvHeader(this.csv, this.multiplePaths);
        Holder h = new Holder();
        VariableElement elem = new VariableElement("");
        h.setSummaryEl(elem);
        ArrayList<ObjectForSubreport3Link> summaryEntries = new ArrayList<ObjectForSubreport3Link>();
        VariableElement el = new VariableElement("");
        h.setDetailsEl(el);
        DetailsDataSource summaryDS = new DetailsDataSource(7);
        summaryDS.setList(summaryEntries);
        elem.addDataSource((SubreportDataSource)summaryDS);
        elem.setSummaryAdded(true);
        summaryDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "summarytotals.column1.title"));
        summaryDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "summarytotals.column2.title"));
        String titleAnchor = "Variable summary";
        ObjectForSubreport3Link objSumm = new ObjectForSubreport3Link();
        objSumm.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.variable.column1.text"));
        if (this.finalVariables == null) {
            this.finalVariables = new ArrayList<Variable>();
        }
        if ((varNo = this.finalVariables.size()) > 0) {
            objSumm.setLeftLink(titleAnchor);
            objSumm.setLeftAnchor(Boolean.valueOf(true));
        } else {
            L.debug("no variables in summary");
        }
        summaryEntries.add(objSumm);
        DetailsDataSource detailsDS = null;
        List<Object> detailsEntries = null;
        HashSet<String> finalVarIds = new HashSet<String>();
        ObjectForSubreport3Link obj = null;
        if (varNo > 0) {
            detailsEntries = new ArrayList();
            Collections.sort(this.finalVariables);
            L.trace("after sorting variables");
            for (Variable var2 : this.finalVariables) {
                this.closeTest();
                Entry entry = this.getEntryWithID(var2.id, this.l1, false, true);
                if (entry == null) {
                    L.debug("variable {} not found in L1 for summary", (Object)var2.varName);
                    entry = this.getEntryWithID(var2.id, this.q2extra);
                    if (entry == null) {
                        L.error("entry not found for {}", (Object)var2.id);
                        continue;
                    }
                }
                if (entry.getName() == null) {
                    Entry tempentry = this.l1.getByInternalId(entry.internalID);
                    if (tempentry != null) {
                        entry = tempentry;
                    } else {
                        L.debug("second try to find in l1 the entry {} was not succesful", (Object)var2.id);
                    }
                }
                if (entry.getName() != null) {
                    if (entry.getName().startsWith("FILLER #")) {
                        L.info("filler: {} filtered out", (Object)entry.getName());
                        continue;
                    }
                } else {
                    L.warn("entry name is null, consider variable's name for filtering");
                    if (var2.varName.startsWith("FILLER #")) {
                        L.info("var: {} filtered out", (Object)var2.varName);
                        continue;
                    }
                    L.warn("wrong in summary! entry={}", (Object)entry);
                }
                obj = new ObjectForSubreport3Link();
                if (entry.getBackID() != -1 || this.isStartedOnDBField() && this.variableMapp.keySet().contains(entry.dbId)) {
                    obj.setMiddleLink(var2.id);
                    obj.setMiddleAnchor(Boolean.valueOf(true));
                } else {
                    L.debug("input variable: {}", (Object)var2.id);
                }
                obj.setLeftValue(com.ez.mainframe.data.utils.Utils.filterNullValue((String)var2.parentRecord) == null ? "" : var2.parentRecord);
                obj.setMiddleValue(var2.varName);
                obj.setRightValue(Messages.getString(FieldExpansionSearch.class, "source.column.entry", new Object[]{var2.defSource, var2.startRow}));
                obj.setRightLink(String.valueOf(var2.defSource) + "," + var2.language + "," + var2.startRow);
                detailsEntries.add(obj);
                finalVarIds.add(var2.id);
            }
            objSumm.setMiddleValue(Integer.toString(finalVarIds.size()));
            if (this.programList.size() > 1) {
                detailsEntries = detailsEntries.stream().filter(Utils.distinctByKeys(var -> String.valueOf(var.getElGroup()) + var.getParent() + var.getHyperlink())).collect(Collectors.toList());
            }
            if (detailsEntries.isEmpty()) {
                objSumm.setLeftAnchor(Boolean.valueOf(false));
                objSumm.setLeftLink(null);
            } else {
                detailsDS = new DetailsDataSource(3);
                detailsDS.setList(detailsEntries);
                detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "variable.summary.page.title"));
                detailsDS.setTitleAnchor(titleAnchor);
                detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "variable.summary.page.TOCentry"));
                elem.addDataSource((SubreportDataSource)detailsDS);
                detailsDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "variable.summary.column1.title"));
                detailsDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "variable.summary.column2.title"));
                detailsDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "variable.summary.column3.title"));
                this.closeTest();
            }
        }
        if (this.programList.size() > 0) {
            titleAnchor = "programs summary";
            obj = new ObjectForSubreport3Link();
            obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.programs.column1.text"));
            obj.setLeftLink(titleAnchor);
            obj.setLeftAnchor(Boolean.valueOf(true));
            obj.setMiddleValue(Integer.toString(this.programList.size()));
            summaryEntries.add(obj);
            detailsEntries = new ArrayList();
            detailsDS = new DetailsDataSource(4);
            detailsDS.setList(detailsEntries);
            detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "summary.programs.page.title"));
            detailsDS.setTitleAnchor(titleAnchor);
            detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "summary.programs.page.TOCentry"));
            elem.addDataSource((SubreportDataSource)detailsDS);
            detailsDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "programs.summary.column1.text"));
            detailsDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "programs.summary.column2.text"));
            this.closeTest();
            Collections.sort(this.programList);
            L.trace("after sorting programs");
            for (Program p : this.programList) {
                this.closeTest();
                if (p.path == null) {
                    p.path = NOT_AVAILABLE;
                }
                obj = new ObjectForSubreport3Link();
                obj.setLeftValue(p.name);
                boolean hasDetails = this.addProgramDetails(el, p, finalVarIds);
                if (hasDetails) {
                    obj.setLeftLink("program_" + p.id);
                    obj.setLeftAnchor(Boolean.valueOf(true));
                }
                obj.setMiddleValue(p.path);
                if (!p.path.equals(NOT_AVAILABLE)) {
                    obj.setMiddleLink(String.valueOf(p.path) + ", " + p.type);
                }
                detailsEntries.add(obj);
            }
        }
        finalVarIds.clear();
        finalVarIds = null;
        for (String resType : this.orderedTypes) {
            this.closeTest();
            List<String[]> rez = this.resourceResults.get(resType);
            if (rez == null || rez.size() <= 0) continue;
            String resTypeName = this.getResourceTypeName(resType);
            titleAnchor = String.valueOf(resTypeName) + " summary";
            obj = new ObjectForSubreport3Link();
            obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.resource.column1.text", new String[]{resTypeName}));
            obj.setLeftLink(titleAnchor);
            obj.setLeftAnchor(Boolean.valueOf(true));
            obj.setMiddleValue(Integer.toString(rez.size()));
            summaryEntries.add(obj);
            detailsEntries = new ArrayList();
            detailsDS = new DetailsDataSource(4);
            detailsDS.setList(detailsEntries);
            detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "summary.resource.page.title", new String[]{resTypeName}));
            detailsDS.setTitleAnchor(titleAnchor);
            detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "summary.resource.page.TOCentry", new String[]{resTypeName}));
            elem.addDataSource((SubreportDataSource)detailsDS);
            detailsDS.setCol1Title(resTypeName);
            String col2Title = Messages.getString(FieldExpansionSearch.class, "resources.summary.column2.text");
            boolean isDataset = false;
            if (resType.equalsIgnoreCase(EXT_TYPE_DATASET)) {
                EntryList all = this.resourceMap.get(resType);
                if (all != null) {
                    String type = this.getResourceTypeName(resType);
                    for (String[] cols : rez) {
                        this.closeTest();
                        Entry entry = this.getEntryWithInternalID(Integer.parseInt(cols[0]), all);
                        if (entry == null) continue;
                        entry.setName(String.valueOf(cols[1]) + "(" + type + ")");
                        if (entry.getProgramName() == null) {
                            entry.setProgramName(cols[1]);
                        }
                        if (entry.programPath == null) {
                            entry.programPath = cols[2];
                        }
                        if (entry.startRow == null) {
                            entry.startRow = cols[3];
                        }
                        this.update(entry);
                    }
                }
                detailsDS.setCol3Title(col2Title);
                isDataset = true;
            } else {
                detailsDS.setCol2Title(col2Title);
            }
            for (String[] cols : rez) {
                this.closeTest();
                obj = new ObjectForSubreport3Link();
                if (resType.equals("56")) {
                    cols[1] = AdabasUtils.getListableName((String)cols[1], (String)cols[4]);
                }
                String resName = ReportsUtils.stripNonValidXMLCharacters((String)cols[1], (boolean)true);
                obj.setLeftValue(resName);
                boolean hasDetails = this.addResourceDetails(el, resType, cols);
                if (hasDetails) {
                    obj.setLeftLink(String.valueOf(resTypeName) + cols[0]);
                    obj.leftTooltip = Messages.getString(FieldExpansionSearch.class, "resource.summary.details.tooltip", new String[]{ReportsUtils.prepareTooltip((String)cols[1])});
                    obj.setLeftAnchor(Boolean.valueOf(true));
                }
                if (isDataset) {
                    obj.setRightValue(NOT_AVAILABLE);
                } else if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[3]) != null && !cols[3].trim().equals("") || com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[2]) != null && !cols[2].trim().equals("")) {
                    String line = cols[3];
                    String source = Messages.getString(FieldExpansionSearch.class, "source.column.entry", new Object[]{cols[2], line});
                    obj.setMiddleValue(source);
                    String language = null;
                    if (resType.equals("1") && cols.length > 4) {
                        language = cols[4];
                    }
                    if (language == null) {
                        language = this.findProgramLanguageByPath(cols[2]);
                    }
                    String link = String.valueOf(cols[2]) + "," + (language == null ? this.getResourceTypeName(resType) : language) + "," + line;
                    obj.setMiddleLink(link);
                } else {
                    obj.setMiddleValue(NOT_AVAILABLE);
                }
                detailsEntries.add(obj);
            }
        }
        this.programList.clear();
        this.resourceResults.clear();
        if (this.extraDependencySummary != null && !this.extraDependencySummary.isEmpty()) {
            for (String extraDepName : this.extraDependencySummary.keySet()) {
                this.closeTest();
                Set<String> content = this.extraDependencySummary.get(extraDepName);
                titleAnchor = String.valueOf(extraDepName) + " summary";
                obj = new ObjectForSubreport3Link();
                obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "extraDep.sources.column1.text", new String[]{extraDepName}));
                obj.setLeftLink(titleAnchor);
                obj.setLeftAnchor(Boolean.valueOf(true));
                obj.setMiddleValue(Integer.toString(content.size()));
                summaryEntries.add(obj);
                detailsEntries = new ArrayList();
                detailsDS = new DetailsDataSource(3);
                detailsDS.setList(detailsEntries);
                detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "extraDep.summary.page.title", new String[]{extraDepName}));
                detailsDS.setTitleAnchor(titleAnchor);
                detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "extraDep.summary.page.TOCentry", new String[]{extraDepName}));
                elem.addDataSource((SubreportDataSource)detailsDS);
                detailsDS.setCol1Title(null);
                detailsDS.setCol2Title(null);
                detailsDS.setCol3Title(null);
                int step = 0;
                ArrayList<String> lst = new ArrayList<String>(content);
                Collections.sort(lst);
                for (String res : lst) {
                    switch (step) {
                        case 0: {
                            obj = new ObjectForSubreport3Link();
                            detailsEntries.add(obj);
                            obj.setLeftValue(res);
                            ++step;
                            break;
                        }
                        case 1: {
                            obj.setMiddleValue(res);
                            ++step;
                            break;
                        }
                        case 2: {
                            obj.setRightValue(res);
                            step = 0;
                            break;
                        }
                    }
                }
            }
            this.extraDependencySummary.clear();
            this.extraDependencySummary = null;
        }
        if (this.sourcesList != null && this.sourcesList.size() > 0) {
            titleAnchor = "sources summary";
            obj = new ObjectForSubreport3Link();
            obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "summary.sources.column1.text"));
            obj.setLeftLink(titleAnchor);
            obj.setLeftAnchor(Boolean.valueOf(true));
            obj.setMiddleValue(Integer.toString(this.sourcesList.size()));
            summaryEntries.add(obj);
            detailsEntries = new ArrayList();
            detailsDS = new DetailsDataSource(4);
            detailsDS.setList(detailsEntries);
            detailsDS.setTitle(Messages.getString(FieldExpansionSearch.class, "summary.sources.section.title"));
            detailsDS.setTitleAnchor(titleAnchor);
            detailsDS.setTocEntry(Messages.getString(FieldExpansionSearch.class, "summary.sources.page.TOCentry"));
            elem.addDataSource((SubreportDataSource)detailsDS);
            detailsDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "sources.summary.column1.text"));
            detailsDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "sources.summary.column2.text"));
            ArrayList<Program> lstSourcesList = new ArrayList<Program>(this.sourcesList);
            Collections.sort(lstSourcesList);
            L.trace("after sorting sources");
            this.closeTest();
            for (Program s : lstSourcesList) {
                this.closeTest();
                obj = new ObjectForSubreport3Link();
                obj.setLeftValue(s.name);
                obj.setLeftLink(String.valueOf(s.path) + ", " + s.type);
                String type = s.type;
                obj.setRightValue(String.valueOf(type) + (s.isInclude ? " " + Utils.RESOURCE_TYPE_INCLUDE : ""));
                detailsEntries.add(obj);
            }
            lstSourcesList.clear();
        }
        this.printQueues("build summary objects for report");
        this.putDetails(el);
        this.printQueues("after build detailed objects for report");
        this.finalVariables.clear();
        this.printQueues("before end");
        this.closePersistentFiles(true);
        return h;
    }

    private void closePersistentFiles(boolean all) {
        if (this.q1 != null && !this.q1.isClosed()) {
            this.q1.close();
        }
        if (this.q2 != null && !this.q2.isClosed()) {
            this.q2.close();
        }
        if (this.l2 != null && !this.l2.isClosed()) {
            this.l2.close();
        }
        if (this.l3 != null && !this.l3.isClosed()) {
            this.l3.close();
        }
        if (this.ltemp != null && !this.ltemp.isClosed()) {
            this.ltemp.close();
        }
        if (all) {
            if (this.entries != null && !this.entries.isClosed()) {
                this.entries.close();
            }
            if (this.l1 != null && !this.l1.isClosed()) {
                this.l1.close();
            }
            if (this.q2extra != null && !this.q2extra.isClosed()) {
                this.q2extra.close();
            }
        }
    }

    private String findProgramLanguageByPath(String prgPath) {
        String language = null;
        for (Program p : this.programList) {
            if (language != null) continue;
            this.closeTest();
            if (p.path == null) {
                p.path = NOT_AVAILABLE;
            }
            if (!p.path.equalsIgnoreCase(prgPath)) continue;
            language = p.type;
            L.trace("path found, use the language of program: {}", (Object)p.name);
        }
        if (language == null && this.sourcesList != null) {
            Iterator<Program> it = this.sourcesList.iterator();
            while (it.hasNext() && language == null) {
                Program p = it.next();
                this.closeTest();
                if (!prgPath.equalsIgnoreCase(p.path) || !p.isInclude) continue;
                language = p.type;
                L.trace("path found, use the language of include: {}", (Object)p.name);
            }
        }
        return language;
    }

    private boolean addProgramDetails(VariableElement el, Program p, Set<String> finalVarIds) {
        boolean considerPrg;
        Entry entry = null;
        VarDetails vd = null;
        if (p.backID != -1) {
            entry = this.getEntryWithInternalID(p.backID, this.entries);
        } else {
            entry = this.getEntryWithID(p.varID, this.entries);
            if (entry != null) {
                vd = new VarDetails();
                vd.to = Messages.getString(FieldExpansionSearch.class, "program.column.entry", new String[]{p.name});
                vd.from = entry.getName();
                vd.programName = entry.getProgramName();
                if (USE_SHARED_INCLUDE.equals(p.stmtType)) {
                    vd.impactType = this.SHARED_INCLUDE;
                    vd.toLink = entry.programPath;
                    vd.toLine = entry.startRow;
                    vd.toLanguage = entry.language;
                } else {
                    vd.impactType = p.stmtType;
                    vd.toLink = p.stmtPath == null ? p.path : String.valueOf(p.stmtPath) + "," + entry.language + "," + p.startRow;
                }
            }
        }
        boolean isStart = false;
        List<VarDetails> details = null;
        if (entry != null && (details = this.getVarDetails(entry, true)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                VarDetails v1 = details.get(i);
                if (v1.programName == null) {
                    continue;
                }
                isStart = v1.programName.equalsIgnoreCase(p.name);
                break;
            }
        }
        boolean bl = considerPrg = details != null && !details.isEmpty();
        if (this.fieldExpansionReport) {
            considerPrg = considerPrg && !isStart;
        } else if (this.multiplePaths) {
            considerPrg = true;
        }
        boolean hasDetails = false;
        if (considerPrg) {
            String[] stringArray;
            DetailsDataSource elemDS = new DetailsDataSource(6);
            String tocEntry = Messages.getString(FieldExpansionSearch.class, "details.program.tocEntry", new String[]{p.name});
            String textToPrint = Messages.getString(FieldExpansionSearch.class, "details.program.entry", new String[]{p.name});
            String detailsTitle = FieldExpansionSearch.getTitle4DetailsSection(textToPrint);
            elemDS.setList(new ArrayList());
            elemDS.setTitle(detailsTitle);
            elemDS.setTitleAnchor("program_" + p.id);
            elemDS.setTocEntry(tocEntry);
            if (isStart || entry == null) {
                elemDS.setCol1Title(null);
                elemDS.setCol2Title(null);
                elemDS.setCol3Title(null);
                details = new ArrayList<VarDetails>();
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue("");
                elemDS.getList().add(obj);
            } else {
                elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
                elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
                elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
            }
            if (vd != null) {
                details.add(vd);
            }
            Entry backEntry = null;
            if (entry != null && this.isStartedOnDBField()) {
                int backId = entry.getBackID();
                while (backId > -1) {
                    backEntry = this.getEntryWithInternalID(backId, this.entries);
                    backId = backEntry.getBackID();
                }
            }
            if (entry == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[4];
                stringArray2[0] = entry.getProgramName();
                stringArray2[1] = p.name;
                stringArray2[2] = Utils.RESOURCE_TYPE_PROGRAM;
                stringArray = stringArray2;
                stringArray2[3] = p.type;
            }
            String[] csvDetails = stringArray;
            boolean hasVarPaths = this.addVarDetails(el, details, elemDS, null, null, null, false, true, backEntry, csvDetails);
            if (this.multiplePaths) {
                PathPrinter pp = new PathPrinter();
                pp.setCSVWriter(this.csv);
                boolean hasPaths = pp.printProgramPaths(this.direction, p.id, p.name, this.programCalls, elemDS);
                VariablePrinter vp = new VariablePrinter();
                vp.setCSVWriter(this.csv);
                HashSet<String> cpy = new HashSet<String>(this.inputVarIds);
                if (this.isStartedOnDBField()) {
                    for (String variD : this.variableMapp.keySet()) {
                        cpy.remove(variD);
                    }
                }
                boolean hasvariables = vp.printVariableList(p.id, p.name, this.varsInPrograms, cpy, elemDS);
                LinkagePrinter lp = new LinkagePrinter();
                lp.setCSVWriter(this.csv);
                boolean hasCalls = lp.printLinkage(p.id, p.name, this.programCalls, finalVarIds, elemDS);
                hasDetails = hasPaths || hasvariables || hasCalls || hasVarPaths;
            } else {
                hasDetails = hasVarPaths;
            }
            if (!hasDetails) {
                L.info("prg without details: {}", (Object)p.name);
            } else {
                el.addDataSource((SubreportDataSource)elemDS);
            }
        } else {
            L.info("not considered prg: {}", (Object)p.name);
        }
        return hasDetails;
    }

    private boolean addResourceDetails(VariableElement el, String resType, String[] cols) {
        EntryList all = this.resourceMap.get(resType);
        boolean hasDetails = false;
        if (all != null) {
            Entry entry = null;
            entry = !resType.equalsIgnoreCase(EXT_TYPE_DATASET) ? this.getEntryWithID(cols[0], all) : this.getEntryWithInternalID(Integer.parseInt(cols[0]), all);
            String cfr_ignored_0 = entry.progID;
            entry.getProgramName();
            if (entry != null) {
                String type = this.getResourceTypeName(resType);
                if (!resType.equalsIgnoreCase(EXT_TYPE_DATASET)) {
                    entry.setName(String.valueOf(cols[1]) + "(" + type + ")");
                    if (entry.getProgramName() == null) {
                        entry.setProgramName(cols[1]);
                    }
                    if (entry.programPath == null) {
                        entry.programPath = cols[2];
                    }
                    if (entry.startRow == null) {
                        entry.startRow = cols[3];
                    }
                    if (resType.equals("9")) {
                        this.update(entry);
                    }
                }
                String resName = ReportsUtils.stripNonValidXMLCharacters((String)cols[1], (boolean)true);
                String tocEntry = Messages.getString(FieldExpansionSearch.class, "details.resource.tocEntry", new String[]{type, resName});
                String resType4Details = Messages.getString(FieldExpansionSearch.class, "resourceType.detailsName." + resType);
                String nameToPrint = Messages.getString(FieldExpansionSearch.class, "details.resource.tocEntry", new String[]{resType4Details, resName});
                DetailsDataSource elemDS = new DetailsDataSource(6);
                ArrayList objList = new ArrayList();
                elemDS.setList(objList);
                elemDS.setTitle(FieldExpansionSearch.getTitle4DetailsSection(nameToPrint));
                elemDS.setTitleAnchor(String.valueOf(type) + cols[0]);
                elemDS.setTitleTooltip(ReportsUtils.prepareTooltip((String)(String.valueOf(type) + " " + cols[1])));
                elemDS.setTocEntry(tocEntry);
                elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
                elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
                elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
                el.addDataSource((SubreportDataSource)elemDS);
                Entry backEntry = null;
                if (this.isStartedOnDBField()) {
                    int backId = entry.getBackID();
                    while (backId > -1) {
                        backEntry = this.getEntryWithInternalID(backId, this.entries);
                        backId = backEntry.getBackID();
                    }
                }
                List<VarDetails> details = this.getVarDetails(entry);
                String[] stringArray = new String[4];
                stringArray[0] = entry.getProgramName();
                stringArray[1] = cols[1];
                stringArray[2] = type;
                hasDetails = this.addVarDetails(el, details, elemDS, null, null, null, false, false, backEntry, stringArray);
                boolean hasPaths = false;
                if (this.multiplePaths) {
                    Set<String> usageInPrograms;
                    Map<String, Set<String>> usageByType = this.resourceUsage.get(resType);
                    PathPrinter pp = new PathPrinter();
                    pp.setCSVWriter(this.csv);
                    if (usageByType != null && (usageInPrograms = usageByType.get(entry.dbId)) != null && !usageInPrograms.isEmpty()) {
                        hasPaths = pp.printResource(this.direction, this.programCalls, elemDS, cols[1], resType4Details, usageInPrograms);
                    }
                }
                hasDetails = hasDetails || hasPaths;
            }
        }
        return hasDetails;
    }

    private boolean addVarDetails(VariableElement el, List<VarDetails> details, DetailsDataSource elemDS, String textInDetails, String tocEntry, String titleAnchor, boolean addLinks, boolean hasSubtitle, Entry backEntry, String[] csvDetails) {
        String detailsTitle;
        boolean hasDetails = false;
        String string = detailsTitle = elemDS != null ? elemDS.getTitle() : FieldExpansionSearch.getTitle4DetailsSection(textInDetails);
        if (details.size() == 0) {
            L.debug("could not found relations for {}", (Object)tocEntry);
            if (elemDS == null) {
                elemDS = new DetailsDataSource(6);
                ArrayList objList = new ArrayList();
                elemDS.setList(objList);
                elemDS.setTitle(detailsTitle);
                elemDS.setTitleAnchor(titleAnchor);
                elemDS.setTocEntry(tocEntry);
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(Messages.getString(FieldExpansionSearch.class, "noDataAvailable.text"));
                elemDS.getList().add(obj);
            }
        } else {
            String fieldName;
            ArrayList<ObjectForSubreport3Link> objList;
            if (elemDS == null) {
                elemDS = new DetailsDataSource(6);
                objList = new ArrayList<ObjectForSubreport3Link>();
                elemDS.setList(objList);
                elemDS.setTitle(detailsTitle);
                elemDS.setTitleAnchor(titleAnchor);
                elemDS.setTocEntry(tocEntry);
                elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
                elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
                elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
            }
            objList = (ArrayList<ObjectForSubreport3Link>)elemDS.getList();
            if (this.isStartedOnDBField() && (fieldName = this.getDBFieldName()) != null) {
                this.addFieldVarEntry(fieldName, details.get((int)0).from, details, backEntry);
            }
            String startProgram = null;
            boolean isFirst = true;
            for (VarDetails vd : details) {
                this.closeTest();
                if (startProgram == null) {
                    startProgram = vd.programName;
                }
                ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                obj.setLeftValue(ReportsUtils.stripNonValidXMLCharacters((String)vd.from, (boolean)true));
                if (addLinks && vd.fromLink != null) {
                    obj.setLeftLink(String.valueOf(vd.fromLink) + "," + vd.fromLanguage + "," + vd.fromLine);
                }
                obj.setMiddleValue(ReportsUtils.stripNonValidXMLCharacters((String)vd.to, (boolean)true));
                if (addLinks && vd.toLink != null) {
                    obj.setMiddleLink(String.valueOf(vd.toLink) + "," + vd.toLanguage + "," + vd.toLine);
                }
                obj.setRightValue(ReportsUtils.stripNonValidXMLCharacters((String)vd.impactType, (boolean)true));
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)vd.toLink) != null) {
                    String language = vd.toLanguage;
                    if (language == null || language.isEmpty()) {
                        language = this.findProgramLanguageByPath(vd.toLink);
                    }
                    obj.setRightLink(String.valueOf(vd.toLink) + "," + language + "," + vd.toLine);
                }
                objList.add(obj);
                if (csvDetails != null) {
                    this.csv.write(new String[]{CSVImpactUtils.CSV_IMPACT_VAR_DETAIL, startProgram, csvDetails[1], String.valueOf(csvDetails[2]) + (csvDetails[3] == null ? "" : " (" + csvDetails[3] + ")"), vd.from, vd.to, vd.impactType});
                }
                if (!isFirst || !hasSubtitle) continue;
                String subTitle = Messages.getString(FieldExpansionSearch.class, "details.startProgram.section.title", new String[]{vd.programName});
                elemDS.setSubTitle(subTitle);
                isFirst = false;
            }
            hasDetails = true;
        }
        return hasDetails;
    }

    private void addFieldVarEntry(String fieldName, String varName, List<VarDetails> details, Entry backEntry) {
        VarDetails fake = new VarDetails();
        fake.from = fieldName;
        fake.to = varName;
        if (backEntry != null) {
            String[] dets = this.variableMapp.get(backEntry.dbId);
            if (dets == null) {
                fake.impactType = SQL_FIELD_MAPPING_LABEL;
            } else {
                fake.impactType = dets[2];
                fake.toLine = dets[3];
                fake.toLink = dets[4];
                fake.toLanguage = dets[5];
                fake.programName = backEntry.getProgramName();
            }
        } else {
            fake.impactType = SQL_FIELD_MAPPING_LABEL;
        }
        details.add(0, fake);
    }

    public static String getTitle4DetailsSection(String impactedTarget) {
        return Messages.getString(FieldExpansionSearch.class, "details.section.title", new String[]{impactedTarget, ""});
    }

    private void fillProgramsDetails(EZSourceConnection conn) {
        HashSet<String> param = new HashSet<String>();
        HashSet<String> paramIncl = new HashSet<String>();
        for (Program program : this.programList) {
            this.closeTest();
            if (!program.isInclude) {
                param.add(program.id);
                continue;
            }
            paramIncl.add(program.id);
        }
        if (!param.isEmpty()) {
            this.queryHandler.runSP(new InputDetailsProcessor(false), EZREPORTS_FIELD_EXPANSION_FillProgramDetails, param, conn);
        }
        if (!paramIncl.isEmpty()) {
            this.queryHandler.runSP(new InputDetailsProcessor(true), EZREPORTS_FIELD_EXPANSION_FillIncludeDetails, paramIncl, conn);
        }
    }

    private String getResourceTypeName(String resType) {
        return Messages.getString(FieldExpansionSearch.class, "resourceType." + resType);
    }

    private VariableElement putDetails(VariableElement el) {
        String fieldName = this.getDBFieldName();
        for (Variable var : this.finalVariables) {
            this.closeTest();
            boolean isVarDirectImpacted = true;
            Entry entry = this.getEntryWithID(var.id, this.l1, false, true);
            L.debug("variable {} not found in L1", (Object)var.varName);
            if (entry == null) {
                isVarDirectImpacted = false;
                entry = this.getEntryWithID(var.id, this.q2extra);
                if (entry == null) {
                    L.debug("variable {} not found in q2extra either", (Object)var.varName);
                    continue;
                }
            }
            if (entry.getName() == null) {
                Entry tempentry = this.l1.getByInternalId(entry.internalID);
                if (tempentry != null) {
                    entry = tempentry;
                } else {
                    L.debug("second try to find in l1 entry {} was not succesful", (Object)var.id);
                }
            }
            if (entry.getName() != null) {
                if (entry.getName().startsWith("FILLER #")) {
                    continue;
                }
            } else {
                L.warn("entry name is null at building report's details; filter out by variable name");
                if (var.varName.startsWith("FILLER #")) {
                    L.info("var: {} filtered out", (Object)var.varName);
                    continue;
                }
                L.warn("wrong in details! entry={}", (Object)entry);
            }
            Iterable<Entry> iterableEntries = isVarDirectImpacted ? this.l1.getById(var.id) : this.q2extra.getById(var.id);
            Map<Entry, List<VarDetails>> entriesDetails = this.getAllVarDetails(iterableEntries);
            boolean varPrinted = false;
            for (Entry entry2 : entriesDetails.keySet()) {
                List<VarDetails> details = entriesDetails.get(entry2);
                DetailsDataSource elemDS = null;
                if (details.size() == 0) {
                    L.debug("could not found relations for {}", (Object)var.varName);
                    continue;
                }
                if (fieldName != null) {
                    boolean added = false;
                    if (details.size() == 1 && this.variableMapp.keySet().contains(entry.dbId)) {
                        added = true;
                    }
                    if (!added) {
                        int backId = entry.getBackID();
                        Entry found = null;
                        while (backId > -1) {
                            found = this.getEntryWithInternalID(backId, this.entries);
                            backId = found.getBackID();
                        }
                        this.addFieldVarEntry(fieldName, details.get((int)0).from, details, found);
                    }
                }
                elemDS = new DetailsDataSource(6);
                ArrayList<ObjectForSubreport3Link> objList = new ArrayList<ObjectForSubreport3Link>();
                elemDS.setList(objList);
                String varNameToPrint = String.valueOf(com.ez.mainframe.data.utils.Utils.filterNullValue((String)var.parentRecord) == null ? "" : String.valueOf(var.parentRecord) + ".") + var.varName;
                if (!varPrinted) {
                    String varType = Messages.getString(FieldExpansionSearch.class, "variable.details.type");
                    String detailsTitle = Messages.getString(FieldExpansionSearch.class, "details.section.title", new String[]{varType, varNameToPrint});
                    String subTitle = Messages.getString(FieldExpansionSearch.class, "details.path.section.title", new String[]{var.defSource, String.valueOf(var.startRow)});
                    String subTitle2 = Messages.getString(FieldExpansionSearch.class, "details.contextProgram.section.title", new String[]{entry.getProgramName()});
                    elemDS.setSubTitle(subTitle);
                    elemDS.setSubTitle2(subTitle2);
                    elemDS.setSubtitleLink(String.valueOf(var.defSource) + "," + var.language + "," + var.startRow);
                    elemDS.setTitle(detailsTitle);
                    elemDS.setTitleAnchor(var.id);
                    elemDS.setTocEntry(varNameToPrint);
                    varPrinted = true;
                }
                elemDS.setCol1Title(Messages.getString(FieldExpansionSearch.class, "details.section.column1.text"));
                elemDS.setCol2Title(Messages.getString(FieldExpansionSearch.class, "details.section.column2.text"));
                elemDS.setCol3Title(Messages.getString(FieldExpansionSearch.class, "details.section.column3.text"));
                for (VarDetails vd : details) {
                    this.closeTest();
                    ObjectForSubreport3Link obj = new ObjectForSubreport3Link();
                    obj.setLeftValue(vd.from);
                    obj.setMiddleValue(vd.to);
                    obj.setRightValue(vd.impactType);
                    if (vd.toLink != null) {
                        String language = vd.toLanguage;
                        if (language == null || language.isEmpty()) {
                            language = this.findProgramLanguageByPath(vd.toLink);
                        }
                        obj.setRightLink(String.valueOf(vd.toLink) + "," + language + "," + vd.toLine);
                    }
                    objList.add(obj);
                    if (this.csv == null) continue;
                    this.csv.write(new String[]{CSVImpactUtils.CSV_IMPACT_VAR_DETAIL, entry.getProgramName(), varNameToPrint, Messages.getString(FieldExpansionSearch.class, "csv.variable.details"), vd.from, vd.to, vd.impactType});
                }
                el.addDataSource((SubreportDataSource)elemDS);
            }
        }
        return el;
    }

    private Map<Entry, List<VarDetails>> getAllVarDetails(Iterable<Entry> iterableEntries) {
        HashMap<Entry, List<VarDetails>> detailsPerEntry = new HashMap<Entry, List<VarDetails>>();
        if (iterableEntries.iterator().hasNext()) {
            ArrayList<Entry> collection = new ArrayList<Entry>();
            Iterator<Entry> it = iterableEntries.iterator();
            while (it.hasNext()) {
                collection.add(it.next());
            }
            TreeSet<Entry> uniqueEntries = new TreeSet<Entry>(new Comparator<Entry>(){

                @Override
                public int compare(Entry o1, Entry o2) {
                    if (o1.getIntOS() == o2.getIntOS() && o1.getIntOE() == o2.getIntOE()) {
                        return 0;
                    }
                    if (o1.getIntOS() == 0 && o1.getIntOE() == 0 && o2.getIntOS() == 1 && o2.getIntOE() == o2.varSize) {
                        return 0;
                    }
                    if (o2.getIntOS() == 0 && o2.getIntOE() == 0 && o1.getIntOS() == 1 && o1.getIntOE() == o1.varSize) {
                        return 0;
                    }
                    return 1;
                }
            });
            uniqueEntries.addAll(collection);
            for (Entry entry1 : uniqueEntries) {
                List<VarDetails> details = this.getVarDetails(entry1);
                if (details.isEmpty()) continue;
                detailsPerEntry.put(entry1, details);
            }
        }
        return detailsPerEntry;
    }

    protected String getDBFieldName() {
        SelectSingleFromListPage.ArrayListItem it;
        String fieldName = null;
        if (this.isStartedOnDBField() && (it = (SelectSingleFromListPage.ArrayListItem)this.report.getProperty("selectedFieldID")) != null) {
            fieldName = it.getStringArray()[0];
        }
        return fieldName;
    }

    private void updateEntries(EZSourceConnection conn) {
        HashSet<String> varParam = new HashSet<String>();
        HashSet<String> prgParam = new HashSet<String>();
        ArrayList<Entry> called = new ArrayList<Entry>();
        for (Entry e : this.entries) {
            this.closeTest();
            if (this.CALLED_PROGRAM.equals(e.getImpactType()) || this.CALLING_PROGRAM.equals(e.getImpactType())) {
                prgParam.add(e.dbId);
                called.add(e);
                continue;
            }
            varParam.add(e.dbId);
        }
        if (!prgParam.isEmpty()) {
            L.debug("updateEntries; details for programs");
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    if (rez != null) {
                        for (String[] cols : rez) {
                            FieldExpansionSearch.this.closeTest();
                            Iterable<Entry> duplicates = FieldExpansionSearch.this.entries.getById(cols[0]);
                            if (duplicates == null || duplicates.iterator() == null || !duplicates.iterator().hasNext()) continue;
                            ArrayList<Entry> updateList = new ArrayList<Entry>();
                            for (Entry e : duplicates) {
                                if (!FieldExpansionSearch.this.CALLED_PROGRAM.equals(e.getImpactType()) && !FieldExpansionSearch.this.CALLING_PROGRAM.equals(e.getImpactType()) || e.isResource) continue;
                                boolean needsUpdate = false;
                                if (e.programPath == null) {
                                    e.programPath = cols[2];
                                    needsUpdate = true;
                                }
                                if (e.language == null) {
                                    e.language = cols[3];
                                    needsUpdate = true;
                                }
                                if (!needsUpdate) continue;
                                updateList.add(e);
                            }
                            for (Entry e : updateList) {
                                FieldExpansionSearch.this.update(e);
                            }
                        }
                    }
                }
            }, EZREPORTS_FIELD_EXPANSION_UpdateEntries_1, prgParam, conn);
        }
        if (!varParam.isEmpty()) {
            L.debug("updateEntries; details for variables");
            this.queryHandler.runSP(new DataStepProcessor(){

                @Override
                public void dataStep(List<String[]> rez) {
                    if (rez != null) {
                        for (String[] cols : rez) {
                            FieldExpansionSearch.this.closeTest();
                            Iterable<Entry> duplicates = FieldExpansionSearch.this.entries.getById(cols[0]);
                            if (duplicates == null || duplicates.iterator() == null || !duplicates.iterator().hasNext()) continue;
                            ArrayList<Entry> updateList = new ArrayList<Entry>();
                            for (Entry e : duplicates) {
                                if (FieldExpansionSearch.this.CALLED_PROGRAM.equals(e.getImpactType()) || FieldExpansionSearch.this.CALLING_PROGRAM.equals(e.getImpactType())) continue;
                                if (e.isResource) {
                                    L.debug("{} is not updated as being resource and not variable", (Object)e);
                                    continue;
                                }
                                if (e.getName() == null) {
                                    e.setName(cols[1]);
                                }
                                String string = e.parent = com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[7]) == null ? "" : cols[7].trim();
                                if (e.getProgramName() == null) {
                                    e.setProgramName(cols[6]);
                                }
                                if (e.programPath == null) {
                                    e.programPath = cols[4];
                                }
                                if (e.language == null) {
                                    e.language = cols[5];
                                }
                                if (e.startRow == null) {
                                    e.startRow = cols[3];
                                }
                                if (e.progID == null) {
                                    e.progID = cols[8];
                                }
                                updateList.add(e);
                            }
                            for (Entry e : updateList) {
                                FieldExpansionSearch.this.update(e);
                            }
                        }
                    }
                }
            }, EZREPORTS_FIELD_EXPANSION_UpdateEntries_2, varParam, conn);
        }
        for (Entry e : called) {
            Entry back;
            this.closeTest();
            if (e.isResource || e.language != null || (back = this.getEntryWithInternalID(e.getBackID(), this.entries)) == null) continue;
            e.language = back.language;
        }
    }

    private void update(Entry e) {
        Iterable<Entry> tmp;
        L.trace("start update entry: {}", (Object)e);
        this.entries.update(e);
        Entry cpyEntry = this.l1.getByInternalId(e.internalID);
        if (cpyEntry != null) {
            L.trace("try to update l1");
            this.l1.update(e);
        } else {
            tmp = this.l1.getById(e.dbId);
            if (tmp != null && tmp.iterator() != null && tmp.iterator().hasNext()) {
                L.trace("second try to update l1");
                this.l1.update(e);
            }
        }
        cpyEntry = this.q2extra.getByInternalId(e.internalID);
        if (cpyEntry != null) {
            L.trace("try to update q2Extra");
            this.q2extra.update(e);
        } else {
            tmp = this.q2extra.getById(e.dbId);
            if (tmp != null && tmp.iterator() != null && tmp.iterator().hasNext()) {
                L.trace("second try to update q2Extra");
                this.q2extra.update(e);
            }
        }
        L.trace("end update entry: {}", (Object)e);
    }

    private List<VarDetails> getVarDetails(Entry entry) {
        return this.getVarDetails(entry, false);
    }

    private List<VarDetails> getVarDetails(Entry entry, boolean isProgram) {
        String fieldName;
        L.info("getVarDetails for entry={}", (Object)entry);
        ArrayList<VarDetails> rez = new ArrayList<VarDetails>();
        HashMap visitedDBIds = new HashMap();
        int back = entry.getBackID();
        int idx = -1;
        if (this.isStartedOnDBField() && back == -1 && this.variableMapp.keySet().contains(entry.dbId) && (fieldName = this.getDBFieldName()) != null) {
            this.addFieldVarEntry(fieldName, entry.getName(), rez, entry);
        }
        while (back != -1) {
            this.closeTest();
            Entry found = this.getEntryWithInternalID(back, this.entries);
            if (found == null) {
                L.error("cound not find entry with internal id {}", (Object)back);
                break;
            }
            if (found.getBackID() == found.internalID) {
                L.error("cycle");
                break;
            }
            ++idx;
            if (!(entry.isResource || this.CALLING_PROGRAM.equals(entry.getImpactType()) || this.CALLED_PROGRAM.equals(entry.getImpactType()))) {
                List<Integer> posList;
                String visitedKey = String.valueOf(entry.dbId) + ":" + entry.getStringOffsetStart() + "," + entry.getStringOffsetEnd();
                if (visitedDBIds.containsKey(visitedKey)) {
                    posList = (List)visitedDBIds.get(visitedKey);
                    posList.add(idx);
                } else {
                    posList = new ArrayList();
                    posList.add(idx);
                    visitedDBIds.put(visitedKey, posList);
                }
            }
            VarDetails vd = new VarDetails();
            Object toName = "";
            boolean toIsProgram = false;
            boolean fromIsProgram = false;
            String impactType = null;
            String fromName = "";
            if (this.SHARED_INCLUDE.equals(entry.getImpactType())) {
                toName = String.valueOf(entry.getName()) + " (" + entry.impactName + ")";
                impactType = entry.getImpactType();
            } else if (this.PROGRAM_ARGUMENT.equals(entry.getImpactType()) || this.DEFINITION_PROGRAM.equals(entry.getImpactType()) || this.CALLED_PROGRAM.equals(entry.getImpactType()) || this.CALLING_PROGRAM.equals(entry.getImpactType())) {
                if (this.PROGRAM_ARGUMENT.equals(entry.getImpactType())) {
                    toName = entry.getName();
                    if (entry.isLinkage()) {
                        toName = Messages.getString(FieldExpansionSearch.class, "linkagesect.column.entry", new String[]{toName});
                    }
                } else if (entry.isResource) {
                    toName = entry.impactName;
                } else {
                    toName = Messages.getString(FieldExpansionSearch.class, "program.column.entry", new String[]{entry.impactName});
                    toIsProgram = true;
                }
                impactType = entry.getImpactType();
            } else {
                if (entry.parent != null && !entry.parent.trim().equals("")) {
                    toName = String.valueOf(entry.parent) + ".";
                }
                if (entry.getName() == null) {
                    Entry tempentry = this.l1.getByInternalId(entry.internalID);
                    if (tempentry == null) {
                        L.debug("second try: entry {} not found in L1", (Object)entry.internalID);
                        tempentry = this.q2extra.getByInternalId(entry.internalID);
                    }
                    if (tempentry == null) {
                        L.debug("second try: entry {} not found in q2extra either", (Object)entry.internalID);
                    } else {
                        entry = tempentry;
                    }
                }
                toName = String.valueOf(toName) + (entry.getName() == null ? entry.dbId : entry.getName());
                if (entry.isLinkage()) {
                    toName = Messages.getString(FieldExpansionSearch.class, "linkagesect.column.entry", new String[]{toName});
                }
                impactType = this.STATEMENT_TYPE.equals(entry.getImpactType()) ? entry.impactName : (this.CALL_PARAMETER.equals(entry.getImpactType()) ? entry.getImpactType() : (entry.impactName == null ? entry.getImpactType() : String.valueOf(entry.impactName) + "." + entry.getImpactType()));
            }
            if (this.SHARED_INCLUDE.equals(found.getImpactType())) {
                fromName = String.valueOf(found.getName()) + " (" + found.impactName + ")";
            } else if (this.PROGRAM_ARGUMENT.equals(found.getImpactType()) || this.DEFINITION_PROGRAM.equals(found.getImpactType()) || this.CALLED_PROGRAM.equals(found.getImpactType()) || this.CALLING_PROGRAM.equals(found.getImpactType())) {
                if (this.PROGRAM_ARGUMENT.equals(found.getImpactType())) {
                    fromName = found.getName();
                    if (found.isLinkage()) {
                        fromName = Messages.getString(FieldExpansionSearch.class, "linkagesect.column.entry", new String[]{fromName});
                    }
                } else {
                    fromName = Messages.getString(FieldExpansionSearch.class, "program.column.entry", new String[]{found.impactName});
                    fromIsProgram = true;
                }
            } else {
                if (found.parent != null && !found.parent.trim().equals("")) {
                    fromName = String.valueOf(found.parent) + ".";
                }
                fromName = String.valueOf(fromName) + (found.getName() == null ? found.dbId : found.getName());
                if (found.isLinkage()) {
                    fromName = Messages.getString(FieldExpansionSearch.class, "linkagesect.column.entry", new String[]{fromName});
                }
            }
            if (!toIsProgram && entry.getIntOS() + entry.getIntOE() != 0) {
                if (entry.getIntOS() == 1 && entry.varSize == entry.getIntOS() + entry.getIntOE() - 1) {
                    L.debug("do not print offsets for toName={} ({} -> {} = {})", new Object[]{toName, toName, fromName, impactType});
                } else {
                    toName = String.valueOf(toName) + "(" + entry.getIntOS() + ", " + entry.getIntOE() + ")";
                }
            }
            if (!fromIsProgram && found.getIntOS() + found.getIntOE() != 0) {
                if (found.getIntOS() == 1 && found.varSize == found.getIntOS() + found.getIntOE() - 1) {
                    L.debug("do not print offsets for fromName={} ({} -> {} = {})", new Object[]{fromName, toName, fromName, impactType});
                } else {
                    fromName = String.valueOf(fromName) + "(" + found.getIntOS() + ", " + found.getIntOE() + ")";
                }
            }
            vd.to = toName;
            vd.from = fromName;
            vd.impactType = impactType;
            vd.fromLink = found.programPath;
            vd.fromLanguage = found.language;
            vd.fromLine = found.startRow;
            vd.toLink = entry.programPath;
            vd.toLanguage = entry.language;
            vd.toLine = entry.startRow;
            vd.programName = this.CALLED_PROGRAM.equals(entry.getImpactType()) ? found.getProgramName() : entry.getProgramName();
            rez.add(0, vd);
            entry = found;
            back = entry.getBackID();
            if (back != -1 || isProgram) continue;
            vd.from = String.valueOf(vd.from) + " (" + entry.getProgramName() + ")";
        }
        L.debug("visitedDbid={}", visitedDBIds);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (String visitedKey : visitedDBIds.keySet()) {
            List posList = (List)visitedDBIds.get(visitedKey);
            if (posList.size() <= 1) continue;
            Integer firstIdx = (Integer)posList.get(0);
            Integer lastIdx = (Integer)posList.get(posList.size() - 1);
            if (lastIdx > firstIdx + 1) {
                Pair p = new Pair((Object)firstIdx, (Object)lastIdx);
                pairs.add(p);
                L.debug("{}={}", (Object)visitedKey, (Object)p);
                continue;
            }
            L.info("{} had indexes: {} which are not filtered, as guessing being a definition_program and his linkage variable", (Object)visitedKey, (Object)posList);
        }
        ArrayList<Pair> filtered = new ArrayList<Pair>();
        for (Pair p : pairs) {
            boolean processed = false;
            for (Pair f : filtered) {
                if ((Integer)f.getFirst() >= (Integer)p.getFirst() && (Integer)f.getSecond() <= (Integer)p.getSecond()) {
                    f.setFirst((Object)((Integer)p.getFirst() - 1));
                    f.setSecond((Object)((Integer)p.getSecond()));
                    processed = true;
                    continue;
                }
                if ((Integer)f.getFirst() < (Integer)p.getFirst() && (Integer)f.getSecond() > (Integer)p.getSecond()) {
                    f.setFirst((Object)((Integer)f.getFirst() - 1));
                    processed = true;
                    continue;
                }
                if ((Integer)f.getSecond() < (Integer)p.getFirst() || (Integer)f.getFirst() > (Integer)p.getSecond()) {
                    p.setFirst((Object)((Integer)p.getFirst() - 1));
                    continue;
                }
                L.warn("pairs overlap: {} -- {}, both it will be filtered", (Object)f, (Object)p);
            }
            if (processed) continue;
            if (filtered.isEmpty() && pairs.size() == 1) {
                p.setFirst((Object)((Integer)p.getFirst() - 1));
            }
            filtered.add(p);
        }
        L.debug("filtered={}", filtered);
        ArrayList<VarDetails> filteredRez = new ArrayList<VarDetails>();
        int i = rez.size() - 1;
        for (VarDetails vd : rez) {
            boolean skip = false;
            L.debug("{}:{} ->> {}", new Object[]{i, vd.from, vd.to});
            for (Pair p : filtered) {
                L.debug("p={}, {}", p.getFirst(), p.getSecond());
                if ((Integer)p.getFirst() >= i || (Integer)p.getSecond() <= i) continue;
                L.info("{}->{} will be skipped; p={}, i={}", new Object[]{vd.from, vd.to, p, i});
                skip = true;
                break;
            }
            if (!skip) {
                filteredRez.add(vd);
            }
            --i;
        }
        return filteredRez;
    }

    public int getNewID() {
        return this.idProvider.newID();
    }

    public boolean isContinued() {
        return this.continued;
    }

    public int getCycles() {
        return this.cycles + 1;
    }

    public void disposeResources() {
        if (this.entries != null) {
            this.entries.dispose();
        }
        if (this.l1 != null) {
            this.l1.dispose();
        }
        if (this.l2 != null) {
            this.l2.dispose();
        }
        if (this.l3 != null) {
            this.l3.dispose();
        }
        if (this.ltemp != null) {
            this.ltemp.dispose();
        }
        if (this.q1 != null) {
            this.q1.dispose();
        }
        if (this.q2 != null) {
            this.q2.dispose();
        }
        if (this.q2extra != null) {
            this.q2extra.dispose();
        }
        if (this.q3 != null) {
            this.q3.clear();
            this.q3 = null;
        }
        if (this.programParameterList != null) {
            this.programParameterList.clear();
            this.programParameterList = null;
        }
        if (this.resourceMap != null) {
            this.resourceMap.clear();
            this.resourceMap = null;
        }
        if (this.resourceResults != null) {
            this.resourceResults.clear();
            this.resourceResults = null;
        }
        if (this.programList != null) {
            this.programList.clear();
            this.programList = null;
        }
        if (this.sourcesList != null) {
            this.sourcesList.clear();
            this.sourcesList = null;
        }
        if (this.finalVariables != null) {
            this.finalVariables.clear();
            this.finalVariables = null;
        }
        if (this.extraDependencySummary != null) {
            this.extraDependencySummary.clear();
            this.extraDependencySummary = null;
        }
        if (this.varsInPrograms != null) {
            this.varsInPrograms.clear();
            this.varsInPrograms = null;
        }
        if (this.variableMapp != null) {
            this.variableMapp.clear();
            this.variableMapp = null;
        }
        if (this.inputVarIds != null) {
            this.inputVarIds.clear();
            this.inputVarIds = null;
        }
    }

    public void setCSVWriter(CSVWriter csvFw) {
        this.csv = csvFw;
    }

    private void linkExtraDependencies(String resType, EZSourceConnection conn, IProgressMonitor pmonitor) {
        EntryList entryList;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        IExtraDependencyProvider edp = this.extraDependencyProviders.get(resType);
        if (edp != null && (entryList = this.resourceMap.get(resType)) != null) {
            if (this.direction == null) {
                this.direction = Direction.BOTH.ordinal();
            }
            Integer dsLimit = (Integer)this.report.getProperty("datasetflow threshold");
            Pair<EntryList, List<String[]>> results = edp.search(entryList, this.resourceUsage, this.excludedDS, this.direction, dsLimit, this.idProvider, conn, (IProgressMonitor)monitor.newChild(10));
            if (results != null && !monitor.isCanceled()) {
                Map<String, Set<String>> edpSumm;
                String newType = edp.getType();
                EntryList el = this.resourceMap.get(newType);
                if (el == null) {
                    this.resourceMap.put(newType, (EntryList)results.getFirst());
                } else {
                    el.addAll((EntryListInterface)results.getFirst());
                }
                List<String[]> r = this.resourceResults.get(newType);
                if (r == null) {
                    r = new ArrayList<String[]>();
                    this.resourceResults.put(newType, r);
                }
                r.addAll((Collection)results.getSecond());
                if (!this.orderedTypes.contains(newType)) {
                    this.orderedTypes.add(newType);
                }
                if ((edpSumm = edp.getSummary()) != null) {
                    for (String resName : edpSumm.keySet()) {
                        Set<String> cont = this.extraDependencySummary.get(resName);
                        if (cont == null) {
                            cont = new HashSet<String>();
                            this.extraDependencySummary.put(resName, cont);
                        }
                        cont.addAll((Collection<String>)edpSumm.get(resName));
                    }
                }
            } else {
                L.info("report was canceled. partial results are available, ask user if report should be generated with partial results");
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FieldExpansionSearch.this.continued = MessageDialog.openQuestion(null, (String)Messages.getString(FieldExpansionSearch.class, "canceledDialog.title"), (String)Messages.getString(FieldExpansionSearch.class, "canceledDialog.message"));
                    }
                });
                if (!this.continued) {
                    L.info("report generation is canceled when trying to bring extra-dependencies");
                    throw new CanceledException(Messages.getString(FieldExpansionSearch.class, "reportCanceled.extraDependencies.exception"));
                }
                L.info("user chose to continue report with partial results. Cancel is not available anymore.");
            }
        }
    }

    private void handleRedefineDA(Map<String, List<Entry>> origEntries, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                String varSize = cols[7];
                List<Entry> dupEntries = origEntries.get(cols[0]);
                for (Entry oe : dupEntries) {
                    int coe;
                    int cos;
                    int[] range;
                    String inpSOS = oe.getStringOffsetStart();
                    String inpSOE = oe.getStringOffsetEnd();
                    int inpOffsetStart = oe.getIntOS();
                    int inpOffsetEnd = oe.getIntOE();
                    int retOffsetStart = Integer.parseInt(cols[3]);
                    int retOffsetEnd = Integer.parseInt(cols[4]);
                    boolean type1ToQ1 = false;
                    boolean type3Or4ToQ1 = false;
                    int newStart = inpSOS == null ? retOffsetStart : inpOffsetStart + retOffsetStart - 1;
                    int newEnd = inpSOE == null ? retOffsetEnd : inpOffsetStart + retOffsetStart + inpOffsetEnd - inpOffsetStart - 1;
                    String newStartS = "" + newStart;
                    String newEndS = "" + newEnd;
                    String dependencyTypeId = cols[5];
                    if (dependencyTypeId.equals("4") && !this.fieldExpansionReport) continue;
                    if (dependencyTypeId.equals("1")) {
                        if (retOffsetStart > inpOffsetEnd || retOffsetEnd < inpOffsetStart) continue;
                        if (retOffsetStart >= inpOffsetStart && retOffsetEnd <= inpOffsetEnd) {
                            type1ToQ1 = true;
                        }
                    }
                    if (dependencyTypeId.equals("3") && retOffsetStart >= inpOffsetStart && retOffsetEnd <= inpOffsetEnd) {
                        type3Or4ToQ1 = true;
                    }
                    if ((dependencyTypeId.equals("1") && type1ToQ1 || dependencyTypeId.equals("3") && type3Or4ToQ1 || dependencyTypeId.equals("4") && type3Or4ToQ1 || dependencyTypeId.equals("7") || dependencyTypeId.equals("8")) && !this.isExcludedID(cols[1]) && !FieldExpansionUtils.isIDIn(cols[1], this.l1, this.closeRunnable) && !FieldExpansionUtils.isIDIn(cols[1], this.q1, this.closeRunnable)) {
                        newStartS = null;
                        newEndS = null;
                        if (dependencyTypeId.equals("1")) {
                            range = this.getIntersection(cols[3], cols[4], oe);
                            cos = range[0];
                            coe = range[1];
                            if (cos != -1 && coe != -1) {
                                cos = cos - Integer.parseInt(cols[3]) + 1;
                                coe = cos + (coe - range[0]);
                                newStartS = "" + cos;
                                newEndS = "" + coe;
                            }
                        } else {
                            newStartS = inpSOS;
                            newEndS = inpSOE;
                        }
                        if (newStartS != null && newEndS != null) {
                            Entry inp = Entry.instantiate(this.idProvider, cols[1]);
                            inp.setImpactType(cols[2]);
                            inp.setBackID(oe.internalID);
                            inp.varSize = Integer.valueOf(varSize);
                            inp.setOffsetStart(newStartS);
                            inp.setOffsetEnd(newEndS);
                            Entry.register(this.idProvider, inp);
                            this.q1.add(inp);
                        }
                    }
                    if (dependencyTypeId.equals("2") || dependencyTypeId.equals("1") && !type1ToQ1 || dependencyTypeId.equals("3") && !type3Or4ToQ1 || dependencyTypeId.equals("4") && !type3Or4ToQ1) {
                        if (dependencyTypeId.equals("1") && !type1ToQ1 || dependencyTypeId.equals("3") && !type3Or4ToQ1 || dependencyTypeId.equals("4") && !type3Or4ToQ1) {
                            if (dependencyTypeId.equals("1")) {
                                range = this.getIntersection(cols[3], cols[4], oe);
                                cos = range[0];
                                coe = range[1];
                                if (cos == -1 || coe == -1) continue;
                                cos = cos - Integer.parseInt(cols[3]) + 1;
                                coe = cos + (coe - range[0]);
                                newStartS = "" + cos;
                                newEndS = "" + coe;
                            } else {
                                if (inpOffsetStart == 0 && inpOffsetEnd == 0) {
                                    newStart = retOffsetStart;
                                    newEnd = retOffsetEnd;
                                } else {
                                    newStart = Math.max(inpOffsetStart, retOffsetStart);
                                    newEnd = Math.min(inpOffsetEnd, retOffsetEnd);
                                }
                                newStartS = "" + newStart;
                                newEndS = "" + newEnd;
                            }
                        }
                        if (dependencyTypeId.equals("2") && oe.getStringOffsetEnd() != null && oe.getStringOffsetStart() != null) {
                            int lenght = oe.getIntOE() - oe.getIntOS();
                            int st = Integer.parseInt(cols[3]) + oe.getIntOS() - 1;
                            int end = st + lenght;
                            newStartS = "" + st;
                            newEndS = "" + end;
                        }
                        if (!(this.isExcludedID(cols[1]) || FieldExpansionUtils.isIDOffsetIn(cols[1], newStartS, newEndS, this.l2, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[1], newStartS, newEndS, this.q2, this.closeRunnable))) {
                            Entry inp = Entry.instantiate(this.idProvider, cols[1]);
                            inp.setImpactType(cols[2]);
                            inp.setBackID(oe.internalID);
                            inp.setOffsetStart(newStartS);
                            inp.setOffsetEnd(newEndS);
                            inp.varSize = Integer.valueOf(varSize);
                            Entry.register(this.idProvider, inp);
                            this.q2.add(inp);
                            if (dependencyTypeId.equals("1") && !type1ToQ1 || dependencyTypeId.equals("3") && !type3Or4ToQ1) {
                                this.q2extra.add(inp);
                            }
                        }
                    }
                    if (!dependencyTypeId.equals("3") && !dependencyTypeId.equals("4") || this.isExcludedID(cols[1]) || FieldExpansionUtils.isIDOffsetIn(cols[1], newStartS, newEndS, this.l3, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[1], newStartS, newEndS, this.q3, this.closeRunnable)) continue;
                    Entry inp = Entry.instantiate(this.idProvider, cols[1]);
                    inp.setImpactType(cols[2]);
                    inp.setBackID(oe.internalID);
                    inp.setOffsetStart(newStartS);
                    inp.setOffsetEnd(newEndS);
                    inp.varSize = Integer.valueOf(varSize);
                    Entry.register(this.idProvider, inp);
                    this.q3.add(inp);
                }
            }
        }
    }

    private void handleProcessVariables(EntryListInterface opList, EntryListInterface backOpList, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                boolean existInOp;
                boolean useOffsets;
                this.closeTest();
                String original = cols[0];
                String dependant = cols[1];
                if (original.equals(dependant)) continue;
                String origSize = cols[7];
                String depSize = cols[8];
                if (origSize == null || origSize.equalsIgnoreCase("null")) {
                    L.warn("varSize null for original varid={}", (Object)original);
                    origSize = "-1";
                }
                if (depSize == null || depSize.equalsIgnoreCase("null")) {
                    L.warn("varSize null for dependent varid={}", (Object)dependant);
                    depSize = "-1";
                }
                boolean bl = useOffsets = cols.length >= 12 && (cols[12] != null || cols[11] != null);
                boolean ignoreOffsets = this.isNumeric(cols[9]) && this.isNumeric(cols[10]) ? !useOffsets : false;
                boolean justAdded = false;
                Entry inp = null;
                Entry parent = this.getEntryWithID(original, this.ltemp);
                boolean considerDependent = true;
                int pSt = 0;
                int pEnd = 0;
                int dSt = 0;
                int dEnd = 0;
                if (parent == null || parent.getStringOffsetStart() == null || parent.getStringOffsetEnd() == null) {
                    pSt = 1;
                    pEnd = Integer.parseInt(origSize);
                } else {
                    pSt = parent.getIntOS();
                    pEnd = parent.getIntOE();
                }
                int depSizeAsInt = Integer.parseInt(depSize);
                if (useOffsets) {
                    boolean isForward = this.direction == 1;
                    int[] destination = this.computeDestination(pSt, pEnd, cols, isForward);
                    if (destination == null) continue;
                    dSt = destination[0];
                    dEnd = destination[1];
                } else if (pEnd - pSt >= depSizeAsInt) {
                    if (pSt > depSizeAsInt) {
                        considerDependent = false;
                    } else {
                        dSt = Math.max(pSt, 1);
                        dEnd = Math.min(pEnd, depSizeAsInt);
                    }
                } else {
                    dSt = pSt;
                    dEnd = pEnd;
                }
                if (!considerDependent) continue;
                boolean existInBackOp = FieldExpansionUtils.isIDIn(dependant, backOpList, this.closeRunnable);
                if (!this.isExcludedID(dependant) && (!existInBackOp || existInBackOp && useOffsets) && (!(existInOp = FieldExpansionUtils.isIDIn(dependant, opList, this.closeRunnable)) || existInOp && useOffsets)) {
                    inp = Entry.instantiate(this.idProvider, dependant);
                    inp.setImpactType(this.STATEMENT_TYPE);
                    inp.impactName = cols[2];
                    inp.setBackID(parent.internalID);
                    inp.setProgramName(cols[3]);
                    inp.programPath = cols[4];
                    inp.startRow = cols[5];
                    if (!ignoreOffsets) {
                        inp.setOffsetStart("" + dSt);
                        inp.setOffsetEnd("" + dEnd);
                    }
                    inp.varSize = Integer.valueOf(depSize);
                    Entry.register(this.idProvider, inp);
                    opList.add(inp);
                    justAdded = true;
                }
                if (!cols[6].equals("-1") || this.isExcludedID(dependant) || FieldExpansionUtils.isIDIn(dependant, this.l2, this.closeRunnable)) continue;
                if (justAdded && opList.equals(this.q2)) {
                    this.q2extra.add(inp);
                    continue;
                }
                if (FieldExpansionUtils.isIDIn(dependant, this.q2, this.closeRunnable)) continue;
                inp = Entry.instantiate(this.idProvider, dependant);
                inp.setImpactType(this.STATEMENT_TYPE);
                inp.impactName = cols[2];
                if (!ignoreOffsets) {
                    inp.setOffsetStart("" + dSt);
                    inp.setOffsetEnd("" + dEnd);
                }
                inp.setBackID(parent.internalID);
                inp.setProgramName(cols[3]);
                inp.programPath = cols[4];
                inp.startRow = cols[5];
                inp.varSize = Integer.valueOf(depSize);
                Entry.register(this.idProvider, inp);
                this.q2.add(inp);
                this.q2extra.add(inp);
            }
        }
    }

    protected int[] computeDestination(int pSt, int pEnd, String[] cols, boolean isForward) {
        Integer depLenght;
        int dSt = 0;
        int dEnd = 0;
        int depSizeAsInt = Integer.parseInt(cols[8]);
        Integer origLenght = cols[13] != null ? Integer.valueOf(Integer.parseInt(cols[13])) : null;
        Integer dOffset = cols[12] != null ? Integer.valueOf(Integer.parseInt(cols[12])) : null;
        Integer origOffset = cols[11] != null ? Integer.valueOf(Integer.parseInt(cols[11])) : null;
        Integer n = depLenght = cols[14] != null ? Integer.valueOf(Integer.parseInt(cols[14])) : null;
        if (origOffset != null) {
            if (pSt + pEnd <= origOffset || origOffset + origLenght <= pSt) {
                L.debug("out of range, different intervals");
                return null;
            }
            pSt = Math.max(pSt, origOffset);
            pEnd = isForward ? pEnd - origOffset + 1 : pEnd;
            int n2 = pEnd = origLenght != null ? Math.min(pEnd, origLenght) : pEnd;
        }
        if (dOffset != null) {
            if (dOffset > depSizeAsInt) {
                L.debug("out of range for dependent");
                return null;
            }
            int n3 = depSizeAsInt = depLenght != null ? Math.min(depLenght, depSizeAsInt) : depSizeAsInt;
        }
        if (pEnd - pSt >= depSizeAsInt) {
            if (pSt > depSizeAsInt && isForward) {
                L.debug("dependent is not impacted");
                return null;
            }
            dSt = dOffset != null ? Math.max(1, dOffset) : 1;
            dEnd = Math.min(pEnd, depSizeAsInt);
        } else {
            dSt = dOffset != null ? Math.max(dOffset, 1) : 1;
            dEnd = pEnd;
        }
        return new int[]{dSt, dEnd};
    }

    private boolean isNumeric(String varType) {
        boolean ret = this.numericVarTypes.contains(varType);
        return ret;
    }

    private void updateVars(String[] cols, Iterable<Entry> duplicates, boolean updateDefProg) {
        if (duplicates == null || duplicates.iterator() == null || !duplicates.iterator().hasNext()) {
            return;
        }
        for (Entry e : duplicates) {
            if (this.CALLED_PROGRAM.equals(e.getImpactType()) || this.CALLING_PROGRAM.equals(e.getImpactType()) || !updateDefProg && this.DEFINITION_PROGRAM.equals(e.getImpactType())) continue;
            if (e.isResource) {
                L.debug("{} is not updated as being resource and not variable", (Object)e);
                continue;
            }
            if (e.getName() == null) {
                e.setName(cols[1]);
            }
            String string = e.parent = com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[7]) == null ? "" : cols[7].trim();
            if (e.getProgramName() == null) {
                e.setProgramName(cols[6]);
            }
            if (e.programPath == null) {
                e.programPath = cols[4];
            }
            if (e.language == null) {
                e.language = cols[5];
            }
            if (e.startRow == null) {
                e.startRow = cols[3];
            }
            this.update(e);
        }
    }

    private void handleQ6(EntryListInterface<Entry> opList, EntryListInterface<Entry> backOpList, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                List<Entry> vps = FieldExpansionUtils.getEntriesWithID(cols[0], this.ltemp);
                for (Entry vp : vps) {
                    Entry inp;
                    Entry parent = this.getProcessedCall(cols[9], cols[5], cols[2], vp.getStringOffsetStart(), vp.getStringOffsetEnd());
                    if (parent == null) {
                        inp = Entry.instantiate(this.idProvider, cols[2]);
                        inp.setImpactType(this.CALLED_PROGRAM);
                        inp.impactName = cols[3];
                        parent = vp;
                        if (parent != null) {
                            inp.setBackID(parent.internalID);
                            if (parent.getStringOffsetStart() != null) {
                                inp.setOffsetStart(parent.getStringOffsetStart());
                            }
                            if (parent.getStringOffsetEnd() != null) {
                                inp.setOffsetEnd(parent.getStringOffsetEnd());
                            }
                        }
                        inp.programPath = cols[6];
                        inp.startRow = cols[7];
                        inp.ordinalPos = cols[5];
                        inp.setProgramName(cols[3]);
                        Entry.register(this.idProvider, inp);
                        this.updateProgramWithCallStatement(inp.internalID, cols[2]);
                        this.markProcessedCall(inp, cols[9], cols[5], cols[2], vp.getStringOffsetStart(), vp.getStringOffsetEnd());
                        parent = inp;
                    }
                    if (this.multiplePaths) {
                        if (this.direction == 1) {
                            this.addProgramCall(cols[9], cols[10], cols[2], cols[3], "->", cols[0], cols[11], cols[4], cols[12], parent.getStringOffsetStart(), parent.getStringOffsetEnd());
                        } else if (!this.onSamePath(vp, cols[9], cols[2])) {
                            this.addProgramCall(cols[2], cols[3], cols[9], cols[10], "<-", cols[4], cols[12], cols[0], cols[11], parent.getStringOffsetStart(), parent.getStringOffsetEnd());
                        }
                    }
                    if (parent == null || this.isExcludedID(cols[4]) || FieldExpansionUtils.isIDOffsetIn(cols[4], parent.getStringOffsetStart(), parent.getStringOffsetEnd(), backOpList, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[4], parent.getStringOffsetStart(), parent.getStringOffsetEnd(), opList, this.closeRunnable)) continue;
                    inp = Entry.instantiate(this.idProvider, cols[4]);
                    inp.setImpactType(this.PROGRAM_ARGUMENT);
                    inp.impactName = cols[3];
                    inp.setIsLinkage(true);
                    inp.setBackID(parent.internalID);
                    if (parent.getStringOffsetStart() != null) {
                        inp.setOffsetStart(parent.getStringOffsetStart());
                    }
                    if (parent.getStringOffsetEnd() != null) {
                        inp.setOffsetEnd(parent.getStringOffsetEnd());
                    }
                    inp.varSize = Integer.valueOf(cols[8]);
                    inp.setProgramName(cols[3]);
                    Entry.register(this.idProvider, inp);
                    opList.add(inp);
                }
            }
        }
    }

    private void handleQ6_1(EntryListInterface<Entry> opList, EntryListInterface<Entry> backOpList, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                List<Entry> vps = FieldExpansionUtils.getEntriesWithID(cols[0], this.ltemp);
                for (Entry vp : vps) {
                    Comparable<Entry> inp;
                    Comparable<Entry> parent = this.getProcessedCall(cols[9], cols[5], cols[2], vp.getStringOffsetStart(), vp.getStringOffsetEnd());
                    if (parent == null) {
                        parent = vp;
                        if (!this.fieldExpansionReport && this.onAForwardCallChain((Entry)parent)) {
                            if (!L.isTraceEnabled()) continue;
                            L.trace("will not continue backward because of forward chain {}", Arrays.asList(cols));
                            continue;
                        }
                        inp = Entry.instantiate(this.idProvider, cols[0]);
                        ((Entry)inp).setImpactType(this.DEFINITION_PROGRAM);
                        ((Entry)inp).impactName = cols[3];
                        ((Entry)parent).setIsLinkage(true);
                        ((Entry)inp).setBackID(((Entry)parent).internalID);
                        if (((Entry)parent).getStringOffsetStart() != null) {
                            ((Entry)inp).setOffsetStart(((Entry)parent).getStringOffsetStart());
                        }
                        if (((Entry)parent).getStringOffsetEnd() != null) {
                            ((Entry)inp).setOffsetEnd(((Entry)parent).getStringOffsetEnd());
                        }
                        ((Entry)inp).ordinalPos = cols[1];
                        ((Entry)inp).setProgramName(cols[3]);
                        ((Entry)inp).varSize = Integer.valueOf(cols[9]);
                        Entry.register(this.idProvider, inp);
                        this.updateProgramWithCallStatement(((Entry)inp).internalID, cols[2]);
                        this.markProcessedCall((Entry)inp, cols[2], cols[1], cols[5], ((Entry)parent).getStringOffsetStart(), ((Entry)parent).getStringOffsetEnd());
                        parent = inp;
                    }
                    if (this.multiplePaths) {
                        if (this.direction == 1) {
                            this.addProgramCall(cols[2], cols[3], cols[5], cols[6], "<-", cols[0], cols[11], cols[4], cols[12], ((Entry)parent).getStringOffsetStart(), ((Entry)parent).getStringOffsetEnd());
                        } else {
                            this.addProgramCall(cols[5], cols[6], cols[2], cols[3], "->", cols[4], cols[12], cols[0], cols[11], ((Entry)parent).getStringOffsetStart(), ((Entry)parent).getStringOffsetEnd());
                        }
                    }
                    if (parent == null || this.isExcludedID(cols[4]) || FieldExpansionUtils.isIDOffsetIn(cols[4], ((Entry)parent).getStringOffsetStart(), ((Entry)parent).getStringOffsetEnd(), opList, this.closeRunnable)) continue;
                    if (!FieldExpansionUtils.isProgramIDIn(cols[5], this.programList, this.closeRunnable)) {
                        inp = new Program();
                        ((Program)inp).setId(cols[5]);
                        ((Program)inp).name = cols[6];
                        ((Program)inp).varID = cols[4];
                        this.programList.add((Program)inp);
                    }
                    Entry inp2 = Entry.instantiate(this.idProvider, cols[5]);
                    inp2.setImpactType(this.CALLING_PROGRAM);
                    inp2.impactName = cols[6];
                    inp2.setBackID(((Entry)parent).internalID);
                    inp2.ordinalPos = cols[1];
                    inp2.setProgramName(cols[6]);
                    inp2.info = cols[2];
                    if (cols.length > 6) {
                        inp2.programPath = cols[7];
                        inp2.startRow = cols[8];
                    }
                    if (((Entry)parent).getStringOffsetStart() != null) {
                        inp2.setOffsetStart(((Entry)parent).getStringOffsetStart());
                    }
                    if (((Entry)parent).getStringOffsetEnd() != null) {
                        inp2.setOffsetEnd(((Entry)parent).getStringOffsetEnd());
                    }
                    Entry.register(this.idProvider, inp2);
                    this.updateProgramWithCallStatement(inp2.internalID, cols[5]);
                    opList.add(inp2);
                    parent = inp2;
                    if (FieldExpansionUtils.isIDOffsetIn(cols[4], ((Entry)parent).getStringOffsetStart(), ((Entry)parent).getStringOffsetEnd(), backOpList, this.closeRunnable)) continue;
                    Entry inp3 = Entry.instantiate(this.idProvider, cols[4]);
                    inp3.setImpactType(this.CALL_PARAMETER);
                    inp3.impactName = cols[6];
                    inp3.setBackID(((Entry)parent).internalID);
                    inp3.ordinalPos = cols[1];
                    inp3.setProgramName(cols[6]);
                    inp3.programPath = cols[7];
                    inp3.startRow = cols[8];
                    inp3.varSize = Integer.valueOf(cols[10]);
                    if (parent != null) {
                        if (((Entry)parent).getStringOffsetStart() != null) {
                            inp3.setOffsetStart(((Entry)parent).getStringOffsetStart());
                        }
                        if (((Entry)parent).getStringOffsetEnd() != null) {
                            inp3.setOffsetEnd(((Entry)parent).getStringOffsetEnd());
                        }
                    }
                    Entry.register(this.idProvider, inp3);
                    opList.add(inp3);
                    if (FieldExpansionUtils.isIDOffsetIn(cols[4], ((Entry)parent).getStringOffsetStart(), ((Entry)parent).getStringOffsetEnd(), this.q1, this.closeRunnable)) continue;
                    this.q1.add(inp3);
                }
            }
        }
    }

    private void addProgramCall(String fromId, String fromName, String toId, String toName, String dir, String fromVId, String fromVName, String toVId, String toVName, String sOffset, String eOffset) {
        CallsInfo fromInfo = this.programCalls.get(fromId);
        if (fromInfo == null) {
            fromInfo = new CallsInfo();
            fromInfo.id = fromId;
            fromInfo.name = fromName;
            fromInfo.inCalls = new ArrayList<PInfo>();
            fromInfo.outCalls = new ArrayList<PInfo>();
            this.programCalls.put(fromId, fromInfo);
        }
        PInfo outExists = null;
        for (PInfo pinfo : fromInfo.outCalls) {
            if (!pinfo.fromId.equals(fromId) || !pinfo.toId.equals(toId)) continue;
            outExists = pinfo;
            break;
        }
        if (outExists == null) {
            PInfo pinfo;
            pinfo = new PInfo();
            pinfo.fromId = fromId;
            pinfo.fromName = fromName;
            pinfo.toId = toId;
            pinfo.toName = toName;
            pinfo.callDir = dir;
            VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
            pinfo.vInfo.add(vinfo);
            fromInfo.outCalls.add(pinfo);
        } else {
            VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
            if (outExists.vInfo.contains(vinfo) && vinfo.linkageVId != null) {
                outExists.vInfo.remove(vinfo);
                outExists.vInfo.add(vinfo);
            } else {
                outExists.vInfo.add(vinfo);
            }
        }
        CallsInfo toInfo = this.programCalls.get(toId);
        if (toInfo == null) {
            toInfo = new CallsInfo();
            toInfo.id = toId;
            toInfo.name = toName;
            toInfo.inCalls = new ArrayList<PInfo>();
            toInfo.outCalls = new ArrayList<PInfo>();
            this.programCalls.put(toId, toInfo);
        }
        PInfo inExists = null;
        for (PInfo pinfo : toInfo.inCalls) {
            if (!pinfo.fromId.equals(fromId) || !pinfo.toId.equals(toId)) continue;
            inExists = pinfo;
            break;
        }
        if (inExists == null) {
            PInfo pinfo;
            pinfo = new PInfo();
            pinfo.fromId = fromId;
            pinfo.fromName = fromName;
            pinfo.toId = toId;
            pinfo.toName = toName;
            pinfo.callDir = dir;
            VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
            pinfo.vInfo.add(vinfo);
            toInfo.inCalls.add(pinfo);
        } else {
            VInfo vinfo = VInfo.create(dir, fromVId, fromVName, toVId, toVName, sOffset, eOffset);
            if (inExists.vInfo.contains(vinfo) && vinfo.linkageVId != null) {
                inExists.vInfo.remove(vinfo);
                inExists.vInfo.add(vinfo);
            } else {
                inExists.vInfo.add(vinfo);
            }
        }
    }

    private boolean onSamePath(Entry e, String idFrom, String idTo) {
        boolean onSame = false;
        while (e != null) {
            if (this.CALLING_PROGRAM.equals(e.getImpactType()) && idFrom.equals(e.dbId) && idTo.equals(e.info)) {
                onSame = true;
                break;
            }
            e = this.getEntryWithInternalID(e.getBackID(), this.entries);
        }
        return onSame;
    }

    private void handleQ5(List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                if (FieldExpansionUtils.isProgramIDIn(cols[2], this.programList, this.closeRunnable)) continue;
                if (this.multiplePaths) {
                    Entry parent = this.getEntryWithID(cols[0], this.ltemp);
                    String sOffset = null;
                    String eOffset = null;
                    if (parent != null) {
                        sOffset = parent.getStringOffsetStart();
                        eOffset = parent.getStringOffsetEnd();
                    }
                    if (this.direction == 1) {
                        this.addProgramCall(cols[6], cols[7], cols[2], cols[3], "->", cols[0], cols[8], null, null, sOffset, eOffset);
                    } else {
                        this.addProgramCall(cols[2], cols[3], cols[6], cols[7], "<-", null, null, cols[0], cols[8], sOffset, eOffset);
                    }
                }
                Program inp = new Program();
                inp.setId(cols[2]);
                inp.name = cols[3];
                inp.varID = cols[0];
                inp.stmtType = cols[1];
                inp.stmtPath = cols[4];
                inp.startRow = cols[5];
                this.programList.add(inp);
            }
        }
    }

    private void handleNddaStep3(Map<String, List<Entry>> origEntries, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                String varSize = cols[3];
                List<Entry> dupEntries = origEntries.get(cols[0]);
                for (Entry orig : dupEntries) {
                    Entry inp;
                    if (orig.getStringOffsetStart() == null || orig.getStringOffsetEnd() == null || orig.getIntOE() < 0 || orig.getIntOS() < 0 || orig.getIntOS() > orig.getIntOE()) continue;
                    if (!(this.isExcludedID(cols[1]) || FieldExpansionUtils.isIDOffsetIn(cols[1], orig.getStringOffsetStart(), orig.getStringOffsetEnd(), this.l2, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[1], orig.getStringOffsetStart(), orig.getStringOffsetEnd(), this.q2, this.closeRunnable))) {
                        inp = Entry.instantiate(this.idProvider, cols[1]);
                        inp.setImpactType(cols[2]);
                        inp.setOffsetStart(orig.getStringOffsetStart());
                        inp.setOffsetEnd(orig.getStringOffsetEnd());
                        inp.setBackID(orig.internalID);
                        inp.varSize = Integer.valueOf(varSize);
                        Entry.register(this.idProvider, inp);
                        this.q2.add(inp);
                    }
                    if (this.isExcludedID(cols[1]) || FieldExpansionUtils.isIDOffsetIn(cols[1], orig.getStringOffsetStart(), orig.getStringOffsetEnd(), this.l3, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[1], orig.getStringOffsetStart(), orig.getStringOffsetEnd(), this.q3, this.closeRunnable)) continue;
                    inp = Entry.instantiate(this.idProvider, cols[1]);
                    inp.setImpactType(cols[2]);
                    inp.setOffsetStart(orig.getStringOffsetStart());
                    inp.setOffsetEnd(orig.getStringOffsetEnd());
                    inp.setBackID(orig.internalID);
                    inp.varSize = Integer.valueOf(varSize);
                    Entry.register(this.idProvider, inp);
                    this.q3.add(inp);
                }
            }
        }
    }

    private void handleResourceResults(Map<String, Map<String, Set<String>>> tmp, List<String[]> rez) {
        if (rez != null) {
            for (Object[] objectArray : rez) {
                Set<String> tbls;
                Map<String, Set<String>> occ;
                this.closeTest();
                String resTypeId = objectArray[2];
                boolean considerRes = true;
                if (resTypeId.equals("1") && (occ = tmp.get(objectArray[11])) != null && (tbls = occ.get(objectArray[0])) != null) {
                    considerRes = tbls.contains(objectArray[3]);
                }
                if (!considerRes) {
                    L.info("sql table skipped; {}", (Object)Arrays.toString(objectArray));
                    continue;
                }
                EntryList resourceList = this.resourceMap.get(resTypeId);
                if (resourceList == null) {
                    resourceList = new EntryList();
                    this.resourceMap.put((String)objectArray[2], resourceList);
                }
                FieldExpansionUtils.registerResourceUsage(this.resourceUsage, resTypeId, (String)objectArray[3], (String)objectArray[10]);
                if (FieldExpansionUtils.isIDIn((String)objectArray[3], resourceList, this.closeRunnable)) continue;
                Entry inp = Entry.instantiate(this.idProvider, (String)objectArray[3]);
                inp.setImpactType(this.STATEMENT_TYPE);
                inp.impactName = objectArray[5];
                inp.setBackID(this.getInternalIDFor((String)objectArray[0], this.ltemp));
                inp.isResource = true;
                inp.setProgramName((String)objectArray[8]);
                inp.programPath = objectArray[7];
                inp.startRow = objectArray[6];
                inp.programType = objectArray[9];
                inp.progID = objectArray[10];
                if (resTypeId.equals("189") || resTypeId.equals("190")) {
                    inp.language = "COBOL";
                }
                Entry.register(this.idProvider, inp);
                resourceList.add(inp);
            }
        }
    }

    private void handleDdaStep3(Map<String, List<Entry>> origEntries, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                String varSize = cols[6];
                List<Entry> dupEntries = origEntries.get(cols[0]);
                for (Entry parent : dupEntries) {
                    Entry inp;
                    if ((cols[2].equals("1") || cols[2].equals("5") || cols[2].equals("6") || cols[2].equals("7") || cols[2].equals("8") || cols[2].equals("3")) && !this.isExcludedID(cols[1]) && !FieldExpansionUtils.isIDIn(cols[1], this.l1, this.closeRunnable) && !FieldExpansionUtils.isIDOffsetIn(cols[1], cols[4], cols[5], this.q1, this.closeRunnable)) {
                        int[] range = this.getIntersection(cols[4], cols[5], parent);
                        int cos = range[0];
                        int coe = range[1];
                        if (cos != -1 && coe != -1) {
                            Entry inp2 = Entry.instantiate(this.idProvider, cols[1]);
                            inp2.setImpactType(this.STATEMENT_TYPE);
                            inp2.impactName = cols[3];
                            if (cos != -1) {
                                cos = cos - Integer.parseInt(cols[4]) + 1;
                                coe = cos + (coe - range[0]);
                                inp2.setOffsetStart("" + cos);
                                inp2.setOffsetEnd("" + coe);
                            }
                            inp2.varSize = Integer.valueOf(varSize);
                            inp2.setBackID(parent.internalID);
                            Entry.register(this.idProvider, inp2);
                            this.q1.add(inp2);
                        }
                    }
                    if (cols[2].equals("2") && !this.isExcludedID(cols[1]) && !FieldExpansionUtils.isIDOffsetIn(cols[1], cols[4], cols[5], this.l2, this.closeRunnable) && !FieldExpansionUtils.isIDOffsetIn(cols[1], cols[4], cols[5], this.q2, this.closeRunnable)) {
                        inp = Entry.instantiate(this.idProvider, cols[1]);
                        inp.setImpactType(cols[3]);
                        inp.setBackID(parent.internalID);
                        inp.varSize = Integer.valueOf(varSize);
                        if (parent.getStringOffsetEnd() == null || parent.getStringOffsetStart() == null) {
                            inp.setOffsetEnd(cols[5]);
                            inp.setOffsetStart(cols[4]);
                        } else {
                            int lenght = parent.getIntOE() - parent.getIntOS();
                            int st = Integer.parseInt(cols[4]) + parent.getIntOS() - 1;
                            int end = st + lenght;
                            inp.setOffsetEnd("" + end);
                            inp.setOffsetStart("" + st);
                        }
                        Entry.register(this.idProvider, inp);
                        this.q2.add(inp);
                    }
                    if (!cols[2].equals("3") || this.isExcludedID(cols[1]) || FieldExpansionUtils.isIDOffsetIn(cols[1], cols[4], cols[5], this.l3, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[1], cols[4], cols[5], this.q3, this.closeRunnable)) continue;
                    inp = Entry.instantiate(this.idProvider, cols[1]);
                    inp.setImpactType(cols[3]);
                    inp.setBackID(parent.internalID);
                    inp.setOffsetEnd(parent.getStringOffsetEnd());
                    inp.setOffsetStart(parent.getStringOffsetStart());
                    inp.varSize = Integer.valueOf(varSize);
                    Entry.register(this.idProvider, inp);
                    this.q3.add(inp);
                }
            }
        }
    }

    private void handleStep0(EntryListInterface opList, EntryListInterface backOpList, Map<String, List<Entry>> origEntries, List<String[]> rez) {
        if (rez != null) {
            for (String[] cols : rez) {
                this.closeTest();
                List<Entry> dupEntries = origEntries.get(cols[0]);
                String varSize = cols[4];
                if (varSize == null || varSize.equalsIgnoreCase("null")) {
                    L.warn("varSize null for varid={}", (Object)cols[1]);
                    varSize = "-1";
                }
                for (Entry parent : dupEntries) {
                    Comparable<Program> inp;
                    if (!(this.isExcludedID(cols[1]) || FieldExpansionUtils.isIDOffsetIn(cols[1], parent.getStringOffsetStart(), parent.getStringOffsetEnd(), backOpList, this.closeRunnable) || FieldExpansionUtils.isIDOffsetIn(cols[1], parent.getStringOffsetStart(), parent.getStringOffsetEnd(), backOpList, this.closeRunnable))) {
                        inp = Entry.instantiate(this.idProvider, cols[1]);
                        ((Entry)inp).setImpactType(this.SHARED_INCLUDE);
                        ((Entry)inp).impactName = cols[3];
                        ((Entry)inp).setBackID(parent.internalID);
                        ((Entry)inp).setOffsetStart(parent.getStringOffsetStart());
                        ((Entry)inp).setOffsetEnd(parent.getStringOffsetEnd());
                        ((Entry)inp).varSize = Integer.parseInt(varSize);
                        Entry.register(this.idProvider, inp);
                        opList.add((Entry)inp);
                    }
                    if (FieldExpansionUtils.isProgramIDIn(cols[2], this.programList, this.closeRunnable)) continue;
                    inp = new Program();
                    ((Program)inp).setId(cols[2]);
                    ((Program)inp).name = cols[3];
                    ((Program)inp).varID = cols[0];
                    ((Program)inp).stmtType = USE_SHARED_INCLUDE;
                    this.programList.add((Program)inp);
                }
            }
        }
    }

    private void handleAdabasResources(List<String[]> data) {
        List<String[]> oldData = this.resourceResults.get("56");
        if (oldData != null) {
            for (String[] s : data) {
                String newId = s[0];
                int pos = 0;
                int i = 0;
                while (i < oldData.size()) {
                    String[] d = oldData.get(i);
                    if (d[0].equals(newId)) {
                        L.debug("found adabasFileId={}", (Object)newId);
                        pos = -100;
                        if (!d[1].equals(s[1])) {
                            L.warn("different fileName for fileId={}; old={}, new={}. First it will be kept.", new Object[]{newId, d[1], s[1]});
                        }
                        if (d[2].equals(s[2])) break;
                        L.warn("different database for fileId={}; old={}, new={}. First it will be kept.", new Object[]{newId, d[2], s[2]});
                        break;
                    }
                    int comp = d[1].compareToIgnoreCase(s[1]);
                    if (comp == 0) {
                        comp = d[2].compareToIgnoreCase(s[2]);
                    }
                    pos = comp > 0 ? i + 1 : i;
                    ++i;
                }
                if (pos == -100) continue;
                oldData.add(pos, s);
            }
        } else {
            this.resourceResults.put("56", data);
        }
    }

    private final class CloseRunnable
    implements Runnable {
        private CloseRunnable() {
        }

        @Override
        public void run() {
            FieldExpansionSearch.this.closeTest();
        }
    }

    private final class InputDetailsProcessor
    implements DataStepProcessor {
        boolean doInclude = false;

        InputDetailsProcessor(boolean isInclude) {
            this.doInclude = isInclude;
        }

        @Override
        public void dataStep(List<String[]> rez) {
            if (rez != null) {
                block0: for (String[] cols : rez) {
                    for (Program program : FieldExpansionSearch.this.programList) {
                        boolean checkIt;
                        FieldExpansionSearch.this.closeTest();
                        boolean bl = checkIt = this.doInclude == program.isInclude;
                        if (!checkIt || !program.id.equals(cols[0])) continue;
                        program.type = cols[3];
                        program.path = com.ez.mainframe.data.utils.Utils.filterNullValue((String)cols[1]) == null ? NOT_AVAILABLE : cols[1];
                        continue block0;
                    }
                }
            }
        }
    }
}

