/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.CSVImpactUtils;
import com.ez.report.application.ezreport.reports.impact.ImpactBuilder;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FieldExpansionSearch;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Holder;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ReportDataSource;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.all.LegendDataSource;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldExpansionBuilder
extends ImpactBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FieldExpansionBuilder.class);
    FieldExpansionSearch fes;
    protected boolean isFieldExpansionReport = true;

    public FieldExpansionBuilder(String reportName, Object object) {
        this.report = null;
    }

    protected String getReportTemplatePath() {
        return "reports/fieldExpansion.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor monitor) {
        this.parameters.put("report.title", Messages.getString(FieldExpansionBuilder.class, "report.title"));
        this.titleParameters(this.parameters);
        return this.parameters;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) {
        boolean continued = true;
        ReportDataSource dataSource = null;
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        if (csvWriter != null) {
            CSVImpactUtils.writeCSVHeader(csvWriter, this.parameters, this.project);
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        this.fes = new FieldExpansionSearch(this.report, this.isFieldExpansionReport);
        this.fes.setCSVWriter(csvWriter);
        try {
            Holder holder;
            boolean hadErrorAndContinue;
            boolean hadError;
            block13: {
                Exception er;
                block12: {
                    hadError = false;
                    hadErrorAndContinue = false;
                    er = null;
                    IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                    IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
                    RunWithLock lockRunn = new RunWithLock();
                    try {
                        ph.executeWithLock(ph, (IMFRunnable)lockRunn, LockType.Shared, monitor);
                        hadError = lockRunn.hadError;
                        hadErrorAndContinue = lockRunn.hadErrorAndContinue;
                    }
                    catch (InterruptedException e) {
                        L.error("", (Throwable)e);
                        er = e;
                    }
                    catch (ExecutionException e) {
                        L.error("", (Throwable)e);
                        if (e.getCause() != null && e.getCause() instanceof CanceledException) break block12;
                        er = e;
                    }
                }
                if (er != null) {
                    hadError = true;
                    LogUtil.displayErrorMessage((Throwable)er, (String)Messages.getString(FieldExpansionBuilder.class, "error.dialog.generic.message"), (String)this.report.name, (Plugin)Activator.getDefault(), (boolean)false);
                    MyRunnable runn = new MyRunnable();
                    Display.getDefault().syncExec((Runnable)runn);
                    hadErrorAndContinue = runn.getResult();
                }
                continued = this.fes.isContinued();
                holder = null;
                if (!hadError || hadErrorAndContinue) {
                    try {
                        holder = this.fes.searchResults();
                    }
                    catch (Throwable t) {
                        if (t.getClass().equals(CanceledException.class)) break block13;
                        L.warn("error when filling datasource; ignored and try to fill report with partial data", t);
                        hadError = true;
                        LogUtil.displayErrorMessage((Throwable)t, (String)Messages.getString(FieldExpansionBuilder.class, "error.dialog.generic.message"), (String)this.report.name, (Plugin)Activator.getDefault(), (boolean)false);
                        MyRunnable runn = new MyRunnable();
                        Display.getDefault().syncExec((Runnable)runn);
                        hadErrorAndContinue = runn.getResult();
                    }
                }
            }
            dataSource = new ReportDataSource(holder);
            continued = this.fes.isContinued();
            ((StopCode)this.stopCode).setContinued(continued || hadErrorAndContinue);
            ((StopCode)this.stopCode).setHadError(hadError);
            this.fes.disposeResources();
            int cycles = this.fes.getCycles();
            this.buildAppendixOptionsPart(this.parameters, continued, hadErrorAndContinue, cycles);
        }
        finally {
            if (csvWriter != null) {
                csvWriter.close();
            }
        }
        return dataSource;
    }

    @Override
    protected List<Integer> getToFilterPrograms() {
        if (this.isFieldExpansionReport) {
            return null;
        }
        return super.getToFilterPrograms();
    }

    protected void initStopCode(IProgressMonitor monitor) {
        this.stopCode = new StopCode(monitor);
    }

    protected void buildAppendixOptionsPart(Map<String, Object> params, boolean continued, boolean hadErrorAndContinue, int cycles) {
        BaseSubreportDataSource excludedDS;
        String s;
        Integer propVal = (Integer)this.report.getProperty("max cycles");
        String maxCyclesText = propVal == null || propVal == 0 ? Messages.getString(FieldExpansionBuilder.class, "depth.appendix.unlimtedvalue") : propVal.toString();
        String optionsText = Messages.getString(FieldExpansionBuilder.class, "depth.appendix.text", new String[]{maxCyclesText});
        Integer dir = (Integer)this.report.getProperty("direction");
        if (dir != null) {
            String direction = FieldExpansionBuilder.getDirectionStr(dir);
            optionsText = String.valueOf(optionsText) + Messages.getString(FieldExpansionBuilder.class, "direction.appendix.text", new String[]{direction});
        }
        if (continued) {
            optionsText = String.valueOf(optionsText) + Messages.getString(FieldExpansionBuilder.class, "canceled.appendix.text", new String[]{String.valueOf(cycles)});
        }
        if (hadErrorAndContinue) {
            optionsText = String.valueOf(optionsText) + Messages.getString(FieldExpansionBuilder.class, "hadError.appendix.text", new String[]{String.valueOf(cycles)});
        }
        params.put("noColor", Boolean.TRUE);
        ElementGroupInfo appDS = new ElementGroupInfo("");
        DSFactory factory = new DSFactory();
        SC1DataSource dataSource = (SC1DataSource)factory.createDS(3);
        dataSource.setExtraTitle(Messages.getString(FieldExpansionBuilder.class, "appendix.title"));
        dataSource.setLayout(6);
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        dataSource.setList(list);
        appDS.addDataSource((SubreportDataSource)dataSource);
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(FieldExpansionBuilder.class, "options.appendix.label"));
        obj.setExpVal(optionsText);
        list.add(obj);
        list.add(FieldExpansionBuilder.createEmptySpace(factory));
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(FieldExpansionBuilder.class, "appendix.inputs.subtitle"));
        SC1DataSource inptsDS = new SC1DataSource();
        inptsDS.setLayout(4);
        obj.setSubreportDS((BaseSubreportDataSource)inptsDS);
        obj.setSubreportName("reports/subCols1-layout4.jasper");
        list.add(obj);
        params.remove("resourcesSummary");
        List inptsLst = (List)params.remove("inputResources");
        inptsDS.setList(inptsLst);
        list.add(FieldExpansionBuilder.createEmptySpace(factory));
        String exp = (String)params.remove("ignoredVarsSummaryLabel");
        if (exp != null) {
            obj = new ObjectForSubreport();
            obj.setExp(exp);
            inptsDS = new SC1DataSource();
            inptsDS.setLayout(4);
            inptsDS.setList((List)params.remove("ignoredVarsSummary"));
            obj.setSubreportDS((BaseSubreportDataSource)inptsDS);
            obj.setSubreportName("reports/subCols1-layout4.jasper");
            list.add(obj);
        }
        if ((s = (String)params.remove("definitionIncludedLabel")) != null && !s.isEmpty()) {
            obj = new ObjectForSubreport();
            obj.setExp("");
            obj.setExpVal(s);
            list.add(obj);
        }
        list.add(FieldExpansionBuilder.createEmptySpace(factory));
        ElementGroupInfo tmp = (ElementGroupInfo)params.remove("excludedDatasets4Appendix");
        if (tmp != null && (excludedDS = tmp.getDS("excludedDatasets")) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(excludedDS.getTitle());
            excludedDS.setTitle(null);
            obj.setSubreportDS(excludedDS);
            obj.setSubreportName("reports/subCols1-layout7.jasper");
            list.add(obj);
            SC1DataSource ddd = (SC1DataSource)tmp.getDS("datasetFlowLimitation");
            obj = new ObjectForSubreport();
            obj.setExp(ddd.getTitle());
            ddd.setTitle(null);
            obj.setSubreportDS((BaseSubreportDataSource)ddd);
            obj.setSubreportName("reports/subCols1-layout5.jasper");
            list.add(obj);
        }
        if (!this.isFieldExpansionReport) {
            ArrayList<String[]> scores = new ArrayList<String[]>();
            String[] stringArray = new String[3];
            stringArray[0] = "";
            String[] edgesTitle = stringArray;
            String txt = Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.programCall");
            String[] stringArray2 = new String[3];
            stringArray2[1] = "blue";
            stringArray2[2] = txt;
            String[] edges1 = stringArray2;
            txt = Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.dataflow");
            String[] stringArray3 = new String[5];
            stringArray3[1] = "green2";
            stringArray3[2] = txt;
            stringArray3[4] = "true";
            String[] edges2 = stringArray3;
            txt = Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.resourceusage");
            String[] stringArray4 = new String[7];
            stringArray4[1] = "black";
            stringArray4[2] = txt;
            stringArray4[6] = "true";
            String[] edges3 = stringArray4;
            scores.add(edgesTitle);
            scores.add(edges1);
            scores.add(edges2);
            scores.add(edges3);
            appDS.addDataSource((SubreportDataSource)new LegendDataSource(Messages.getString(FieldExpansionBuilder.class, "appendix.flow.legend.title"), scores));
            params.put("thinLines", Boolean.TRUE);
        }
        params.put("appendixDS", appDS);
    }

    public static ObjectForSubreport createEmptySpace(DSFactory factory) {
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setSubreportDS(factory.createDS(5));
        obj.setSubreportName("reports/subEmptySpace.jasper");
        return obj;
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Boolean forPrograms = (Boolean)this.inputs.get("selectionOnPrograms");
            if (forPrograms != null) {
                if (Boolean.TRUE.equals(forPrograms)) {
                    this.report.addProperty("resource_type", (Object)Utils.RESOURCE_TYPE_PROGRAM);
                } else {
                    this.report.addProperty("resource_type", (Object)Utils.RESOURCE_TYPE_INCLUDE);
                }
            }
            this.report.addProperty("selectionOnDBField", this.inputs.get("selectionOnDBField"));
            Integer depth = (Integer)this.inputs.get("max cycles");
            this.report.addProperty("max cycles", (Object)depth);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public void cleanMemory() {
        if (this.fes != null) {
            this.fes.disposeResources();
            this.fes = null;
        }
        super.cleanMemory();
    }

    class MyRunnable
    implements Runnable {
        boolean vb = false;

        MyRunnable() {
        }

        @Override
        public void run() {
            this.vb = MessageDialog.openQuestion(null, (String)Messages.getString(FieldExpansionBuilder.class, "error.dialog.title"), (String)Messages.getString(FieldExpansionBuilder.class, "error.dialog.question.message"));
        }

        boolean getResult() {
            return this.vb;
        }
    }

    class RunWithLock
    implements IMFRunnable {
        boolean hadError = false;
        boolean hadErrorAndContinue = false;

        RunWithLock() {
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            block2: {
                try {
                    FieldExpansionBuilder.this.fes.doSearch(conn, pmonitor);
                }
                catch (Throwable t) {
                    if (t.getClass().equals(CanceledException.class)) break block2;
                    L.warn("error when searching for variables; ignored and try to fill report with partial data", t);
                    this.hadError = true;
                    LogUtil.displayErrorMessage((Throwable)t, (String)Messages.getString(FieldExpansionBuilder.class, "error.dialog.generic.message"), (String)((FieldExpansionBuilder)FieldExpansionBuilder.this).report.name, (Plugin)Activator.getDefault(), (boolean)false);
                    MyRunnable runn = new MyRunnable();
                    Display.getDefault().syncExec((Runnable)runn);
                    this.hadErrorAndContinue = runn.getResult();
                }
            }
        }
    }

    protected class StopCode
    implements Runnable {
        private IProgressMonitor monitor;
        private boolean continued = false;
        private boolean hadError = false;

        public StopCode(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void setHadError(boolean hadError) {
            this.hadError = hadError;
        }

        public void setContinued(boolean continued) {
            this.continued = continued;
        }

        @Override
        public void run() {
            if (!this.continued) {
                if (this.monitor.isCanceled()) {
                    FieldExpansionBuilder.this.cleanMemory();
                }
                if (this.monitor.isCanceled() || this.hadError) {
                    FieldExpansionBuilder.this.canceled = true;
                    throw new CanceledException("report canceled");
                }
            }
        }
    }
}

