/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.report.application.ezreport.reports.impact.fieldexpansion.Entry;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.EntryListInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryList
implements EntryListInterface<Entry> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EntryList.class);
    Map<String, List<Entry>> byId = new HashMap<String, List<Entry>>();
    Map<Integer, Entry> byInternalIds = new HashMap<Integer, Entry>();

    @Override
    public void add(Entry e) {
        if (!this.byInternalIds.containsKey(e.internalID)) {
            List<Entry> duplicates = this.byId.get(e.dbId);
            if (duplicates == null) {
                duplicates = new ArrayList<Entry>();
                this.byId.put(e.dbId, duplicates);
            }
            duplicates.add(e);
            this.byInternalIds.put(e.internalID, e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.byInternalIds != null && this.byInternalIds.isEmpty();
    }

    @Override
    public void clear() {
        this.byId.clear();
        this.byInternalIds.clear();
    }

    @Override
    public int size() {
        return this.byInternalIds.size();
    }

    public List<Entry> getById(String id) {
        return this.byId.get(id);
    }

    @Override
    public Entry getByInternalId(int id) {
        return this.byInternalIds.get(id);
    }

    @Override
    public List<Entry> getList() {
        return new ArrayList<Entry>(this.byInternalIds.values());
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.byInternalIds.values().iterator();
    }

    @Override
    public void addAll(EntryListInterface<Entry> q) {
        for (Entry e : q) {
            this.add(e);
        }
    }

    @Override
    public void update(Entry entry) {
        Entry removed = this.byInternalIds.remove(entry.internalID);
        L.trace("** removed from byInternalIds={}", (Object)removed);
        if (removed != null) {
            this.byInternalIds.put(entry.internalID, entry);
        }
        Entry toRem = null;
        ArrayList<Entry> it = this.getById(entry.dbId);
        if (it != null) {
            for (Entry ent : it) {
                if (ent.internalID != entry.internalID) continue;
                L.trace("** found it: {}", (Object)entry);
                toRem = ent;
                break;
            }
            if (toRem != null) {
                boolean rem = it.remove(toRem);
                L.trace("** removed from byId={}", (Object)rem);
                if (rem) {
                    it.add(0, entry);
                }
            }
        } else if (removed != null) {
            L.warn("entry not found in byID, but it was in byInternalId; it will be added");
            it = new ArrayList<Entry>();
            this.byId.put(entry.dbId, it);
            it.add(0, entry);
        }
    }

    static void printEntryList(EntryList lst, String lstName) {
        L.trace("EntryList-{}: {}", (Object)lstName, (Object)lst.size());
        L.trace("{}.byIds(map): {}::{}", new Object[]{lstName, lst.byId.size(), lst.byId});
        L.trace("{}.byInternalIds(map): {}::{}", new Object[]{lstName, lst.byInternalIds.size(), lst.byInternalIds});
        L.trace("------------------------------");
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void dispose() {
        this.clear();
    }
}

