/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.report.application.ezreport.reports.impact.fieldexpansion.IDProvider;
import java.io.IOException;
import java.io.Serializable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Entry
implements Serializable,
Comparable<Entry> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Entry.class);
    private static final String NULL_VALUE = "EZ_NULL_VALUE";
    public boolean isResource = false;
    public String programPath;
    private String programName;
    int internalID = 0;
    String dbId;
    private int backID = -1;
    private String impactType;
    String impactName;
    String ordinalPos;
    String backOrdinalPos;
    private String offsetStart;
    private String offsetEnd;
    private int intOS;
    private int intOE;
    private boolean isLinkage = false;
    private String name;
    public String language;
    public String startRow;
    public String parent;
    public String programType;
    public int varSize = -1;
    public String info;
    protected String progID;

    Entry(int internalID, String dbId) {
        this.internalID = internalID;
        this.dbId = dbId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public int getIntOS() {
        return this.intOS;
    }

    public int getIntOE() {
        return this.intOE;
    }

    public String getStringOffsetStart() {
        return this.offsetStart;
    }

    public String getStringOffsetEnd() {
        return this.offsetEnd;
    }

    public void setOffsetStart(String offsetStart) {
        if (offsetStart != null) {
            this.offsetStart = offsetStart;
            this.intOS = Integer.valueOf(offsetStart);
        }
    }

    public void setOffsetEnd(String offsetEnd) {
        if (offsetEnd != null) {
            this.offsetEnd = offsetEnd;
            this.intOE = Integer.valueOf(offsetEnd);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Entity(intid=").append(this.internalID).append("; id=").append(this.dbId).append("; backID=").append(this.backID);
        buf.append("; impactType=").append(this.impactType).append("; impactName=").append(this.impactName);
        buf.append("; ordinalPos=").append(this.ordinalPos).append("; backOrdinalPos=").append(this.backOrdinalPos);
        buf.append("; programName=").append(this.programName).append("; name=").append(this.name);
        buf.append(")");
        return buf.toString();
    }

    public void setImpactType(String impactType) {
        this.impactType = impactType;
    }

    public String getImpactType() {
        return this.impactType;
    }

    public int getBackID() {
        return this.backID;
    }

    public void setBackID(int backID) {
        if (this.internalID == backID) {
            L.info("cycle: id=backid={}, dbid={}", (Object)this.internalID, (Object)this.dbId);
        }
        this.backID = backID;
    }

    public void setIsLinkage(boolean isLinkage) {
        this.isLinkage = isLinkage;
    }

    public boolean isLinkage() {
        return this.isLinkage;
    }

    @Override
    public int compareTo(Entry o) {
        int res = 0;
        if (o instanceof Entry) {
            Entry other = o;
            res = this.internalID == other.internalID ? 0 : (this.internalID > other.internalID ? 1 : -1);
        }
        return res;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dbId == null ? 0 : this.dbId.hashCode());
        result = 31 * result + this.internalID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.dbId == null ? other.dbId != null : !this.dbId.equals(other.dbId)) {
            return false;
        }
        return this.internalID == other.internalID;
    }

    public static Entry instantiate(IDProvider idProvider, String dbID) {
        Entry entry = new Entry(idProvider.newID(), dbID);
        return entry;
    }

    public static void register(IDProvider idProvider, Entry entry) {
        if (idProvider == null || entry == null) {
            throw new RuntimeException("idProvider or entry is null!");
        }
        idProvider.register(entry);
    }

    static class CustomSerializer
    implements Serializer<Entry>,
    Serializable {
        private static final long serialVersionUID = 10L;

        CustomSerializer() {
        }

        public void serialize(DataOutput2 out, Entry value) throws IOException {
            try {
                out.writeInt(value.internalID);
                out.writeUTF(value.dbId);
                if (value.getName() != null) {
                    out.writeUTF(value.getName());
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                out.writeInt(value.backID);
                if (value.backOrdinalPos != null) {
                    out.writeUTF(value.backOrdinalPos);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.impactName != null) {
                    out.writeUTF(value.impactName);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.impactType != null) {
                    out.writeUTF(value.impactType);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                out.writeInt(value.intOE);
                out.writeInt(value.intOS);
                out.writeBoolean(value.isResource);
                if (value.language != null) {
                    out.writeUTF(value.language);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.offsetEnd != null) {
                    out.writeUTF(value.offsetEnd);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.offsetStart != null) {
                    out.writeUTF(value.offsetStart);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.ordinalPos != null) {
                    out.writeUTF(value.ordinalPos);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.parent != null) {
                    out.writeUTF(value.parent);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.getProgramName() != null) {
                    out.writeUTF(value.getProgramName());
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.programPath != null) {
                    out.writeUTF(value.programPath);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.programType != null) {
                    out.writeUTF(value.programType);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.startRow != null) {
                    out.writeUTF(value.startRow);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                out.writeBoolean(value.isLinkage);
                out.writeInt(value.varSize);
                if (value.info != null) {
                    out.writeUTF(value.info);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
                if (value.progID != null) {
                    out.writeUTF(value.progID);
                } else {
                    out.writeUTF(Entry.NULL_VALUE);
                }
            }
            catch (Throwable ex) {
                L.error("exception at serialization; ignored", ex);
            }
        }

        public Entry deserialize(DataInput2 in, int available) throws IOException {
            Entry entry = null;
            try {
                entry = new Entry(in.readInt(), in.readUTF());
                String tmp = in.readUTF();
                if (!Entry.NULL_VALUE.equals(tmp)) {
                    entry.setName(tmp);
                }
                entry.backID = in.readInt();
                tmp = in.readUTF();
                if (!Entry.NULL_VALUE.equals(tmp)) {
                    entry.backOrdinalPos = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.impactName = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.impactType = tmp;
                }
                entry.intOE = in.readInt();
                entry.intOS = in.readInt();
                entry.isResource = in.readBoolean();
                tmp = in.readUTF();
                if (!Entry.NULL_VALUE.equals(tmp)) {
                    entry.language = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.offsetEnd = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.offsetStart = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.ordinalPos = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.parent = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.setProgramName(tmp);
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.programPath = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.programType = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.startRow = tmp;
                }
                entry.isLinkage = in.readBoolean();
                entry.varSize = in.readInt();
                tmp = in.readUTF();
                if (!Entry.NULL_VALUE.equals(tmp)) {
                    entry.info = tmp;
                }
                if (!Entry.NULL_VALUE.equals(tmp = in.readUTF())) {
                    entry.progID = tmp;
                }
            }
            catch (Throwable ex) {
                L.error("exception at deserialization; ignored", ex);
            }
            return entry;
        }

        public int fixedSize() {
            return -1;
        }
    }
}

