/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact.fieldexpansion;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.INetworkProvider;
import java.util.HashMap;
import java.util.Map;

public class AAutoNetworkProvider
implements INetworkProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private EZSourceConnection conn;
    private Boolean hasData = null;
    private String jobNetworkPrefix = "select AAUTONetworks.NetworkName, AAUTONetworks.NetwkExpandedName, AAUTONetworkJobs.JobNumber from AAutoNetworks \n \tinner join AAUTONetworkJobs on AAUtoNetworks.NetworkID = AAUTONetworkJobs.NetworkID\n \tinner join AAUTOJobs on AAUTONetworkJobs.JobId = AAUTOJobs.JobID\n where AAUTOJobs.JobName = ";
    private Map<String, Pair<String, String>> jobNetworkCache = new HashMap<String, Pair<String, String>>();

    public AAutoNetworkProvider(EZSourceConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean isDataAvailable() {
        if (this.hasData == null) {
            int networks;
            this.hasData = false;
            String[][] data = this.conn.executeSQL("select count(*) from AAutoNetworks");
            if (data != null && data.length > 0 && (networks = Integer.parseInt(data[0][0])) > 0) {
                this.hasData = true;
            }
        }
        return this.hasData;
    }

    @Override
    public Pair<String, String> getNetworkForJob(String jobName) {
        String network = null;
        String expanded = null;
        String jobNo = null;
        Pair pair = null;
        if (this.isDataAvailable()) {
            String jn = jobName.toLowerCase();
            if (this.jobNetworkCache.containsKey(jn)) {
                pair = this.jobNetworkCache.get(jn);
            } else {
                String[][] data = this.conn.executeSQL(String.valueOf(this.jobNetworkPrefix) + "'" + jobName + "'");
                if (data != null && data.length > 0) {
                    network = data[0][0];
                    expanded = data[0][1];
                    jobNo = data[0][2];
                    if (expanded != null && !expanded.isEmpty()) {
                        network = String.valueOf(network) + "[" + expanded + "]";
                    }
                    if (jobNo != null && jobNo.isEmpty()) {
                        jobNo = null;
                    }
                }
                pair = new Pair(network, jobNo);
                this.jobNetworkCache.put(jn, (Pair<String, String>)pair);
            }
        }
        return pair;
    }
}

