/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableSelectionVerifier
implements SelectSingleFromListPage.SelectionVerifier {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VariableSelectionVerifier.class);
    private boolean acceptRecord = false;

    public VariableSelectionVerifier(boolean acceptRecord) {
        this.acceptRecord = acceptRecord;
    }

    public String checkSelectionOK(SelectSingleFromListPage.ListItem listItem) {
        SelectSingleFromListPage.ArrayListItem item = (SelectSingleFromListPage.ArrayListItem)listItem;
        String[] obj = item.getStringArray();
        int filler = 0;
        int field = 0;
        boolean category = true;
        try {
            if (obj != null) {
                category = false;
                filler = Integer.valueOf(obj[5]);
                field = Integer.valueOf(obj[4]);
            }
        }
        catch (NumberFormatException nfe) {
            L.error("wrong filler or field for listItem={}", listItem.getObject(), (Object)nfe);
        }
        String message = null;
        if (category) {
            message = Messages.getString(VariableSelectionVerifier.class, "notSelect.category.errorMessage");
        } else {
            if (filler == -1) {
                message = Messages.getString(VariableSelectionVerifier.class, "notSelect.filler.errorMessage");
            }
            if (!this.acceptRecord && field != -1) {
                message = Messages.getString(VariableSelectionVerifier.class, "notSelect.record.errorMessage");
            }
        }
        return message;
    }
}

