/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableOrBrowsePage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VariableOrBrowsePage.class);
    public static final String VARIABLE_NAME = "variableName";
    public static final String IMPACT_DIRECTION = "impact direction";
    public static final String IMPACT_DIRECTION_CHANGED = "impact_direction_changed";
    public static final Integer FORWARD = 1;
    public static final Integer BACKWARD = 2;
    public static final String MAX_CYCLES = "max cycles";
    public static final int NOLIMIT_DEPTH_VALUE = 0;
    public static final int MIN_DEPTH_VALUE = 1;
    public static final int MAX_DEPTH_VALUE = 1000;
    private static final String STARTED_ON_FIELD = "selectionOnDBField";
    private Button fieldChoice;
    private Group directionGroup;
    private Button forward;
    private Button backward;
    private Group varChoiceGroup;
    private Button browseChoice;
    private boolean showDirectionChoice;
    private boolean showDepthChoice = false;
    private Group depthChoiceGroup;
    private Button depthChoice;
    private Text depthText;
    private String description;

    public VariableOrBrowsePage(String pageName, boolean showDirectionChoice) {
        super(pageName);
        this.setTitle(Messages.getString(VariableOrBrowsePage.class, "page.title"));
        this.description = showDirectionChoice ? Messages.getString(VariableOrBrowsePage.class, "page.desc.direction") : Messages.getString(VariableOrBrowsePage.class, "page.description");
        this.setDescription(this.description);
        this.showDirectionChoice = showDirectionChoice;
    }

    public VariableOrBrowsePage(String pageName, boolean showDirectionChoice, boolean showDepthChoice) {
        this(pageName, showDirectionChoice);
        this.showDepthChoice = showDepthChoice;
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginTop = 30;
        gl.marginLeft = 20;
        gl.verticalSpacing = 20;
        page.setLayout((Layout)gl);
        this.createStartPointChoiceGroup(page);
        if (this.showDirectionChoice) {
            this.createDirectionGroup(page);
        }
        if (this.showDepthChoice) {
            this.createDepthChoiceGroup(page);
        }
        this.setPageComplete(false);
        this.setControl((Control)page);
    }

    private void createStartPointChoiceGroup(Composite page) {
        this.varChoiceGroup = new Group(page, 0);
        this.varChoiceGroup.setText(Messages.getString(VariableOrBrowsePage.class, "var.grp.txt"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = false;
        this.varChoiceGroup.setLayout((Layout)gl);
        this.browseChoice = new Button((Composite)this.varChoiceGroup, 16);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.browseChoice.setLayoutData((Object)gd);
        this.browseChoice.setText(Messages.getString(VariableOrBrowsePage.class, "browse.btn.txt"));
        this.browseChoice.setSelection(false);
        this.fieldChoice = new Button((Composite)this.varChoiceGroup, 16);
        this.fieldChoice.setText(Messages.getString(VariableOrBrowsePage.class, "field.btn.txt"));
        this.fieldChoice.setSelection(false);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fieldChoice.setLayoutData((Object)gd);
        ChoiceSelection cs = new ChoiceSelection();
        this.browseChoice.addSelectionListener((SelectionListener)cs);
        this.fieldChoice.addSelectionListener((SelectionListener)cs);
    }

    private void createDirectionGroup(Composite page) {
        this.directionGroup = new Group(page, 0);
        this.directionGroup.setText(Messages.getString(VariableOrBrowsePage.class, "direction.grp.txt"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.directionGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        this.directionGroup.setLayoutData((Object)gd);
        DirectionAdapter da = new DirectionAdapter();
        this.forward = new Button((Composite)this.directionGroup, 16);
        this.forward.setText(Messages.getString(VariableOrBrowsePage.class, "forward.btn.txt"));
        this.forward.setSelection(false);
        this.forward.addSelectionListener((SelectionListener)da);
        this.backward = new Button((Composite)this.directionGroup, 16);
        this.backward.setText(Messages.getString(VariableOrBrowsePage.class, "backward.btn.txt"));
        this.backward.setSelection(false);
        this.backward.addSelectionListener((SelectionListener)da);
        this.setDirection();
    }

    private void createDepthChoiceGroup(Composite page) {
        this.depthChoiceGroup = new Group(page, 0);
        this.depthChoiceGroup.setText(Messages.getString(VariableOrBrowsePage.class, "depth.grp.txt"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = false;
        this.depthChoiceGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        this.depthChoiceGroup.setLayoutData((Object)gd);
        this.depthChoice = new Button((Composite)this.depthChoiceGroup, 32);
        this.depthChoice.setText(Messages.getString(VariableOrBrowsePage.class, "depth.btn.txt"));
        this.depthChoice.setSelection(false);
        this.depthChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = VariableOrBrowsePage.this.depthChoice.getSelection();
                VariableOrBrowsePage.this.depthText.setEnabled(selected);
                VariableOrBrowsePage.this.setPageComplete(!selected || VariableOrBrowsePage.this.checkDepthValue());
                VariableOrBrowsePage.this.setDepth();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.depthText = new Text((Composite)this.depthChoiceGroup, 2052);
        gd = new GridData(256);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 50;
        gd.widthHint = 50;
        this.depthText.setLayoutData((Object)gd);
        this.depthText.setEnabled(false);
        this.depthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (VariableOrBrowsePage.this.depthChoice.getSelection()) {
                    VariableOrBrowsePage.this.setPageComplete(true);
                }
                VariableOrBrowsePage.this.setDepth();
            }
        });
        this.setDepth();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        boolean complete = this.checkDirection();
        if (complete && (complete = this.checkDepthValue())) {
            complete = this.browseChoice.getSelection() || this.fieldChoice.getSelection();
        }
        this.setPageComplete(complete);
    }

    private boolean checkDepthValue() {
        boolean complete = true;
        if (this.depthChoice != null) {
            if (this.depthChoice.getSelection()) {
                String depth = this.depthText.getText();
                try {
                    int depthInt = Integer.valueOf(depth);
                    complete = depthInt > 0 && depthInt <= 1000;
                    this.setMessage(this.description, 0);
                }
                catch (NumberFormatException ex) {
                    L.warn("wrong value for depth", (Throwable)ex);
                    this.setMessage(Messages.getString(VariableOrBrowsePage.class, "wrongDepth.error.message", new String[]{String.valueOf(1), String.valueOf(1000)}), 3);
                    complete = false;
                }
            } else {
                this.setMessage(this.description, 0);
            }
        }
        return complete;
    }

    private boolean checkDirection() {
        boolean ret = this.forward == null && this.backward == null || this.forward != null && this.forward.getSelection() || this.backward != null && this.backward.getSelection();
        return ret;
    }

    private void setVariableName(String text) {
        ((PrepareReportWizard)this.getWizard()).set(VARIABLE_NAME, (Object)text);
    }

    private void setDirection() {
        int direction = this.forward.getSelection() ? FORWARD : BACKWARD;
        ((PrepareReportWizard)this.getWizard()).set(IMPACT_DIRECTION, (Object)direction);
    }

    private void setDepth() {
        int depthInt = 0;
        if (this.depthChoice != null && this.depthChoice.getSelection()) {
            String depth = this.depthText.getText();
            try {
                depthInt = Integer.valueOf(depth);
            }
            catch (NumberFormatException ex) {
                L.info("wrong value for depth; default ({}) is used", (Object)0, (Object)ex);
            }
        }
        ((PrepareReportWizard)this.getWizard()).set(MAX_CYCLES, (Object)depthInt);
    }

    public IWizardPage getNextPage() {
        if (((PrepareReportWizard)this.getWizard()).getValue(VARIABLE_NAME) != null) {
            return ((PrepareReportWizard)this.getWizard()).getPage("browseExcludedVariables");
        }
        Object startOnField = ((PrepareReportWizard)this.getWizard()).getValue(STARTED_ON_FIELD);
        if (startOnField != null && ((Boolean)startOnField).booleanValue()) {
            return ((PrepareReportWizard)this.getWizard()).getPage("selectDBTable");
        }
        return ((PrepareReportWizard)this.getWizard()).getPage("program or include");
    }

    public void setPageComplete(boolean complete) {
        this.setVariableName(null);
        if (complete) {
            boolean bl = complete = this.browseChoice.getSelection() || this.fieldChoice.getSelection();
        }
        if (complete && this.depthChoice != null) {
            complete = this.checkDepthValue();
        }
        if (complete) {
            complete = this.checkDirection();
        }
        super.setPageComplete(complete);
    }

    private void refreshVariableChoiseGroup(boolean enabled) {
    }

    class ChoiceSelection
    extends SelectionAdapter {
        ChoiceSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget source = e.widget;
            ((PrepareReportWizard)VariableOrBrowsePage.this.getWizard()).set(VariableOrBrowsePage.STARTED_ON_FIELD, (Object)VariableOrBrowsePage.this.fieldChoice.getSelection());
            if (source.equals(VariableOrBrowsePage.this.browseChoice)) {
                VariableOrBrowsePage.this.refreshVariableChoiseGroup(false);
                VariableOrBrowsePage.this.setPageComplete(VariableOrBrowsePage.this.checkDepthValue() && VariableOrBrowsePage.this.checkDirection());
            } else if (source.equals(VariableOrBrowsePage.this.fieldChoice)) {
                VariableOrBrowsePage.this.refreshVariableChoiseGroup(false);
                VariableOrBrowsePage.this.setPageComplete(VariableOrBrowsePage.this.checkDepthValue() && VariableOrBrowsePage.this.checkDirection());
            }
        }
    }

    private class DirectionAdapter
    extends SelectionAdapter {
        private DirectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            VariableOrBrowsePage.this.setDirection();
            VariableOrBrowsePage.this.setPageComplete(true);
        }
    }
}

