/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.NonBlockingOperationHandle;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.ProgramsUsingIncludeCollector;
import com.ez.report.application.ezreport.reports.impact.VariableOrBrowsePage;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableDetailProvider
implements SelectSingleFromListPage.ListDetailProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VariableDetailProvider.class);
    public static final String ENTITY_TYPE = Messages.getString(VariableDetailProvider.class, "entityType.variable");
    private static final Integer VAR_MAX_NO = 100000;
    static final String EZ_MARKER = "EZ#MARKER";
    private static final String DBFIELD_QUERY_ORDER_BY_PART = "\tORDER BY ProgIDReference, ancestor, father, StartRow";
    private PrepareReportWizard wizard;
    private String description = null;
    private String selectionKey;
    private String selectionOnProgramsKey;
    private String selectionOnDBFieldKey;
    private boolean isStartedOnDBField = false;
    private String pageKey = "";
    private boolean isFieldUsage = false;
    private String selectPrgUsingInclKey;

    private String getProgramsVariableQuery(EZSourceConnection bridge) {
        return "SELECT Variables.VarID, Variables.iLevel, Variables.VarName, Variables.PIC, Variables.IsField, Variables.IsFiller, \r\n                      Occurrences.StartRow, Paragraphs.ParaName, '', Variables.father, Variables.type, Variables.ProgIDReference, Variables.ancestor, Variables.VarID\r\nFROM         Variables INNER JOIN\r\n                      Occurrences ON Variables.OccurID = Occurrences.OccurID LEFT OUTER JOIN\r\n                      Paragraphs ON Occurrences.ParaID = Paragraphs.ParaID AND Occurrences.ProgID = Paragraphs.ProgramID\r\nWHERE     (Variables.IsCopy = 0) and (Variables.ProgIDReference in (select ProgramID from " + Utils.getTempTableName((EZSourceConnection)bridge, (String)"numeric_param_temp") + "))" + "\nORDER BY Variables.ProgIDReference, Variables.ancestor, Variables.father, Occurrences.StartRow";
    }

    private String getProgramsCountVariableQuery(EZSourceConnection bridge) {
        return "SELECT count(*) FROM         Variables INNER JOIN\r\n                      Occurrences ON Variables.OccurID = Occurrences.OccurID LEFT OUTER JOIN\r\n                      Paragraphs ON Occurrences.ParaID = Paragraphs.ParaID AND Occurrences.ProgID = Paragraphs.ProgramID\r\nWHERE     (Variables.IsCopy = 0) and (Variables.ProgIDReference in (select ProgramID from " + Utils.getTempTableName((EZSourceConnection)bridge, (String)"numeric_param_temp") + "))";
    }

    private String getIncludesVariableQuery(EZSourceConnection bridge) {
        return "SELECT DISTINCT \r\n                       -100, Variables.iLevel, Variables.VarName, Variables.PIC, Variables.IsField, Variables.IsFiller, \r\n                      Occurrences.StartRow, Paragraphs.ParaName,'', Variables.father, Variables.type, Variables.ProgIDReference, Variables.ancestor, Variables.VarID\r\nFROM         Variables INNER JOIN\r\n                      Occurrences ON Variables.OccurID = Occurrences.OccurID LEFT OUTER JOIN\r\n                      Paragraphs ON Occurrences.ParaID = Paragraphs.ParaID AND Occurrences.ProgID = Paragraphs.ProgramID\r\nWHERE     (Occurrences.PathID IN (select ProgramID from " + Utils.getTempTableName((EZSourceConnection)bridge, (String)"numeric_param_temp") + ")) " + EZ_MARKER + " ORDER BY Variables.ProgIDReference, Variables.ancestor, Variables.father, Occurrences.StartRow";
    }

    private String getIncludesCountVariableQuery(EZSourceConnection bridge) {
        return "SELECT count (DISTINCT Variables.VarID) FROM Variables INNER JOIN      Occurrences ON Variables.OccurID = Occurrences.OccurID WHERE (Occurrences.PathID IN (select ProgramID from " + Utils.getTempTableName((EZSourceConnection)bridge, (String)"numeric_param_temp") + "))" + EZ_MARKER;
    }

    private String getDbFieldFwVariableQuery(EZSourceConnection conn) {
        return "SELECT DISTINCT Variables.VarID , Variables.iLevel, Variables.VarName, Variables.PIC, Variables.IsField, Variables.IsFiller, Occurrences.StartRow, Paragraphs.ParaName, ProgramAliases.ProgramId, Variables.father, Variables.type, Variables.ProgIDReference, Variables.ancestor, Variables.VarID, ProgramAliases.AliasName AS ProgramName\t\n\tFROM Occurrences \t\t\t\tINNER JOIN Variables             \t\tON Occurrences.OccurID = Variables.OccurID \t\n\t\t\tINNER JOIN Paths             \t\tON Occurrences.PathID = Paths.PathID \t\n\t\t\tINNER JOIN SqlTables \t\t\t\tINNER JOIN SqlFields \t\t\t\t\tON SqlTables.SqlTableID = SqlFields.SqlTableID \t\n\t\t\tINNER JOIN StatementReferenceEX             \t\tON SqlFields.SqlFieldID = StatementReferenceEX.ReadResourceID \t\t\t\t\tON Variables.VarID = StatementReferenceEX.WrittenResourceID \t\n\t\t\tINNER JOIN ProgramAliases             \t\tON StatementReferenceEX.ProgramID = ProgramAliases.ProgramId AND ProgramAliases.AliasType = 0 \t\t\t\tLEFT OUTER JOIN Paragraphs \t\t\t\t\tON Occurrences.ParaID = Paragraphs.ParaID AND Occurrences.ProgID = Paragraphs.ProgramID \t\n\t\tWHERE (StatementReferenceEX.ReadResourceType = 187) \t\t\t\tAND SqlFields.SqlFieldID IN (select ProgramID from " + Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp") + ") ";
    }

    private String getDbFieldBkwVariableQuery(EZSourceConnection conn) {
        return "SELECT DISTINCT Variables.VarID , Variables.iLevel, Variables.VarName, Variables.PIC, Variables.IsField, Variables.IsFiller, Occurrences.StartRow, Paragraphs.ParaName, ProgramAliases.ProgramID, Variables.father, Variables.type, Variables.ProgIDReference, Variables.ancestor, Variables.VarID, ProgramAliases.AliasName AS ProgramName\t\n\t\tFROM \t\t\t\tStatementReferenceEX \t\t\t\tINNER JOIN SqlFields \t\t\t\t\tON StatementReferenceEX.WrittenResourceID = SqlFields.SqlFieldID \n\t\t\t\tINNER JOIN Variables             \t\tON StatementReferenceEX.ReadResourceID = Variables.VarID \n\t\t\t\tINNER JOIN Occurrences             \t\tON Variables.OccurID = Occurrences.OccurID \n\t\t\t\tINNER JOIN Paths             \t\tON Occurrences.PathID = Paths.PathID \n\t\t\t\tINNER JOIN SqlTables             \t\tON SqlFields.SqlTableID = SqlTables.SqlTableID \n\t\t\t\tINNER JOIN ProgramAliases             \t\tON StatementReferenceEX.ProgramID = ProgramAliases.ProgramId AND ProgramAliases.AliasType = 0  \n           \tLEFT OUTER JOIN Paragraphs \t\t\t\t\tON Occurrences.ParaID = Paragraphs.ParaID AND Occurrences.ProgID = Paragraphs.ProgramID \t\t\n\tWHERE (StatementReferenceEX.WrittenResourceType = 187) \t\t\t\tAND SqlFields.SqlFieldID IN (select ProgramID from " + Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp") + ") ";
    }

    private String getDbFieldVariableQuery(EZSourceConnection bridge) {
        String q = null;
        Object direction = this.wizard.getValue("impact direction");
        if (direction == null) {
            q = String.valueOf(this.getDbFieldFwVariableQuery(bridge)) + " UNION " + this.getDbFieldBkwVariableQuery(bridge) + DBFIELD_QUERY_ORDER_BY_PART;
        } else if (VariableOrBrowsePage.FORWARD.equals(direction)) {
            q = String.valueOf(this.getDbFieldFwVariableQuery(bridge)) + DBFIELD_QUERY_ORDER_BY_PART;
        } else if (VariableOrBrowsePage.BACKWARD.equals(direction)) {
            q = String.valueOf(this.getDbFieldBkwVariableQuery(bridge)) + DBFIELD_QUERY_ORDER_BY_PART;
        }
        Assert.isNotNull(q);
        return q;
    }

    public VariableDetailProvider(PrepareReportWizard wizard, String pageKey) {
        this(wizard, "selected id", "selectionOnPrograms", "selectionOnDBField", pageKey, "selectPrgUsingIncl");
    }

    public VariableDetailProvider(PrepareReportWizard wizard, String selectionKey, String selectionOnProgramsKey, String selectionOnDBField, String pageKey, String selectPrgUsingInclKey) {
        this.wizard = wizard;
        this.selectionKey = selectionKey;
        this.selectionOnProgramsKey = selectionOnProgramsKey;
        this.selectionOnDBFieldKey = selectionOnDBField;
        this.pageKey = pageKey;
        this.selectPrgUsingInclKey = selectPrgUsingInclKey;
    }

    public VariableDetailProvider(PrepareReportWizard wizard, String pageKey, boolean isFieldUsage) {
        this(wizard, pageKey);
        this.isFieldUsage = true;
    }

    public void setSelectionIDKey(String selectionKey) {
        this.selectionKey = selectionKey;
    }

    public void setSelectionOnProgramsKey(String selectionOnProgramsKey) {
        this.selectionOnProgramsKey = selectionOnProgramsKey;
    }

    private List<String> prepareProgramParam(SelectSingleFromListPage.ArrayListItem selection, EZSourceConnection conn) {
        ArrayList<String> ret = new ArrayList<String>();
        if (selection.getStringArray().length >= 3 && selection.getStringArray()[3].equals("8")) {
            try {
                String query = "select programid from programs where programtypeid in (15, 16) and ancestor = ? ";
                String[][] rez = conn.executeSQL(query, new Object[]{selection.getStringArray()[0]});
                if (rez != null && rez.length > 0) {
                    String[][] stringArray = rez;
                    int n = rez.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] row = stringArray[n2];
                        ret.add(row[0]);
                        ++n2;
                    }
                }
            }
            catch (EZSourceNativeException e) {
                L.error("prepareProgramParam()", (Throwable)e);
            }
        } else {
            ret.add(selection.getStringArray()[1]);
        }
        return ret;
    }

    private Node buildTree(String[][] rez) {
        Node head = new Node();
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        String headFather = "0";
        Node dsect = null;
        Node local = null;
        ArrayList<String> fakeFathers = new ArrayList<String>();
        nodes.put(headFather, head);
        String[][] stringArray = rez;
        int n = rez.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            String fatherId = row[9];
            String varId = row[13];
            String varType = row[10];
            Node father = (Node)nodes.get(fatherId);
            if (father == null) {
                L.debug("unordered list, created fake node with id: {}", (Object)fatherId);
                father = new Node();
                nodes.put(fatherId, father);
                fakeFathers.add(fatherId);
            }
            if ("20".equals(varType) && fatherId.equals(headFather)) {
                if (dsect == null) {
                    dsect = new Node("DSECT");
                    head.children.add(dsect);
                }
                father = dsect;
            } else if (("21".equals(varType) || "22".equals(varType) || "23".equals(varType) || "24".equals(varType)) && fatherId.equals(headFather)) {
                if (local == null) {
                    local = new Node("Local");
                    head.children.add(local);
                }
                father = local;
            }
            Node cNode = (Node)nodes.get(varId);
            if (cNode != null) {
                cNode.row = row;
            } else {
                cNode = new Node();
                cNode.row = row;
                nodes.put(varId, cNode);
            }
            fakeFathers.remove(varId);
            father.children.add(cNode);
            ++n2;
        }
        for (String id : fakeFathers) {
            head.children.add((Node)nodes.get(id));
        }
        return head;
    }

    public List<SelectSingleFromListPage.ListItem> getItems(EZSourceConnection bridge, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString(VariableDetailProvider.class, "get.var.task.name"), (int)-1);
        List<SelectSingleFromListPage.ListItem> items = null;
        List<Object> param = null;
        String query = null;
        SelectSingleFromListPage.ArrayListItem selection = null;
        String pathOrPrgID = null;
        Object startOnField = this.wizard.getValue(this.selectionOnDBFieldKey);
        this.isStartedOnDBField = startOnField != null && (Boolean)startOnField != false;
        Integer prgId = null;
        if (this.isStartedOnDBField) {
            selection = (SelectSingleFromListPage.ArrayListItem)this.wizard.getValue("selectedFieldID");
            query = this.getDbFieldVariableQuery(bridge);
            param = new ArrayList<String>();
            param.add(selection.getStringArray()[1]);
        } else {
            boolean forPrograms = (Boolean)this.wizard.getValue(this.selectionOnProgramsKey);
            if (this.wizard.getValue(this.selectionKey) instanceof Collection) {
                List lst = (List)this.wizard.getValue(this.selectionKey);
                selection = (SelectSingleFromListPage.ArrayListItem)lst.get(0);
            } else if (this.wizard.getValue(this.selectionKey) instanceof SelectSingleFromListPage.ArrayListItem) {
                selection = (SelectSingleFromListPage.ArrayListItem)this.wizard.getValue(this.selectionKey);
            }
            pathOrPrgID = selection.getStringArray()[1];
            if (forPrograms) {
                query = this.getProgramsVariableQuery(bridge);
                param = this.prepareProgramParam(selection, bridge);
            } else {
                query = this.getIncludesVariableQuery(bridge);
                param = new ArrayList();
                param.add(pathOrPrgID);
                ArrayList prgInputs = (ArrayList)this.wizard.getValue(this.selectPrgUsingInclKey);
                if (prgInputs == null) {
                    String qforPrg = ProgramsUsingIncludeCollector.getProgramsUsingIncludesQuery(bridge, this.isFieldUsage).replace(EZ_MARKER, pathOrPrgID);
                    String[][] rez = bridge.executeSQL(qforPrg);
                    if (rez != null && rez.length > 0) {
                        prgId = Integer.valueOf(rez[0][1]);
                        this.wizard.set("PROGRAM_FOR_VAR_LAYOUT", (Object)rez[0][0]);
                    }
                } else {
                    prgId = ((ProgramInput)prgInputs.get(0)).getProgramID();
                    this.wizard.set("PROGRAM_FOR_VAR_LAYOUT", (Object)((ProgramInput)prgInputs.get(0)).getListableName());
                }
                if (prgId != null) {
                    query = query.replace(EZ_MARKER, " and ProgIDReference = " + prgId);
                } else {
                    L.warn("not found program Id that use selected include");
                    query = query.replace(EZ_MARKER, "");
                }
            }
        }
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[param.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            String[][] rez = bridge.executeSQL(query, types, param);
            if (rez != null && rez.length > 0) {
                Node head = this.buildTree(rez);
                HashMap<String, SelectSingleFromListPage.ArrayListItem> usedNames = new HashMap<String, SelectSingleFromListPage.ArrayListItem>();
                items = this.buildListItems(head, pathOrPrgID, 0, usedNames);
            }
            this.showError(null);
        }
        catch (EZSourceNativeException e) {
            L.error("getItems()", (Throwable)e);
            items = null;
        }
        this.description = items == null || items.size() == 0 ? Messages.getString(VariableDetailProvider.class, "noVariable.message") : Messages.getString(VariableDetailProvider.class, "default.description");
        return items;
    }

    private void showError(final String errMsg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((WizardPage)VariableDetailProvider.this.wizard.getPage(VariableDetailProvider.this.pageKey)).setErrorMessage(errMsg);
            }
        });
    }

    private String[][] getData(EZSourceConnection bridge, List<String> param, String query, List<EZSourceDataType> types, IProgressMonitor monitor) {
        ArrayList resultPool;
        block11: {
            NonBlockingOperationHandle handler = null;
            resultPool = new ArrayList();
            try {
                try {
                    String[] procParam = new String[]{};
                    handler = bridge.beginNonTransactionalStoredProc("_testInclude", procParam, types, new ArrayList<String>(param), 100000);
                    boolean doIt = !monitor.isCanceled();
                    while (doIt && !handler.finished()) {
                        List rows = handler.getAvailableData();
                        if (rows != null) {
                            resultPool.addAll(rows);
                        }
                        doIt = !monitor.isCanceled();
                        System.out.println(resultPool.size());
                    }
                }
                catch (EZSourceConnectionException e) {
                    L.error("error getting data", (Throwable)e);
                    if (handler != null) {
                        handler.close();
                        L.trace("after close handler");
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (handler != null) {
                    handler.close();
                    L.trace("after close handler");
                }
                throw throwable;
            }
            if (handler != null) {
                handler.close();
                L.trace("after close handler");
            }
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return (String[][])resultPool.toArray((T[])new String[0][]);
    }

    private List<SelectSingleFromListPage.ListItem> buildListItems(Node cNode, String pathOrPrgID, int level, Map<String, SelectSingleFromListPage.ArrayListItem> usedNames) {
        ArrayList<SelectSingleFromListPage.ListItem> items = new ArrayList<SelectSingleFromListPage.ListItem>();
        SelectSingleFromListPage.ListItem cItem = this.buildItem(cNode, pathOrPrgID, level, usedNames);
        if (cItem != null) {
            items.add(cItem);
            ++level;
        }
        for (Node child : cNode.children) {
            List<SelectSingleFromListPage.ListItem> cItems = this.buildListItems(child, pathOrPrgID, level, usedNames);
            items.addAll(cItems);
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SelectSingleFromListPage.ListItem buildItem(Node cNode, String pathOrPrgID, int level, Map<String, SelectSingleFromListPage.ArrayListItem> usedNames) {
        String varLine;
        if (!cNode.isDrawable()) {
            return null;
        }
        StringBuilder textBuf = new StringBuilder();
        SelectSingleFromListPage.ArrayListItem item = new SelectSingleFromListPage.ArrayListItem();
        String varName = cNode.getName();
        if (cNode.row != null) {
            item.setStringArray(cNode.row);
            if (!this.isStartedOnDBField) {
                item.setElementAt(8, pathOrPrgID);
            }
        }
        this.ident(textBuf, level);
        textBuf.append(cNode.getLevel());
        String varKey = varName;
        String string = varLine = cNode.row != null ? cNode.row[6] : "";
        if (cNode.isFiller()) {
            varName = "FILLER";
            varKey = varName.concat("|").concat(varLine).concat("|").concat(pathOrPrgID);
        }
        if (usedNames.containsKey(varKey.toUpperCase())) {
            SelectSingleFromListPage.ArrayListItem it = usedNames.get(varKey.toUpperCase());
            if (it != null) {
                String[] array = it.getStringArray();
                if (array.length == 1 || this.isStartedOnDBField && array.length == 2) {
                    if (array[0].equals(varLine)) {
                        if (!this.isStartedOnDBField) return null;
                        if (array[1].equals(cNode.row[8])) {
                            return null;
                        }
                    }
                } else {
                    if (it.getStringArray()[6].equals(varLine) && (cNode.row.length < 15 || it.getStringArray().length == 15 && it.getStringArray()[14].equals(cNode.row[14]))) {
                        return null;
                    }
                    String paraName = it.getStringArray()[7];
                    String prgName = "";
                    if (this.isStartedOnDBField) {
                        prgName = "program " + it.getStringArray()[14] + ", ";
                    }
                    paraName = Utils.filterNullValue((String)paraName) == null ? "" : String.valueOf(paraName) + ", ";
                    String newText = String.valueOf(it.getListText()) + " (" + prgName + paraName + "line:" + it.getStringArray()[6] + ")";
                    it.setListText(newText);
                    it.setDuplicateName(true);
                    SelectSingleFromListPage.ArrayListItem ali = new SelectSingleFromListPage.ArrayListItem();
                    String[] s = null;
                    s = this.isStartedOnDBField ? new String[]{it.getStringArray()[6], it.getStringArray()[8]} : new String[]{it.getStringArray()[6]};
                    ali.setStringArray(s);
                    usedNames.put(varKey.toUpperCase(), ali);
                }
            }
            String paraName = cNode.row[7];
            String prgName = "";
            if (this.isStartedOnDBField) {
                prgName = "program " + cNode.row[14] + ", ";
            }
            paraName = Utils.filterNullValue((String)paraName) == null ? "" : String.valueOf(paraName) + ", ";
            textBuf.append(varName).append(" (" + prgName + paraName + "line:").append(varLine).append(")");
            item.setDuplicateName(true);
        } else {
            usedNames.put(varKey.toUpperCase(), item);
            textBuf.append(varName);
        }
        item.setListText(textBuf.toString());
        return item;
    }

    private void ident(StringBuilder textBuf, int ident) {
        int j = 0;
        while (j < ident) {
            textBuf.append("      ");
            ++j;
        }
    }

    private List<SelectSingleFromListPage.ListItem> buildListItems(String[][] rez, String pathOrPrgID) {
        ArrayList<SelectSingleFromListPage.ListItem> items = new ArrayList<SelectSingleFromListPage.ListItem>();
        int ident = 0;
        int oldLevel = -1;
        int level = -1;
        int filler = 0;
        HashMap<String, SelectSingleFromListPage.ArrayListItem> usedNames = new HashMap<String, SelectSingleFromListPage.ArrayListItem>();
        StringBuffer textBuf = new StringBuffer();
        int i = 0;
        while (i < rez.length) {
            block13: {
                SelectSingleFromListPage.ArrayListItem li;
                block9: {
                    String varName;
                    block10: {
                        String paraName;
                        block11: {
                            SelectSingleFromListPage.ArrayListItem it;
                            block12: {
                                block8: {
                                    textBuf.delete(0, textBuf.length());
                                    try {
                                        level = Integer.valueOf(rez[i][1]);
                                        filler = Integer.valueOf(rez[i][5]);
                                    }
                                    catch (NumberFormatException nfe) {
                                        level = 1;
                                        filler = 0;
                                        L.error("{}", (Throwable)nfe);
                                    }
                                    if (oldLevel == -1) {
                                        oldLevel = level;
                                    }
                                    if (level > oldLevel) {
                                        ++ident;
                                    } else if (level < oldLevel) {
                                        ident = 0;
                                    }
                                    li = new SelectSingleFromListPage.ArrayListItem();
                                    li.setStringArray(rez[i]);
                                    li.appendStringToArray(pathOrPrgID);
                                    int j = 0;
                                    while (j < ident) {
                                        textBuf.append("      ");
                                        ++j;
                                    }
                                    textBuf.append(rez[i][1]).append(" ");
                                    if (filler != -1) break block8;
                                    textBuf.append("FILLER");
                                    break block9;
                                }
                                varName = rez[i][2];
                                if (!usedNames.containsKey(varName.toUpperCase())) break block10;
                                it = (SelectSingleFromListPage.ArrayListItem)usedNames.get(varName.toUpperCase());
                                if (it == null) break block11;
                                String[] array = it.getStringArray();
                                if (array.length != 1) break block12;
                                if (!array[0].equals(rez[i][6])) break block11;
                                break block13;
                            }
                            if (it.getStringArray()[6].equals(rez[i][6])) break block13;
                            String paraName2 = it.getStringArray()[7];
                            paraName2 = Utils.filterNullValue((String)paraName2) == null ? "" : String.valueOf(paraName2) + ", ";
                            String newText = String.valueOf(it.getListText()) + " (" + paraName2 + "line:" + it.getStringArray()[6] + ")";
                            it.setListText(newText);
                            it.setDuplicateName(true);
                            SelectSingleFromListPage.ArrayListItem ali = new SelectSingleFromListPage.ArrayListItem();
                            ali.setStringArray(new String[]{it.getStringArray()[6]});
                            usedNames.put(varName.toUpperCase(), ali);
                        }
                        paraName = Utils.filterNullValue((String)(paraName = rez[i][7])) == null ? "" : String.valueOf(paraName) + ", ";
                        textBuf.append(varName).append(" (" + paraName + "line:").append(rez[i][6]).append(")");
                        li.setDuplicateName(true);
                        break block9;
                    }
                    usedNames.put(varName.toUpperCase(), li);
                    textBuf.append(varName);
                }
                li.setListText(textBuf.toString());
                items.add((SelectSingleFromListPage.ListItem)li);
                oldLevel = level;
            }
            ++i;
        }
        return items;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public String getTitle() {
        boolean hasmultipleSel;
        boolean bl = hasmultipleSel = this.wizard.getValue("selectMultipleInputs") == null || (Boolean)this.wizard.getValue("selectMultipleInputs") != false;
        if (hasmultipleSel) {
            return Messages.getString(VariableDetailProvider.class, "title.4multipleVarSelection");
        }
        return Messages.getString(VariableDetailProvider.class, "title");
    }

    public boolean isCheckBox() {
        return false;
    }

    public boolean hasFilters() {
        return true;
    }

    class Node {
        String name = null;
        String[] row = null;
        List<Node> children = new LinkedList<Node>();

        Node() {
        }

        Node(String name) {
            this.name = name;
        }

        String getName() {
            return this.name != null ? this.name : this.row[2];
        }

        String getLevel() {
            return this.name != null ? "" : String.valueOf(String.format("%02d", Integer.valueOf(this.row[1]))) + " ";
        }

        boolean isFiller() {
            return this.row == null ? false : this.row[5].equals("-1");
        }

        public boolean isDrawable() {
            return this.row != null || this.name != null;
        }
    }
}

