/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.impact.ProgramOrIncludesDetailFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipNoVariableEntities
implements ProgramOrIncludesDetailFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String queryForPrograms = "select distinct Programs.ProgramID, Programs.ancestor, Programs.ProgramTypeID\r\n\tfrom Programs inner join Variables on Programs.ProgramID = Variables.ProgIDReference\r\n\twhere Variables.IsCopy = 0";
    private static final String queryForIncludes = "select distinct Occurrences.PathID, '', ''\r\n\tfrom Variables inner join Occurrences On Variables.OccurID = Occurrences.OccurID";
    private static final Logger L = LoggerFactory.getLogger(SkipNoVariableEntities.class);

    @Override
    public String[][] filterResults(String[][] results, boolean forPrograms) {
        L.debug("filtering results without variables for type: {}", (Object)(forPrograms ? "programs" : "includes"));
        Pair<List<String>, List<String>> id_anc = null;
        try {
            id_anc = this.getValidIds(forPrograms);
        }
        catch (EZSourceNativeException e) {
            L.error("error occured. will not filter", (Throwable)e);
        }
        if (id_anc == null) {
            return results;
        }
        LinkedList<String[]> rez = new LinkedList<String[]>();
        String[][] stringArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            if (((List)id_anc.getFirst()).contains(row[1])) {
                rez.add(row);
            } else if (row.length >= 3 && row[3].equals("8") && ((List)id_anc.getSecond()).contains(row[0])) {
                rez.add(row);
            }
            ++n2;
        }
        String[][] ret = (String[][])rez.toArray((T[])new String[0][]);
        return ret;
    }

    private Pair<List<String>, List<String>> getValidIds(boolean forPrograms) {
        String[][] rez;
        block12: {
            String query = forPrograms ? queryForPrograms : queryForIncludes;
            rez = null;
            EZSourceConnection bridge = null;
            try {
                bridge = EZSourceConnectionManager.getCurrent();
                rez = bridge.executeSQL(query);
            }
            catch (EZSourceConnectionException ex) {
                L.error("getValidIds()", (Throwable)ex);
                if (bridge != null) {
                    EZSourceConnectionManager.release((EZSourceConnection)bridge);
                }
                break block12;
            }
            catch (Exception e) {
                try {
                    L.error("getValidIds()", (Throwable)e);
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                }
            }
            if (bridge == null) break block12;
            EZSourceConnectionManager.release((EZSourceConnection)bridge);
        }
        Pair ret = null;
        ArrayList<String> listIds = null;
        HashSet<String> listAncestors = null;
        if (rez != null && rez.length > 0) {
            ret = new Pair();
            listIds = new ArrayList<String>();
            listAncestors = new HashSet<String>();
            String[][] stringArray = rez;
            int n = rez.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                listIds.add(row[0]);
                if (row[1] != null && !row[1].isEmpty()) {
                    listAncestors.add(row[1]);
                }
                ++n2;
            }
            ret.setFirst(listIds);
            ret.setSecond(new ArrayList(listAncestors));
        }
        return ret;
    }
}

