/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.ImpactReportWizard;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectVariablePage
extends SelectSingleFromListPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectVariablePage.class);
    boolean filled = false;
    List<Integer> indexes = null;

    public SelectVariablePage(String pageName) {
        super(pageName);
    }

    protected void fillPage() {
        Object field = ((PrepareReportWizard)this.getWizard()).getValue("selectionOnDBField");
        if (field != null && ((Boolean)field).booleanValue()) {
            field = ((PrepareReportWizard)this.getWizard()).getValue("selectedFieldID");
            if (field != null) {
                Object forceFil = ((PrepareReportWizard)this.getWizard()).getValue("impact_direction_changed");
                if (forceFil != null && Boolean.valueOf(forceFil.toString()).booleanValue()) {
                    this.filled = false;
                }
                if (!this.filled) {
                    super.fillPage();
                    this.filled = true;
                }
            }
        } else {
            super.fillPage();
        }
        if (this.indexes != null) {
            for (int idx : this.indexes) {
                this.listControl.select(idx);
            }
        }
    }

    public void forceFillPage() {
        this.filled = false;
        this.fillPage();
    }

    protected void init() {
        String prg = (String)((PrepareReportWizard)this.getWizard()).getValue("PROGRAM_FOR_VAR_LAYOUT");
        if (prg != null) {
            this.setHeaderInfo(Messages.getString(ImpactReportWizard.class, "info.prg.txt", new String[]{prg}));
        } else {
            this.setHeaderInfo(null);
        }
        super.init();
        this.indexes = null;
        Object field = ((PrepareReportWizard)this.getWizard()).getValue("selectionOnDBField");
        if (field != null && ((Boolean)field).booleanValue()) {
            field = ((PrepareReportWizard)this.getWizard()).getValue("selectedFieldID");
            if (field != null) {
                if (this.items != null && this.items.size() > 0) {
                    ArrayList<SelectSingleFromListPage.ListItem> sel = new ArrayList<SelectSingleFromListPage.ListItem>();
                    this.indexes = new ArrayList<Integer>();
                    int i = 0;
                    while (i < this.items.size()) {
                        String message = this.checkSelectionOK(i);
                        if (message == null) {
                            SelectSingleFromListPage.ListItem selItem = (SelectSingleFromListPage.ListItem)this.items.get(i);
                            sel.add(selItem);
                            this.indexes.add(i);
                        }
                        ++i;
                    }
                    if (!sel.isEmpty()) {
                        ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, sel);
                        this.setPageComplete(true);
                    } else {
                        ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, null);
                        this.setPageComplete(false);
                    }
                } else {
                    ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, null);
                    this.setPageComplete(false);
                }
            }
            this.getContainer().updateButtons();
        } else {
            ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, null);
            this.setPageComplete(false);
        }
    }

    public IWizardPage getPreviousPage() {
        ((PrepareReportWizard)this.getWizard()).set("PROGRAM_FOR_VAR_LAYOUT", null);
        return super.getPreviousPage();
    }

    protected void selectValue(int[] indexes) {
        boolean pageComplete = true;
        if (indexes.length > 0) {
            ArrayList<SelectSingleFromListPage.ListItem> sel = new ArrayList<SelectSingleFromListPage.ListItem>();
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                SelectSingleFromListPage.ListItem selItem = (SelectSingleFromListPage.ListItem)this.items.get(index);
                String message = this.checkSelectionOK(index);
                if (message != null) {
                    this.listControl.deselect(index);
                    this.setMessage(message, 2);
                    L.warn("{} was not selected; selectionVerified failed", (Object)selItem.getListText());
                } else {
                    if (selItem.getObject() != null) {
                        sel.add(selItem);
                    }
                    L.debug("selected: {}", (Object)selItem.getListText());
                }
                ++n2;
            }
            if (!sel.isEmpty()) {
                ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, sel);
                this.setMessage(null);
            } else {
                pageComplete = false;
            }
        } else {
            pageComplete = false;
        }
        this.setPageComplete(pageComplete);
    }

    protected void createListOfInputs(Composite page) {
        boolean hasmultipleSel;
        boolean bl = hasmultipleSel = ((PrepareReportWizard)this.getWizard()).getValue("selectMultipleInputs") == null || (Boolean)((PrepareReportWizard)this.getWizard()).getValue("selectMultipleInputs") != false;
        if (hasmultipleSel) {
            this.listControl = new org.eclipse.swt.widgets.List(page, 2818);
            this.listControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int[] indexes = SelectVariablePage.this.listControl.getSelectionIndices();
                    SelectVariablePage.this.selectValue(indexes);
                }
            });
        } else {
            super.createListOfInputs(page);
        }
    }
}

