/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramsUsingIncludeCollector
extends BridgeResourcesCollectorAdapter<ProgramInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramsUsingIncludeCollector.class);
    private PrepareReportWizard wizard;
    private String selectionOnIncludesKey;
    private boolean isFieldUsage = false;

    public ProgramsUsingIncludeCollector(PrepareReportWizard wizard, String selectionOnIncludesKey) {
        this.wizard = wizard;
        this.selectionOnIncludesKey = selectionOnIncludesKey;
    }

    public ProgramsUsingIncludeCollector(PrepareReportWizard wizard, String selectionOnIncludesKey, boolean isFieldUsage) {
        this(wizard, selectionOnIncludesKey);
        this.isFieldUsage = isFieldUsage;
    }

    protected static String getProgramsUsingIncludesQuery(EZSourceConnection bridge, boolean isFieldUsage) {
        String inclTypes = isFieldUsage ? "13, 57, 60, 67, 99" : "13, 67";
        return "SELECT DISTINCT ProgramAliases.AliasName AS ProgramName, ProgramAliases.ProgramId, '', Programs.ProgramTypeID FROM       Programs \n INNER JOIN ProgramAliases \t\tON Programs.ProgramID = ProgramAliases.ProgramId AND ProgramAliases.AliasType = 0 \n INNER JOIN OccurrencesStmt ON OccurrencesStmt.ProgID = Programs.ProgramID \n INNER JOIN StatementReference sr on sr.OccurID = OccurrencesStmt.OccurID\n INNER JOIN Resources ON Resources.ResourceId = sr.ResourceId\n INNER JOIN Occurrences ON Resources.OccurID = Occurrences.OccurID\n WHERE     (Programs.OccurID > 0) and sr.resourcetype in (" + inclTypes + ") " + "\t\tand Occurrences.PathId =  " + "EZ#MARKER" + "\n ORDER BY ProgramAliases.AliasName";
    }

    public List<ProgramInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        List resources = null;
        ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
        try {
            Object val = this.wizard.getValue(this.selectionOnIncludesKey);
            SelectSingleFromListPage.ArrayListItem ali = val instanceof SelectSingleFromListPage.ArrayListItem ? (SelectSingleFromListPage.ArrayListItem)val : (val instanceof List ? (SelectSingleFromListPage.ArrayListItem)((List)val).get(0) : null);
            Assert.isNotNull((Object)ali);
            String inclId = ali.getStringArray()[1];
            String query = ProgramsUsingIncludeCollector.getProgramsUsingIncludesQuery(conn, this.isFieldUsage).replace("EZ#MARKER", inclId);
            resources = factory.getAvailablePrograms(query, conn);
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error when collect programs", (Throwable)e);
        }
        return resources;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

