/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.ProgramOrIncludesDetailFilter;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import com.ez.report.application.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProgramOrIncludesDetailProvider
implements SelectSingleFromListPage.ListDetailProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramOrIncludesDetailProvider.class);
    private PrepareReportWizard wizard;
    private String description;
    private String title;
    private String entityType;
    ProgramOrIncludesDetailFilter filter = null;
    private String selectionOnProgramsKey;

    public ProgramOrIncludesDetailProvider(PrepareReportWizard wizard) {
        this.wizard = wizard;
        this.title = Messages.getString(ProgramOrIncludesDetailProvider.class, "title");
        this.description = Messages.getString(ProgramOrIncludesDetailProvider.class, "description");
        this.selectionOnProgramsKey = "selectionOnPrograms";
    }

    public void setFilter(ProgramOrIncludesDetailFilter filter) {
        this.filter = filter;
    }

    public void setSelectionOnProgramsKey(String selectionOnProgramsKey) {
        this.selectionOnProgramsKey = selectionOnProgramsKey;
    }

    public List<SelectSingleFromListPage.ListItem> getItems(EZSourceConnection bridge, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.setTaskName(Messages.getString(ProgramOrIncludesDetailProvider.class, "get.res.task.name"));
        List<SelectSingleFromListPage.ListItem> items = null;
        boolean forPrograms = (Boolean)this.wizard.getValue(this.selectionOnProgramsKey);
        SelectSingleFromListPage.ArrayListItem appList = (SelectSingleFromListPage.ArrayListItem)this.wizard.getValue("selected applications");
        HashSet<String> apps = null;
        if (monitor.isCanceled()) {
            return null;
        }
        if (appList != null) {
            String[] app = appList.getStringArray();
            apps = new HashSet<String>();
            apps.add(app[1]);
        }
        String query = null;
        if (forPrograms) {
            this.entityType = Utils.RESOURCE_TYPE_PROGRAM;
            query = apps != null && apps.size() != 0 ? this.getProgramsForAppQuery() : this.getProgramsQuery();
        } else {
            this.entityType = Utils.RESOURCE_TYPE_INCLUDE;
            query = apps != null && apps.size() != 0 ? this.getIncludesForAppQuery() : this.getIncludesQuery();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        String[][] rez = null;
        try {
            List<Object> types = new ArrayList();
            if (apps != null && !apps.isEmpty()) {
                types = Arrays.asList(new EZSourceDataType[apps.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                rez = bridge.executeSQL(query, types, new ArrayList(apps));
            } else {
                rez = bridge.executeSQL(query);
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("getItems()", (Throwable)e);
            items = null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (rez != null) {
            items = this.filterResults(rez, forPrograms);
        }
        this.title = Messages.getString(ProgramOrIncludesDetailProvider.class, "title.detailed", new String[]{this.entityType});
        this.description = Messages.getString(ProgramOrIncludesDetailProvider.class, "description");
        return items;
    }

    private List<SelectSingleFromListPage.ListItem> filterResults(String[][] rez, boolean forPrograms) {
        ArrayList<SelectSingleFromListPage.ArrayListItem> items = null;
        if (this.filter != null) {
            rez = this.filter.filterResults(rez, forPrograms);
        }
        if (rez != null && rez.length > 0) {
            items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
            int i = 0;
            while (i < rez.length) {
                SelectSingleFromListPage.ArrayListItem li = new SelectSingleFromListPage.ArrayListItem();
                li.setStringArray(rez[i]);
                items.add(li);
                ++i;
            }
        } else {
            items = null;
        }
        return items;
    }

    protected abstract String getProgramsQuery();

    protected abstract String getProgramsForAppQuery();

    protected abstract String getIncludesQuery();

    protected abstract String getIncludesForAppQuery();

    public String getDescription() {
        return this.description;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isCheckBox() {
        return false;
    }

    public boolean hasFilters() {
        return true;
    }
}

