/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.datasetflow.SelectDatasetsAndDirectionPage;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.wizard.MultiSelectionPage;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.ui.ApplicationsProvider;
import com.ez.mainframe.reports.gui.wizard.BuildListOfItemsPage;
import com.ez.mainframe.reports.gui.wizard.ImpactSettingsPage;
import com.ez.mainframe.reports.gui.wizard.ProgramOrIncludePage;
import com.ez.mainframe.reports.gui.wizard.VariablePatternFilter;
import com.ez.report.application.ezreport.reports.impact.DBFieldProvider;
import com.ez.report.application.ezreport.reports.impact.DBTableProvider;
import com.ez.report.application.ezreport.reports.impact.ProgramsUsingIncludeCollector;
import com.ez.report.application.ezreport.reports.impact.SelectDBFieldPage;
import com.ez.report.application.ezreport.reports.impact.SelectVariablePage;
import com.ez.report.application.ezreport.reports.impact.SkipNoVariableEntities;
import com.ez.report.application.ezreport.reports.impact.VariableDetailProvider;
import com.ez.report.application.ezreport.reports.impact.VariableOrBrowsePage;
import com.ez.report.application.ezreport.reports.impact.VariableSelectionVerifier;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.ProgramsProvider;
import com.ez.report.application.ui.collectors.MultipleVSAMCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PatternFilter;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ImpactReportWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String EXCLUDED_VARIABLES_PAGE_KEY = "browseExcludedVariables";
    private static final String VARIABLE_OR_BROWSE_PAGE_KEY = "chooseStartPoint";
    public static final String PRG_FOR_VAR_LAYOUT = "PROGRAM_FOR_VAR_LAYOUT";
    public static final String SELECT_PROGRAMS_USING_INCLUDE = "select from programs using includes";
    ProgramOrIncludePage browsePIpage = null;
    private boolean ucmdbProject;
    private boolean showDirection;
    SelectSingleFromListPage vspExcluded = null;
    private BuildListOfItemsPage blip;
    private SelectSingleFromListPage sspExcluded;
    private SelectSingleFromListPage vsp;
    private VariableOrBrowsePage vbp;
    private boolean showDepthLimit = false;
    private Map<String, Object> params;
    private boolean showExcludedDSPage = false;
    private boolean excludedVarAdded = false;
    private boolean multipleSelection = false;

    public ImpactReportWizard(boolean ucmdbProject, String wizardName, boolean showDirection, boolean showDepthLimit, Map<String, Object> params, boolean multipleSelection, boolean showExcludedDSPage) {
        this.ucmdbProject = ucmdbProject;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(wizardName);
        this.showDirection = showDirection;
        this.showDepthLimit = showDepthLimit;
        this.params = params;
        this.showExcludedDSPage = showExcludedDSPage;
        this.multipleSelection = multipleSelection;
        this.set("selectMultipleInputs", Boolean.TRUE);
        this.init();
    }

    public void init() {
        if (this.params == null) {
            if (this.ucmdbProject) {
                SelectSingleFromListPage appssp = new SelectSingleFromListPage("application name page");
                ApplicationsProvider appProv = new ApplicationsProvider(this);
                appssp.setSelectionKey("selected applications");
                appssp.setItemProvider((SelectSingleFromListPage.ListDetailProvider)appProv);
                this.addPage((IWizardPage)appssp);
            }
            this.vbp = new VariableOrBrowsePage(VARIABLE_OR_BROWSE_PAGE_KEY, this.showDirection, this.showDepthLimit);
            this.addPage((IWizardPage)this.vbp);
            this.addPage((IWizardPage)new ProgramOrIncludePage("program or include"));
            SelectSingleFromListPage ssp = new SelectSingleFromListPage("select single from list");
            ProgramsProvider poiip = new ProgramsProvider(this);
            ssp.setSelectionKey("selected id");
            poiip.setFilter(new SkipNoVariableEntities());
            ssp.setItemProvider((SelectSingleFromListPage.ListDetailProvider)poiip);
            this.addPage((IWizardPage)ssp);
            MultiSelectionPage sp = null;
            if (this.multipleSelection) {
                sp = new MultiSelectionPage(SELECT_PROGRAMS_USING_INCLUDE, false);
                sp.setTitle(Messages.getString(ImpactReportWizard.class, "prg.selection"));
                sp.setDescription(Messages.getString(ImpactReportWizard.class, "prg.selection.descr"));
                sp.setSelectedPropName("selectPrgUsingIncl");
                ProgramsUsingIncludeCollector pc = new ProgramsUsingIncludeCollector(this, "selected id");
                sp.setResourcesCollector((ResourcesCollector)pc);
                this.addPage((IWizardPage)sp);
            }
            SelectSingleFromListPage dbTablesPage = new SelectSingleFromListPage("selectDBTable");
            DBTableProvider tblProv = new DBTableProvider();
            dbTablesPage.setSelectionKey("selectedDBTableID");
            dbTablesPage.setItemProvider((SelectSingleFromListPage.ListDetailProvider)tblProv);
            dbTablesPage.setDescription(tblProv.getDescription());
            this.addPage((IWizardPage)dbTablesPage);
            Object dbFieldsPage = new SelectDBFieldPage("selectDBField");
            DBFieldProvider fieldProv = new DBFieldProvider(this);
            dbFieldsPage.setSelectionKey("selectedFieldID");
            dbFieldsPage.setItemProvider(fieldProv);
            dbFieldsPage.setDescription(fieldProv.getDescription());
            this.addPage((IWizardPage)dbFieldsPage);
        } else {
            ImpactSettingsPage isp = new ImpactSettingsPage(VARIABLE_OR_BROWSE_PAGE_KEY, this.showDirection);
            this.addPage((IWizardPage)isp);
            if (!this.isStartedOnDBField()) {
                List prgInp = (List)this.params.get("selected resources");
                ArrayList<SelectSingleFromListPage.ArrayListItem> items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
                boolean isInclude = false;
                for (ProgramInputNoGUI pi : prgInp) {
                    SelectSingleFromListPage.ArrayListItem item = new SelectSingleFromListPage.ArrayListItem();
                    items.add(item);
                    Integer typeCode = pi.getTypeCode();
                    if (typeCode != -100) {
                        String[] prgSel = new String[]{pi.getName(), String.valueOf(pi.getProgramID()), "", String.valueOf(typeCode)};
                        this.set("selectionOnPrograms", Boolean.TRUE);
                        item.setStringArray(prgSel);
                        continue;
                    }
                    isInclude = true;
                    String[] inclSel = new String[]{pi.getName(), String.valueOf(pi.getProgramID())};
                    this.set("selectionOnPrograms", Boolean.FALSE);
                    item.setStringArray(inclSel);
                    this.params.remove("selected resources");
                }
                this.set("selected id", items);
                MultiSelectionPage sp = null;
                if (isInclude && this.multipleSelection) {
                    sp = new MultiSelectionPage(SELECT_PROGRAMS_USING_INCLUDE, false);
                    sp.setTitle(Messages.getString(ImpactReportWizard.class, "prg.selection"));
                    sp.setDescription(Messages.getString(ImpactReportWizard.class, "prg.selection.descr"));
                    sp.setSelectedPropName("selectPrgUsingIncl");
                    ProgramsUsingIncludeCollector pc = new ProgramsUsingIncludeCollector(this, "selected id");
                    sp.setResourcesCollector((ResourcesCollector)pc);
                    this.addPage((IWizardPage)sp);
                }
            }
        }
        if (this.params == null || !this.params.containsKey("selected variable(s)")) {
            if (this.isStartedOnDBField()) {
                Object fieldID = this.params.get("selectedFieldID");
                if (fieldID == null) {
                    SelectDBFieldPage dbFieldsPage = new SelectDBFieldPage("selectDBField");
                    DBFieldProvider fieldProv = new DBFieldProvider(this);
                    dbFieldsPage.setSelectionKey("selectedFieldID");
                    dbFieldsPage.setItemProvider(fieldProv);
                    this.addPage((IWizardPage)dbFieldsPage);
                }
                this.set("selectionOnDBField", Boolean.TRUE);
                this.set("selectedFieldID", fieldID);
                this.set("selectedDBTableID", this.params.get("selectedDBTableID"));
            }
            this.vsp = new SelectVariablePage("variable select page name");
            VariableDetailProvider vdp = new VariableDetailProvider(this, "variable select page name");
            this.vsp.setItemProvider((SelectSingleFromListPage.ListDetailProvider)vdp);
            VariableSelectionVerifier vsf = new VariableSelectionVerifier(true);
            this.vsp.setSelectionVerifier((SelectSingleFromListPage.SelectionVerifier)vsf);
            this.vsp.setPatternFilter((PatternFilter)new VariablePatternFilter());
            this.vsp.setSelectionKey("selected variable(s)");
            this.addPage((IWizardPage)this.vsp);
        }
        String title = Messages.getString(ImpactReportWizard.class, "page.title");
        String description = Messages.getString(ImpactReportWizard.class, "page.description");
        this.blip = new BuildListOfItemsPage(EXCLUDED_VARIABLES_PAGE_KEY, title, description);
        this.blip.setWizardItemKey("excluded variables");
        this.blip.setBrowseAction(new ExpandedBrowseAction());
        this.addPage((IWizardPage)this.blip);
        this.browsePIpage = new ProgramOrIncludePage("pgm_include.page.name");
        this.browsePIpage.setSelectionOnProgramsKey("excluded selectiononprogramskey");
        this.addPage((IWizardPage)this.browsePIpage);
        this.sspExcluded = new SelectSingleFromListPage("excluded.single.list.page.name");
        ProgramsProvider poiip = new ProgramsProvider(this);
        poiip.setSelectionOnProgramsKey("excluded selectiononprogramskey");
        this.sspExcluded.setSelectionKey("excluded key");
        poiip.setFilter(new SkipNoVariableEntities());
        this.sspExcluded.setItemProvider((SelectSingleFromListPage.ListDetailProvider)poiip);
        this.addPage((IWizardPage)this.sspExcluded);
        this.vspExcluded = new SelectSingleFromListPage("excluded.variable.list.page.name");
        VariableDetailProvider vdp = new VariableDetailProvider(this, "excluded key", "excluded selectiononprogramskey", "excludedDBField", "excluded.variable.list.page.name", "excluded.prgusingincl");
        this.vspExcluded.setItemProvider((SelectSingleFromListPage.ListDetailProvider)vdp);
        VariableSelectionVerifier vsf = new VariableSelectionVerifier(true);
        this.vspExcluded.setSelectionVerifier((SelectSingleFromListPage.SelectionVerifier)vsf);
        this.vspExcluded.setPatternFilter((PatternFilter)new VariablePatternFilter());
        this.vspExcluded.setSelectionKey("excluded_varID");
        this.addPage((IWizardPage)this.vspExcluded);
        if (this.showExcludedDSPage) {
            title = Messages.getString(ImpactReportWizard.class, "excludeDatasetsPage.title");
            description = Messages.getString(ImpactReportWizard.class, "excludeDatasetsPage.description");
            SelectDatasetsAndDirectionPage selectExcludedDatasetsPage = new SelectDatasetsAndDirectionPage("Datasets to be excluded", title, description, false, false, true);
            selectExcludedDatasetsPage.setLeftGroupLabel(Messages.getString(ImpactReportWizard.class, "av.object.type"));
            selectExcludedDatasetsPage.setRightGroupLabel(Messages.getString(ImpactReportWizard.class, "sel.object.type"));
            selectExcludedDatasetsPage.setAvailablePropName("not selected datasets");
            selectExcludedDatasetsPage.setSelectedPropName("excluded datasets");
            selectExcludedDatasetsPage.setErrMsgNoResource(Messages.getString(ImpactReportWizard.class, "err.message"));
            boolean showTemporaryDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
            MultipleVSAMCollector ic = new MultipleVSAMCollector();
            if (showTemporaryDatasets) {
                ic.setResourcesQuery("SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID inner JOIN JCLDD ON JCLDDRef.DDID = JCLDD.DDID WHERE JCLPhysicalDataSet.IsInstream<>1 and JCLDD.DDName not in ('STEPLIB', 'JOBLIB', 'PROCLIB') ORDER BY DataSetName,GenerationNumber, MemberName");
            } else {
                ic.setResourcesQuery("SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID inner JOIN JCLDD ON JCLDDRef.DDID = JCLDD.DDID WHERE JCLPhysicalDataSet.IsInstream<>1 AND JCLPhysicalDataSet.Istemp<>1  and JCLDD.DDName not in ('STEPLIB', 'JOBLIB', 'PROCLIB') ORDER BY DataSetName,GenerationNumber, MemberName");
            }
            selectExcludedDatasetsPage.setResourcesCollector((ResourcesCollector)ic);
            this.addPage((IWizardPage)selectExcludedDatasetsPage);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.set("datesetflow is limited", false);
    }

    public boolean canFinish() {
        IWizardPage excluded;
        boolean ret = false;
        IWizardPage current = this.getContainer().getCurrentPage();
        if (current == (excluded = this.getPage(EXCLUDED_VARIABLES_PAGE_KEY)) || current == this.getPage("Datasets to be excluded")) {
            ret = true;
        } else if (current == this.getPage("programs page") && current.getNextPage() == excluded || current == this.getPage(VARIABLE_OR_BROWSE_PAGE_KEY) && (this.getValue("variableName") != null || this.params != null && this.params.get("selected variable(s)") != null) || current == this.getPage("selectDBField")) {
            ret = current.isPageComplete();
        } else {
            ret = super.canFinish();
            if (current == this.vspExcluded) {
                ret = this.vspExcluded.isPageComplete();
            }
        }
        return ret;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (EXCLUDED_VARIABLES_PAGE_KEY.equals(page.getName())) {
            return super.getNextPage(page);
        }
        if ("program or include".equals(page.getName())) {
            return this.getPage("select single from list");
        }
        if ("select single from list".equals(page.getName())) {
            Boolean forPrograms = (Boolean)this.getValue("selectionOnPrograms");
            if (forPrograms != null) {
                if (Boolean.TRUE.equals(forPrograms)) {
                    return this.getPage("variable select page name");
                }
                if (this.multipleSelection) {
                    return this.getPage(SELECT_PROGRAMS_USING_INCLUDE);
                }
                return this.getPage("variable select page name");
            }
        } else if (SELECT_PROGRAMS_USING_INCLUDE.equals(page.getName())) {
            return this.getPage("variable select page name");
        }
        if (page == this.vspExcluded) {
            return this.excludedVarAdded ? super.getNextPage(page) : null;
        }
        return super.getNextPage(page);
    }

    public boolean cancelPressed() {
        boolean ret = true;
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.vspExcluded || page == this.sspExcluded || page == this.browsePIpage) {
            ((ReportWizardDialog)this.getContainer()).getButton(16).setText(IDialogConstants.FINISH_LABEL);
            this.clearSelections();
            this.getContainer().showPage((IWizardPage)this.blip);
            ret = false;
        }
        return ret;
    }

    protected boolean buttonPressed(int buttonId) {
        boolean ret = true;
        IWizardPage page = this.getContainer().getCurrentPage();
        if (buttonId == 14) {
            if (page == this.vspExcluded || page == this.sspExcluded || page == this.browsePIpage) {
                ((ReportWizardDialog)this.getContainer()).getButton(16).setText(IDialogConstants.FINISH_LABEL);
                this.clearSelections();
                this.getContainer().showPage((IWizardPage)this.blip);
                ret = false;
            } else if (page == this.blip) {
                if (this.vbp != null && !this.getPage("program or include").isPageComplete()) {
                    page.setPreviousPage((IWizardPage)this.vbp);
                } else {
                    page.setPreviousPage((IWizardPage)this.vsp);
                }
                ret = true;
            }
        } else if (buttonId == 15) {
            if (page == this.sspExcluded) {
                this.excludedVarAdded = false;
            }
        } else if (buttonId == 16 && page == this.vspExcluded) {
            ((ReportWizardDialog)this.getContainer()).getButton(16).setText(IDialogConstants.FINISH_LABEL);
            this.excludedVarAdded = false;
            if (buttonId == 16) {
                Properties p = new Properties();
                SelectSingleFromListPage.ArrayListItem prgInclSelection = (SelectSingleFromListPage.ArrayListItem)this.getValue("excluded key");
                String[] array = prgInclSelection.getStringArray();
                p.setProperty("resourceName", array[0]);
                p.setProperty("resourceID/Path", array[1]);
                String[] vararray = ((SelectSingleFromListPage.ArrayListItem)this.getValue("excluded_varID")).getStringArray();
                p.setProperty("varID", vararray[0]);
                p.setProperty("iLevel", vararray[1]);
                p.setProperty("varName", vararray[2]);
                p.setProperty("startRow", vararray[6]);
                if (Utils.filterNullValue((String)vararray[7]) != null) {
                    p.setProperty("paragraph", vararray[7]);
                }
                Boolean isProgram = (Boolean)this.getValue("excluded selectiononprogramskey");
                p.setProperty("isProgram", isProgram.toString());
                this.blip.addEntry(p);
                this.clearSelections();
                this.excludedVarAdded = true;
            }
            this.getContainer().showPage((IWizardPage)this.blip);
            ret = false;
        }
        return ret;
    }

    private void clearSelections() {
        this.set("excluded_varID", null);
        this.set("excluded key", null);
        this.vspExcluded.setPageComplete(false);
        this.sspExcluded.setPageComplete(false);
        this.browsePIpage.setPageComplete(false);
    }

    private boolean isStartedOnDBField() {
        Object p;
        boolean ret = false;
        Object object = p = this.params != null ? this.params.get("selectionOnDBField") : null;
        if (p != null && (ret = ((Boolean)p).booleanValue())) {
            ret = this.params.get("selectedFieldID") != null || this.params.get("selectedDBTableID") != null;
        }
        return ret;
    }

    class ExpandedBrowseAction
    implements Runnable {
        ExpandedBrowseAction() {
        }

        @Override
        public void run() {
            ImpactReportWizard.this.getContainer().showPage((IWizardPage)ImpactReportWizard.this.browsePIpage);
            String btnText = Messages.getString(ImpactReportWizard.class, "add.btn.txt");
            Button addToListButton = ((ReportWizardDialog)ImpactReportWizard.this.getContainer()).getButton(16);
            GridData gd = new GridData();
            gd.minimumWidth = 200;
            addToListButton.setText(btnText);
            addToListButton.setLayoutData((Object)gd);
            ImpactReportWizard.this.getContainer().getShell().pack();
        }
    }
}

