/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.VariableOrBrowsePage;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImpactBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactBuilder.class);
    protected boolean resultsInitialized;
    protected String appName = null;
    protected Map<String, Properties> selectedInputsDetails;
    protected Map<String, String> resourcesDetails;
    protected String startVarName = null;
    protected Collection<String> selectedIDs;
    protected String dbTable = null;
    protected String dbField = null;
    private Map<String, String> programs;
    private Map<String, Properties> excludedVars;
    private List<VSAMInput> excludedDS;
    private Integer direction;
    public static final String APP_NAME = "APPLICATION_NAME";
    public static final String PROGRAMS_MAP = "program map";
    public static final String DIRECTION = "direction";
    public static final String START_VARIABLE_NAME = "start_var_name";
    public static final String EXCLUDED_VARIABLES = "excluded variables";
    public static final String EXCLUDED_DATASETS = "excluded datasets";
    public static final String VARIABLES_DETAILS = "variables_details";
    public static final String RESOURCES_MAP = "resources_map";
    public static final String MAX_CYCLES = "max cycles";
    protected boolean readFromInputs = true;
    public static final String SELECT_DB_FIELD_PAGE_KEY = "selectDBField";
    public static final String SELECTED_DBFIELD_ID = "selectedFieldID";
    public static final String SELECTED_DB_TABLE_ID = "selectedDBTableID";
    public static final String SELECTION_ON_DBFIELD = "selectionOnDBField";
    public static final String SELECT_DB_TABLE_PAGE_KEY = "selectDBTable";
    public static final String SELECT_MULTIPLE_INPUTS = "selectMultipleInputs";
    public static final String EXCLUDED_DATASETS_APPENDIX_DS_KEY = "excludedDatasets";
    public static final String DATASET_FLOW_LIMITATION_APPENDIX_DS_KEY = "datasetFlowLimitation";
    public static final String IGNORED_VARS_SUMMARY_KEY = "ignoredVarsSummary";
    public static final String IGNORED_VARS_SUMMARY_LABEL_KEY = "ignoredVarsSummaryLabel";
    public static final String EXCLUDED_DATASETS4_APPENDIX_KEY = "excludedDatasets4Appendix";
    protected static final String IGNORED_DATASETS_SUMMARY_LABEL_KEY = "ignoredDatasetsSummaryLabel";
    public static final String SELECT_PRG_USING_INCL = "selectPrgUsingIncl";

    public void setInputs(Map<String, Object> inputs) {
        super.setInputs(inputs);
        this.readFromInputs = this.inputs.get("report_model") == null;
    }

    protected void initialize(IProgressMonitor monitor) {
        if (!this.resultsInitialized) {
            if (this.readFromInputs) {
                Boolean dsLimited;
                List excluded;
                this.direction = (Integer)this.inputs.get("impact direction");
                this.excludedVars = (Map)this.inputs.get(EXCLUDED_VARIABLES);
                if (this.excludedVars != null) {
                    this.updateExcludedFromInclude(this.excludedVars, monitor);
                }
                if ((excluded = (List)this.inputs.get(EXCLUDED_DATASETS)) != null) {
                    this.excludedDS = BaseResourceInput4GUI.extractNonGUIObjects((Collection)excluded);
                }
                if ((dsLimited = (Boolean)this.inputs.get("datesetflow is limited")) != null && dsLimited.booleanValue()) {
                    Integer dsLimit = (Integer)this.inputs.get("datasetflow threshold");
                    this.report.addProperty("datasetflow threshold", (Object)dsLimit);
                }
                this.report.addProperty(DIRECTION, (Object)this.direction);
                this.startVarName = (String)this.inputs.get("variableName");
                if (this.startVarName == null) {
                    SelectSingleFromListPage.ArrayListItem appList;
                    Object selVars = this.inputs.get("selected variable(s)");
                    Set<SelectSingleFromListPage.ArrayListItem> results = new HashSet<SelectSingleFromListPage.ArrayListItem>();
                    if (selVars instanceof Collection) {
                        results.addAll((Collection)selVars);
                    } else {
                        results.add((SelectSingleFromListPage.ArrayListItem)selVars);
                    }
                    List<Integer> prgToFilter = this.getToFilterPrograms();
                    results = this.updateIdsFromInclude(results, prgToFilter, monitor);
                    Boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
                    if (projectIsUCMDB != null && projectIsUCMDB.booleanValue() && (appList = (SelectSingleFromListPage.ArrayListItem)this.inputs.get("selected applications")) != null) {
                        String[] apps = appList.getStringArray();
                        HashSet<String> appNames = new HashSet<String>();
                        appNames.add(apps[0]);
                        if (appNames != null && appNames.size() == 1) {
                            this.appName = (String)appNames.iterator().next();
                        } else {
                            L.error("multiple application selection is not allowed in project");
                            throw new RuntimeException("project is not prepared for multiple application selection");
                        }
                    }
                    this.report.addProperty(APP_NAME, (Object)this.appName);
                    List selected = null;
                    if (this.isStartedOnDBField()) {
                        SelectSingleFromListPage.ArrayListItem s = (SelectSingleFromListPage.ArrayListItem)this.inputs.get(SELECTED_DBFIELD_ID);
                        this.dbField = s.getStringArray()[0];
                        s = (SelectSingleFromListPage.ArrayListItem)this.inputs.get(SELECTED_DB_TABLE_ID);
                        this.dbTable = s.getStringArray()[0];
                        HashMap<String, String> prgs = new HashMap<String, String>();
                        for (SelectSingleFromListPage.ArrayListItem itm : results) {
                            String[] cols = itm.getStringArray();
                            if (cols.length == 15) {
                                prgs.put(cols[8], cols[14]);
                                continue;
                            }
                            if (cols.length != 16) continue;
                            prgs.put(cols[8], cols[15]);
                        }
                        this.report.addProperty(PROGRAMS_MAP, prgs);
                    } else if (this.inputs.get("selected id") instanceof SelectSingleFromListPage.ArrayListItem) {
                        selected = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
                        selected.add((SelectSingleFromListPage.ArrayListItem)this.inputs.get("selected id"));
                    } else {
                        selected = (List)this.inputs.get("selected id");
                    }
                    if (selected != null) {
                        this.resourcesDetails = new HashMap<String, String>();
                        for (SelectSingleFromListPage.ArrayListItem it : selected) {
                            this.resourcesDetails.put(it.getStringArray()[1], it.getStringArray()[0]);
                        }
                    }
                    this.selectedIDs = this.getIDs(results);
                    this.report.setInput(this.selectedIDs);
                    if (!this.isStartedOnDBField()) {
                        this.programs = this.getPrograms(results);
                        this.report.addProperty(PROGRAMS_MAP, this.programs);
                    }
                    this.report.addProperty(VARIABLES_DETAILS, this.selectedInputsDetails);
                    this.report.addProperty(RESOURCES_MAP, this.resourcesDetails);
                    this.report.addProperty(SELECTED_DB_TABLE_ID, this.inputs.get(SELECTED_DB_TABLE_ID));
                    this.report.addProperty(SELECTED_DBFIELD_ID, this.inputs.get(SELECTED_DBFIELD_ID));
                } else {
                    this.report.addProperty(START_VARIABLE_NAME, (Object)this.startVarName);
                }
                this.report.addProperty(EXCLUDED_VARIABLES, this.excludedVars);
                this.report.addProperty(EXCLUDED_DATASETS, this.excludedDS);
                this.readFromInputs = false;
            } else {
                this.selectedIDs = (Collection)this.report.getProperty("inputs");
                this.appName = (String)this.report.getProperty(APP_NAME);
                this.resourcesDetails = (Map)this.report.getProperty(RESOURCES_MAP);
                this.selectedInputsDetails = (Map)this.report.getProperty(VARIABLES_DETAILS);
                this.programs = (Map)this.report.getProperty(PROGRAMS_MAP);
                this.startVarName = (String)this.report.getProperty(START_VARIABLE_NAME);
                this.direction = (Integer)this.report.getProperty(DIRECTION);
                this.excludedVars = (Map)this.report.getProperty(EXCLUDED_VARIABLES);
                this.excludedDS = (List)this.report.getProperty(EXCLUDED_DATASETS);
            }
            this.resultsInitialized = true;
        }
    }

    protected List<Integer> getToFilterPrograms() {
        ArrayList prgInputs = (ArrayList)this.inputs.get(SELECT_PRG_USING_INCL);
        ArrayList<Integer> prgToFilter = null;
        if (prgInputs != null) {
            prgToFilter = new ArrayList<Integer>();
            for (ProgramInput pi : prgInputs) {
                prgToFilter.add(pi.getProgramID());
            }
        }
        return prgToFilter;
    }

    private void updateExcludedFromInclude(final Map<String, Properties> excludedVars, IProgressMonitor monitor) {
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection bridge, IProgressMonitor pmonitor) {
                    for (String key : excludedVars.keySet()) {
                        Properties p = (Properties)excludedVars.get(key);
                        String varID = p.getProperty("varID");
                        if (!"-100".equals(varID)) continue;
                        String pathId = p.getProperty("resourceID/Path");
                        String varName = p.getProperty("varName");
                        String startRow = p.getProperty("startRow");
                        String query = ImpactBuilder.this.createQueryToUpdateIdsFromInclude(bridge, varName, startRow, pathId, false, true, false);
                        try {
                            String[][] rez = bridge.executeSQL(query);
                            if (rez.length <= 0) continue;
                            new ArrayList();
                            p.setProperty("varIDNumber", String.valueOf(rez.length));
                            int i = 0;
                            String[][] stringArray = rez;
                            int n = rez.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] row = stringArray[n2];
                                p.setProperty(String.valueOf(varName) + "." + i, row[0]);
                                ++i;
                                ++n2;
                            }
                        }
                        catch (EZSourceNativeException e) {
                            L.error("cannot retrieve ID for include", (Throwable)e);
                            throw new RuntimeException("cannot connect to Application Discovery build");
                        }
                    }
                }
            }, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
    }

    private String createQueryToUpdateIdsFromInclude(EZSourceConnection bridge, String varName, String startRow, String pathID, boolean isFiller, boolean excludedVar, boolean filterByPrg) {
        SelectSingleFromListPage.ArrayListItem appList;
        String IDENTIFY_INCLUDE_VAR_PREFIX = "SELECT Variables.VarID, ProgramAliases.ProgramId, ProgramAliases.AliasName AS ProgramName \n" + (isFiller ? ", Variables.VarName " : "") + "FROM (Variables INNER JOIN Occurrences ON Variables.OccurID = Occurrences.OccurID) " + "INNER JOIN ProgramAliases ON Occurrences.ProgID = ProgramAliases.ProgramId and ProgramAliases.AliasType = 0 ";
        String IDENTIFY_INCLUDE_VAR_UCMDB_PREFIX = "SELECT Variables.VarID, Programs.ProgramID, Programs.ProgramName " + (isFiller ? ", Variables.VarName " : "") + " FROM (" + "Components " + "INNER JOIN (" + "(Variables " + "INNER JOIN Occurrences " + "\t\t\tON Variables.OccurID = Occurrences.OccurID" + ") " + "INNER JOIN Programs " + "\t\t\tON Occurrences.ProgID = Programs.ProgramID " + ") \tON Components.ResourceID = Occurrences.ProgID " + ") " + "INNER JOIN (" + "Applications " + "INNER JOIN AppToComponents " + "\t\t\tON Applications.ApplicationID = AppToComponents.ApplicationID" + ") " + "\tON Components.ComponentID = AppToComponents.ComponentID";
        StringBuilder wcBuf = new StringBuilder(" WHERE ");
        String query = IDENTIFY_INCLUDE_VAR_PREFIX;
        Boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (projectIsUCMDB != null && projectIsUCMDB.booleanValue() && (appList = (SelectSingleFromListPage.ArrayListItem)this.inputs.get("selected applications")) != null) {
            String[] apps = appList.getStringArray();
            HashSet<String> ids = new HashSet<String>();
            ids.add(apps[1]);
            if (ids.size() == 0 || ids.size() > 1) {
                throw new IllegalArgumentException("report is not built for multiple or no application selection");
            }
            String appId = (String)ids.iterator().next();
            wcBuf.append("(Components.ResourceType = 5)  AND (Applications.ApplicationID = ");
            wcBuf.append(appId);
            wcBuf.append(") AND ");
            query = IDENTIFY_INCLUDE_VAR_UCMDB_PREFIX;
        }
        if (isFiller) {
            wcBuf.append("(Variables.VarName LIKE 'FILLER%') AND ");
        } else if (excludedVar) {
            wcBuf.append("(Variables.VarName='").append(varName).append("') AND ");
        } else if (filterByPrg) {
            wcBuf.append("(Variables.ProgIDReference in (Select ProgramID from " + com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)bridge, (String)"numeric_param_temp") + ")) AND ");
        }
        wcBuf.append("(Occurrences.StartRow = ").append(startRow).append(") AND ");
        wcBuf.append("(Occurrences.PathID = ").append(pathID).append(")");
        return String.valueOf(query) + wcBuf.toString();
    }

    boolean isFiller(String[] row) {
        if (row == null) {
            return false;
        }
        return row[5].equals("-1");
    }

    private Set<SelectSingleFromListPage.ArrayListItem> updateIdsFromInclude(final Set<SelectSingleFromListPage.ArrayListItem> selectedSet, final List<Integer> prgToFilter, IProgressMonitor monitor) {
        final HashSet<SelectSingleFromListPage.ArrayListItem> updated = new HashSet<SelectSingleFromListPage.ArrayListItem>();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection bridge, IProgressMonitor pmonitor) {
                    for (SelectSingleFromListPage.ArrayListItem ali : selectedSet) {
                        String[] selected = ali.getStringArray();
                        if (selected[0].equals("-100")) {
                            boolean isFiller = ImpactBuilder.this.isFiller(selected);
                            String query = ImpactBuilder.this.createQueryToUpdateIdsFromInclude(bridge, selected[2], selected[6], selected[8], isFiller, false, prgToFilter != null);
                            try {
                                String[][] rez = null;
                                if (prgToFilter != null) {
                                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[prgToFilter.size()]);
                                    Collections.fill(types, EZSourceDataType.Integer);
                                    rez = bridge.executeSQL(query, types, prgToFilter);
                                } else {
                                    rez = bridge.executeSQL(query);
                                }
                                if (rez == null) continue;
                                int idIdx = 0;
                                while (idIdx < rez.length) {
                                    SelectSingleFromListPage.ArrayListItem clone = (SelectSingleFromListPage.ArrayListItem)ali.clone();
                                    clone.setElementAt(0, rez[idIdx][0]);
                                    clone.setElementAt(8, rez[idIdx][1]);
                                    clone.appendStringToArray(rez[idIdx][2]);
                                    if (isFiller) {
                                        if (rez[idIdx].length < 4) {
                                            L.warn("wrong results for details; use the same name for this FILLER: {}", (Object)rez[idIdx][0]);
                                        } else {
                                            clone.setElementAt(2, rez[idIdx][3]);
                                        }
                                    }
                                    updated.add(clone);
                                    ++idIdx;
                                }
                                continue;
                            }
                            catch (EZSourceNativeException e) {
                                L.error("cannot retrieve ID for include", (Throwable)e);
                                throw new RuntimeException("cannot connect to Application Discovery build");
                            }
                        }
                        updated.add(ali);
                    }
                }
            }, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return updated;
    }

    private Set<SelectSingleFromListPage.ArrayListItem> updateIdsFromIncludevechi(Set<SelectSingleFromListPage.ArrayListItem> selectedSet) {
        HashSet<SelectSingleFromListPage.ArrayListItem> updated = new HashSet<SelectSingleFromListPage.ArrayListItem>();
        String IDENTIFY_INCLUDE_VAR_PREFIX = "SELECT Variables.VarID, Programs.ProgramID, Programs.ProgramName\r\nFROM (Variables INNER JOIN Occurrences ON Variables.OccurID = Occurrences.OccurID) INNER JOIN Programs ON Occurrences.ProgID = Programs.ProgramID";
        String IDENTIFY_INCLUDE_VAR_UCMDB_PREFIX = "SELECT Variables.VarID, Programs.ProgramID, Programs.ProgramName\r\nFROM (Components INNER JOIN ((Variables INNER JOIN Occurrences \t\t\tON Variables.OccurID = Occurrences.OccurID) INNER JOIN Programs \t\t\tON Occurrences.ProgID = Programs.ProgramID) ON Components.ResourceID = Occurrences.ProgID)      INNER JOIN (Applications INNER JOIN AppToComponents \t\t\t\t\tON Applications.ApplicationID = AppToComponents.ApplicationID) \t\t\tON Components.ComponentID = AppToComponents.ComponentID";
        for (SelectSingleFromListPage.ArrayListItem ali : selectedSet) {
            String[] selected = ali.getStringArray();
            if (selected[0].equals("-100")) {
                SelectSingleFromListPage.ArrayListItem appList;
                StringBuffer wcBuf = new StringBuffer(" WHERE ");
                String query = IDENTIFY_INCLUDE_VAR_PREFIX;
                boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
                if (projectIsUCMDB && (appList = (SelectSingleFromListPage.ArrayListItem)this.inputs.get("selected applications")) != null) {
                    String[] apps = appList.getStringArray();
                    HashSet<String> ids = new HashSet<String>();
                    ids.add(apps[1]);
                    if (ids.size() == 0 || ids.size() > 1) {
                        throw new IllegalArgumentException("report is not built for multiple or no application selection");
                    }
                    String appId = (String)ids.iterator().next();
                    wcBuf.append("(Components.ResourceType = 5)  AND (Applications.ApplicationID = ");
                    wcBuf.append(appId);
                    wcBuf.append(") AND ");
                    query = IDENTIFY_INCLUDE_VAR_UCMDB_PREFIX;
                }
                String varName = selected[2];
                String startRow = selected[6];
                String pathID = selected[8];
                wcBuf.append("(Variables.VarName='").append(varName).append("') AND ");
                wcBuf.append("(Occurrences.StartRow = ").append(startRow).append(") AND ");
                wcBuf.append("(Occurrences.PathID = ").append(pathID).append(")");
                query = String.valueOf(query) + wcBuf.toString();
                EZSourceConnection bridge = null;
                try {
                    try {
                        bridge = EZSourceConnectionManager.getCurrent();
                        String[][] rez = bridge.executeSQL(query);
                        int idIdx = 0;
                        while (idIdx < rez.length) {
                            SelectSingleFromListPage.ArrayListItem clone = (SelectSingleFromListPage.ArrayListItem)ali.clone();
                            clone.setElementAt(0, rez[idIdx][0]);
                            clone.setElementAt(8, rez[idIdx][1]);
                            clone.appendStringToArray(rez[idIdx][2]);
                            updated.add(clone);
                            ++idIdx;
                        }
                        continue;
                    }
                    catch (EZSourceNativeException e) {
                        L.error("cannot retrieve ID for include", (Throwable)e);
                        throw new RuntimeException("cannot connect to Application Discovery build");
                    }
                }
                finally {
                    if (bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                }
            }
            updated.add(ali);
        }
        return updated;
    }

    protected Collection getSelected() {
        if (this.selectedIDs == null) {
            L.warn("no IDs!");
        }
        return this.selectedIDs;
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        this.addLocaleParameter(params);
        this.parameters.put("resourcesSummary", Messages.getString(ImpactBuilder.class, "resources.summary"));
    }

    /*
     * WARNING - void declaration
     */
    protected void titleParameters(Map<String, Object> params) {
        void var9_28;
        String dirStr;
        String varName;
        String resourceName;
        String varLine;
        String varParagraph;
        Properties p;
        ObjectForSubreport obj;
        String resType = (String)this.report.getProperty("resource_type");
        String externalizedResType = null;
        if (Utils.RESOURCE_TYPE_PROGRAM.equals(resType) || Utils.RESOURCE_TYPE_INCLUDE.equals(resType) && this.programs != null && !this.programs.isEmpty()) {
            externalizedResType = Messages.getString(ImpactBuilder.class, "resourceType.program");
        } else if (Utils.RESOURCE_TYPE_INCLUDE.equals(resType)) {
            externalizedResType = Messages.getString(ImpactBuilder.class, "resourceType.include");
        } else if (this.isStartedOnDBField()) {
            externalizedResType = Messages.getString(ImpactBuilder.class, "resourceType.databaseField");
        } else {
            L.warn("what is the resource type?!");
        }
        String paragraphPart = "";
        ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
        String appendixStr = null;
        if (this.isStartedOnDBField()) {
            Map progs = (Map)this.report.getProperty(PROGRAMS_MAP);
            if (progs != null && !progs.isEmpty()) {
                ArrayList arrayList = new ArrayList(progs.values());
                Collections.sort(arrayList);
                StringBuilder progsStr = new StringBuilder();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String prg = (String)iterator.next();
                    progsStr.append(prg);
                    if (!iterator.hasNext()) continue;
                    progsStr.append(", ");
                }
                appendixStr = this.appName != null ? Messages.getString(ImpactBuilder.class, "appendix.dbfield.withProgramsAndApps.input", new String[]{this.dbField, this.dbTable, progsStr.toString(), this.appName}) : Messages.getString(ImpactBuilder.class, "appendix.dbfield.withPrograms.input", new String[]{this.dbField, this.dbTable, progsStr.toString()});
            } else {
                appendixStr = Messages.getString(ImpactBuilder.class, "appendix.dbfield.input", new String[]{this.dbField, this.dbTable});
            }
            obj = new ObjectForSubreport();
            obj.setExp(appendixStr);
            obj.setExpVal("");
            lst.add(obj);
        } else if (this.appName != null) {
            if (this.startVarName == null) {
                for (String string : this.selectedInputsDetails.keySet()) {
                    p = this.selectedInputsDetails.get(string);
                    String varName2 = p.getProperty("varName");
                    varParagraph = p.getProperty("paragraphName");
                    varLine = p.getProperty("startRow");
                    resourceName = Utils.RESOURCE_TYPE_INCLUDE.equals(resType) ? this.programs.get(p.getProperty("resourceID")) : this.resourcesDetails.get(p.getProperty("resourceID"));
                    String string2 = paragraphPart = varParagraph == null ? "" : String.valueOf(varParagraph) + "; ";
                    appendixStr = varLine != null && !varLine.isEmpty() ? (paragraphPart.isEmpty() ? Messages.getString(ImpactBuilder.class, "appendixStrVarLine", new String[]{varName2, varLine, externalizedResType, resourceName}) : Messages.getString(ImpactBuilder.class, "appendixStrVarParagraphLine", new String[]{varName2, paragraphPart, varLine, externalizedResType, resourceName})) : Messages.getString(ImpactBuilder.class, "appendixStrNoApplication", new String[]{varName2, externalizedResType, resourceName, this.appName});
                    obj = new ObjectForSubreport();
                    obj.setExp(appendixStr);
                    obj.setExpVal("");
                    lst.add(obj);
                }
            } else {
                Object[] objectArray = new String[4];
                objectArray[0] = this.startVarName;
                objectArray[1] = externalizedResType;
                objectArray[3] = this.appName;
                appendixStr = Messages.getString(ImpactBuilder.class, "appendixStrWithApplication", objectArray);
            }
        } else if (this.startVarName == null) {
            for (String string : this.selectedInputsDetails.keySet()) {
                p = this.selectedInputsDetails.get(string);
                String varName2 = p.getProperty("varName");
                varParagraph = p.getProperty("paragraphName");
                varLine = p.getProperty("startRow");
                resourceName = Utils.RESOURCE_TYPE_INCLUDE.equals(resType) ? this.programs.get(p.getProperty("resourceID")) : this.resourcesDetails.get(p.getProperty("resourceID"));
                String string3 = paragraphPart = varParagraph == null ? "" : varParagraph;
                appendixStr = varLine != null && !varLine.isEmpty() ? (paragraphPart.isEmpty() ? Messages.getString(ImpactBuilder.class, "appendixStrVarLine", new String[]{varName2, varLine, externalizedResType, resourceName}) : Messages.getString(ImpactBuilder.class, "appendixStrVarParagraphLine", new String[]{varName2, paragraphPart, varLine, externalizedResType, resourceName})) : Messages.getString(ImpactBuilder.class, "appendixStrNoApplication", new String[]{varName2, externalizedResType, resourceName});
                obj = new ObjectForSubreport();
                obj.setExp(appendixStr);
                obj.setExpVal("");
                lst.add(obj);
            }
        } else {
            appendixStr = Messages.getString(ImpactBuilder.class, "appendixStrNoApplicationStartVar", new String[]{this.startVarName});
            obj = new ObjectForSubreport();
            obj.setExp(appendixStr);
            obj.setExpVal("");
            lst.add(obj);
        }
        params.put("inputResources", lst);
        if (this.excludedVars != null && this.excludedVars.size() > 0) {
            params.put(IGNORED_VARS_SUMMARY_LABEL_KEY, Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.label"));
            lst = new ArrayList();
            for (String key : this.excludedVars.keySet()) {
                Properties entryProp = this.excludedVars.get(key);
                String resourceName2 = entryProp.getProperty("resourceName");
                String isProgram = entryProp.getProperty("isProgram");
                String startRow = entryProp.getProperty("startRow");
                String paragraph = entryProp.getProperty("paragraph");
                String txt = varName = entryProp.getProperty("varName");
                String resTypeStr = null;
                Boolean hasParagraph = false;
                Boolean hasLine = false;
                if (resourceName2 != null && !resourceName2.isEmpty()) {
                    resTypeStr = Boolean.valueOf(isProgram) != false ? Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.resourcetype.program") : Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.resourcetype.include");
                }
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)paragraph) != null && !paragraph.isEmpty()) {
                    hasParagraph = true;
                }
                if (startRow != null && !startRow.isEmpty()) {
                    hasLine = true;
                }
                if (!hasParagraph.booleanValue() && !hasLine.booleanValue()) {
                    if (resTypeStr != null) {
                        txt = Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.varEntry", new String[]{varName, resTypeStr, resourceName2});
                    }
                } else {
                    txt = hasLine == false ? Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.varEntryWithParagraph", new String[]{varName, resTypeStr, resourceName2, paragraph}) : (hasParagraph != false ? Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.varEntryWithParagraphAndLine", new String[]{varName, resTypeStr, resourceName2, paragraph, startRow}) : Messages.getString(ImpactBuilder.class, "appendix.excludedVariables.varEntryWithLine", new String[]{varName, resTypeStr, resourceName2, startRow}));
                }
                obj = new ObjectForSubreport();
                obj.setExp(txt);
                obj.setExpVal("");
                lst.add(obj);
            }
            params.put(IGNORED_VARS_SUMMARY_KEY, lst);
        }
        Integer lmt = (Integer)this.report.getProperty("datasetflow threshold");
        if (this.excludedDS != null || lmt != null) {
            String string = Messages.getString(ImpactBuilder.class, "appendix.excludedDatasets.label");
            ElementGroupInfo ds = new ElementGroupInfo("");
            DSFactory factory = new DSFactory();
            ArrayList<ObjectForSubreport> objList = null;
            String lmtTitle = Messages.getString(ImpactBuilder.class, "appendix.datasetflow.unlimited");
            if (lmt != null) {
                lmtTitle = Messages.getString(ImpactBuilder.class, "appendix.datasetflow.limited", new String[]{lmt.toString()});
            }
            SC1DataSource elemDS = new SC1DataSource();
            elemDS.setKey(DATASET_FLOW_LIMITATION_APPENDIX_DS_KEY);
            elemDS.setTitle(lmtTitle);
            elemDS.setLayout(5);
            objList = new ArrayList<ObjectForSubreport>();
            elemDS.setList(objList);
            obj = factory.createObj(3, new String[]{"", ""}, null);
            objList.add(obj);
            ds.addDataSource((SubreportDataSource)elemDS);
            if (this.excludedDS != null) {
                elemDS = new SC1DataSource();
                elemDS.setTitle(string);
                elemDS.setKey(EXCLUDED_DATASETS_APPENDIX_DS_KEY);
                elemDS.setLayout(7);
                objList = new ArrayList();
                elemDS.setList(objList);
                ds.addDataSource((SubreportDataSource)elemDS);
                Collections.sort(this.excludedDS);
                int i = 0;
                while (i < this.excludedDS.size()) {
                    this.checkStop();
                    MultipleVSAMInput res1 = (MultipleVSAMInput)this.excludedDS.get(i);
                    MultipleVSAMInput res2 = (MultipleVSAMInput)(++i < this.excludedDS.size() ? this.excludedDS.get(i) : null);
                    obj = new ObjectForSubreport();
                    obj.setExp(ReportsUtils.stripNonValidXMLCharacters((String)res1.getListableName(), (boolean)true));
                    if (res2 != null) {
                        obj.setExpVal(ReportsUtils.stripNonValidXMLCharacters((String)res2.getListableName(), (boolean)true));
                    }
                    objList.add(obj);
                    ++i;
                }
            }
            this.parameters.put(EXCLUDED_DATASETS4_APPENDIX_KEY, ds);
            com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subBase.jasper", (String)"excludedDatasets4AppendixTemplate", (Map)this.parameters);
        }
        String string = "";
        String coverPageRow2 = "";
        if (this.isStartedOnDBField()) {
            String string4 = Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnField", new String[]{this.dbField, this.dbTable});
        } else {
            String string5 = Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVars");
            if (this.selectedInputsDetails != null && !this.selectedInputsDetails.isEmpty()) {
                void var9_19;
                int i = 0;
                Iterator<String> it = this.selectedInputsDetails.keySet().iterator();
                while (it.hasNext() && i < 2 && this.selectedInputsDetails.size() > i) {
                    void var9_24;
                    String key = it.next();
                    Properties p2 = this.selectedInputsDetails.get(key);
                    varName = p2.getProperty("varName");
                    String varParagraph2 = p2.getProperty("paragraphName");
                    String varLine2 = p2.getProperty("startRow");
                    String resourceName3 = Utils.RESOURCE_TYPE_INCLUDE.equals(resType) ? this.programs.get(p2.getProperty("resourceID")) : this.resourcesDetails.get(p2.getProperty("resourceID"));
                    paragraphPart = varParagraph2 == null ? "" : String.valueOf(varParagraph2) + "; ";
                    ++i;
                    if (varLine2 != null && !varLine2.isEmpty()) {
                        if (resourceName3 != null) {
                            String string6 = String.valueOf(var9_19) + Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarWithParagraphAndResrs", new String[]{varName, paragraphPart, varLine2, externalizedResType, resourceName3});
                        } else {
                            String string7 = String.valueOf(var9_19) + Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarWithParagraphNoResrs", new String[]{varName, paragraphPart, varLine2, externalizedResType, resourceName3});
                        }
                    } else if (resourceName3 != null) {
                        String string8 = String.valueOf(var9_19) + Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphWithResrs", new String[]{varName == null ? this.startVarName : varName, externalizedResType, resourceName3});
                    } else {
                        String string9 = String.valueOf(var9_19) + Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphNoResrs", new String[]{varName == null ? this.startVarName : varName});
                    }
                    if (i >= this.selectedInputsDetails.size()) continue;
                    String string10 = String.valueOf(var9_24) + ", ";
                }
                if (this.selectedInputsDetails.size() > 2) {
                    String string11 = String.valueOf(var9_19) + Messages.getString(ImpactBuilder.class, "coverPage.row1.multiple.inputs", new String[]{String.valueOf(this.selectedInputsDetails.size() - 2)});
                }
            } else {
                String string12 = String.valueOf(string5) + Messages.getString(ImpactBuilder.class, "coverPage.row1.startOnVarNoParagraphNoResrs", new String[]{this.startVarName});
            }
        }
        Object depth = this.getReportModel().getProperty(MAX_CYCLES);
        boolean noDepth = depth == null || (Integer)depth == 0;
        String string13 = dirStr = this.direction != null ? ImpactBuilder.getDirectionStr(this.direction) : null;
        if (dirStr != null) {
            coverPageRow2 = noDepth ? Messages.getString(ImpactBuilder.class, "coverPage.row2.directionNoDepth", new String[]{dirStr}) : Messages.getString(ImpactBuilder.class, "coverPage.row2.directionAndDepth", new String[]{dirStr, "" + depth});
        } else if (!noDepth) {
            coverPageRow2 = Messages.getString(ImpactBuilder.class, "coverPage.row2.depthNoDirection", new String[]{"" + depth});
        }
        params.put("title.varName", var9_28);
        if (coverPageRow2 != null) {
            params.put("title.resourceName", coverPageRow2);
        }
        if (this.appName != null) {
            params.put("title.applicationName", Messages.getString(ImpactBuilder.class, "title.applicationName", new String[]{this.appName}));
            params.put("title.appFieldValues", this.appName);
        }
        this.parameters.put("separateColumn", false);
    }

    public static String getDirectionStr(Integer dir) {
        String direction = null;
        if (VariableOrBrowsePage.FORWARD.equals(dir)) {
            direction = Messages.getString(ImpactBuilder.class, "direction.forward");
        } else if (VariableOrBrowsePage.BACKWARD.equals(dir)) {
            direction = Messages.getString(ImpactBuilder.class, "direction.backward");
        }
        return direction;
    }

    private Map<String, String> getPrograms(Collection<SelectSingleFromListPage.ArrayListItem> inputs) {
        HashMap<String, String> ret = null;
        if (inputs != null && !inputs.isEmpty()) {
            ret = new HashMap<String, String>();
            for (SelectSingleFromListPage.ArrayListItem arrayListItem : inputs) {
                String[] cols = arrayListItem.getStringArray();
                if (cols.length != 15) continue;
                ret.put(cols[8], cols[14]);
            }
        }
        return ret;
    }

    private Collection<String> getIDs(Collection<SelectSingleFromListPage.ArrayListItem> inputs) {
        HashSet<String> ret = null;
        if (inputs != null && !inputs.isEmpty()) {
            this.selectedInputsDetails = new HashMap<String, Properties>();
            ret = new HashSet<String>();
            for (SelectSingleFromListPage.ArrayListItem arrayListItem : inputs) {
                ret.add(arrayListItem.getStringArray()[0]);
                String[] details = arrayListItem.getStringArray();
                Properties p = new Properties();
                p.setProperty("varName", details[2]);
                p.setProperty("resourceID", details[8]);
                if (arrayListItem.hasDuplicateName()) {
                    p.setProperty("startRow", details[6]);
                    String paragraph = details[7];
                    if (paragraph != null) {
                        p.setProperty("paragraphName", details[7]);
                    }
                }
                this.selectedInputsDetails.put(details[0], p);
            }
        }
        return ret;
    }

    public JasperPrint getReportDocument() {
        JasperPrint print;
        JasperPrint jasperPrint = print = this.report != null ? this.report.print : null;
        if (print != null) {
            this.report.print.setProperty("pdf_hyperlink_export", "true");
        }
        return print;
    }

    protected boolean isStartedOnDBField() {
        boolean ret = false;
        Object startOnField = this.inputs.get(SELECTION_ON_DBFIELD);
        if (startOnField != null) {
            ret = (Boolean)startOnField;
        }
        return ret;
    }
}

