/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTable;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTableField;
import com.ez.internal.analysis.config.inputs.EZSourceVariable;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ezreport.reports.impact.VariableDetailProvider;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImpactAbstractAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactAbstractAnalysis.class);
    public static final String SELECT_SINGLE_PROG_OR_INCLUDE_PAGE_NAME = "select single from list";

    public ImpactAbstractAnalysis() {
        this(null);
    }

    public ImpactAbstractAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null && inputs.size() > 0) {
            Object obj = inputs.get(0);
            if (obj instanceof EZSourceVariable) {
                this.setVariableAsInput(inputs);
            } else if (obj instanceof EZSourceSQLTableField || obj instanceof EZSourceSQLTable) {
                this.setSQLasInput(inputs);
            } else {
                L.debug("input is project, program or include");
                super.setInputs(inputs);
            }
        }
    }

    protected void setSQLasInput(List inputs) {
        L.debug("input is a db field");
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        new ArrayList();
        HashSet inputNames = new HashSet();
        for (Object inpObj : inputs) {
            boolean isField = inpObj instanceof EZSourceSQLTableField;
            if (!isField && !(inpObj instanceof EZSourceSQLTable)) continue;
            EZObjectType fieldObj = (EZObjectType)inpObj;
            EZEntityID entity = fieldObj.getEntID();
            list.add(entity);
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
            if (prjSg == null) continue;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            this.setParams(null);
            SelectSingleFromListPage.ArrayListItem it = null;
            String tableName = null;
            Integer tableId = null;
            if (isField) {
                EZSourceSQLFieldTableIDSg sg = (EZSourceSQLFieldTableIDSg)((EZObjectType)inpObj).getEntID().getSegment(EZSourceSQLFieldTableIDSg.class);
                String fieldName = sg.getSQLFieldName();
                Integer fieldId = sg.getFieldId();
                if (fieldName != null && fieldId != null) {
                    it = new SelectSingleFromListPage.ArrayListItem();
                    it.setStringArray(new String[]{fieldName, fieldId.toString()});
                    this.params.put("selectedFieldID", it);
                }
                tableName = sg.getSQLTableName();
                tableId = (Integer)fieldObj.getProperty("SqlTableId");
            } else {
                EZSourceSQLTableIDSg sg = (EZSourceSQLTableIDSg)((EZObjectType)inpObj).getEntID().getSegment(EZSourceSQLTableIDSg.class);
                tableName = sg.getSQLTableName();
                tableId = (Integer)fieldObj.getProperty("SqlTableId");
            }
            it = new SelectSingleFromListPage.ArrayListItem();
            it.setStringArray(new String[]{tableName, tableId != null ? tableId.toString() : null});
            this.params.put("selectedDBTableID", it);
            this.params.put("selectionOnDBField", Boolean.TRUE);
            this.addAllContextValues(this.params);
            this.addContextValue("input_list", list);
            this.addContextValue("inputs name string", inputNames);
            break;
        }
    }

    protected void setVariableAsInput(List inputs) {
        L.debug("a variable is input");
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        ArrayList<BaseMainframeResourceInput> sel = new ArrayList<BaseMainframeResourceInput>();
        HashSet<String> inputNames = new HashSet<String>();
        ArrayList<SelectSingleFromListPage.ArrayListItem> items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
        for (Object inpObj : inputs) {
            if (!(inpObj instanceof EZSourceVariable)) continue;
            EZEntityID entity = ((EZSourceVariable)inpObj).getEntID();
            list.add(entity);
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
            if (prjSg == null) continue;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
            String prgName = prgSg.getListableName();
            sel.add((BaseMainframeResourceInput)new ProgramInputNoGUI(prgName, prgSg.getTypeId(), prgSg.getProgramId()));
            inputNames.add(prgName);
            EZSourceVariableIDSg varSg = (EZSourceVariableIDSg)entity.getSegment(EZSourceVariableIDSg.class);
            SelectSingleFromListPage.ArrayListItem item = new SelectSingleFromListPage.ArrayListItem();
            String[] varSel = new String[]{varSg.getVarId(), varSg.getVarLevel(), varSg.getResourceName(), varSg.getPic(), varSg.isField() ? "-1" : "0", varSg.isFiller() ? "-1" : "0", varSg.getVarStartRow(), "VT_NULL", String.valueOf(prgSg.getProgramId()), varSg.getVarFather(), varSg.getVarType(), varSg.getVarProgIdRef(), varSg.getAncestor(), varSg.getVarId()};
            item.setStringArray(varSel);
            items.add(item);
        }
        if (!sel.isEmpty()) {
            this.setParams(sel);
            if (!items.isEmpty()) {
                this.params.put("selected variable(s)", items);
                this.params.put("resource_type", VariableDetailProvider.ENTITY_TYPE);
            }
        }
        this.addAllContextValues(this.params);
        this.addContextValue("input_list", list);
        this.addContextValue("inputs name string", inputNames);
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    protected AnalysisType getAnalysisType() {
        return null;
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            Boolean v1 = (Boolean)params1.get("selectionOnPrograms");
            Boolean v2 = (Boolean)params2.get("selectionOnPrograms");
            if (v1 != null) {
                ret = v1.equals(v2);
                if (ret) {
                    String p1 = (String)params1.get("resource_type");
                    String p2 = (String)params2.get("resource_type");
                    ret = p1 != null ? p1.equals(p2) : p2 == null;
                }
            } else {
                boolean bl = ret = v2 == null;
            }
            if (ret) {
                String var1Name = (String)params1.get("variableName");
                String var2Name = (String)params2.get("variableName");
                if (var1Name != null) {
                    ret = var1Name.equalsIgnoreCase(var2Name);
                } else {
                    boolean bl = ret = var2Name == null;
                }
                if (ret) {
                    Integer dir1 = (Integer)params1.get("impact direction");
                    Integer dir2 = (Integer)params2.get("impact direction");
                    if (dir1 != null) {
                        ret = dir1.equals(dir2);
                    } else {
                        boolean bl = ret = dir2 == null;
                    }
                    if (ret) {
                        Object l1 = params1.get("selected variable(s)");
                        Object l2 = params2.get("selected variable(s)");
                        if (l1 == null && l2 == null) {
                            ret = true;
                        } else if (l1 instanceof SelectSingleFromListPage.ArrayListItem && l2 instanceof SelectSingleFromListPage.ArrayListItem) {
                            SelectSingleFromListPage.ArrayListItem lst1 = (SelectSingleFromListPage.ArrayListItem)params1.get("selected variable(s)");
                            SelectSingleFromListPage.ArrayListItem lst2 = (SelectSingleFromListPage.ArrayListItem)params2.get("selected variable(s)");
                            if (lst1 != null) {
                                Object obj1 = lst1.getObject();
                                if (lst2 != null) {
                                    Object obj2 = lst2.getObject();
                                    ret = obj1 instanceof Object[] && obj2 instanceof Object[] ? Arrays.equals((Object[])obj1, (Object[])obj2) : obj1.equals(obj2);
                                } else {
                                    ret = false;
                                }
                            } else {
                                ret = lst2 == null;
                            }
                        } else {
                            ret = l1 instanceof Collection && l2 instanceof Collection ? l1.equals(l2) : false;
                        }
                        if (ret) {
                            Object obj2;
                            Object obj1;
                            Object lID1 = params1.get("selected id");
                            Object lID2 = params2.get("selected id");
                            if (lID1 == null && lID2 == null) {
                                ret = true;
                            } else if (lID1 instanceof SelectSingleFromListPage.ArrayListItem && lID2 instanceof SelectSingleFromListPage.ArrayListItem) {
                                SelectSingleFromListPage.ArrayListItem lst1 = (SelectSingleFromListPage.ArrayListItem)params1.get("selected id");
                                SelectSingleFromListPage.ArrayListItem lst2 = (SelectSingleFromListPage.ArrayListItem)params2.get("selected id");
                                if (lst1 != null) {
                                    obj1 = lst1.getObject();
                                    if (lst2 != null) {
                                        obj2 = lst2.getObject();
                                        ret = obj1 instanceof Object[] && obj2 instanceof Object[] ? Arrays.equals((Object[])obj1, (Object[])obj2) : obj1.equals(obj2);
                                    } else {
                                        ret = false;
                                    }
                                } else {
                                    ret = lst2 == null;
                                }
                            } else {
                                ret = lID1 instanceof Collection && lID2 instanceof Collection ? lID1.equals(lID2) : false;
                            }
                            if (ret) {
                                ArrayList prg1 = (ArrayList)params1.get("selectPrgUsingIncl");
                                ArrayList prg2 = (ArrayList)params2.get("selectPrgUsingIncl");
                                if (prg1 != null) {
                                    ret = prg1.equals(prg2);
                                } else {
                                    boolean bl = ret = prg2 == null;
                                }
                                if (ret) {
                                    Map excluded1 = (Map)params1.get("excluded variables");
                                    Map excluded2 = (Map)params2.get("excluded variables");
                                    if (excluded1 != null) {
                                        ret = excluded1.equals(excluded2);
                                    } else {
                                        boolean bl = ret = excluded2 == null;
                                    }
                                }
                                if (ret) {
                                    List excludedDS1 = (List)params1.get("excluded datasets");
                                    List excludedDS2 = (List)params2.get("excluded datasets");
                                    if (excludedDS1 != null) {
                                        ret = excludedDS1.equals(excludedDS2);
                                    } else {
                                        boolean bl = ret = excludedDS2 == null;
                                    }
                                }
                                if (ret) {
                                    obj1 = params1.get("max cycles");
                                    obj2 = params2.get("max cycles");
                                    if (obj1 != null) {
                                        ret = obj1.equals(obj2);
                                        if (!ret && (Integer)obj1 == 0 && obj2 == null) {
                                            ret = true;
                                        }
                                    } else {
                                        ret = obj2 == null || (Integer)obj2 == 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected void putDefaultParams() {
        Object sl;
        super.putDefaultParams();
        Object val = this.params.get("selected resources");
        if (val == null && (sl = this.params.get("selected id")) != null) {
            ArrayList<SelectSingleFromListPage.ArrayListItem> selectedList = null;
            if (sl instanceof SelectSingleFromListPage.ArrayListItem) {
                selectedList = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
                selectedList.add((SelectSingleFromListPage.ArrayListItem)sl);
            } else {
                selectedList = (ArrayList<SelectSingleFromListPage.ArrayListItem>)sl;
            }
            for (SelectSingleFromListPage.ArrayListItem selected : selectedList) {
                String[] stringArray = selected.getStringArray();
                String prgName = stringArray[0];
                String prgId = stringArray[1];
                if (stringArray.length > 2) {
                    String prgTypeId = stringArray[3];
                    ArrayList<ProgramInputNoGUI> sel = new ArrayList<ProgramInputNoGUI>();
                    ProgramInputNoGUI input = prgTypeId != null && !prgTypeId.isEmpty() ? new ProgramInputNoGUI(prgName, Integer.valueOf(prgTypeId), Integer.valueOf(prgId)) : new ProgramInputNoGUI(prgName, null, Integer.valueOf(prgId));
                    sel.add(input);
                    this.params.put("selected resources", sel);
                    continue;
                }
                L.debug("an include was selected as input");
            }
        }
        if ((val = this.params.get("show summary only")) == null) {
            this.params.put("show summary only", Boolean.FALSE);
        }
        if ((val = this.params.get("show appendix")) == null) {
            this.params.put("show appendix", Boolean.TRUE);
        }
        if ((val = this.params.get("all resources selected")) == null) {
            this.params.put("all resources selected", Boolean.FALSE);
        }
    }
}

