/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTableProvider
implements SelectSingleFromListPage.ListDetailProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DBTableProvider.class);
    private String title;
    private String entityType = Messages.getString(DBTableProvider.class, "entityType");

    public List<SelectSingleFromListPage.ListItem> getItems(EZSourceConnection bridge, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.setTaskName(Messages.getString(DBTableProvider.class, "get.res.task.name"));
        List<SelectSingleFromListPage.ListItem> items = null;
        String query = "SELECT TableName, SqlTableID FROM SqlTables";
        String[][] rez = null;
        try {
            rez = bridge.executeSQL(query);
        }
        catch (EZSourceConnectionException e) {
            L.error("getItems()", (Throwable)e);
            items = null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (rez != null) {
            items = this.buildResults(rez);
        }
        this.title = Messages.getString(DBTableProvider.class, "title", new String[]{this.entityType});
        return items;
    }

    private List<SelectSingleFromListPage.ListItem> buildResults(String[][] rez) {
        ArrayList<SelectSingleFromListPage.ArrayListItem> items = null;
        if (rez != null && rez.length > 0) {
            items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
            int i = 0;
            while (i < rez.length) {
                SelectSingleFromListPage.ArrayListItem li = new SelectSingleFromListPage.ArrayListItem();
                li.setStringArray(rez[i]);
                items.add(li);
                ++i;
            }
        }
        return items;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return "";
    }

    public String getEntityType() {
        return this.entityType;
    }

    public boolean isCheckBox() {
        return false;
    }

    public boolean hasFilters() {
        return true;
    }
}

