/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFieldProvider
implements SelectSingleFromListPage.ListDetailProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DBFieldProvider.class);
    PrepareReportWizard wiz;
    private String title;
    private String description;
    private String entityType = null;
    private String parentType = null;

    public DBFieldProvider(PrepareReportWizard wizard) {
        this.wiz = wizard;
        this.entityType = Messages.getString(DBFieldProvider.class, "entityType");
        this.parentType = Messages.getString(DBFieldProvider.class, "parentType");
        this.title = Messages.getString(DBFieldProvider.class, "title", new String[]{this.entityType});
    }

    public List<SelectSingleFromListPage.ListItem> getItems(EZSourceConnection bridge, IProgressMonitor monitor) {
        Integer tblID = null;
        String tblName = null;
        try {
            SelectSingleFromListPage.ArrayListItem itm = (SelectSingleFromListPage.ArrayListItem)this.wiz.getValue("selectedDBTableID");
            if (itm != null) {
                tblName = itm.getStringArray()[0];
                if (itm.getStringArray()[1] != null) {
                    tblID = Integer.valueOf(itm.getStringArray()[1]);
                }
            }
        }
        catch (Exception ex) {
            L.warn("", (Throwable)ex);
            tblID = null;
        }
        if (tblID == null && (tblName == null || tblName.isEmpty())) {
            L.warn("no dbTable selected!");
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        sub.setTaskName(Messages.getString(DBFieldProvider.class, "get.res.task.name"));
        String query = "SELECT FieldName,SqlFieldID FROM SqlFields WHERE SqlTableID = ";
        if (tblID == null) {
            query = "SELECT SqlFields.FieldName,SqlFields.SqlFieldID FROM SqlFields INNER JOIN SqlTables ON SqlFields.SqlTableID=SqlTables.SqlTableID WHERE Sqltables.Tablename = '";
            query = String.valueOf(query) + tblName + "'";
        } else {
            query = String.valueOf(query) + tblID;
        }
        List<SelectSingleFromListPage.ListItem> items = null;
        String[][] rez = null;
        try {
            rez = bridge.executeSQL(query);
        }
        catch (EZSourceConnectionException e) {
            L.error("getItems()", (Throwable)e);
            items = null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (rez != null) {
            this.description = Messages.getString(DBFieldProvider.class, "description", new String[]{this.entityType, this.parentType});
            items = this.buildResults(rez);
        } else {
            this.description = Messages.getString(DBFieldProvider.class, "noFields.description");
        }
        return items;
    }

    private List<SelectSingleFromListPage.ListItem> buildResults(String[][] rez) {
        ArrayList<SelectSingleFromListPage.ArrayListItem> items = null;
        if (rez != null && rez.length > 0) {
            items = new ArrayList<SelectSingleFromListPage.ArrayListItem>();
            int i = 0;
            while (i < rez.length) {
                SelectSingleFromListPage.ArrayListItem li = new SelectSingleFromListPage.ArrayListItem();
                li.setStringArray(rez[i]);
                items.add(li);
                ++i;
            }
        }
        return items;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public boolean isCheckBox() {
        return false;
    }

    public boolean hasFilters() {
        return true;
    }
}

