/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.impact;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.impact.fieldexpansion.FieldExpansionSearch;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImpactUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CSVImpactUtils.class);
    public static String CSV_IMPACT_VAR_DETAIL = "1";
    public static String CSV_PROGRAM_PATHS = "2";
    public static String CSV_RESOURCE_PATHS = "3";
    public static String CSV_VAR_LIST = "4";
    public static String CSV_LINKAGE = "5";

    public static void writeCSVHeader(CSVWriter csv, Map<String, String> parameters, String project) {
        if (csv != null) {
            csv.writeLine(parameters.get("report.title"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm");
            csv.writeLine(Messages.getString(CSVImpactUtils.class, "csv.header.date", new Object[]{sdf.format(new Date())}));
            csv.writeLine(Messages.getString(CSVImpactUtils.class, "csv.header.project", new String[]{project}));
            String varName = parameters.get("all.inputs.name");
            if (varName != null && !varName.isEmpty()) {
                csv.writeLine(varName);
            } else {
                varName = parameters.get("title.varName");
                if (varName != null && !varName.isEmpty()) {
                    csv.writeLine(varName);
                }
            }
            String options = parameters.get("title.resourceName");
            if (options != null && !options.isEmpty()) {
                csv.writeLine(options);
            }
            csv.writeLine("");
        }
    }

    public static void writeCsvHeader(CSVWriter csv, boolean multiplePaths) {
        if (csv != null) {
            csv.write(new String[]{Messages.getString(FieldExpansionSearch.class, "csv.header.section.head")});
            csv.write(new String[]{CSV_IMPACT_VAR_DETAIL, Messages.getString(FieldExpansionSearch.class, "csv.header.section.vardetail")});
            csv.write(new String[]{"", Messages.getString(FieldExpansionSearch.class, "csv.header.columns"), Messages.getString(FieldExpansionSearch.class, "csv.header.program"), Messages.getString(FieldExpansionSearch.class, "csv.header.impactResource"), Messages.getString(FieldExpansionSearch.class, "csv.header.impactResourceType"), Messages.getString(FieldExpansionSearch.class, "csv.header.from"), Messages.getString(FieldExpansionSearch.class, "csv.header.to"), Messages.getString(FieldExpansionSearch.class, "csv.header.impactType")});
            if (multiplePaths) {
                csv.write(new String[]{CSV_PROGRAM_PATHS, Messages.getString(FieldExpansionSearch.class, "csv.header.section.path")});
                csv.write(new String[]{"", Messages.getString(FieldExpansionSearch.class, "csv.header.columns"), Messages.getString(FieldExpansionSearch.class, "csv.header.program"), Messages.getString(FieldExpansionSearch.class, "csv.header.dataflowdir"), Messages.getString(FieldExpansionSearch.class, "csv.header.path")});
                csv.write(new String[]{CSV_RESOURCE_PATHS, Messages.getString(FieldExpansionSearch.class, "csv.header.section.path")});
                csv.write(new String[]{"", Messages.getString(FieldExpansionSearch.class, "csv.header.columns"), Messages.getString(FieldExpansionSearch.class, "csv.header.impactResource"), Messages.getString(FieldExpansionSearch.class, "csv.header.impactResourceType"), Messages.getString(FieldExpansionSearch.class, "csv.header.dataflowdir"), Messages.getString(FieldExpansionSearch.class, "csv.header.path")});
                csv.write(new String[]{CSV_VAR_LIST, Messages.getString(FieldExpansionSearch.class, "csv.header.section.varlist")});
                csv.write(new String[]{"", Messages.getString(FieldExpansionSearch.class, "csv.header.columns"), Messages.getString(FieldExpansionSearch.class, "csv.header.program"), Messages.getString(FieldExpansionSearch.class, "csv.header.var")});
                csv.write(new String[]{CSV_LINKAGE, Messages.getString(FieldExpansionSearch.class, "csv.invocationDetails.title")});
                csv.write(new String[]{"", Messages.getString(FieldExpansionSearch.class, "csv.header.columns"), Messages.getString(FieldExpansionSearch.class, "csv.header.program"), Messages.getString(FieldExpansionSearch.class, "csv.header.callinvoke"), Messages.getString(FieldExpansionSearch.class, "csv.header.program"), Messages.getString(FieldExpansionSearch.class, "csv.header.param"), Messages.getString(FieldExpansionSearch.class, "csv.header.linkage")});
                csv.writeLine("");
            }
            csv.write(new String[]{Messages.getString(FieldExpansionSearch.class, "csv.header.section.column"), Messages.getString(FieldExpansionSearch.class, "csv.header.section.data")});
        }
    }
}

