/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.halstead;

import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.halstead.HalsteadReportBuilder;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.report.generation.common.ui.AbstractExportCSVAction;
import com.ez.report.generation.common.ui.PreGeneratedCSVExportAction;
import com.ez.report.generation.common.ui.ReportInfoAdapter;
import com.jasperassistant.designer.viewer.ReportViewer;
import java.util.Map;
import javax.swing.JLabel;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalsteadAnalysisJob
extends EZReportJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HalsteadAnalysisJob.class);
    private String propFile;

    public HalsteadAnalysisJob(String arg0, EZEntityID id) {
        super(arg0, id);
        this.graphInfo = new EZReportHalsteadGI(id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.initialize(id);
        this.initialComponent = new JLabel(Messages.getString(HalsteadAnalysisJob.class, "report.label"));
    }

    public HalsteadAnalysisJob(EZEntityID arg1) {
        this(Messages.getString(HalsteadAnalysisJob.class, "jobname"), arg1);
    }

    @Override
    protected AbstractBuilder getBuilder() {
        HalsteadReportBuilder builder = new HalsteadReportBuilder(this.reportName, this.propFile);
        builder.setProject(this.projectName);
        return builder;
    }

    @Override
    public void setParameters(Map<String, Object> settings) {
        super.setParameters(settings);
        this.propFile = (String)settings.get("properties_file");
    }

    class EZReportHalsteadGI
    extends ReportInfoAdapter {
        public EZReportHalsteadGI(EZEntityID id) {
            super(id);
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/halstead.gif").createImage();
            }
            return this.image;
        }

        public String getText() {
            String txt = Messages.getString(HalsteadAnalysisJob.class, "report.tab.title", new String[]{HalsteadAnalysisJob.this.viewTabLabel});
            return txt;
        }

        protected AbstractExportCSVAction instantiateCSVExportAction(ReportViewer viewer) {
            return new PreGeneratedCSVExportAction(this.reportViewer);
        }
    }
}

