/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.vsamfile;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.Datasource;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.Utils;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSAMFileViewerReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VSAMFileViewerReportBuilder.class);

    public VSAMFileViewerReportBuilder(String reportName) {
        this.report = null;
    }

    protected String getReportTemplatePath() {
        return "reports/documentationReport.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(VSAMFileViewerReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        String externalized = Messages.getString(VSAMFileViewerReportBuilder.class, "report.title");
        this.parameters.put("report.title", externalized);
        Boolean showApp = (Boolean)this.getReportModel().getProperty("show appendix");
        this.parameters.put("showAppendix", showApp);
        boolean showInputs = (Boolean)this.getReportModel().getProperty("showInputDetails");
        this.parameters.put("showInputs", showInputs);
        this.parameters.put("resourcesSummary", Messages.getString(VSAMFileViewerReportBuilder.class, "resources.summary"));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.parameters.put("appendixFirstLineValue", String.valueOf(prgList.size()));
        this.buildInputs4Appendix(prgList);
        this.parameters.put("separateColumn", Boolean.FALSE);
        this.parameters.put("color", "blue");
        Utils.putSubreportStream((String)"/reports/subBaseDoc.jasper", (String)"detailsTemplate", (Map)this.parameters);
        Utils.putSubreportStream((String)"/reports/subBase.jasper", (String)"subBaseTemplate", (Map)this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) throws Exception {
        Collection selected = this.getSelected();
        Datasource ds = new Datasource(selected, this, monitor);
        return ds;
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected JasperPrint prepareDocument(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        RunWithLock runn = new RunWithLock(jReport, params, ds, monitor, status);
        try {
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return runn.print;
    }

    Runnable getStopCode() {
        return this.stopCode;
    }

    JasperPrint prepDocument(JasperReport jReport, Map params, JRDataSource ds, EZSourceConnection conn, IProgressMonitor monitor, IStatus status) {
        ((Datasource)ds).setConnection(conn);
        return super.prepareDocument(jReport, params, ds, monitor, status);
    }

    EZSourceProjectIDSg getProjectIdSg() {
        Object val = this.inputs.get("projectInfo");
        if (val != null) {
            if (val instanceof EZSourceProjectIDSg) {
                return (EZSourceProjectIDSg)val;
            }
            if (val instanceof ProjectInfo) {
                ProjectInfo ezsourcePrj = (ProjectInfo)val;
                return new EZSourceProjectIDSg(ezsourcePrj);
            }
        }
        return null;
    }

    class RunWithLock
    implements IMFRunnable {
        JasperPrint print;
        AbstractReportBuilder builder;
        JasperReport jReport;
        Map params;
        JRDataSource ds;
        IProgressMonitor monitor;
        IStatus status;

        public RunWithLock(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
            this.jReport = jReport;
            this.params = params;
            this.ds = ds;
            this.monitor = monitor;
            this.status = status;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            this.print = VSAMFileViewerReportBuilder.this.prepDocument(this.jReport, this.params, this.ds, conn, this.monitor, this.status);
        }
    }
}

