/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.vsamfile;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.reports.EzReportInfoAdapter;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.VSAMFileViewerReportBuilder;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.viewer.execution.EZReportJob;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSAMFileJob
extends EZReportJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VSAMFileJob.class);
    public static final String PROJECT_INFO_KEY = "projectInfo";

    public VSAMFileJob(EZEntityID arg1) {
        this(Messages.getString(VSAMFileJob.class, "job.name"), arg1);
    }

    public VSAMFileJob(String arg0, EZEntityID arg1) {
        super(arg0, arg1);
        this.graphInfo = new EZReportVSAMFileGI(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.initialize(this.id);
        this.initialComponent = new JLabel(Messages.getString(VSAMFileJob.class, "report.label"));
    }

    @Override
    public void setParameters(Map<String, Object> params) {
        Collection copy = (Collection)params.get("selected resources");
        List lst = BaseResourceInput4GUI.extractNonGUIObjects((Collection)copy);
        HashSet inpts = new HashSet(lst);
        params.put("selected resources", lst);
        HashSet<String> inpNames = new HashSet<String>();
        for (VSAMInput inp : inpts) {
            inpNames.add(inp.getListableName());
        }
        this.analysis.addContextValue("inputs name string", inpNames);
        List prjInfoLst = (List)this.analysis.getContextValue("PROJECT_LIST");
        if (prjInfoLst != null && !prjInfoLst.isEmpty()) {
            Object o = prjInfoLst.get(0);
            params.put(PROJECT_INFO_KEY, o);
        } else {
            ProjectInfo pInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
            if (pInfo != null) {
                params.put(PROJECT_INFO_KEY, pInfo);
            } else {
                L.warn("inputs without projectInfo!!");
            }
        }
        super.setParameters(params);
    }

    @Override
    protected AbstractBuilder getBuilder() {
        VSAMFileViewerReportBuilder builder = new VSAMFileViewerReportBuilder(this.reportName);
        builder.setProject(this.projectName);
        return builder;
    }

    class EZReportVSAMFileGI
    extends EzReportInfoAdapter {
        public EZReportVSAMFileGI(EZEntityID id) {
            super(id);
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/dataset.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            String txt = Messages.getString(VSAMFileJob.class, "report.tab.title", new String[]{VSAMFileJob.this.viewTabLabel});
            return txt;
        }
    }
}

