/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.vsamfile;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.VSAMFileJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.MultipleVSAMCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VSAMFileAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public VSAMFileAnalysis() {
        this(null);
    }

    public VSAMFileAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            if (inputs.size() > 0 && inputs.get(0) instanceof EZSourceProjectInputType) {
                super.setInputs(inputs);
            } else {
                ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
                this.params = new HashMap();
                ArrayList<MultipleVSAMInput> sel = new ArrayList<MultipleVSAMInput>();
                for (Object inpObj : inputs) {
                    if (!(inpObj instanceof EZSourceDataset)) continue;
                    EZEntityID entity = ((EZSourceDataset)inpObj).getEntID();
                    list.add(entity);
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                    if (prjSg == null) continue;
                    if (!prjSg.getProjectName().equals(this.projectName)) {
                        this.setPrjName(prjSg.getProjectName());
                        this.addContextValue("input_project_names", prjSg.getProjectName());
                        ProjectInfo pInfo = prjSg.getProjectInfo();
                        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                        this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    }
                    EZSourceDatasetIDSg datasetSg = (EZSourceDatasetIDSg)entity.getSegment(EZSourceDatasetIDSg.class);
                    String name = datasetSg.getDatasetName();
                    MultipleVSAMInput mvsami = new MultipleVSAMInput(name, datasetSg.getDatasetMemberName(), datasetSg.getDatasetId(), datasetSg.getGenerationNumber());
                    mvsami.setIncomplete(datasetSg.isIncompleteSegment());
                    sel.add(mvsami);
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                    ArrayList<EZSourceProjectIDSg> tmp = new ArrayList<EZSourceProjectIDSg>();
                    tmp.add(prjSg);
                    this.addContextValue("PROJECT_LIST", tmp);
                }
                if (!sel.isEmpty()) {
                    this.params.put("project_name", this.projectName);
                    this.params.put("selected resources", sel);
                    this.params.put("show summary only", Boolean.FALSE);
                    this.params.put("show appendix", com.ez.mainframe.reports.gui.preferences.PreferenceUtils.getPreferenceStore().getBoolean("showAppendix"));
                    this.params.put("showInputDetails", com.ez.mainframe.reports.gui.preferences.PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails"));
                    this.addContextValue("input_list", list);
                }
            }
        }
    }

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(VSAMFileAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page");
        selectProgramsPage.setLeftGroupLabel(Messages.getString(VSAMFileAnalysis.class, "av.object.type"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(VSAMFileAnalysis.class, "sel.object.type"));
        boolean showTemporaryDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        MultipleVSAMCollector ic = new MultipleVSAMCollector();
        String query = "SELECT cast(NULL as integer) AS DataSetID, mf.DSName AS DataSetName, cast(NULL as integer) AS GenerationNumber, \n\t\tcast(NULL as varchar(50)) AS MemberName \n\t\tFROM MFCICSFile mf \n\t\tINNER JOIN Files f on mf.DDName = f.LogicalName and f.TypeCode IS NULL AND (mf.DSName IS NOT NULL AND mf.DSName <> '')".concat(" \n UNION \n");
        query = query.concat(showTemporaryDatasets ? "SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID WHERE JCLPhysicalDataSet.IsInstream<>1 ORDER BY DataSetName,GenerationNumber, MemberName" : "SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID WHERE JCLPhysicalDataSet.IsInstream<>1 AND JCLPhysicalDataSet.Istemp<>1 ORDER BY DataSetName,GenerationNumber, MemberName");
        ic.setResourcesQuery(query);
        selectProgramsPage.setResourcesCollector((ResourcesCollector)ic);
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, VSAMFileJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_VSAMFILE_ANALYSIS;
    }
}

