/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.vsamfile;

import com.ez.common.model.BaseResourceInput;
import com.ez.mainframe.reports.gui.AbstractGeneratorBuilder;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.DocumentationDataSource;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.Datasource;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.application.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractGeneratorBuilder {
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private Map<String, String> files;
    private List<String> targets = new ArrayList<String>();
    String currentTarget = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
    }

    @Override
    protected JRDataSource getDSForTarget(int targetIndex, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.currentTarget = this.targets.get(targetIndex);
        String fileName = this.files.get(this.currentTarget);
        L.debug("start collecting data for " + fileName + " (index=" + targetIndex + ")");
        List<Object4Report> resultList = this.data(fileName, this.currentTarget, this.stopCode, monitor.newChild(100));
        if (!resultList.isEmpty()) {
            boolean isUCMDB = false;
            if (this.pInfo != null) {
                isUCMDB = this.pInfo.isUMCDB();
            } else {
                L.warn("pInfo null for project {}", (Object)this.project);
            }
            Utils.setParamsForTitle((Map)this.parameters, (String)this.project, (boolean)isUCMDB, (Map)this.inputs);
            this.parameters.put("report.title", Messages.getString(ReportBuilder.class, "report.title"));
            this.parameters.put("title.name", Messages.getString(ReportBuilder.class, "firstPage.component.type"));
            this.parameters.put("title.nameValue", fileName);
            this.parameters.put("showAppendix", Boolean.TRUE);
            this.parameters.put("color", "violet");
            this.parameters.put("report.details", Messages.getString(ReportBuilder.class, "report.details"));
            String currentTargetType = null;
            fileName = fileName.toUpperCase();
            if (fileName.contains(".PRODS.") || fileName.contains(".PRODM.")) {
                currentTargetType = Messages.getString(ReportBuilder.class, "prodSM.type");
            } else if (fileName.contains(".PRODV.")) {
                currentTargetType = Messages.getString(ReportBuilder.class, "prodV.type");
            } else if (fileName.contains(".PRODT.")) {
                currentTargetType = Messages.getString(ReportBuilder.class, "prodT.type");
            }
            this.parameters.put("title.type", Messages.getString(ReportBuilder.class, "firstPage.file.type"));
            this.parameters.put("title.typeValue", currentTargetType);
            L.debug("end building datasource for {}", (Object)fileName);
            return new DocumentationDataSource(resultList, null);
        }
        return null;
    }

    private List<Object4Report> data(String datasetName, String currentTarget, Runnable stopCode, SubMonitor monitor) {
        HashSet<String> params = new HashSet<String>();
        params.add(currentTarget);
        return Datasource.getData(datasetName, params, stopCode, monitor);
    }

    @Override
    protected int getNumOfTargets(IProgressMonitor pmonitor) {
        Collection selected = this.getSelected();
        this.files = new HashMap<String, String>();
        if (selected != null && !selected.isEmpty()) {
            for (BaseResourceInput vsam : selected) {
                int id = vsam.getResourceID();
                String fileID = String.valueOf(id);
                String fileName = vsam.getListableName();
                this.files.put(fileID, fileName);
            }
        }
        this.targets.addAll(this.files.keySet());
        return this.targets.size();
    }

    @Override
    protected int getNumOfTargetsFromProp(SubMonitor pmonitor) {
        int ret = -1;
        return ret;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected String getReportTemplatePath() {
        return "reports/genericReport.jasper";
    }

    @Override
    protected void cleanTarget() {
    }

    @Override
    public String getFilePrefix() {
        return null;
    }

    @Override
    public String getFileSuffix() {
        return Messages.getString(ReportBuilder.class, "fileName.suffix");
    }

    @Override
    public String getIndexTitle() {
        return Messages.getString(ReportBuilder.class, "htmlIndex.title");
    }

    @Override
    public String getDefaultOutputFolder() {
        return "vsamFile";
    }
}

