/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.vsamfile;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.ServerType;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.gui.utils.DatasetUtils;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.reports.gui.AbstractGeneratorBuilder;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.DocumentationReportsUtil;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.VSAMFileViewerReportBuilder;
import com.ez.report.application.ezreport.reports.documentation.vsamfile.VSAMReportElement;
import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.Object4TestReport;
import com.ez.report.generation.common.datasource.SC3TableDataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datasource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Datasource.class);
    List<VSAMInput> inputs;
    VSAMReportElement currentValue = null;
    EZSourceProjectIDSg ezsourcePrj = null;
    Runnable stopCode;
    private SubMonitor monitor;
    private EZSourceConnection bridge;
    static final String Q1 = "EZReports_VSAMFile_Q1";
    static final String Q11 = "SELECT DDNAME FROM MFCICSFile WHERE DSNAME = ";
    static final String Q2 = "EZReports_VSAMFile_Q2";
    private static final String tempTableName = "ds_param_temp";
    static final String Q5 = "EZReports_VSAMFile_Q5";
    private static final String Q6 = "EZReports_VSAMFile_Q6";

    public Datasource(Collection<VSAMInput> selected, VSAMFileViewerReportBuilder builder, IProgressMonitor pmonitor) {
        this.inputs = new ArrayList<VSAMInput>(selected);
        this.inputs.sort(null);
        this.monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(this.inputs.size() * 10));
        this.monitor.subTask(Messages.getString(Datasource.class, "monitor.startprocess.subtask"));
        this.stopCode = builder.getStopCode();
        this.ezsourcePrj = builder.getProjectIdSg();
    }

    private void completeAllDbidForDSName(MultipleVSAMInput inp) {
        HashSet<String> dsNames = new HashSet<String>();
        dsNames.add(inp.getName());
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[dsNames.size()]);
        Collections.fill(types, EZSourceDataType.String);
        String[][] infoToCompleteInput = this.bridge.executeSQL(DatasetUtils.getDatasetInputInfoQuery((ServerType)this.bridge.getProjectInfo().getDbEngine()), types, new ArrayList(dsNames));
        if (infoToCompleteInput != null) {
            String[][] stringArray = infoToCompleteInput;
            int n = infoToCompleteInput.length;
            int n2 = 0;
            while (n2 < n) {
                String[] info = stringArray[n2];
                inp.addInfo(Integer.valueOf(info[0]), info[2]);
                ++n2;
            }
        }
    }

    public boolean nextItem() throws JRException {
        this.currentValue = null;
        if (!this.inputs.isEmpty()) {
            this.bridge.executeUpdate(this.buildCreateStr(this.bridge));
            VSAMInput inpt = this.inputs.remove(0);
            this.currentValue = this.buildDetails4VSAM(inpt);
            com.ez.mainframe.data.utils.Utils.cleanTable((EZSourceConnection)this.bridge, (String)tempTableName);
            com.ez.mainframe.data.utils.Utils.dropTempTable((EZSourceConnection)this.bridge, (String)tempTableName);
        }
        return this.currentValue != null;
    }

    private String buildCreateStr(EZSourceConnection conn) {
        return com.ez.report.application.ezreport.utils.Utils.buildCreateStr4DSParamTable(conn, tempTableName);
    }

    private VSAMReportElement buildDetails4VSAM(VSAMInput inpt) {
        String vsamName = ReportsUtils.stripNonValidXMLCharacters((String)inpt.getListableName(), (boolean)false);
        List<Object4Report> resultList = this.data(inpt);
        VSAMReportElement vsamElem = new VSAMReportElement(vsamName, resultList);
        vsamElem.setTooltip(inpt.getListableName());
        return vsamElem;
    }

    private List<Object4Report> data(VSAMInput inpt) {
        String vsamName = inpt.getName();
        String memberName = ((MultipleVSAMInput)inpt).getMemberName();
        HashSet<String> ids = new HashSet<String>();
        if (inpt instanceof MultipleVSAMInput) {
            if (((MultipleVSAMInput)inpt).isIncomplete()) {
                this.completeAllDbidForDSName((MultipleVSAMInput)inpt);
            }
            Collection ids2 = ((MultipleVSAMInput)inpt).getIds();
            for (Integer id : ids2) {
                if (id == null) continue;
                ids.add(id.toString());
            }
        } else {
            ids.add(inpt.getResourceID().toString());
        }
        this.stopCode.run();
        List<Object4Report> results = Datasource.getData(this.bridge, this.ezsourcePrj, vsamName, memberName, ids, this.stopCode, this.monitor.newChild(100));
        return results;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("detailsDataSource")) {
            value = this.currentValue.getDS();
        } else if (field.getName().equals("detailName")) {
            value = this.currentValue.getDetailName();
        } else if (field.getName().equals("detailTOC")) {
            value = this.currentValue.getDetailTOC();
        } else if (field.getName().equals("tocTooltip")) {
            value = ReportsUtils.prepareTooltip((String)this.currentValue.getTooltip());
        }
        return value;
    }

    static boolean usageInJobs(EZSourceConnection bridge, ElementGroupInfo elemDetails, Set<Integer> datasetIds, String memberName, String ddCard) {
        boolean hasResults = false;
        ArrayList<EZSourceDataType> dstypes = new ArrayList<EZSourceDataType>();
        dstypes.add(EZSourceDataType.Integer);
        dstypes.add(EZSourceDataType.String);
        String[][] selectedDSs = new String[datasetIds.size()][2];
        int ii = 0;
        for (Integer dsid : datasetIds) {
            selectedDSs[ii][0] = String.valueOf(dsid);
            selectedDSs[ii++][1] = memberName;
        }
        bridge.insertBatch(com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)bridge, (String)tempTableName), selectedDSs, dstypes);
        String[][] results5 = bridge.execNonTransactionalStoredProc(Q5, new Object[]{ddCard});
        com.ez.mainframe.data.utils.Utils.cleanTable((EZSourceConnection)bridge, (String)tempTableName);
        if (results5 != null && results5.length > 0) {
            L.debug("results5.size={}", (Object)results5.length);
            hasResults = true;
            ArrayList<Object4TestReport> listWUResults = new ArrayList<Object4TestReport>();
            String currJob = "";
            int j = 0;
            while (j < results5.length) {
                String job = results5[j][0];
                String step = results5[j][1];
                String progName = results5[j][7] != null && !results5[j][7].isEmpty() ? results5[j][7] : results5[j][2];
                Object4TestReport obj = new Object4TestReport();
                if (!currJob.equals(job)) {
                    currJob = job;
                    obj.setLeftExpresion(ReportsUtils.stripNonValidXMLCharacters((String)job, (boolean)false));
                }
                obj.setMiddleExpresion(ReportsUtils.stripNonValidXMLCharacters((String)step, (boolean)false));
                obj.setRightExpresion(ReportsUtils.stripNonValidXMLCharacters((String)progName, (boolean)false));
                obj.setParentElement(ddCard);
                listWUResults.add(obj);
                ++j;
            }
            results5 = null;
            String columnLbl1 = Messages.getString(Datasource.class, "jobs.column.name");
            String columnLbl2 = Messages.getString(Datasource.class, "steps.column.name");
            String columnLbl3 = Messages.getString(Datasource.class, "programs.column.name");
            SC3TableDataSource ds = new SC3TableDataSource(columnLbl1, columnLbl2, columnLbl3, listWUResults);
            ds.setLayout(2);
            ds.setExtraTitle(Messages.getString(Datasource.class, "fileUsageInJobs.group.name", new String[]{String.valueOf(listWUResults.size())}));
            ds.setTocEntry(Messages.getString(Datasource.class, "toc.fileUsageInJobs.group.name"));
            elemDetails.addDataSource((SubreportDataSource)ds);
        }
        return hasResults;
    }

    static boolean usageInPrograms(Set<String> params, Runnable stopCode, EZSourceConnection bridge, ElementGroupInfo elemDetails, String ddCard, Map<Integer, String> programs, Set<String> fileIds, boolean isUsingCICSFile) {
        boolean hasResults = false;
        if (programs != null || isUsingCICSFile) {
            List<EZSourceDataType> types;
            String[][] res = null;
            if (programs != null && !programs.isEmpty()) {
                types = Arrays.asList(new EZSourceDataType[programs.keySet().size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                res = bridge.execNonTransactionalStoredProc(Q6, new Object[]{ddCard}, types, new ArrayList<Integer>(programs.keySet()));
            } else if (isUsingCICSFile) {
                res = bridge.execNonTransactionalStoredProc(Q6, new Object[]{ddCard});
            }
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    params.add(res[j][1]);
                    ++j;
                }
            }
            params.addAll(fileIds);
            res = null;
            fileIds.clear();
            if (!params.isEmpty()) {
                types = Arrays.asList(new EZSourceDataType[params.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                String[][] results4 = bridge.execNonTransactionalStoredProc("EZReports_FilesVsPrograms_Selective_BY_ID", new Object[0], types, new ArrayList<String>(params));
                if (results4 != null && results4.length > 0) {
                    L.debug("results4.size={}", (Object)results4.length);
                    ArrayList<Object4TestReport> listWUResults = new ArrayList<Object4TestReport>();
                    String currPrg = "";
                    int total = 0;
                    int j = 0;
                    while (j < results4.length) {
                        String prg = results4[j][1];
                        String prgPath = results4[j][6];
                        if (prgPath != null && !prgPath.isEmpty()) {
                            prgPath = Utils.getFileName((String)prgPath);
                            prg = prg.concat(" (").concat(prgPath).concat(")");
                        }
                        if (isUsingCICSFile || programs.values().contains(prg)) {
                            String stmtType = results4[j][2];
                            Integer stmtCount = new Integer(Integer.parseInt(results4[j][3]));
                            Object4TestReport obj = new Object4TestReport();
                            if (!currPrg.equals(prg)) {
                                currPrg = prg;
                                obj.setLeftExpresion(ReportsUtils.stripNonValidXMLCharacters((String)prg, (boolean)false));
                            }
                            obj.setMiddleExpresion(ReportsUtils.stripNonValidXMLCharacters((String)stmtType, (boolean)false));
                            obj.setRightExpresion(stmtCount.toString());
                            obj.setParentElement(ddCard);
                            listWUResults.add(obj);
                            total += stmtCount.intValue();
                        } else {
                            L.info("prg not in call tree: {}", (Object)prg);
                        }
                        ++j;
                    }
                    results4 = null;
                    if (!listWUResults.isEmpty()) {
                        hasResults = true;
                        String columnLbl1 = Messages.getString(Datasource.class, "programs.column.name");
                        String columnLbl2 = Messages.getString(Datasource.class, "stmtType.column.name");
                        String columnLbl3 = Messages.getString(Datasource.class, "count.column.name");
                        SC3TableDataSource ds = new SC3TableDataSource(columnLbl1, columnLbl2, columnLbl3, listWUResults);
                        ds.setLayout(2);
                        ds.setExtraTitle(Messages.getString(Datasource.class, "fileUsageInPrograms.group.name", new String[]{String.valueOf(total)}));
                        ds.setTocEntry(Messages.getString(Datasource.class, "toc.fileUsageInPrograms.group.name"));
                        elemDetails.addDataSource((SubreportDataSource)ds);
                    }
                    stopCode.run();
                }
            }
        }
        return hasResults;
    }

    public static List<Object4Report> getData(String datasetName, Set<String> params, Runnable stopCode, SubMonitor monitor) {
        List<Object4Report> ret = null;
        EZSourceConnection bridge = null;
        try {
            bridge = EZSourceConnectionManager.getCurrent();
            ret = Datasource.getData(datasetName, params, stopCode, monitor);
        }
        finally {
            if (bridge != null) {
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
            }
        }
        return ret;
    }

    public static List<Object4Report> getData(EZSourceConnection conn, EZSourceProjectIDSg ezsourcePrj, String datasetName, String memberName, Set<String> params, Runnable stopCode, SubMonitor monitor) {
        List<Object> resultList = null;
        monitor.subTask(datasetName);
        try {
            String[][] results1;
            String[][] selectedDSs = new String[params.size()][2];
            int ii = 0;
            boolean runQ1 = false;
            for (String dsid : params) {
                if (Integer.valueOf(dsid) <= 0) continue;
                selectedDSs[ii][0] = dsid;
                selectedDSs[ii++][1] = memberName;
                runQ1 = true;
            }
            if (runQ1) {
                int res1Length;
                ArrayList<EZSourceDataType> dstypes = new ArrayList<EZSourceDataType>();
                dstypes.add(EZSourceDataType.Integer);
                dstypes.add(EZSourceDataType.String);
                conn.insertBatch(com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)conn, (String)tempTableName), selectedDSs, dstypes);
                results1 = AbstractGeneratorBuilder.runProc(conn, Q1, null, (IProgressMonitor)monitor);
                com.ez.mainframe.data.utils.Utils.cleanTable((EZSourceConnection)conn, (String)tempTableName);
                int n = res1Length = results1 != null ? results1.length : 0;
                if (results1 != null && res1Length > 0) {
                    L.debug("results1.size={}", (Object)res1Length);
                    resultList = Datasource.processingResults(conn, memberName, params, stopCode, monitor, results1);
                }
            } else {
                ElementGroupInfo elemDetails;
                boolean hasResults;
                String query = Q11.concat("'" + datasetName + "'");
                results1 = conn.executeSQL(query);
                int res1Length = results1 != null ? results1.length : 0;
                String ddName = null;
                if (results1 != null && res1Length > 0) {
                    ddName = results1[0][0];
                }
                if (hasResults = Datasource.processEachDD(conn, memberName, params, stopCode, monitor, elemDetails = new ElementGroupInfo(""), null, ddName, null, true)) {
                    resultList = new ArrayList();
                    Object4Report obj4Rep = new Object4Report(ddName, elemDetails);
                    resultList.add(obj4Rep);
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("error at executing of report", (Throwable)e);
        }
        return resultList;
    }

    private static List<Object4Report> processingResults(EZSourceConnection conn, String memberName, Set<String> params, Runnable stopCode, SubMonitor monitor, String[][] results1) {
        ArrayList<Object4Report> resultList = new ArrayList<Object4Report>();
        HashMap<String, HashMap<Integer, String>> ddProgs = new HashMap<String, HashMap<Integer, String>>();
        ElementGroupInfo elemDetails = null;
        String prevDDCard = null;
        HashSet<Integer> datasetIds = new HashSet<Integer>();
        int i = 0;
        while (i < results1.length) {
            String nextDDCard;
            String prgName = results1[i][1];
            String prgID = results1[i][2];
            String ddCard = results1[i][3];
            String occurID = results1[i][4];
            String currentTarget = results1[i][5];
            datasetIds.add(Integer.valueOf(currentTarget));
            String prgPath = results1[i][6];
            if (prgPath != null && !prgPath.isEmpty()) {
                prgPath = Utils.getFileName((String)prgPath);
                prgName = prgName.concat(" (").concat(prgPath).concat(")");
            }
            boolean hasResults = false;
            String string = nextDDCard = i + 1 < results1.length ? results1[i + 1][3] : null;
            if (!"".equals(ddCard)) {
                HashMap<Integer, String> programs;
                if (!ddCard.equals(prevDDCard)) {
                    elemDetails = new ElementGroupInfo("");
                }
                if ((programs = (HashMap<Integer, String>)ddProgs.get(ddCard)) == null) {
                    programs = new HashMap<Integer, String>();
                    ddProgs.put(ddCard, programs);
                }
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)prgID) == null) {
                    L.info("program {} not exist in project. it will be ignored", (Object)prgName);
                } else if (!occurID.equals("0")) {
                    programs.put(Integer.valueOf(prgID), prgName);
                    String[][] prgCgResults = conn.execNonTransactionalStoredProc("EZViewer_CalledProgramID", new Object[]{Integer.valueOf(prgID), 1});
                    if (prgCgResults != null) {
                        String[][] stringArray = prgCgResults;
                        int n = prgCgResults.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] rez = stringArray[n2];
                            programs.put(Integer.valueOf(rez[1]), rez[2]);
                            ++n2;
                        }
                    }
                } else {
                    L.info("program with id {} has occurID=0. it will be ignored", (Object)prgID);
                }
                if (!ddCard.equals(nextDDCard)) {
                    hasResults = Datasource.processEachDD(conn, memberName, params, stopCode, monitor, elemDetails, datasetIds, ddCard, programs, false);
                }
                programs = null;
            } else {
                L.info("empty DDCardName for dataset {} -- {}", (Object)currentTarget, (Object)prgName);
            }
            if (hasResults && !ddCard.equals(nextDDCard)) {
                datasetIds.clear();
                Object4Report obj4Rep = new Object4Report(ddCard, elemDetails);
                resultList.add(obj4Rep);
            }
            prevDDCard = ddCard;
            ++i;
        }
        results1 = null;
        return resultList;
    }

    private static boolean processEachDD(EZSourceConnection conn, String memberName, Set<String> params, Runnable stopCode, SubMonitor monitor, ElementGroupInfo elemDetails, Set<Integer> datasetIds, String ddCard, Map<Integer, String> programs, boolean isUsingCICSFile) {
        List<Object4Report> lst;
        boolean hasResults = false;
        HashSet<String> fileIds = new HashSet<String>();
        HashSet<Integer> varIDs = new HashSet<Integer>();
        String[][] results2 = null;
        if (programs != null && !programs.keySet().isEmpty()) {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[programs.keySet().size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            results2 = conn.execNonTransactionalStoredProc(Q2, new Object[]{ddCard}, types, new ArrayList<Integer>(programs.keySet()));
        } else if (isUsingCICSFile) {
            results2 = conn.execNonTransactionalStoredProc(Q2, new Object[]{ddCard});
        }
        if (results2 != null && results2.length > 0) {
            L.debug("results2.size={}", (Object)results2.length);
            int j = 0;
            while (j < results2.length) {
                String varID = results2[j][2];
                varIDs.add(Integer.valueOf(varID));
                fileIds.add(results2[j][3]);
                ++j;
            }
            results2 = null;
        }
        if (!(lst = DocumentationReportsUtil.buildVariables(varIDs, elemDetails, conn, stopCode, (IProgressMonitor)monitor)).isEmpty()) {
            L.debug("variables.size={}", (Object)lst.size());
            hasResults = true;
        }
        varIDs.clear();
        params.clear();
        boolean bl = hasResults = Datasource.usageInPrograms(params, stopCode, conn, elemDetails, ddCard, programs, fileIds, isUsingCICSFile) || hasResults;
        if (datasetIds != null && !datasetIds.isEmpty()) {
            hasResults = Datasource.usageInJobs(conn, elemDetails, datasetIds, memberName, ddCard) || hasResults;
        }
        return hasResults;
    }

    public void setConnection(EZSourceConnection conn) {
        this.bridge = conn;
    }
}

