/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.jobflow;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.jobflow.Datasource;
import com.ez.report.application.ezreport.reports.documentation.jobflow.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.Utils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewerReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ViewerReportBuilder.class);

    public ViewerReportBuilder(String reportName, String settings) {
        this.report = null;
    }

    protected String getReportTemplatePath() {
        return "reports/documentationReport.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ViewerReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        String externalized = Messages.getString(ViewerReportBuilder.class, "report.title");
        this.parameters.put("report.title", externalized);
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.parameters.put("appendixFirstLineValue", String.valueOf(prgList.size()));
        this.buildInputs4Appendix(prgList);
        this.parameters.put("separateColumn", Boolean.FALSE);
        Utils.putSubreportStream((String)"/reports/subBaseDoc.jasper", (String)"detailsTemplate", (Map)this.parameters);
        Utils.putSubreportStream((String)"/reports/subBase.jasper", (String)"subBaseTemplate", (Map)this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) {
        Collection selected = this.getSelected();
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        Datasource ds = new Datasource(selected, monitor, this, csvWriter);
        return ds;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    Runnable getStopCode() {
        return this.stopCode;
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    protected JasperPrint prepareDocument(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        RunWithLock runn = new RunWithLock(jReport, params, ds, monitor, status);
        try {
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return runn.print;
    }

    JasperPrint prepDocument(JasperReport jReport, Map params, JRDataSource ds, EZSourceConnection conn, IProgressMonitor monitor, IStatus status) {
        ((Datasource)ds).setConnection(conn);
        return super.prepareDocument(jReport, params, ds, monitor, status);
    }

    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.job"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.step")});
        }
    }

    class RunWithLock
    implements IMFRunnable {
        JasperPrint print;
        AbstractReportBuilder builder;
        JasperReport jReport;
        Map params;
        JRDataSource ds;
        IProgressMonitor monitor;
        IStatus status;

        public RunWithLock(JasperReport jReport, Map params, JRDataSource ds, IProgressMonitor monitor, IStatus status) {
            this.jReport = jReport;
            this.params = params;
            this.ds = ds;
            this.monitor = monitor;
            this.status = status;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            this.print = ViewerReportBuilder.this.prepDocument(this.jReport, this.params, this.ds, conn, this.monitor, this.status);
        }
    }
}

