/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.jobflow;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.JobInputNoGUI;
import com.ez.mainframe.reports.gui.AbstractGeneratorBuilder;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.DocumentationDataSource;
import com.ez.report.application.ezreport.reports.documentation.jobflow.JclPgmHelper;
import com.ez.report.application.ezreport.reports.documentation.jobflow.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.all.LegendDataSource;
import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.Object4TestReport;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SC3TableDataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractGeneratorBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String TEXT_COLOR = "Text_Color";
    private static final String FILL_COLOR = "Fill_Color";
    static final String DS_DETAILS_KEY = "dsKey";
    private static final String SUMMARY_ELEM_KEY = "summary";
    String[][] jobs;
    private String settingsName = null;
    private String outFolder;
    private String[] currentTarget;
    String[][] pgmSteps;
    private Map<Integer, List<TSENode>> tsNodeLevels;
    private JclPgmHelper jclPgmHelper;
    private static final String EZREP_PROCEDURE_1 = "EZReports_JobFlowReport_q1";
    private static final String EZREP_PROCEDURE_21 = "EZReports_JobFlowReport_q2_1";
    private static final String EZREP_PROCEDURE_3 = "EZReports_JobFlowReport_q3";

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.settingsName = settings;
        this.needsTS = true;
    }

    @Override
    protected int getNumOfTargetsFromProp(SubMonitor pmonitor) {
        int ret = -1;
        return ret;
    }

    @Override
    protected int getNumOfTargets(IProgressMonitor pmonitor) {
        Collection selected = this.getSelected();
        if (this.jobs == null) {
            this.jobs = ReportBuilder.buildJobsInfos(selected);
        }
        return this.jobs != null ? this.jobs.length : 0;
    }

    public static String[][] buildJobsInfos(Collection<JobInputNoGUI> input) {
        String[][] jobs = new String[input.size()][];
        int i = 0;
        for (JobInputNoGUI job : input) {
            jobs[i] = new String[]{String.valueOf(job.getJobID()), job.getJobName(), job.getMemberName()};
            ++i;
        }
        return jobs;
    }

    @Override
    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        this.parameters.put("report.title", externalized);
        this.parameters.put("showAppendix", Boolean.TRUE);
        this.parameters.put("annexLbl", Messages.getString(ReportBuilder.class, "report.appendixLabel"));
        externalized = Messages.getString(ReportBuilder.class, "report.detail");
        this.parameters.put("report.details", externalized);
        monitor.worked(100);
        return this.parameters;
    }

    protected String getReportTemplatePath() {
        return "reports/genericReport.jasper";
    }

    public AbstractReport getReportModel() {
        String folder;
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.setOwnerInfos(this.inputs);
        }
        this.outFolder = (folder = (String)this.report.getProperty("outputFolderName")) != null ? folder : this.getDefaultOutputFolder();
        return this.report;
    }

    @Override
    protected JRDataSource getDSForTarget(int targetIndex, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.currentTarget = this.jobs[targetIndex];
        String jobQName = this.currentTarget[1].equals(this.currentTarget[2]) ? this.currentTarget[1] : String.valueOf(this.currentTarget[1]) + "(" + this.currentTarget[2] + ")";
        monitor.subTask(jobQName);
        LinkedList<Object4Report> resultList = new LinkedList<Object4Report>();
        ElementGroupInfo summaryElem = new ElementGroupInfo(SUMMARY_ELEM_KEY);
        ElementGroupInfo legends = this.data(this.currentTarget, resultList, summaryElem, (IProgressMonitor)monitor.newChild(100));
        this.parameters.put("title.name", Messages.getString(ReportBuilder.class, "report.resourceTypeName"));
        this.parameters.put("title.nameValue", ReportsUtils.stripNonValidXMLCharacters((String)jobQName, (boolean)true));
        monitor.worked(100);
        DocumentationDataSource dds = new DocumentationDataSource(resultList, summaryElem);
        dds.setLegends(legends);
        return dds;
    }

    private ElementGroupInfo data(String[] target, List<Object4Report> resultList, ElementGroupInfo summaryElem, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        resultList.clear();
        DSFactory factory = new DSFactory();
        this.stopCode.run();
        String jobQName = target[1].equals(target[2]) ? target[1] : String.valueOf(target[1]) + "(" + target[2] + ")";
        String cfr_ignored_0 = target[2];
        this.addGraphLinks(summaryElem, factory, jobQName);
        ArrayList<Integer> jobAsParam = new ArrayList<Integer>();
        jobAsParam.add(Integer.valueOf(target[0]));
        String procsTitle = Messages.getString(ReportBuilder.class, "proc.lbl");
        String listNamesTitle = Messages.getString(ReportBuilder.class, "listing.lbl");
        String procsTotalLbl = Messages.getString(ReportBuilder.class, "total.proc.occurences");
        ReportBuilder.treatProcedures(null, summaryElem, pmonitor, factory, jobAsParam, procsTitle, procsTotalLbl, listNamesTitle, this.stopCode);
        ReportBuilder.treatSteps(null, resultList, monitor, jobAsParam, this.stopCode, this.jclPgmHelper, this.pgmSteps, null);
        ElementGroupInfo legends = null;
        if (resultList.isEmpty()) {
            resultList.add(new Object4Report(null));
        } else {
            legends = this.createEntry4Legends();
            BaseSubreportDataSource breakPageSubreport = factory.createDS(4);
            summaryElem.addDataSource((SubreportDataSource)breakPageSubreport);
        }
        monitor.worked(100);
        return legends;
    }

    public static void treatSteps(EZSourceConnection conn, List<Object4Report> resultList, SubMonitor monitor, ArrayList<Integer> jobAsParam, Runnable stopCode, JclPgmHelper jclPgmHelper, String[][] pgmSteps, CSVWriter csvWriter) {
        List<Object4Report> list;
        Object4Report obj4Rep;
        String qName;
        String sourceName;
        int position;
        Object stepName;
        int j;
        TreeMap<Integer, List<Object4Report>> steps = new TreeMap<Integer, List<Object4Report>>();
        stopCode.run();
        if (jobAsParam == null) {
            return;
        }
        if (conn == null) {
            conn = EZSourceConnectionManager.getCurrent();
        }
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[jobAsParam.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        String[][] procSteps = conn.execNonTransactionalStoredProc(EZREP_PROCEDURE_21, new String[0], types, jobAsParam);
        if (procSteps != null) {
            j = 0;
            while (j < procSteps.length) {
                stopCode.run();
                stepName = procSteps[j][3];
                String procName = procSteps[j][4];
                position = Integer.valueOf(procSteps[j][5]);
                sourceName = procSteps[j][6];
                qName = procSteps[j][0].equals(procSteps[j][1]) ? procSteps[j][0] : String.valueOf(procSteps[j][0]) + "-" + procSteps[j][1];
                obj4Rep = ReportBuilder.makeObjForReport(qName, (String)stepName, procName, position, sourceName, false);
                list = (ArrayList<Object4Report>)steps.get(position);
                if (list == null) {
                    list = new ArrayList<Object4Report>();
                    steps.put(position, list);
                }
                list.add(obj4Rep);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{qName, obj4Rep.getDetailName()});
                }
                ++j;
            }
        }
        if ((pgmSteps = (jclPgmHelper = new JclPgmHelper(stopCode)).getPgmSteps(conn, jobAsParam, monitor)) != null) {
            j = 0;
            while (j < pgmSteps.length) {
                stopCode.run();
                stepName = pgmSteps[j][3];
                String pgmName = pgmSteps[j][4];
                position = Integer.valueOf(pgmSteps[j][5]);
                sourceName = pgmSteps[j][6];
                qName = pgmSteps[j][0].equals(pgmSteps[j][1]) ? pgmSteps[j][0] : String.valueOf(pgmSteps[j][0]) + "-" + pgmSteps[j][1];
                obj4Rep = ReportBuilder.makeObjForReport(qName, (String)stepName, pgmName, position, sourceName, true);
                list = (List)steps.get(position);
                if (list == null) {
                    list = new ArrayList();
                    steps.put(position, list);
                }
                list.add(obj4Rep);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{qName, obj4Rep.getDetailName()});
                }
                ++j;
            }
        }
        for (List obj4Reps : steps.values()) {
            stopCode.run();
            resultList.addAll(obj4Reps);
        }
        stopCode.run();
        String[][] dds = conn.execNonTransactionalStoredProc(EZREP_PROCEDURE_3, new String[0], types, jobAsParam);
        if (dds != null) {
            String columnLbl1 = Messages.getString(ReportBuilder.class, "ddName.column.name");
            String columnLbl2 = Messages.getString(ReportBuilder.class, "dsName.column.name");
            String columnLbl3 = Messages.getString(ReportBuilder.class, "disposition.column.name");
            Integer stepId = null;
            ArrayList<Object4TestReport> listDataSet = null;
            int j2 = 0;
            while (j2 < dds.length) {
                stopCode.run();
                if (!(dds[j2][5].toUpperCase().startsWith("EZSOURCE_TEMP_") || dds[j2][7].toUpperCase().startsWith("EZSOURCE_TEMP_") || dds[j2][5].toUpperCase().startsWith("EZ_TEMP_") || dds[j2][7].toUpperCase().startsWith("EZ_TEMP_"))) {
                    Integer currentStepId = Integer.valueOf(dds[j2][4]);
                    if (!currentStepId.equals(stepId)) {
                        ReportBuilder.makeDDCardDS(steps, columnLbl1, columnLbl2, columnLbl3, stepId, (List<Object4TestReport>)listDataSet);
                        listDataSet = new ArrayList<Object4TestReport>();
                    }
                    Object4TestReport o = new Object4TestReport();
                    o.setLeftExpresion(ReportsUtils.stripNonValidXMLCharacters((String)dds[j2][5], (boolean)false));
                    o.setMiddleExpresion(ReportsUtils.stripNonValidXMLCharacters((String)dds[j2][7], (boolean)false));
                    o.setRightExpresion(ReportsUtils.stripNonValidXMLCharacters((String)dds[j2][8], (boolean)false));
                    listDataSet.add(o);
                    stepId = currentStepId;
                }
                ++j2;
            }
            if (listDataSet != null && !listDataSet.isEmpty()) {
                ReportBuilder.makeDDCardDS(steps, columnLbl1, columnLbl2, columnLbl3, stepId, (List<Object4TestReport>)listDataSet);
            }
        }
    }

    public static boolean treatProcedures(EZSourceConnection conn, ElementGroupInfo parentElement, IProgressMonitor pmonitor, DSFactory factory, ArrayList<Integer> jobAsParam, String procTitle, String procsTotalLbl, String listTitle, Runnable stopCode) {
        boolean ret = false;
        if (jobAsParam == null) {
            return ret;
        }
        if (conn == null) {
            conn = EZSourceConnectionManager.getCurrent();
        }
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[jobAsParam.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        String[][] procs = conn.execNonTransactionalStoredProc(EZREP_PROCEDURE_1, new String[0], types, jobAsParam);
        if (procs != null) {
            ret = true;
            ArrayList<ObjectForSubreport> procedures = new ArrayList<ObjectForSubreport>();
            int i = 0;
            while (i < procs.length) {
                ObjectForSubreport o = new ObjectForSubreport();
                o.setExp(procs[i][2]);
                procedures.add(o);
                stopCode.run();
                ++i;
            }
            BaseSubreportDataSource summaryDS = factory.createDS(3);
            summaryDS.setKey(DS_DETAILS_KEY);
            ArrayList summaryList = new ArrayList();
            summaryDS.setList(summaryList);
            summaryDS.setExtraTitle(procTitle);
            summaryDS.setTocEntry(procTitle);
            if (!procedures.isEmpty()) {
                SC3DataSource listNamesDS = (SC3DataSource)factory.createDS(1);
                listNamesDS.setLayout(2);
                listNamesDS.setTitle(listTitle);
                listNamesDS.setList(procedures);
                summaryDS.setListNamesDataSource((Object)listNamesDS);
            }
            parentElement.addDataSource((SubreportDataSource)summaryDS);
            Utils.makeGenericEntry(summaryList, (String)procsTotalLbl, (Object)procedures.size(), (String)SUMMARY_ELEM_KEY);
        }
        return ret;
    }

    protected void addGraphLinks(ElementGroupInfo summaryElem, DSFactory factory, String jobQName) {
        BaseSubreportDataSource summaryDS = factory.createDS(3);
        ArrayList summaryList = new ArrayList();
        String graphsLbl = Messages.getString(ReportBuilder.class, "graphs.lbl");
        summaryDS.setList(summaryList);
        summaryDS.setExtraTitle(graphsLbl);
        summaryDS.setTocEntry(graphsLbl);
        summaryElem.addDataSource((SubreportDataSource)summaryDS);
        String lbl = Messages.getString(ReportBuilder.class, "call.graph1");
        ObjectForSubreport obj = Utils.makeGenericEntry(summaryList, (String)lbl, null, (String)SUMMARY_ELEM_KEY);
        String legalFileName = this.getLegalFileNameFor(jobQName);
        legalFileName = legalFileName.replaceAll("#", "%23");
        String hyperlink = "./" + legalFileName + "-callgraph.svg";
        hyperlink = hyperlink.replaceAll(Matcher.quoteReplacement(File.separator), "/");
        obj.setHyperlink(hyperlink);
        lbl = Messages.getString(ReportBuilder.class, "call.graph2");
        obj = Utils.makeGenericEntry(summaryList, (String)lbl, null, (String)SUMMARY_ELEM_KEY);
        hyperlink = "./" + legalFileName + "-flowgraph.svg";
        hyperlink = hyperlink.replaceAll(Matcher.quoteReplacement(File.separator), "/");
        hyperlink = hyperlink.replaceAll("#", "%23");
        obj.setHyperlink(hyperlink);
    }

    private ElementGroupInfo createEntry4Legends() {
        ElementGroupInfo legends = new ElementGroupInfo("legends");
        ArrayList<String[]> scores = new ArrayList<String[]>();
        String[] stringArray = new String[3];
        stringArray[0] = Messages.getString(ReportBuilder.class, "nodes.lbl");
        String[] nodesTitle = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[1] = "paleGreen";
        stringArray2[2] = Messages.getString(ReportBuilder.class, "paleGreen.desc");
        String[] nodes1 = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[1] = "paleRed";
        stringArray3[2] = Messages.getString(ReportBuilder.class, "paleRed.desc");
        String[] nodes2 = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[1] = "magenta";
        stringArray4[2] = Messages.getString(ReportBuilder.class, "magenta.desc");
        String[] nodes3 = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = Messages.getString(ReportBuilder.class, "edges.lbl");
        String[] edgesTitle = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[1] = "black";
        stringArray6[2] = Messages.getString(ReportBuilder.class, "black.desc");
        String[] edges1 = stringArray6;
        String[] stringArray7 = new String[3];
        stringArray7[1] = "paleRed";
        stringArray7[2] = Messages.getString(ReportBuilder.class, "paleRed.desc.edge");
        String[] edges2 = stringArray7;
        scores.add(nodesTitle);
        scores.add(nodes1);
        scores.add(nodes2);
        scores.add(nodes3);
        scores.add(edgesTitle);
        scores.add(edges1);
        scores.add(edges2);
        legends.addDataSource((SubreportDataSource)new LegendDataSource(Messages.getString(ReportBuilder.class, "call.graph1"), scores));
        scores = new ArrayList();
        String[] stringArray8 = new String[3];
        stringArray8[0] = Messages.getString(ReportBuilder.class, "report.appendix.nodesTitle");
        nodesTitle = stringArray8;
        String[] stringArray9 = new String[3];
        stringArray9[1] = "paleRed";
        stringArray9[2] = Messages.getString(ReportBuilder.class, "report.appendix.nodesWithFlowgraph");
        nodes1 = stringArray9;
        String[] stringArray10 = new String[3];
        stringArray10[1] = "green2";
        stringArray10[2] = Messages.getString(ReportBuilder.class, "report.appendix.jobStep");
        nodes2 = stringArray10;
        String[] stringArray11 = new String[3];
        stringArray11[1] = "paleGreen";
        stringArray11[2] = Messages.getString(ReportBuilder.class, "report.appendix.jobStepWithinProcedure");
        nodes3 = stringArray11;
        String[] stringArray12 = new String[3];
        stringArray12[1] = "blue1";
        stringArray12[2] = Messages.getString(ReportBuilder.class, "report.appendix.conditionalJobStep");
        String[] nodes4 = stringArray12;
        String[] stringArray13 = new String[3];
        stringArray13[1] = "paleCyan";
        stringArray13[2] = Messages.getString(ReportBuilder.class, "report.appendix.conditionalJobStepWithinProcThen");
        String[] nodes5 = stringArray13;
        String[] stringArray14 = new String[3];
        stringArray14[1] = "gray";
        stringArray14[2] = Messages.getString(ReportBuilder.class, "report.appendix.conditionalJobStepElse");
        String[] nodes6 = stringArray14;
        String[] stringArray15 = new String[3];
        stringArray15[1] = "gray1";
        stringArray15[2] = Messages.getString(ReportBuilder.class, "report.appendix.conditionalJobStepWithinProcElse");
        String[] nodes7 = stringArray15;
        String[] stringArray16 = new String[3];
        stringArray16[1] = "paleBlue";
        stringArray16[2] = Messages.getString(ReportBuilder.class, "report.appendix.conditionalNodes");
        String[] nodes8 = stringArray16;
        String[] stringArray17 = new String[3];
        stringArray17[0] = Messages.getString(ReportBuilder.class, "report.appendix.edgesTitle");
        edgesTitle = stringArray17;
        String[] stringArray18 = new String[3];
        stringArray18[1] = "black";
        stringArray18[2] = Messages.getString(ReportBuilder.class, "report.appendix.flowPath");
        edges1 = stringArray18;
        scores.add(nodesTitle);
        scores.add(nodes1);
        scores.add(nodes2);
        scores.add(nodes3);
        scores.add(nodes4);
        scores.add(nodes5);
        scores.add(nodes6);
        scores.add(nodes7);
        scores.add(nodes8);
        scores.add(edgesTitle);
        scores.add(edges1);
        scores.add(edges2);
        legends.addDataSource((SubreportDataSource)new LegendDataSource(Messages.getString(ReportBuilder.class, "call.graph2"), scores));
        return legends;
    }

    private static Object4Report makeObjForReport(String jobName, String stepName, String procName, int position, String sourceName, boolean isPgm) {
        if (sourceName == null || sourceName.equals("0")) {
            sourceName = jobName;
        }
        String s1 = isPgm ? Messages.getString(ReportBuilder.class, "step.group.detail.title.execPgm", new Object[]{position, stepName, sourceName, procName}) : Messages.getString(ReportBuilder.class, "step.group.detail.title.execProcedure", new Object[]{position, stepName, sourceName, procName});
        String s2 = Messages.getString(ReportBuilder.class, "step.group.detail.TOCentry", new Object[]{position, stepName, sourceName});
        Object4Report obj4Rep = new Object4Report(ReportsUtils.stripNonValidXMLCharacters((String)s1, (boolean)true), ReportsUtils.stripNonValidXMLCharacters((String)s2, (boolean)true), null);
        return obj4Rep;
    }

    private static void makeDDCardDS(Map<Integer, List<Object4Report>> steps, String columnLbl1, String columnLbl2, String columnLbl3, Integer stepId, List<Object4TestReport> listDataSet) {
        if (listDataSet != null && !listDataSet.isEmpty()) {
            ElementGroupInfo elemDetails = new ElementGroupInfo("DD cards details");
            SC3TableDataSource ds = new SC3TableDataSource(columnLbl1, columnLbl2, columnLbl3, listDataSet);
            ds.setKey(DS_DETAILS_KEY);
            ds.setLayout(3);
            elemDetails.addDataSource((SubreportDataSource)ds);
            List<Object4Report> obj4Reps = steps.get(stepId);
            if (obj4Reps != null) {
                for (Object4Report obj4Rep : obj4Reps) {
                    obj4Rep.setElemDetails(elemDetails);
                }
            }
        }
    }

    @Override
    protected void extraWork(int targetIdx, JRDataSource ds, IProgressMonitor pmonitor) {
        SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
    }

    @Override
    public String getFilePrefix() {
        return null;
    }

    @Override
    public String getFileSuffix() {
        return " Job Flow";
    }

    @Override
    public String getIndexTitle() {
        return Messages.getString(ReportBuilder.class, "htmlIndex.title");
    }

    @Override
    public String getDefaultOutputFolder() {
        return "jobflow";
    }

    public void cleanMemory() {
        this.currentTarget = null;
        this.jobs = null;
        this.jclPgmHelper = null;
        this.pgmSteps = null;
        if (this.tsNodeLevels != null) {
            this.tsNodeLevels.clear();
            this.tsNodeLevels = null;
        }
        super.cleanMemory();
    }
}

