/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.jobflow;

import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JobReportElement {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private JobReportElementDS elemDetailsDS;
    private String detailName;
    private String detailTOC;

    public JobReportElement(String detailName) {
        this.detailName = detailName;
    }

    public JobReportElement(List<Object4Report> resultList, String jobQName) {
        this(jobQName);
        this.elemDetailsDS = new JobReportElementDS(resultList);
    }

    public String getDetailName() {
        return this.detailName;
    }

    public String getDetailTOC() {
        return this.detailTOC != null ? this.detailTOC : this.detailName;
    }

    public JobReportElementDS getDS() {
        return this.elemDetailsDS;
    }

    class JobReportElementDS
    extends BaseSubreportDataSource {
        private List<Object4Report> elemDetails;
        private Object4Report currentVal;
        private BaseSubreportDataSource ds = null;
        int i = 0;

        public JobReportElementDS(List<Object4Report> resultList) {
            this.elemDetails = resultList;
            if (this.elemDetails != null && !this.elemDetails.isEmpty()) {
                this.i = this.elemDetails.size();
            }
        }

        public boolean next() throws JRException {
            boolean ret;
            boolean bl = ret = this.i > 0;
            if (ret) {
                this.currentVal = this.elemDetails.remove(0);
                --this.i;
                ElementGroupInfo details = this.currentVal.getElemDetails();
                if (details != null && details.hasNoData()) {
                    details.next();
                }
                this.ds = null;
            }
            return ret;
        }

        public Object getFieldValue(JRField field) throws JRException {
            Object value = null;
            ElementGroupInfo details = this.currentVal.getElemDetails();
            if (field.getName().equalsIgnoreCase("subreportDataSource")) {
                if (details != null) {
                    this.ds = details.hasNoData() ? (BaseSubreportDataSource)details.getFieldValue(field) : details.getDS("dsKey");
                }
                value = this.ds;
            } else if (field.getName().equalsIgnoreCase("subreport1Template")) {
                if (this.ds != null) {
                    value = this.ds.getReportTemplate();
                }
            } else if (field.getName().equalsIgnoreCase("groupDiscriminator") || field.getName().equalsIgnoreCase("titleText")) {
                value = this.currentVal.getDetailName();
            }
            return value;
        }
    }
}

