/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation.jobflow;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.JobInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.documentation.jobflow.JclPgmHelper;
import com.ez.report.application.ezreport.reports.documentation.jobflow.JobReportElement;
import com.ez.report.application.ezreport.reports.documentation.jobflow.ReportBuilder;
import com.ez.report.application.ezreport.reports.documentation.jobflow.ViewerReportBuilder;
import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datasource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Datasource.class);
    private ViewerReportBuilder builder;
    private SubMonitor monitor;
    JobReportElement currentValue = null;
    int currentPos = 0;
    private String[][] jobs;
    private EZSourceConnection bridgeConnection = null;
    private CSVWriter csvWriter;

    public Datasource(Collection<JobInputNoGUI> inputs, IProgressMonitor pmonitor, ViewerReportBuilder reportBuilder, CSVWriter csvWriter) {
        this.csvWriter = csvWriter;
        this.monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(inputs.size() * 10));
        this.monitor.subTask(Messages.getString(Datasource.class, "monitor.startprocess.subtask"));
        this.builder = reportBuilder;
        this.jobs = ReportBuilder.buildJobsInfos(inputs);
    }

    public boolean nextItem() throws JRException {
        this.currentValue = null;
        if (this.jobs.length > 0 && this.currentPos < this.jobs.length) {
            String[] j = this.jobs[this.currentPos];
            this.jobs[this.currentPos] = null;
            ++this.currentPos;
            String jobName = this.getJobName(j);
            String cfr_ignored_0 = j[2];
            Integer jobId = Integer.valueOf(j[0]);
            L.trace("before build data for job: {}", (Object)jobName);
            this.currentValue = this.buildReportElement(jobName, jobId, this.monitor.newChild(10));
            L.trace("after build data for job: {}", (Object)jobName);
        } else {
            this.monitor.setWorkRemaining(0);
            this.monitor.subTask("");
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
        }
        return this.currentValue != null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("detailsDataSource")) {
            value = this.currentValue.getDS();
        } else if (field.getName().equals("detailName")) {
            value = ReportsUtils.stripNonValidXMLCharacters((String)this.currentValue.getDetailName(), (boolean)true);
        } else if (field.getName().equals("detailTOC")) {
            value = this.currentValue.getDetailTOC();
        }
        return value;
    }

    private String getJobName(String[] currentTarget) {
        String jobQName = currentTarget[1].equals(currentTarget[2]) ? currentTarget[1] : String.valueOf(currentTarget[1]) + "(" + currentTarget[2] + ")";
        return jobQName;
    }

    private JobReportElement buildReportElement(String jobName, Integer jobId, SubMonitor newChild) {
        this.monitor.subTask(Messages.getString(Datasource.class, "monitor.prepareDataForJob.subtask", new String[]{jobName}));
        LinkedList<Object4Report> resultList = new LinkedList<Object4Report>();
        this.data(resultList, jobId, (IProgressMonitor)this.monitor.newChild(100));
        this.monitor.worked(100);
        JobReportElement jobElement = new JobReportElement(resultList, jobName);
        return jobElement;
    }

    private void data(List<Object4Report> resultList, Integer jobId, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        resultList.clear();
        this.builder.getStopCode().run();
        ElementGroupInfo summaryElem = new ElementGroupInfo("job");
        ArrayList<Integer> jobAsParam = new ArrayList<Integer>();
        jobAsParam.add(jobId);
        String listNamesTitle = Messages.getString(Datasource.class, "listing.lbl");
        String procsTotalLbl = Messages.getString(Datasource.class, "total.proc.occurences");
        boolean vb = ReportBuilder.treatProcedures(this.bridgeConnection, summaryElem, pmonitor, new DSFactory(), jobAsParam, null, procsTotalLbl, listNamesTitle, this.builder.getStopCode());
        if (vb) {
            Object4Report obj4Rep = new Object4Report(Messages.getString(Datasource.class, "procedures.section.title"), summaryElem);
            resultList.add(obj4Rep);
        }
        JclPgmHelper jclPgmHelper = new JclPgmHelper(this.builder.getStopCode());
        ReportBuilder.treatSteps(this.bridgeConnection, resultList, monitor, jobAsParam, this.builder.getStopCode(), jclPgmHelper, null, this.csvWriter);
        if (resultList.isEmpty()) {
            Object4Report obj = new Object4Report("", new ElementGroupInfo(""));
            resultList.add(obj);
        }
        monitor.worked(100);
    }

    public void setConnection(EZSourceConnection conn) {
        this.bridgeConnection = conn;
    }
}

