/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentationReportsUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DocumentationReportsUtil.class);
    public static final String Q3 = "EZReports_VSAMFile_Q3";
    public static final String Q4 = "EZReports_VSAMFile_Q4";
    public static final String SPACE_IDENT = "   ";
    private static final String PRG_LABEL = Messages.getString(DocumentationReportsUtil.class, "prg.label");
    public static final String INCL_LABEL = Messages.getString(DocumentationReportsUtil.class, "incl.label");

    public static List<Object4Report> buildVariables(Collection<Integer> varIDs, ElementGroupInfo elemGroup, EZSourceConnection bridge, Runnable stopCode, IProgressMonitor pmonitor) {
        String[][] varsResults = null;
        LinkedList<Object4Report> listObj = new LinkedList<Object4Report>();
        ArrayList<String> varsInIncludes = new ArrayList<String>();
        bridge = bridge == null ? EZSourceConnectionManager.getCurrent() : bridge;
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[varIDs.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        varsResults = bridge.execNonTransactionalStoredProc(Q3, new Object[0], types, new ArrayList<Integer>(varIDs));
        if (varsResults != null) {
            boolean makeNewGroup = elemGroup == null;
            String occPrev = null;
            String[][] stringArray = varsResults;
            int n = varsResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] varRes = stringArray[n2];
                String occ = varRes[10];
                String isCopy = varRes[2];
                boolean makeRecordObj = true;
                int copy = 0;
                try {
                    copy = Integer.valueOf(isCopy);
                }
                catch (NumberFormatException nfe) {
                    L.debug("{}", (Throwable)nfe);
                }
                if (copy == -1) {
                    if (occPrev != null && !occPrev.equals(occ)) {
                        varsInIncludes.clear();
                        occPrev = occ;
                    } else if (varsInIncludes.contains(varRes[1])) {
                        makeRecordObj = false;
                    } else {
                        varsInIncludes.add(varRes[1]);
                        occPrev = occ;
                    }
                } else {
                    varsInIncludes.clear();
                    occPrev = null;
                }
                if (makeRecordObj) {
                    ArrayList<Integer> IDs4Record = new ArrayList<Integer>();
                    IDs4Record.add(Integer.valueOf(varRes[0]));
                    String recordName = varRes[1];
                    String tabString = "";
                    String structurelbl = "";
                    String varName = varRes[1];
                    String prg_Name = varRes[3];
                    String level = varRes[4];
                    String usage = varRes[5];
                    String pic = varRes[6];
                    String include_Name = varRes[9];
                    String fullVarText = varRes[11];
                    if (Utils.filterNullValue((String)fullVarText) != null && !fullVarText.isEmpty()) {
                        String[] res = DocumentationReportsUtil.getType(recordName, fullVarText);
                        pic = res[0];
                        usage = res[1];
                    } else {
                        if (Utils.filterNullValue((String)usage) == null) {
                            usage = "";
                        }
                        if (Utils.filterNullValue((String)pic) == null) {
                            pic = "";
                        } else if (!"".equalsIgnoreCase(pic)) {
                            pic = Messages.getString(DocumentationReportsUtil.class, "pic.label", new String[]{pic});
                        }
                    }
                    ArrayList<ObjectForSubreport> recordDetailsList = new ArrayList<ObjectForSubreport>();
                    int currentlevel = Integer.valueOf(level);
                    DocumentationReportsUtil.fillReportDetails(tabString, level, varName, pic, usage, recordDetailsList);
                    String[][] recordStructs = null;
                    List<EZSourceDataType> types2 = Arrays.asList(new EZSourceDataType[IDs4Record.size()]);
                    Collections.fill(types2, EZSourceDataType.Integer);
                    recordStructs = bridge.execNonTransactionalStoredProc(Q4, new Object[0], types2, IDs4Record);
                    if (recordStructs != null) {
                        String[][] stringArray2 = recordStructs;
                        int n3 = recordStructs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String[] recordStruct = stringArray2[n4];
                            varName = recordStruct[2];
                            int diez = varName.indexOf("#");
                            if (diez != -1 && varName.substring(0, diez).trim().equalsIgnoreCase("FILLER")) {
                                varName = "FILLER";
                            }
                            level = recordStruct[4];
                            fullVarText = recordStruct[10];
                            if (Utils.filterNullValue((String)fullVarText) != null && !fullVarText.isEmpty()) {
                                String[] res = DocumentationReportsUtil.getType(varName, fullVarText);
                                pic = res[0];
                                usage = res[1];
                            } else {
                                L.warn("fullVarText null for varName={}", (Object)varName);
                                pic = recordStruct[8];
                                usage = recordStruct[9];
                                if (Utils.filterNullValue((String)usage) == null) {
                                    usage = "";
                                }
                                if (Utils.filterNullValue((String)pic) == null) {
                                    pic = "";
                                } else if (!"".equalsIgnoreCase(pic)) {
                                    pic = Messages.getString(DocumentationReportsUtil.class, "pic.label", new String[]{pic});
                                }
                            }
                            int intLevel = Integer.parseInt(level);
                            if (currentlevel != intLevel) {
                                int idx;
                                if (intLevel - currentlevel >= 1) {
                                    tabString = tabString.concat(SPACE_IDENT);
                                } else if (intLevel - currentlevel < 1 && (idx = tabString.lastIndexOf(SPACE_IDENT)) > 0) {
                                    tabString = tabString.substring(0, idx);
                                }
                                currentlevel = intLevel;
                            }
                            DocumentationReportsUtil.fillReportDetails(tabString, level, varName, pic, usage, recordDetailsList);
                            stopCode.run();
                            ++n4;
                        }
                        recordStructs = null;
                    } else {
                        L.debug("No detailed structure for record {}", (Object)recordName);
                    }
                    structurelbl = isCopy.equals("0") ? Messages.getString(DocumentationReportsUtil.class, "structure.label", new String[]{recordName, PRG_LABEL, prg_Name}) : Messages.getString(DocumentationReportsUtil.class, "structure.label", new String[]{recordName, INCL_LABEL, include_Name});
                    String sc3DSTitle = null;
                    if (makeNewGroup) {
                        elemGroup = new ElementGroupInfo(structurelbl);
                    } else {
                        sc3DSTitle = structurelbl;
                    }
                    SC3DataSource ds3 = new SC3DataSource(sc3DSTitle, recordDetailsList);
                    ds3.setExtraTitle(sc3DSTitle);
                    ds3.setLayout(3);
                    elemGroup.addDataSource((SubreportDataSource)ds3);
                    Object4Report obj4Rep = new Object4Report(structurelbl, elemGroup);
                    listObj.add(obj4Rep);
                    stopCode.run();
                }
                ++n2;
            }
            varsResults = null;
        }
        return listObj;
    }

    private static void fillReportDetails(String tabString, String level, String varName, String type, String usage, List<ObjectForSubreport> recordDetailsList) {
        String recordFieldValue = tabString.concat(level.concat(". ").concat(varName));
        if (!usage.isEmpty() && !usage.startsWith("USAGE")) {
            usage = Messages.getString(DocumentationReportsUtil.class, "usage.label", new String[]{usage});
        }
        L.debug(recordFieldValue);
        ObjectForSubreport obj4SubRep = new ObjectForSubreport();
        obj4SubRep.setExp(ReportsUtils.stripNonValidXMLCharacters((String)recordFieldValue, (boolean)false));
        recordDetailsList.add(obj4SubRep);
        obj4SubRep = new ObjectForSubreport();
        obj4SubRep.setExp(ReportsUtils.stripNonValidXMLCharacters((String)type, (boolean)false));
        recordDetailsList.add(obj4SubRep);
        obj4SubRep = new ObjectForSubreport();
        obj4SubRep.setExp(ReportsUtils.stripNonValidXMLCharacters((String)usage, (boolean)false));
        recordDetailsList.add(obj4SubRep);
    }

    private static String[] getType(String varName, String fullVarText) {
        String pic = "";
        String usage = "";
        int idx = fullVarText.indexOf(varName);
        if (idx > 0) {
            if ((idx = idx + varName.length() + 1) < fullVarText.length()) {
                pic = fullVarText.substring(idx, fullVarText.length());
                if ((pic = pic.trim()).endsWith(",") || pic.endsWith(".") || pic.endsWith(";")) {
                    pic = pic.substring(0, pic.length() - 1);
                    pic = pic.trim();
                }
                if ((idx = pic.indexOf("USAGE")) < 0) {
                    idx = pic.indexOf("usage");
                }
                if (idx > -1) {
                    usage = pic.substring(idx, pic.length());
                    usage = usage.trim();
                    pic = pic.substring(0, idx);
                    pic = pic.trim();
                } else {
                    usage = "";
                }
            } else {
                usage = "";
                pic = "";
            }
        } else {
            L.warn("fullVarText without varName: {} for record {}", (Object)fullVarText, (Object)varName);
            usage = "";
            pic = "";
        }
        return new String[]{pic, usage};
    }
}

