/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.documentation;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.model.Constants;
import com.ez.report.generation.common.model.ReportInformation;
import java.io.File;
import java.util.Properties;

public abstract class AbstractDocumentationReport
extends AbstractReport {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String FOLDER = "outputFolderName";

    public void loadPropertiesFromFile(File f, EZSourceConnection bridge) {
        if (f == null) {
            ProjectInfo prjInfo = bridge.getProjectInfo();
            ReportInformation repInfo = this.getReportInformation();
            String path = Utils.getProjectPathName((String)prjInfo.getProjectName()).concat(File.separator).concat(repInfo.getReportName()).concat(Constants.PATH_SEPARATOR).concat("default.properties");
            f = new File(path);
        }
        this.addProperty("settings file", f.getName().substring(0, f.getName().lastIndexOf(46)));
        Properties prop = Utils.readSettings((File)f);
        this.addProperty(FOLDER, prop.getProperty(FOLDER));
    }

    public void loadPropertiesFromFile(String settingsFile) {
        File f = null;
        ReportInformation repInfo = this.getReportInformation();
        String projectPath = Utils.getProjectPathName((String)this.projectName);
        if (settingsFile != null && !"".equals(settingsFile)) {
            String path = projectPath.concat(File.separator).concat(repInfo.getReportName()).concat(Constants.PATH_SEPARATOR).concat(settingsFile);
            if (!path.endsWith(".properties")) {
                path = path.concat(".properties");
            }
            f = new File(path);
        } else {
            String path = projectPath.concat(File.separator).concat(repInfo.getReportName()).concat(Constants.PATH_SEPARATOR).concat("default.properties");
            f = new File(path);
        }
        this.loadPropertiesFromFile(f);
    }

    public void loadPropertiesFromFile(File f) {
        if (f != null) {
            Properties prop = Utils.readSettings((File)f);
            this.addProperty(FOLDER, prop.getProperty(FOLDER));
        }
    }

    protected abstract ReportInformation getReportInformation();
}

