/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.deadCode.ddcl.unusedelements;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.common.ui.listselection.Listable;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ezreport.reports.deadCode.ddcl.unusedelements.UnusedDDCLElementsJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.ui.collectors.DDCLElementCollector;
import com.ez.report.application.ui.collectors.InputsCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.GenericSelectPage;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedDDCLElementsAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UnusedDDCLElementsAnalysis.class);
    static final String SELECTED_ROOTS_PROP_NAME = "selected roots";
    static final String AVAILABLE_ROOTS_PROP_NAME = "available roots";

    public UnusedDDCLElementsAnalysis() {
        this(null);
    }

    public UnusedDDCLElementsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected PrepareReportWizard getWizard() {
        UnusedDDCLElemsReportWizard wizard = new UnusedDDCLElemsReportWizard();
        String wizardName = Messages.getString(UnusedDDCLElementsAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        RootsPage resTypePage = new RootsPage("roots page");
        resTypePage.setDescription(Messages.getString(UnusedDDCLElementsAnalysis.class, "wizard.rootsPage.description"));
        resTypePage.setTitle(Messages.getString(UnusedDDCLElementsAnalysis.class, "wizard.rootsPage.title"));
        resTypePage.setLeftGroupLabel(Messages.getString(UnusedDDCLElementsAnalysis.class, "av.wizard.rootsPage.objectType"));
        resTypePage.setRightGroupLabel(Messages.getString(UnusedDDCLElementsAnalysis.class, "sel.wizard.rootsPage.objectType"));
        resTypePage.setAvailablePropName(AVAILABLE_ROOTS_PROP_NAME);
        resTypePage.setSelectedPropName(SELECTED_ROOTS_PROP_NAME);
        resTypePage.setResourcesCollector((ResourcesCollector)new DDCLRootsCollector());
        resTypePage.setMinSizeOfSelected(0);
        List<Listable> defRoots = this.buildDefaultRootProperty();
        wizard.set(SELECTED_ROOTS_PROP_NAME, defRoots);
        resTypePage.setDefaultSelected(defRoots);
        wizard.addPage((IWizardPage)resTypePage);
        SelectProgramsPage selectInputsPage = new SelectProgramsPage("programs page", true, false);
        selectInputsPage.setLeftGroupLabel(Messages.getString(UnusedDDCLElementsAnalysis.class, "av.wizard.objectType"));
        selectInputsPage.setRightGroupLabel(Messages.getString(UnusedDDCLElementsAnalysis.class, "sel.wizard.objectType"));
        String filesQuery = "SELECT DDCLElement.Id, DDCLElement.Name, DDCLElement.DdsTypeId FROM DDCLElement WHERE DDCLElement.isLocal='false' AND DDCLElement.DdsTypeId IN (select * from #numeric_param_temp)ORDER BY DDCLElement.DdsTypeId, DDCLElement.Name ";
        DDCLElementCollector pc = new DDCLElementCollector();
        pc.setResourcesQuery(filesQuery);
        selectInputsPage.setResourcesCollector((ResourcesCollector)pc);
        wizard.addPage((IWizardPage)selectInputsPage);
        return wizard;
    }

    @Override
    protected void processSpecificInput(EZObjectType inpObj, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZObjectType objType = inpObj;
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            EZEntityID entityId;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((entityId = objType.getEntID()) != null) {
                EZSourceDDCLElementIDSg ddclSg = (EZSourceDDCLElementIDSg)entityId.getSegment(EZSourceDDCLElementIDSg.class);
                if (ddclSg != null) {
                    String name = ddclSg.getName();
                    L.debug("input is an ddcl element {}", (Object)name);
                    Integer type = ddclSg.getType();
                    Integer dbID = ddclSg.getId();
                    sel.add((BaseMainframeResourceInput)new DDCLElementInput(name, type, dbID));
                    inputNames.add(name);
                }
            } else {
                L.debug("resource or ddcl segment id null for: {}", (Object)objType.getName());
            }
        }
    }

    private List<Listable> buildDefaultRootProperty() {
        ArrayList<Listable> defRoots = new ArrayList<Listable>();
        defRoots.add((Listable)new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(24)));
        defRoots.add((Listable)new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(28)));
        defRoots.add((Listable)new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(27)));
        return defRoots;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, UnusedDDCLElementsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_UNUSEDDDCLELEMENTS_ANALYSIS;
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            Collection lst1 = (Collection)params1.get(SELECTED_ROOTS_PROP_NAME);
            Collection lst2 = (Collection)params2.get(SELECTED_ROOTS_PROP_NAME);
            if (lst1 != null) {
                List nonGuiLst1 = BaseResourceInput4GUI.extractNonGUIObjects((Collection)lst1);
                List nonGuiLst2 = null;
                if (lst2 != null) {
                    nonGuiLst2 = BaseResourceInput4GUI.extractNonGUIObjects((Collection)lst2);
                }
                ret = nonGuiLst1.equals(nonGuiLst2);
            } else {
                ret = lst2 == null;
            }
        }
        return ret;
    }

    @Override
    protected void setParams(List<BaseMainframeResourceInput> selInputs) {
        super.setParams(selInputs);
        List<Listable> defRoots = this.buildDefaultRootProperty();
        this.params.put(SELECTED_ROOTS_PROP_NAME, defRoots);
    }

    class DDCLRoot
    extends BaseMainframeResourceInput {
        private static final long serialVersionUID = 1L;

        public DDCLRoot(Integer type) {
            super("", type);
            this.name = Utils.getExternalizedType4DDCLComponent((Integer)type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DDCLRoot other = (DDCLRoot)((Object)obj);
            if (this.type == null) {
                if (other.type != null) {
                    return false;
                }
            } else {
                if (!this.type.equals(other.type)) {
                    return false;
                }
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
            }
            return true;
        }
    }

    class DDCLRootsCollector
    extends InputsCollector {
        DDCLRootsCollector() {
        }

        public List collect(boolean useFilters, Set apps, EZSourceConnection conn) {
            ArrayList<BaseMainframeResource4GUI> roots = new ArrayList<BaseMainframeResource4GUI>();
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(25)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(26)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(16)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(11)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(14)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(4)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(3)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(10)));
            roots.add(new BaseMainframeResource4GUI((BaseResourceInput)new DDCLRoot(12)));
            return roots;
        }

        public List getAvailableImages() {
            return null;
        }
    }

    class RootsPage
    extends GenericSelectPage {
        List<Listable> defSelected;

        public RootsPage(String pageName) {
            super(pageName);
            this.defSelected = null;
            this.showReportsOptionGroup = true;
            this.showInputsOption = true;
            this.optionValue = PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails");
        }

        public void setDefaultSelected(List<Listable> defRoots) {
            this.defSelected = defRoots;
        }

        public void fillUIWithProgress() {
            super.fillUIWithProgress();
            this.propertiesGroup.setSelected(this.defSelected);
            this.wizard.set(UnusedDDCLElementsAnalysis.SELECTED_ROOTS_PROP_NAME, this.defSelected);
            this.wizard.getContainer().updateButtons();
        }

        public boolean isPageComplete() {
            boolean ret = super.isPageComplete();
            if (ret) {
                List sel = this.propertiesGroup.getAvObjectList();
                L.trace("available types: {}", (Object)sel);
                ret = sel != null && sel.size() >= 1;
            }
            return ret;
        }

        protected boolean getShowAppendixValue() {
            Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
            return showAppendix;
        }

        protected void addShowAppendixOptions(Composite optionsGroup) {
            this.defaultAddAppendixOptions(optionsGroup);
        }
    }

    class UnusedDDCLElemsReportWizard
    extends PrepareReportWizard {
        UnusedDDCLElemsReportWizard() {
        }

        public IWizardPage getNextPage(IWizardPage page) {
            IWizardPage next = super.getNextPage(page);
            if (next != null && next.getName().equals("programs page")) {
                DDCLElementCollector collector = (DDCLElementCollector)((SelectProgramsPage)next).getResourcesCollector();
                List selectedRootId = this.getList(UnusedDDCLElementsAnalysis.SELECTED_ROOTS_PROP_NAME);
                Set<Integer> ids = this.getAllTypes();
                for (BaseMainframeResource4GUI ri : selectedRootId) {
                    Integer rootId = ri.getTypeCode();
                    ids.remove(rootId);
                }
                collector.setParameters(ids, EZSourceDataType.Integer);
            }
            return next;
        }

        public boolean canFinish() {
            boolean ret = false;
            if (this.getContainer().getCurrentPage() == this.getPage("programs page")) {
                ret = this.getContainer().getCurrentPage().isPageComplete();
            }
            return ret;
        }

        private Set<Integer> getAllTypes() {
            HashSet<Integer> types = new HashSet<Integer>();
            types.add(24);
            types.add(25);
            types.add(26);
            types.add(16);
            types.add(11);
            types.add(14);
            types.add(4);
            types.add(28);
            types.add(27);
            types.add(3);
            types.add(10);
            types.add(12);
            return types;
        }
    }
}

