/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.deadCode.ddcl.unusedelements;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.programSummary.SummaryDS;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.Triplet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datasource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Datasource.class);
    private static final String UNUSED_DDCL_TpService_SP_Name = "EZViewer_UnusedDDCL_TP_Service";
    private static final String UNUSED_DDCL_Applications_SP_Name = "EZViewer_UnusedDDCL_Applications";
    private static final String UNUSED_DDCL_Dialogues_SP_Name = "EZViewer_UnusedDDCL_Dialogues";
    private static final String UNUSED_DDCL_Exchanges_SP_Name = "EZViewer_UnusedDDCL_Exchanges";
    private static final String UNUSED_DDCL_Components_SP_Name = "EZViewer_UnusedDDCL_Components";
    private static final String UNUSED_DDCL_Modules_SP_Name = "EZViewer_UnusedDDCL_Modules";
    private static final String UNUSED_DDCL_Screens_SP_Name = "EZViewer_UnusedDDCL_Screens";
    private static final String UNUSED_DDCL_ReportPrograms_SP_Name = "EZViewer_UnusedDDCL_ReportPrograms";
    private static final String UNUSED_DDCL_BatchPrograms_SP_Name = "EZViewer_UnusedDDCL_BatchPrograms";
    private static final String UNUSED_DDCL_Records_SP_Name = "EZViewer_UnusedDDCL_Records";
    private static final String UNUSED_DDCL_Files_SP_Name = "EZViewer_UnusedDDCL_Files";
    private static final String UNUSED_DDCL_Sets_SP_Name = "EZViewer_UnusedDDCL_Sets";
    Set<Integer> inptIds;
    private List<Integer> avTypes = new ArrayList<Integer>();
    private List<Integer> values;
    private List<EZSourceDataType> types;
    private ElementGroupInfo currentObj;
    boolean hasData = false;
    boolean isLast = false;
    DSFactory factory = new DSFactory();
    private SubMonitor monitor;
    List<ObjectForSubreport> lst;
    Map<String, Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>> summDS;
    String projectName = null;
    private CSVWriter csvWriter;

    public Datasource(Collection<DDCLElementInput> selected, String project, CSVWriter csvWriter, IProgressMonitor pmonitor) {
        this.monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(this.avTypes.size() * 10));
        this.projectName = project;
        this.csvWriter = csvWriter;
        this.prepareInputs(selected);
        this.buildSummaryDS();
    }

    private void buildSummaryDS() {
        this.summDS = new HashMap<String, Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>>();
        this.lst = new ArrayList<ObjectForSubreport>();
        Triplet pair = new Triplet();
        pair.setThird((Object)new SC1DataSource(null, this.lst));
        this.summDS.put("", (Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>)pair);
    }

    private void prepareInputs(Collection<DDCLElementInput> selected) {
        this.inptIds = new HashSet<Integer>();
        for (DDCLElementInput elem : selected) {
            this.inptIds.add(elem.getResourceID());
            Integer type = elem.getTypeCode();
            if (this.avTypes.contains(type)) continue;
            this.avTypes.add(type);
        }
        this.values = new ArrayList<Integer>(this.inptIds);
        this.types = Arrays.asList(new EZSourceDataType[this.inptIds.size()]);
        Collections.fill(this.types, EZSourceDataType.Integer);
    }

    public boolean nextItem() throws JRException {
        boolean hasNext;
        this.currentObj = null;
        if (!this.avTypes.isEmpty()) {
            Integer idElemType = this.avTypes.remove(0);
            this.monitor.subTask(Utils.getExternalizedType4DDCLComponent((Integer)idElemType));
            this.currentObj = this.getUnusedElems(idElemType);
            if (!this.hasData) {
                this.hasData = this.currentObj != null;
            }
            this.monitor.worked(10);
            this.monitor.subTask("");
        }
        boolean bl = hasNext = this.currentObj != null || !this.avTypes.isEmpty();
        if (!hasNext && !this.isLast) {
            this.isLast = true;
            if (!this.hasData) {
                this.currentObj = new ElementGroupInfo("", null, Messages.getString(Datasource.class, "noData.message"));
                hasNext = true;
            }
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
        }
        return hasNext;
    }

    private ElementGroupInfo getUnusedElems(Integer idElemType) {
        ElementGroupInfo elem = null;
        String elemTypeName = Utils.getExternalizedType4DDCLComponent((Integer)idElemType);
        String[][] results = this.getData(idElemType);
        if (results != null && results.length > 0) {
            elem = new ElementGroupInfo(Messages.getString(Datasource.class, "report.details.group.name", new String[]{elemTypeName}));
            BaseSubreportDataSource elemDS = this.factory.createDS(1);
            ArrayList<ObjectForSubreport> objList = new ArrayList<ObjectForSubreport>();
            elemDS.setList(objList);
            elem.addDataSource((SubreportDataSource)elemDS);
            int i = 0;
            while (i < results.length) {
                String name = results[i][0];
                String[] tmp = new String[]{elemTypeName, name};
                ObjectForSubreport obj = this.factory.createObj(1, tmp, "");
                objList.add(obj);
                if (this.csvWriter != null) {
                    this.csvWriter.write(tmp);
                }
                ++i;
            }
            ObjectForSubreport obj = new ObjectForSubreport();
            String totalString = Messages.getString(Datasource.class, "report.summary.group.entry", new String[]{elemTypeName});
            obj.setExp(totalString);
            obj.setExpVal("" + results.length);
            this.lst.add(obj);
        }
        return elem;
    }

    private String[][] getData(Integer idElemType) {
        String[][] results = null;
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.projectName, null);
        try {
            TmpIMFRunnable runn = new TmpIMFRunnable(idElemType);
            ph.executeWithLock(ph, (IMFRunnable)runn, LockType.Shared, (IProgressMonitor)this.monitor.newChild(100));
            results = runn.getResults();
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return results;
    }

    private String[] getParameters(Integer idElemType) {
        String[] params = null;
        params = 4 == idElemType ? new String[]{"true"} : new String[]{};
        return params;
    }

    private String getProcedure(Integer idElemType) {
        switch (idElemType) {
            case 24: {
                return UNUSED_DDCL_TpService_SP_Name;
            }
            case 25: {
                return UNUSED_DDCL_Applications_SP_Name;
            }
            case 26: {
                return UNUSED_DDCL_Dialogues_SP_Name;
            }
            case 16: {
                return UNUSED_DDCL_Exchanges_SP_Name;
            }
            case 11: {
                return UNUSED_DDCL_Components_SP_Name;
            }
            case 14: {
                return UNUSED_DDCL_Screens_SP_Name;
            }
            case 4: {
                return UNUSED_DDCL_Modules_SP_Name;
            }
            case 3: {
                return UNUSED_DDCL_Records_SP_Name;
            }
            case 12: {
                return UNUSED_DDCL_Files_SP_Name;
            }
            case 27: {
                return UNUSED_DDCL_ReportPrograms_SP_Name;
            }
            case 28: {
                return UNUSED_DDCL_BatchPrograms_SP_Name;
            }
            case 10: {
                return UNUSED_DDCL_Sets_SP_Name;
            }
        }
        return null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        String fname = field.getName();
        if (this.currentObj != null) {
            if (fname.equals("testReportDataSource")) {
                value = this.currentObj.getDataSource();
            } else if (fname.equals("prg_name")) {
                value = this.currentObj.getGroupElem();
            } else if (fname.equals("prg_type")) {
                value = this.currentObj.getGroupElemType();
            }
        } else if (fname.equals("prg_name")) {
            value = this.hasData ? null : "";
        }
        if (fname.equals("hasData")) {
            value = this.hasData;
        }
        return value;
    }

    AbstractReportDataSource getTotalsDS() {
        return new SummaryDS(this.summDS);
    }

    class TmpIMFRunnable
    implements IMFRunnable {
        String[][] results = null;
        Integer idElemType = null;

        public TmpIMFRunnable(Integer elementTypeId) {
            this.idElemType = elementTypeId;
        }

        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            try {
                String procName = Datasource.this.getProcedure(this.idElemType);
                if (procName == null) {
                    L.warn("no procedure for type: {}", (Object)this.idElemType);
                    this.results = null;
                } else {
                    String[] params = Datasource.this.getParameters(this.idElemType);
                    this.results = conn.execNonTransactionalStoredProc(procName, params, Datasource.this.types, Datasource.this.values);
                    if (this.results != null && this.results.length > 0) {
                        L.trace("results.size={} of typeId={}", (Object)this.results.length, (Object)this.idElemType);
                    }
                }
            }
            catch (EZSourceConnectionException e) {
                L.error("error at executing of report", (Throwable)e);
            }
        }

        String[][] getResults() {
            return this.results;
        }
    }
}

