/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.crossapplication.sharedresources;

import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.crossapplication.sharedresources.ReportBuilder;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportExecutorInterface;
import com.ez.report.generation.common.ui.AbstractExportCSVAction;
import com.ez.report.generation.common.ui.PreGeneratedCSVExportAction;
import com.ez.report.generation.common.ui.ReportInfoAdapter;
import com.jasperassistant.designer.viewer.ReportViewer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;

public class SharedResourcesJob
extends EZReportJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public SharedResourcesJob(String arg0, EZEntityID arg1) {
        super(arg0, arg1);
        this.graphInfo = new EZReportSharedResGI(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.initialize(this.id);
        this.initialComponent = new JLabel(Messages.getString(SharedResourcesJob.class, "report.label"));
    }

    public SharedResourcesJob(EZEntityID arg1) {
        this(Messages.getString(SharedResourcesJob.class, "jobName"), arg1);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        IStatus st = Status.OK_STATUS;
        ReportExecutorInterface executor = this.buildExecutor();
        executor.generateReport(monitor);
        if (this.graphInfo != null) {
            this.graphInfo.setCloseHandlers(executor.getCloseHandlers());
            Map files = this.builder.getExtraFilesToExport();
            if (files != null && !files.isEmpty()) {
                this.graphInfo.addExportedFiles(files);
            }
        }
        this.builder.cleanMemory();
        this.builder = null;
        GenerationStatus status = executor.getFinishStatus();
        this.callFinishListeners(status);
        if (status.isCanceled()) {
            st = Status.CANCEL_STATUS;
        } else if (status.isError()) {
            st = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(SharedResourcesJob.class, "status.error.message"));
        }
        if (this.analysis != null) {
            this.computeTabName();
        }
        return st;
    }

    @Override
    protected AbstractBuilder getBuilder() {
        ReportBuilder builder = new ReportBuilder(this.reportName, null);
        builder.setProject(this.projectName);
        return builder;
    }

    @Override
    protected void computeTabName() {
        StringBuffer buf = new StringBuffer();
        Set inputs = this.analysis.getContextSetValue("inputs name string");
        if (inputs != null) {
            Iterator it = inputs.iterator();
            while (it.hasNext()) {
                buf.append((String)it.next());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
        }
        this.viewTabLabel = buf.toString();
    }

    class EZReportSharedResGI
    extends ReportInfoAdapter {
        public EZReportSharedResGI(EZEntityID id) {
            super(id);
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/shared.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            String txt = Messages.getString(SharedResourcesJob.class, "report.tab.title", new String[]{SharedResourcesJob.this.viewTabLabel});
            return txt;
        }

        protected AbstractExportCSVAction instantiateCSVExportAction(ReportViewer reportViewer) {
            return new PreGeneratedCSVExportAction(reportViewer);
        }
    }
}

