/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.crossapplication.sharedresources;

import com.ez.common.ui.listselection.Listable;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ezreport.reports.crossapplication.sharedresources.SharedResourcesJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.ResourceTypesPage;
import com.ez.report.application.ui.wizard.SelectApplicationsForSharedResourcesPage;
import com.ez.report.application.utils.ProjectApplicationInput;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedResourcesAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SharedResourcesAnalysis.class);
    @Deprecated
    private Boolean useApplications = SharedResourcesUtils.useApplications();

    public SharedResourcesAnalysis() {
        this(null);
    }

    public SharedResourcesAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            this.addContextValue("input_list", new ArrayList(inputs));
        }
    }

    @Override
    protected boolean checkInputs(List inputs) {
        return true;
    }

    @Override
    public boolean filterInputs() {
        boolean result = false;
        List inputs = this.getContextListValue("input_list");
        if (this.checkInputs(inputs)) {
            boolean getModel = true;
            PrepareReportWizard wizard = this.getWizard();
            if (wizard != null) {
                wizard.set("selected projects", (Object)inputs);
                StringBuffer projectNamesSepByComma = new StringBuffer();
                for (EZSourceProjectInputType project : inputs) {
                    projectNamesSepByComma.append(project.getName());
                    projectNamesSepByComma.append(", ");
                }
                projectNamesSepByComma.delete(projectNamesSepByComma.length() - 2, projectNamesSepByComma.length());
                wizard.setWindowTitle(String.valueOf(projectNamesSepByComma.toString()) + "  -  " + wizard.getWindowTitle());
                final PrepareReportWizard wiz = wizard;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ReportWizardDialog dialog = new ReportWizardDialog(wiz.getShell(), (IWizard)wiz);
                        dialog.create();
                        dialog.setMinimumPageSize(700, 570);
                        dialog.open();
                    }
                });
                if (wizard.isCanceled()) {
                    getModel = false;
                    result = true;
                }
            }
            HashSet<String> inputNames = new HashSet<String>();
            for (EZSourceProjectInputType inputProject : inputs) {
                inputNames.add(inputProject.getName());
            }
            if (this.useApplications.booleanValue()) {
                this.addContextValue("input project names set", inputNames);
            } else {
                this.addContextValue("inputs name string", inputNames);
            }
            this.addContextValue("AUDIT_PROJ_NAMES", new ArrayList(inputNames));
            Map map = getModel ? (wizard != null ? wizard.getValues() : new HashMap()) : (this.params = null);
            if (this.params != null) {
                this.addAllContextValues(this.params);
                if (this.useApplications.booleanValue()) {
                    HashSet<String> inputAppNames = null;
                    List selectedApps = (List)this.params.get("selected applications for shared resources");
                    if (selectedApps != null && !selectedApps.isEmpty()) {
                        inputAppNames = new HashSet<String>();
                        for (ProjectApplicationInput app : selectedApps) {
                            inputAppNames.add(app.getDisplayName());
                        }
                    }
                    this.addContextValue("inputs name string", inputAppNames);
                }
            }
            if (result) {
                this.notifyFinish();
            }
        }
        return result;
    }

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(SharedResourcesAnalysis.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        if (this.useApplications.booleanValue()) {
            SelectApplicationsForSharedResourcesPage selectApplicationsPage = new SelectApplicationsForSharedResourcesPage("applications for shared resources page");
            selectApplicationsPage.setDescription(Messages.getString(SharedResourcesAnalysis.class, "wizard.selectApplicationsPage.description"));
            wizard.addPage((IWizardPage)selectApplicationsPage);
        }
        ResourceTypesPage resTypePage = new ResourceTypesPage("programs page", true);
        resTypePage.setDescription(Messages.getString(SharedResourcesAnalysis.class, "wizard.resourceTypesPage.description"));
        resTypePage.setTitle(Messages.getString(SharedResourcesAnalysis.class, "wizard.resourceTypesPage.title"));
        resTypePage.setLeftGroupLabel(Messages.getString(SharedResourcesAnalysis.class, "av.wizard.resourceTypesPage.objectType"));
        resTypePage.setRightGroupLabel(Messages.getString(SharedResourcesAnalysis.class, "sel.wizard.resourceTypesPage.objectType"));
        resTypePage.setAvailablePropName("available resources");
        resTypePage.setSelectedPropName("selected resources");
        Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
        resTypePage.setShowAppendixValue(showAppendix.booleanValue());
        wizard.addPage((IWizardPage)resTypePage);
        return wizard;
    }

    protected AbstractAnalysisJob getJob(EZEntityID arg0) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(this.id, SharedResourcesJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_SHAREDRESOURCES_ANALYSIS;
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EZReportAnalysis)) {
            return false;
        }
        EZReportAnalysis a2 = (EZReportAnalysis)((Object)obj);
        boolean bl = this.type == null && a2.getType() == null ? true : (ret = this.type != null && a2.getType() != null && this.type.equals((Object)a2.getType()));
        if (ret) {
            Set inputProjectNames1 = null;
            Set inputProjectNames2 = null;
            if (this.useApplications.booleanValue()) {
                inputProjectNames1 = this.getContextSetValue("input project names set");
                inputProjectNames2 = a2.getContextSetValue("input project names set");
            } else {
                inputProjectNames1 = this.getContextSetValue("inputs name string");
                inputProjectNames2 = a2.getContextSetValue("inputs name string");
            }
            if (inputProjectNames1 != null) {
                ret = inputProjectNames1.equals(inputProjectNames2);
            } else {
                boolean bl2 = ret = inputProjectNames2 == null;
            }
        }
        if (ret && this.useApplications.booleanValue()) {
            Set inputAppNames1 = this.getContextSetValue("inputs name string");
            Set inputAppNames2 = a2.getContextSetValue("inputs name string");
            if (inputAppNames1 != null) {
                ret = inputAppNames1.equals(inputAppNames2);
            } else {
                boolean bl3 = ret = inputAppNames2 == null;
            }
        }
        if (ret) {
            List selectedResTypes1 = this.getContextListValue("selected resources");
            List selectedResTypes2 = a2.getContextListValue("selected resources");
            HashSet<String> selectedResTypesSet1 = null;
            if (selectedResTypes1 != null && !selectedResTypes1.isEmpty()) {
                selectedResTypesSet1 = new HashSet<String>();
                for (Listable resourceType : selectedResTypes1) {
                    selectedResTypesSet1.add(resourceType.getListableName());
                }
            }
            HashSet<String> selectedResTypesSet2 = null;
            if (selectedResTypes2 != null && !selectedResTypes2.isEmpty()) {
                selectedResTypesSet2 = new HashSet<String>();
                for (Listable resourceType : selectedResTypes2) {
                    selectedResTypesSet2.add(resourceType.getListableName());
                }
            }
            ret = selectedResTypesSet1 != null ? selectedResTypesSet1.equals(selectedResTypesSet2) : selectedResTypesSet2 == null;
        }
        return ret;
    }
}

